#include <iostream>
#include "VtbEchoWrite.h"
#include <verilated.h>
#include <verilated_vcd_c.h>

int main(int argc, const char ** argv, const char ** env) {
  Verilated::commandArgs(argc, argv);

  VtbEchoWrite * dut = new VtbEchoWrite;
  
  Verilated::traceEverOn(true);
  VerilatedVcdC * tfp = new VerilatedVcdC;
  dut->trace(tfp, 99);
  tfp->open("tbEchoWrite.vcd");

  dut->clk = 0;
  dut->reset = 0;
  dut->in_dv = 0;
  dut->in_data = 0;

  int time = 0;

  // writeOCM erases memory: 4000 clock cycles
  for ( ; time < 20*4100 ; time += 10) {
    dut->clk = ((time % 20) >= 10) ? 1 : 0;
    if (time == 0) dut->reset = 1;
    if (time == 40) dut->reset = 0;
    dut->eval();
    tfp->dump( time );
  }

  int byte_index = 0;
  int next_sched_send = 0;
  // data -> testEcho
  for ( ; time < 2000000 ; time += 10) {
    dut->clk = ((time % 20) >= 10) ? 1 : 0;
      if ((time % 20) >= 10) {
        // Every clock cycle
        if (byte_index < 784) {
          dut->in_dv = 1;
          dut->in_data = byte_index % 50;
          byte_index++;
        } else {
          dut->in_dv = 0;
          dut->in_data = 0;
          if (next_sched_send == 0)
            next_sched_send = time + 20*10000;  // schedule next send in 10000 clock cycles
        }

        if (next_sched_send != 0 && time > next_sched_send) {
          next_sched_send = 0;
          byte_index = 0;
        }
      }
    dut->eval();
    
    tfp->dump( time );

  }
  
  tfp->close();
  delete tfp;

  dut->final();
  delete dut;

  return 0;
}