#ifndef _CHIP8_H
#define _CHIP8_H

#ifdef __cplusplus
extern "C" {
#endif

#include <linux/ioctl.h>

#define CHIP8_MAGIC 'q'

typedef struct {
  unsigned int data;
  unsigned int addr;
} opcode;

/* ioctls and their arguments */
#define CHIP8_INSTR_WRITE _IOW(CHIP8_MAGIC, 1, opcode *)

#define CHIP_RAM_START 0x00
#define CHIP_RAM_END 0x800
#define DISK_RAM_START 0x800
#define DISK_RAM_END 0x880
#define KEYBOARD_ADDR 0xffe
#define CTRL_ADDR 0xfff

#ifdef __cplusplus
}
#endif

#endif
