// Due to time constraints, we were unable to integrate the sound module. 
// This file is mixed with some old testing code but does contain the guts
// to make the sound work.
module vga_ball(input logic        clk,
	        input logic 	   reset,
		input logic [15:0]  writedata,
		input logic 	   write,
		input 		   chipselect,
//		input logic [4:0]  address,
		output logic [7:0] addr,

		input left_chan_ready,
		input right_chan_ready,

		output logic [7:0] VGA_R, VGA_G, VGA_B,
		output logic 	   VGA_CLK, VGA_HS, VGA_VS,
		                   VGA_BLANK_n,
		output logic 	   VGA_SYNC_n,
		output logic [15:0] sample_data_l,
		output logic sample_valid_l,
		output logic [15:0] sample_data_r,
		output logic sample_valid_r);


   logic [10:0]	   hcount;
   logic [9:0]     vcount;
   logic [7:0] data;


   logic [7:0] 	   background_r, background_g, background_b;
//   logic [15:0]    game_data;

	reg [11:0] counter;
	//logic flag1;
	//logic flag2;
	logic flag3;

   fb_counters counters(.clk50(clk), .*);
   character_sprites boss(.addr(addr), .data(data));
   parameter DISP_COLS = 10'd640;
   parameter DISP_ROWS = 10'd480;
   parameter DISP_COL_OFFSET = 10'd64;
   parameter DISP_ROW_OFFSET = 10'd112;
   parameter CHIP8_SCALING_FACTOR = 8;

   logic [9:0] disp_col;  // hcount[10:1] is pixel column
   logic [9:0] disp_row;  // vcount[9:0] is pixel row
   logic chip8_area;
   logic is_foreground;
   logic [5:0] chip8_col;
   logic [4:0] chip8_row;
   logic [7:0] d_is_foreground;
   logic [7:0] misc;

   assign misc = 8'h80 >> (chip8_col % 8);

   assign disp_col = hcount[10:1];
   assign disp_row = vcount;

   assign chip8_col = (disp_col - DISP_COL_OFFSET) / CHIP8_SCALING_FACTOR;
   assign chip8_row = (disp_row - DISP_ROW_OFFSET) / CHIP8_SCALING_FACTOR;
   assign chip8_area = (disp_col >= DISP_COL_OFFSET) && (disp_col < (DISP_COLS - DISP_COL_OFFSET)) 
                          && (disp_row >= DISP_ROW_OFFSET) && (disp_row < (DISP_ROWS - DISP_ROW_OFFSET));
   assign addr = (chip8_row * 8'h08) + ( chip8_row / 8);
   assign d_is_foreground = data & misc;
   assign is_foreground = d_is_foreground > 0 ? 1 : 0;

	always_comb begin 
		{VGA_R,VGA_G,VGA_B}={8'h00,8'h00,8'h00};
		if ((VGA_BLANK_n) && (chip8_area) && (is_foreground))
		begin
			{VGA_R,VGA_G,VGA_B} = {8'hff, 8'hff, 8'hff};
		end
	else begin
		{VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
	end
end

	reg	[13:0] address1;
	wire	[15:0] q1;

	shoot audio1(.address(address1), .clock(clk), .q(q1)); //1653

logic left_chan_ready1;
logic right_chan_ready1;
initial begin
	left_chan_ready1 = 1'b1;
	right_chan_ready1 = 1'b1;
end	
	always_ff @(posedge clk) begin
		if(reset) begin
			counter <= 0;
			sample_valid_l <= 0; sample_valid_r <= 0;
		end

		else if(left_chan_ready1 == 1 && right_chan_ready1 == 1 && counter < 3125) begin
			counter <= counter + 1;
			sample_valid_l <= 0; sample_valid_r <= 0;
		end
		else if(left_chan_ready1 == 1 && right_chan_ready1 == 1 && counter == 3125) begin
			counter <= 0;
			sample_valid_l <= 1; sample_valid_r <= 1;

			if (is_foreground==1'b1 || flag3 ==1'b0) begin
				if (address1 < 13'd5832) begin
					address1 <= address1+1;
					flag3 <= 1'b0;
				end
				else begin
					address1 <=0;
					flag3 <= 1'b1;
				end
				sample_data_l <= q1;
				sample_data_r <= q1;
			end

			else begin
				sample_data_l <= 0;
				sample_data_r <= 0;
			end	
		end
		
		else begin
		sample_valid_l <= 0; sample_valid_r <= 0;
		end
	end



/*   always_comb begin

	case (address)
	  3'h3 : begin
		   hposnext    = {hpos[9:8], writedata};
		   vposnext    = vpos;
		 end
	  3'h4 : begin
		   hposnext    = {writedata[1:0], hpos[7:0]};
		   vposnext    = {vpos[8:6], writedata[7:2]};
	 	 end
	  3'h5 : begin
		   hposnext    = hpos;
		   vposnext    = {writedata[2:0], vpos[5:0]};
		 end
	  default: begin
		   hposnext    = hpos;
		   vposnext    = vpos;
		 end
        endcase
	
   end*/

/*   always_ff @(posedge clk)
   begin
	hpos <= hpos;
	vpos <= vpos;
     if (reset) begin
	hpos <= 10'd56;
	vpos <=  9'd56;
	background_r <= 8'h0;
	background_g <= 8'h0;
	background_b <= 8'h80;
     end else if (chipselect && write)
       case (address)
	 3'h0 : background_r <= writedata;
	 3'h1 : background_g <= writedata;
	 3'h2 : background_b <= writedata;
	 default: begin
		hpos <= hposnext;
		vpos <= vposnext;
	   end
       endcase
   end*/

/*   always_comb begin
      {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
      if (VGA_BLANK_n )
	if ( ((hcount[10:1] - hpos)*(hcount[10:1] - hpos) + (vcount[8:0] - vpos)*(vcount[8:0] - vpos)) <= 256 )
	  {VGA_R, VGA_G, VGA_B} = {8'h10, 8'hff, 8'h00};
	else
	  {VGA_R, VGA_G, VGA_B} =
             {background_r, background_g, background_b};
   end*/
	       
endmodule

module fb_counters(
 input logic 	     clk50, reset,
 output logic [10:0] hcount,  // hcount[10:1] is pixel column
 output logic [9:0]  vcount,  // vcount[9:0] is pixel row
 output logic 	     VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n);

/*
 * 640 X 480 VGA timing for a 50 MHz clock: one pixel every other cycle
 * 
 * HCOUNT 1599 0             1279       1599 0
 *             _______________              ________
 * ___________|    Video      |____________|  Video
 * 
 * 
 * |SYNC| BP |<-- HACTIVE -->|FP|SYNC| BP |<-- HACTIVE
 *       _______________________      _____________
 * |____|       VGA_HS          |____|
 */
   // Parameters for hcount
   parameter HACTIVE      = 11'd 1280,
             HFRONT_PORCH = 11'd 32,
             HSYNC        = 11'd 192,
             HBACK_PORCH  = 11'd 96,   
             HTOTAL       = HACTIVE + HFRONT_PORCH + HSYNC +
                            HBACK_PORCH; // 1600
   
   // Parameters for vcount
   parameter VACTIVE      = 10'd 480,
             VFRONT_PORCH = 10'd 10,
             VSYNC        = 10'd 2,
             VBACK_PORCH  = 10'd 33,
             VTOTAL       = VACTIVE + VFRONT_PORCH + VSYNC +
                            VBACK_PORCH; // 525

   logic endOfLine;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          hcount <= 0;
     else if (endOfLine) hcount <= 0;
     else  	         hcount <= hcount + 11'd 1;

   assign endOfLine = hcount == HTOTAL - 1;
       
   logic endOfField;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          vcount <= 0;
     else if (endOfLine)
       if (endOfField)   vcount <= 0;
       else              vcount <= vcount + 10'd 1;

   assign endOfField = vcount == VTOTAL - 1;

   // Horizontal sync: from 0x520 to 0x5DF (0x57F)
   // 101 0010 0000 to 101 1101 1111
   assign VGA_HS = !( (hcount[10:8] == 3'b101) &
		      !(hcount[7:5] == 3'b111));
   assign VGA_VS = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);

   assign VGA_SYNC_n = 1'b0; // For putting sync on the green signal; unused
   
   // Horizontal active: 0 to 1279     Vertical active: 0 to 479
   // 101 0000 0000  1280	       01 1110 0000  480
   // 110 0011 1111  1599	       10 0000 1100  524
   assign VGA_BLANK_n = !( hcount[10] & (hcount[9] | hcount[8]) ) &
			!( vcount[9] | (vcount[8:5] == 4'b1111) );

   /* VGA_CLK is 25 MHz
    *             __    __    __
    * clk50    __|  |__|  |__|
    *        
    *             _____       __
    * hcount[0]__|     |_____|
    */
   assign VGA_CLK = hcount[0]; // 25 MHz clock: rising edge sensitive
   
endmodule
