/*
 * Userspace program that communicates with the vga_ball device driver
 * through ioctls
 *
 * Stephen A. Edwards
 * Columbia University

 * Software Part of Breakout Game Remastered Project
 * CSEE 4840, Spring 2022, Columbia University 
 */


#include <stdio.h>
#include "vga_ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include <pthread.h>
#include <math.h>
#include <time.h>
#include "usbkeyboard.h"
#define BRICK_W 30
#define BRICK_H 15
#define BALL_R 10
#define PADDLE_W 90
#define PADDLE_H 20
#define PADDLE_R 10
#define PADDLE_L 70

#define SOUND_DEFULT 0
#define SOUND_HIT_BRICK 1
#define SOUND_WALL_PAD 2
#define SOUND_GAME_OVER 3


double h_location;
//double speed_paddle, ball_h = 312.0, ball_v = 440.0, speed_h, speed_v;
int brick_status[7][10];
int reset = 1;
int lives = 3;
int game_start = 0;
int finalstatus = 0;
//int size;
int vga_ball_fd;
hardware_data data = {0, 0, 0, 0, 0}; // TODO
struct libusb_device_handle *mouse;   // a mouse device handle
pthread_t mouse_thread;
void *mouse_thread_f(void *);
int ball_h = 195;
int ball_v = 425;
int sound_effect = 0;
int gloabl_score = 0;
int game_stage = 0; // 1, 2 
int game_hp = 3;
int game_over = 0; // 0 default 1 game over 2 win
int game_over_sound = 1;
int re_start = 1;
int easy_mode = 0;



/* Read and print the background color */
void print_background_color()
{
  vga_ball_arg_t vla;

  if (ioctl(vga_ball_fd, VGA_BALL_READ_BACKGROUND, &vla))
  {
    perror("ioctl(VGA_BALL_READ_BACKGROUND) failed");
    return;
  }
  // printf("%02x %02x %02x\n", vla.data.red, vla.data.green, vla.data.blue);
}

/* Set the background color */
void set_background_color(const hardware_data *c)
{
  vga_ball_arg_t vla;
  vla.data = *c;
  if (ioctl(vga_ball_fd, VGA_BALL_WRITE_BACKGROUND, &vla))
  {
    perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
    return;
  }
}

/* The 4  ways of hit */
/* return flag = 0 if not hit on the brick */
/* return flag = 1 if hit on the brick from top */
/* return flag = 2 if hit on the brick from bottom */
/* return flag = 3 if hit on the brick from left  */
/* return flag = 4 if hit on the brick from right */
/* use the flag to determine the ball velocity change */
/* the corresponding brick status should be changed into 0 */
int hitOnBrick(int ball_v, int ball_h, int brick_width, int brick_height, int brick_h, int brick_v)
{
  int flag;
  // h:horizontal; v:vertical
  // hit on top: flag= 1
  if (ball_h >= brick_h && ball_h <= brick_h + brick_width && ball_v >= brick_v - 5 && ball_v <=brick_v /*ball_h- 5  >= brick_h && ball_h+5<= brick_h + brick_width && ball_v + 5 >    brick_v && ball_v + 5 <=brick_v + brick_height*/)
    {
      flag = 1;
    }
  // hit on bottom: flag= 2
  else if (ball_h >= brick_h && ball_h <= brick_h + brick_width && ball_v <= brick_v + brick_height + 5 && ball_v >= brick_v + brick_height /*ball_h - 5 >= brick_h && ball_h + 5 <= brick_h + brick_width && ball_v <= brick_v + brick_height + 5 && ball_v - 5 > brick_v*/)
    {
      flag = 2;
    }
  // hit from left: flag= 3
  else if (ball_v >= brick_v && ball_v <= brick_v + brick_height && ball_h >= brick_h - 5 && ball_h <= brick_h /* ball_h + 5 >= brick_h && ball_h < brick_h + brick_width - 5*/)
    {
      flag = 3;
    }
  // hit from right: flag= 4
  else if (ball_v >= brick_v && ball_v <= brick_v + brick_height && ball_h <= brick_h + brick_width + 5 && ball_h >= brick_h + brick_width /*ball_h - 5 <= brick_h + brick_width && ball_h > brick_h + 5*/)
  {
    flag = 4;
  }
  // doesn't hit on the brick: flag= 0
  else
  {
    flag = 0;
  }

  return flag;
}


// conv game status
long get_game_status(int game_stage, int game_hp, int game_over) {
  int x[16];
  for (int j = 0; j < 16; j++) {
    x[j] = 0;
  }

  x[15] = game_stage;
  if (game_hp == 3) { 
    x[14] = 1;
    x[13] = 1;
  } else if (game_hp == 2) {
    x[13] = 1;
  }

  if (game_over == 1) {
    x[12] = 1;
  } else if (game_over == 2) {
    x[12] = 1;
    x[11] = 1;
  }


  long y = 0;
  for (int i = 0; i < 16; i++){
    y = y * 2 + x[i];
  }

  //printf("get_game_status %d", y);
  return(y);
}



// vec to binary
long long convert2bin( int x[13], int color) {
  long long  y = color; // 000 001 010 011 100 101

  // 1.color
  for (int i = 0; i < 13; i++){
    y = y * 2 + x[i];
  }
  return(y);
}

// vec to binary
long hex2hexadecimal(int score) {
  int x[16];
  
  for (int j = 0; j < 16; j++) {
    x[j] = 0;
  }

  int idx = 15; // 12-15 
  
  //printf("original score %d\n",score);
  while (score > 0) {
    int num = score % 10;

    int cur_idx = idx;
    while (num > 0) {
      x[cur_idx] = num % 2;
      num = (int)(num/2);
      cur_idx -= 1;
    }
    score = (int)(score / 10);
    idx -= 4;
  }

  long y = 0;
  for (int i = 0; i < 16; i++){
    y = y * 2 + x[i];
  }

  //printf("score %d, %lld \n", score, y);
  return(y);
  //vec 2 10
}



int check_clear(int matrix[6][13],int x, int y){
  for(int i = 0; i < x; i++){
    for (int j = 0; j < y; j++) { 
      if (matrix[i][j] != 0){
	       return 0;
      }
    }
  }
  return 1;
}



int main()
{
  vga_ball_arg_t vla;
  int i;
  int j;

  static const char filename[] = "/dev/vga_ball";

  printf("VGA ball Userspace program started\n");

  if ((vga_ball_fd = open(filename, O_RDWR)) == -1)
  {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

  printf("initial state: ");
  print_background_color();

  // input from device
  libusb_context *ctx = NULL; // a libusb session
  libusb_device **devs;       // pointer to pointer of device, used to retrieve a list of devices
  int r;                      // for return values
  ssize_t cnt;                // holding number of devices in list
  r = libusb_init(&ctx);      // initialize a library session
  if (r < 0)
  {
    printf("%s  %d\n", "Init Error", r); // there was an error
    return 1;
  }
  libusb_set_debug(ctx, 3);                 // set verbosity level to 3, as suggested in the documentation
  cnt = libusb_get_device_list(ctx, &devs); // get the list of devices
  if (cnt < 0)
  {
    printf("%s\n", "Get Device Error"); // there was an error
  }

  printf("\n11111\n");
  // mouse = libusb_open_device_with_vid_pid(ctx, 12943, 33); //open mouse
  // 081f:e401
  // mouse = libusb_open_device_with_vid_pid(ctx, 0x1c4f, 0x0002);
  mouse = libusb_open_device_with_vid_pid(ctx, 0x081f, 0xe401);
  printf("\n2222\n");





  if (mouse == NULL)
  {
    printf("%s\n", "Cannot open device");
    libusb_free_device_list(devs, 1); // free the list, unref the devices in it
    libusb_exit(ctx);                 // close the session
    return 0;
  }
  else
  {
    printf("%s\n", "Device opened");
    libusb_free_device_list(devs, 1); // free the list, unref the devices in it
    if (libusb_kernel_driver_active(mouse, 0) == 1)
    { // find out if kernel driver is attached
      printf("%s\n", "Kernel Driver Active");
      if (libusb_detach_kernel_driver(mouse, 0) == 0) // detach it
        printf("%s\n", "Kernel Driver Detached!");
    }
    r = libusb_claim_interface(mouse, 0); // claim interface 0 (the first) of device (mine had just 1)
    if (r < 0)
    {
      printf("%s\n", "Cannot Claim Interface");
      return 1;
    }
  }
  printf("%s\n", "Claimed Interface");

  pthread_create(&mouse_thread, NULL, mouse_thread_f, NULL);

  
  
  while(1) {
     // ===========
      // 0. define
      int brick_row = 6;
      int brick_col = 13;
      //int brick_matrix[brick_row][brick_col]; // 1 has brick 0 empty
      // int brick_width = BRICK_W;
      // int brick_height = BRICK_H;
      int ball_radius = BALL_R;
      int paddle_length = PADDLE_W;
      int brick_h, brick_v;
      int game_status;
      int flag[6][13];
      int flag_paddle = 0;
      int matrixclear;

      // 1. init
      // initialize

      h_location = 275;
      game_status = 1;
      game_over_sound = 1;
      game_start = 0;


      // 1.2 bricks
      // stage 1
      int brick_matrix[6][13] = {
        {0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,1,1,1,1,0,0,1,0,0,1,0,0}, 
        {0,1,0,0,0,0,0,1,0,0,1,0,0}, 
        {0,1,0,0,0,0,0,1,0,0,1,0,0},
        {0,1,1,1,1,0,0,1,1,1,1,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0}
      }; 

      /*
      // simifiy stage 1
      for(int i = 0; i < brick_row; i++){
        for (int j = 0; j < brick_col; j++) { 
            if ( i == 5 && j == 9){
               brick_matrix[i][j] = 1;
            }
            else if ( i == 4 && j == 11){
               brick_matrix[i][j] = 1;
            }
            else {
               brick_matrix[i][j] = 0;
            }
          }
      } */


      // stage 2 map
      int stage2matrix[6][13] = {
        {1,0,1,0,1,0,1,0,1,0,1,0,1},
        {1,0,1,0,1,0,1,0,1,0,1,0,1}, 
        {1,0,1,0,1,0,1,0,1,0,1,0,1}, 
        {1,0,1,0,1,0,1,0,1,0,1,0,1},
        {1,0,1,0,1,0,1,0,1,0,1,0,1},
        {1,0,1,0,1,0,1,0,1,0,1,0,1}
      };
      
      /*
      // simifiy stage 2 
      for(int i = 0; i < brick_row; i++){
        for (int j = 0; j < brick_col; j++) { 
            if ( i == 5 && j == 9){
               stage2matrix[i][j] = 1;
            }
            else if ( i == 4 && j == 11){
               stage2matrix[i][j] = 1;
            }
            else {
               stage2matrix[i][j] = 0;
            }
          }
      }*/


      // 3. easy mode
      int easy_matrix[6][13] = {
        {0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0}, 
        {0,0,0,0,0,0,0,0,0,0,0,0,0}, 
        {0,0,0,0,0,0,0,0,0,0,0,0,0},
        {0,0,0,0,0,0,0,0,0,0,1,0,0},
        {0,0,0,0,0,0,0,0,0,0,0,0,0}
      };



      // 1.3 ball
      ball_h = 208;
      ball_v = 425;
      int step = 1;
      int speed_h = 1;
      int speed_v = -2;
      int brick_width = 32;
      int brick_height = 16;




      // init data
      data.x_pad = 208;  // work
      gloabl_score = 0;
      game_stage = 0;
      game_over = 0;
      game_hp = 3;
      sound_effect = 0;
      easy_mode = 0;

      data.x_ball = ball_h;
      data.y_ball = ball_v;
      data.brick1  = convert2bin( brick_matrix[0], 0 );
      data.brick2  = convert2bin( brick_matrix[1], 1 );
      data.brick3  = convert2bin( brick_matrix[2], 2 );
      data.brick4  = convert2bin( brick_matrix[3], 3 );
      data.brick5  = convert2bin( brick_matrix[4], 4 );
      data.brick6  = convert2bin( brick_matrix[5], 5 );
      data.score = hex2hexadecimal(gloabl_score);
      data.game_status = get_game_status(game_stage, game_hp, game_over);

      set_background_color(&data); // TODO


    // game logitic
    while (1)
    { 

      sound_effect = SOUND_DEFULT;
      if (game_start == 0) {
        continue;
      }




      sound_effect = 0; // init

      ball_h += speed_h * step;
      ball_v += speed_v * step;
      // data.x_ball       = (int) ball_h * 4; // TODO
      // data.green = 195;
      data.x_ball = ball_h;
      data.y_ball = ball_v; 


      //printf(" %d, %d \n", data.x_ball, data.y_ball);


      // check hit wall
      if (ball_v <= 53) {
        speed_v = 0 - speed_v;
        sound_effect = SOUND_WALL_PAD;
      }    
      if (ball_h >= 411) {
        speed_h = 0 - speed_h;
        sound_effect = SOUND_WALL_PAD;
      }
      if (ball_h <= 5) {
        speed_h = 0 - speed_h;
        sound_effect = SOUND_WALL_PAD;
      }
      // check hit pad
      //if (ball_h <=  data.x_pad +20 && ball_h >= data.x_pad -20 && ball_v == 429/*ball_v +5 >= 430 && ball_v + 5 <= 440*/){
      if (ball_h <=  data.x_pad +20 && ball_h >= data.x_pad -20 && ball_v >= 425 && ball_v <= 430/*ball_v +5 >= 430 && ball_v + 5 <= 440*/){
        speed_v = 0 - speed_v;
        sound_effect = SOUND_WALL_PAD;
      }
     
      //printf("easy_mode, %d", easy_mode);
      // easy mode
      if (easy_mode == 1) {
          for(int i = 0; i < brick_row; i++){
           for (int j = 0; j < brick_col; j++) { 
             brick_matrix[i][j] = easy_matrix[i][j] ;
           }
         }
      }


      // check hit brick    
      for (int i = 0; i < 6; i++) {
        for (int j = 0; j < 13; j++) {
          if (brick_matrix[i][j] == 1)
              {
                //printf("%d \n",brick_matrix[i][j]);
                brick_h = brick_width * j;
                brick_v = brick_height * i + 80;
                flag[i][j] = hitOnBrick(ball_v, ball_h,  brick_width, brick_height, brick_h, brick_v);
                // update flag
                if (flag[i][j] == 1) {
                      speed_v = 0 - speed_v;
                      brick_matrix[i][j] = 0;
                }
                if (flag[i][j] == 2) {
                      speed_v = 0 - speed_v;
                      brick_matrix[i][j] = 0;
                }
                if (flag[i][j] == 3) {
                      speed_h = 0 - speed_h;
                      brick_matrix[i][j] = 0;
                }
                if (flag[i][j] == 4) {
                      speed_h = 0 - speed_h;
                      brick_matrix[i][j] = 0;
                }
                // hit brick
                if (flag[i][j] != 0) {
                  sound_effect = SOUND_HIT_BRICK;  
                  gloabl_score += 10;
                }
              }
          }
      }


      // check game over TODO
      if (ball_v >= 475) {
        game_hp -= 1;

        ball_h = data.x_pad;
        ball_v = 425;
        game_start = 0;
        speed_h = 1;
        speed_v = -2;
      }

      if (game_hp == 0) {
        sound_effect = SOUND_GAME_OVER;
        data.sound_effect = sound_effect; 
        game_over = 1;
        break;
      }


      //printf("%d %d, %d, %d \n", data.brick3, data.brick4, data.brick5, data.brick6);
      

      matrixclear = check_clear(brick_matrix, 6, 13);

      // win
      if (matrixclear == 1 && game_stage == 1) {
        game_over = 2;
        sound_effect = 4;
        data.brick1  = convert2bin( brick_matrix[0], 0 );
        data.brick2  = convert2bin( brick_matrix[1], 1 );
        data.brick3  = convert2bin( brick_matrix[2], 2 );
        data.brick4  = convert2bin( brick_matrix[3], 3 );
        data.brick5  = convert2bin( brick_matrix[4], 4 );
        data.brick6  = convert2bin( brick_matrix[5], 5 );
        data.sound_effect = sound_effect; 
        data.score = hex2hexadecimal(gloabl_score); 
        data.game_status = get_game_status(game_stage, game_hp,game_over);
        break;
      } 

      //  2rd stage
      if ( matrixclear == 1) {
        data.x_pad = 208;
        ball_h = data.x_pad;
        ball_v = 425;
        game_start = 0;
        step = 2; // ball step
        speed_h = 1;
        speed_v = -2;
        game_stage = 1;
        sound_effect = 0;
        easy_mode = 0;

        for(int i = 0; i < brick_row; i++){
  	       for (int j = 0; j < brick_col; j++) { 
  	         brick_matrix[i][j] = stage2matrix[i][j] ;
  	       }
  	     }
      }

      // assign data
      data.brick1  = convert2bin( brick_matrix[0], 0 );
      data.brick2  = convert2bin( brick_matrix[1], 1 );
      data.brick3  = convert2bin( brick_matrix[2], 2 );
      data.brick4  = convert2bin( brick_matrix[3], 3 );
      data.brick5  = convert2bin( brick_matrix[4], 4 );
      data.brick6  = convert2bin( brick_matrix[5], 5 );
      data.sound_effect = sound_effect; 
      data.score = hex2hexadecimal(gloabl_score); 
      data.game_status = get_game_status(game_stage, game_hp,game_over);


      set_background_color(&data); // TODO
      usleep(15000);               // 1000000

    }  
    
    if (game_over == 2) {
      data.game_status = get_game_status(game_stage, game_hp, game_over);
      set_background_color(&data); 
    } else if (game_over == 1) {
      data.game_status = get_game_status(game_stage, game_hp, game_over);
      set_background_color(&data); 
    }


    // reset sound aviod too long
    usleep(250000);  
    sound_effect = 0;
    data.sound_effect = sound_effect; 
    int original_ball_x = ball_h;
    int original_pad_x = data.x_pad;
    //set_background_color(&data); 

    re_start = 0;
    while (re_start == 0) {
        data.x_pad = original_pad_x;
        data.x_ball = original_ball_x;
        re_start = 0;
        set_background_color(&data); 
    }
  }

  return 0;
}



//read the mouse
void *mouse_thread_f(void *ignored)
{
  printf("mouse thread started\n");

  vga_ball_arg_t vla;
  

  while (1)
  {
    unsigned char buff[64];
    int size = 8;
    libusb_interrupt_transfer(mouse, 0x81, buff, 0x0008, &size, 0);

    int t_speed = 0;
    int pad_diff = 0;
    int step = 2;
    int screen_left = 16;
    int screen_right = 400;

    //printf("buff[0],buff[1],buff[2] %d, %d, %d,%d, %d, %d,%d ,%d \n", buff[0],buff[1],buff[2],buff[3],buff[4],buff[5],buff[6],buff[7]);

    // left:  0   127  0 128 128 15
    // right: 255 127 0 128 128 15 
    // up:    127 0   0 128 128 15
    // down   127 255 0 128 128 15
    // A:     127 127 0 128 128 47
    // restart: 127 127 0 128 128 15 32
    // X + Y: 127 127 0 128 128 15  9
    // X:     127 127 0 128 128 31
    // Y:     127 127 0 128 128 143 
    if (buff[0] == 0) {
      // 0 127 0 128 128 15
      // left
      pad_diff = -step;

      // ball move with pad
      if (game_start == 0 && (screen_left < ball_h - step)) {
        ball_h -= step;
      }

    } else if (buff[0] == 255) {
      // right
      // 255 127 0 128 128 15 
      pad_diff = step;

      // ball move with pad
      if (game_start == 0 && (ball_h + step < screen_right)) {
        ball_h += step;
      }

    //} else if (buff[0] == 127 && buff[1] == 0) {
    } else if (buff[0] == 127 && buff[1] == 127 && buff[5] == 47) {
      game_start = 1;
      //printf("start \n");

    //} else if (buff[0] == 127 && buff[1] == 255) {
    } else if (buff[0] == 127 && buff[1] == 127 && buff[5] == 15 && buff[6] == 32) {
      re_start = 1;
      //printf("restart \n");
    } else if (buff[0] == 127 && buff[1] == 127 && buff[5] == 159 && (game_start == 1)) {
      //printf("easy");
      easy_mode = 1;
      // 
    }

    //printf("%d, %d, %d, %d\n", buff[0],buff[1],buff[2],buff[3]);


    // data.x_ball =  195;
    // data.y_ball =  300;
    //  30 - 360
    // avoid pad hit pall
    if ((screen_left < data.x_pad + pad_diff) && (data.x_pad + pad_diff < screen_right))
    {
      data.x_pad = data.x_pad + pad_diff; // work
    }

    data.x_ball = ball_h;
    data.y_ball = ball_v;
    set_background_color(&data); // TODO
  }
}
