#include <stdio.h>
#include "vga_ball.h"
#include <stdlib.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include "usbkeyboard.h"
#include <pthread.h>

#define SERVER_HOST "128.59.64.152"
#define SERVER_PORT 42000

#define BUFFER_SIZE 128

int vga_ball_fd;

struct libusb_device_handle *keyboard;
uint8_t endpoint_address;

pthread_t network_thread;
void *network_thread_f(void *);


/* Read and print the background color */
void print_background_color() {
  vga_ball_arg_t vla;
  
  if (ioctl(vga_ball_fd, VGA_BALL_READ_BACKGROUND, &vla)) {
      perror("ioctl(VGA_BALL_READ_BACKGROUND) failed");
      return;
  }
  printf("%04x\n",vla.background.game_data);
}

/* Set the background color */
void set_background_color(vga_ball_color_t *c)
{
  vga_ball_arg_t vla;
  vla.background = *c;
  if (ioctl(vga_ball_fd, VGA_BALL_WRITE_BACKGROUND, &vla)) {
      perror("ioctl(VGA_BALL_SET_BACKGROUND) failed");
      return;
  }
}

// attack bullet

void bullet_cal(char *c,short *d,char *e,char flag)
{
    char x,y;


    if(*(c+3)){
    switch(*(c+2)){
	case 0x00 : *(c+1) = *(c+1)-0x02; break;
	case 0x01: *c = *c-0x02;break;
	case 0x02: *(c+1) = *(c+1)+0x02;break;
	case 0x03: *c = *c + 0x02;break;}

    if(*c<16||*c>220||*(c+1)<8||*(c+1)>216)  *(c+3) = 0x00;


    if(*c<128&&*c>112&&*(c+1)<216&&*(c+1)>200)  
	{ *(d+18) = *(d+18)&0x0fff|0x1000; *(d+18) = (*(d+18))&0xfffc|0x0003;	set_background_color(d);}


if(flag){
	// attack emeny1 tank
    if(((*(d+5))&0x0001)== 0x0001){
    if((*c)<(((*(d+4))&0xff00)/256+16)&&(*c)>(((*(d+4))&0xff00)/256))
        {if ((*(c+1))<(((*(d+4))&0x00ff)%256+16)&&(*(c+1))>(((*(d+4))&0x00ff)%256) )
	{	*(d+5) = (*(d+5))&0xfffe;
		*(d+18) = (*(d+18))&0xfffc|0x0003;
		set_background_color(d);	
                *(c+3) = 0x00;}}}
  
	// attack emeny2 tank
    if(((*(d+7))&0x0001)== 0x0001){
    if((*c)<(((*(d+6))&0xff00)/256+16)&&(*c)>(((*(d+6))&0xff00)/256))
        {if ((*(c+1))<(((*(d+6))&0x00ff)%256+16)&&(*(c+1))>(((*(d+6))&0x00ff)%256) )
	{	*(d+7) = (*(d+7))&0xfffe;
		*(d+18) = (*(d+18))&0xfffc|0x0003;	
		set_background_color(d);
                *(c+3) = 0x00;}}}

	// attack emeny3 tank
    if(((*(d+9))&0x0001)== 0x0001){
    if((*c)<(((*(d+8))&0xff00)/256+16)&&(*c)>(((*(d+8))&0xff00)/256))
        {if ((*(c+1))<(((*(d+8))&0x00ff)%256+16)&&(*(c+1))>(((*(d+8))&0x00ff)%256) )
	{	*(d+9) = (*(d+9))&0xfffe;
		*(d+18) = (*(d+18))&0xfffc|0x0003;
		set_background_color(d);
                *(c+3) = 0x00;}}}

	// attack emeny4 tank
    if(((*(d+11))&0x0001)== 0x0001){
    if((*c)<(((*(d+10))&0xff00)/256+16)&&(*c)>(((*(d+10))&0xff00)/256))
        {if ((*(c+1))<(((*(d+10))&0x00ff)%256+16)&&(*(c+1))>(((*(d+10))&0x00ff)%256) )
	{	*(d+11) = (*(d+11))&0xfffe;
		*(d+18) = (*(d+18))&0xfffc|0x0003;
		set_background_color(d);
                *(c+3) = 0x00;}}}
}

else {
    if(((*(d+3))&0x0001)== 0x0001){
    if((*c)<(((*(d+2))&0xff00)/256+16)&&(*c)>(((*(d+2))&0xff00)/256))
        {if ((*(c+1))<(((*(d+2))&0x00ff)%256+16)&&(*(c+1))>(((*(d+2))&0x00ff)%256) )
	{	*(d+3) = (*(d+3))&0xfffe;
		*(d+18) = (*(d+18))&0xfffc|0x0003;
		set_background_color(d);
                *(c+3) = 0x00;}}}
}


    x = (*c-16)/8;
    y = (*(c+1)-8)/8;
   
    switch(*(c+2))  //table[0] = i*2048+j*64+map[j][i]*2+1;
	{
	   case 0x00:{ if( (*(e+y*26+x)) ==1)       {*(e+y*26+x) = 2;*(c+3) = 0x00;*d=x*2048+y*64+2*2+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} 
                       else if( (*(e+y*26+x)) ==4)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==2)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==3)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==6)  {*(c+3) = 0x00;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} //brick bullet disapper
                       if( (*(e+y*26+x+1)) ==1)  {*(e+y*26+x+1) = 2;*(c+3) = 0x00;*d=(x+1)*2048+2*2+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+1)) ==4)  {*(e+y*26+x+1) = 0;*(c+3) = 0x00;*d=(x+1)*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+1)) ==2)  {*(e+y*26+x+1) = 0;*(c+3) = 0x00;*d=(x+1)*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+1)) ==5)  {*(e+y*26+x+1) = 0;*(c+3) = 0x00;*d=(x+1)*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+1)) ==6)  {*(c+3) = 0x00;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} //brick bullet disapper
                       break;}

	   case 0x01:{ if( (*(e+y*26+x)) ==1)       {*(e+y*26+x) = 5;*(c+3) = 0x00;*d=x*2048+y*64+5*2+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} 
                       else if( (*(e+y*26+x)) ==5)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==4)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==3)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==6)  {*(c+3) = 0x00;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} //brick bullet disapper
                       if( (*(e+y*26+x+26)) ==1)  {*(e+y*26+x+26) = 5;*(c+3) = 0x00;*d=x*2048+5*2+(y+1)*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+26)) ==3)  {*(e+y*26+x+26) = 0;*(c+3) = 0x00;*d=x*2048+(y+1)*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+26)) ==2)  {*(e+y*26+x+26) = 0;*(c+3) = 0x00;*d=x*2048+(y+1)*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+26)) ==5)  {*(e+y*26+x+26) = 0;*(c+3) = 0x00;*d=x*2048+(y+1)*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+26)) ==6)  {*(c+3) = 0x00;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} //brick bullet disapper
                       break;     }

	   case 0x02:{ if( (*(e+y*26+x)) ==1)       {*(e+y*26+x) = 4;*(c+3) = 0x00;*d=x*2048+y*64+4*2+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} 
                       else if( (*(e+y*26+x)) ==4)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==2)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==3)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==6)  {*(c+3) = 0x00;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} //brick bullet disapper
                       if( (*(e+y*26+x+1)) ==1)  {*(e+y*26+x+1) = 4;*(c+3) = 0x00;*d=(x+1)*2048+4*2+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+1)) ==4)  {*(e+y*26+x+1) = 0;*(c+3) = 0x00;*d=(x+1)*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+1)) ==2)  {*(e+y*26+x+1) = 0;*(c+3) = 0x00;*d=(x+1)*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+1)) ==5)  {*(e+y*26+x+1) = 0;*(c+3) = 0x00;*d=(x+1)*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+1)) ==6)  {*(c+3) = 0x00;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} //brick bullet disapper
                       break;     }
                
	   case 0x03:{ if( (*(e+y*26+x)) ==1)       {*(e+y*26+x) = 3;*(c+3) = 0x00;*d=x*2048+y*64+3*2+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} 
                       else if( (*(e+y*26+x)) ==5)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==4)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==3)  {*(e+y*26+x) = 0;*(c+3) = 0x00;*d=x*2048+y*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x)) ==6)  {*(c+3) = 0x00;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} //brick bullet disapper
                       if( (*(e+y*26+x+26)) ==1)  {*(e+y*26+x+26) = 3;*(c+3) = 0x00;*d=x*2048+3*2+(y+1)*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+26)) ==3)  {*(e+y*26+x+26) = 0;*(c+3) = 0x00;*d=x*2048+(y+1)*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+26)) ==2)  {*(e+y*26+x+26) = 0;*(c+3) = 0x00;*d=x*2048+(y+1)*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+26)) ==5)  {*(e+y*26+x+26) = 0;*(c+3) = 0x00;*d=x*2048+(y+1)*64+1;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);}
                       else if( (*(e+y*26+x+26)) ==6)  {*(c+3) = 0x00;*(d+18) = (*(d+18))&0xfffc|0x0002;set_background_color(d);} //brick bullet disapper
                       break;     }
	}
        *d=x*2048+y*64+0;
  
        set_background_color(d);   
   }
}

void rote(char i, char dir,char *c,short *d)  //tank,direction,map,table
{
        int temp1,temp2,temp3,temp4,temp5,temp6;
        short temp_check=0;
        char j;
        char check1=0;
        char check2=0;
        char check3=0;
        char check4=0;

          temp1 = (((*(d+2*i))&0xff00)/256-0x10)/8 + ((((*(d+2*i))&0x00ff)%256-0x09)/8)*26;
          temp2 = (((*(d+2*i))&0xff00)/256-0x11)/8 + ((((*(d+2*i))&0x00ff)%256-0x08)/8)*26;
          temp3 = (((*(d+2*i))&0xff00)/256-0x10)/8 + ((((*(d+2*i))&0x00ff)%256+0x08)/8)*26;
          temp4 = (((*(d+2*i))&0xff00)/256+0x00)/8 + ((((*(d+2*i))&0x00ff)%256-0x08)/8)*26;
	
	for(j=1;j<6;j++){
         if(j!=i && (*(d+2*j+1)&0x01) ) 
         if ( ((*(d+2*i))&0x00ff ) <= ((*(d+2*j)+0x0011)&0x00ff)) 
         if ( ((*(d+2*i))&0x00ff ) > ((*(d+2*j)-0x0010)&0x00ff)) 
		if (  ((*(d+2*i))&0xff00) > ( (*(d+2*j)-0x1000 )&0xff00)  ) 
		if (  ((*(d+2*i))&0xff00) < ( (*(d+2*j)+0x1000)&0xff00 )  ) 
              check1=1;  

         if(j!=i && (*(d+2*j+1)&0x01) ) 
         if ( ((*(d+2*i))&0x00ff ) > ((*(d+2*j)-0x10)&0x00ff)) 
         if ( ((*(d+2*i))&0x00ff ) < ((*(d+2*j)+0x10)&0x00ff)) 
		if (  ((*(d+2*i))&0xff00) > ( (*(d+2*j)-0x1000 )&0xff00)  ) 
		if (  ((*(d+2*i))&0xff00) <= ( (*(d+2*j)+0x1100)&0xff00 )  ) 
              check2=1; 
 

         if(j!=i && (*(d+2*j+1)&0x01) ) 
         if ( ((*(d+2*i))&0x00ff ) >= ((*(d+2*j)-0x11)&0x00ff)) 
         if ( ((*(d+2*i))&0x00ff ) < ((*(d+2*j)+0x10)&0x00ff)) 
		if (  ((*(d+2*i))&0xff00) > ( (*(d+2*j)-0x1000 )&0xff00)  ) 
		if (  ((*(d+2*i))&0xff00) < ( (*(d+2*j)+0x1000)&0xff00 )  ) 
              check3=1;  

          if(j!=i && (*(d+2*j+1)&0x01) ) 
         if ( ((*(d+2*i))&0x00ff ) > ((*(d+2*j)-0x10)&0x00ff)) 
         if ( ((*(d+2*i))&0x00ff ) < ((*(d+2*j)+0x10)&0x00ff)) 
		if (  ((*(d+2*i))&0xff00) >= ( (*(d+2*j)-0x1100 )&0xff00)  ) 
		if (  ((*(d+2*i))&0xff00) < ( (*(d+2*j)+0x1000)&0xff00 )  ) 
              check4=1;   
	}
	
       temp_check = *(d+2*i);
        // up 
        switch(dir){
       
        case 0:{                 

                *(d+2*i)= (*(d+2*i)+0x0400)&0xf8ff; //adjustment
		for(j=1;j<6;j++){
       		  if(j!=i && (*(d+2*j+1)&0x01) ) 
       		  if ( ((*(d+2*i))&0x00ff ) <= ((*(d+2*j)+0x0011)&0x00ff)) 
       		  if ( ((*(d+2*i))&0x00ff ) > ((*(d+2*j)-0x0010)&0x00ff)) 
		  if (  ((*(d+2*i))&0xff00) > ( (*(d+2*j)-0x1000 )&0xff00)  ) 
		  if (  ((*(d+2*i))&0xff00) < ( (*(d+2*j)+0x1000)&0xff00 )  ) 
         	     check1=1;   
		}
		if(!check1 &&
		  ( (*(c+temp1) == 0||*(c+temp1) ==8||(*(c+temp1) ==2 && (((*(d+2*i)&0x00ff)%256-0x09)&0x07) >0x03))
       		  &&(*(c+temp1+1) == 0||*(c+temp1+1) == 8 || (*(c+temp1+1) ==2 && (((*(d+2*i)&0x00ff)%256-0x09)&0x07) >0x03)))   
		&& (((*(d+2*i))&0x00ff)>8) )   *(d+2*i) = *(d+2*i) -0x01;
  
                 else {  
			*(d+2*i)=temp_check;
			if (i!=1)  *(d+2*i+1)= ((*(d+2*i+1))&0xffcf)+(rand()%4)*16;
			}
        	
		if (i==1) *(d+2*i+1) = (*(d+2*i+1))&0xffcf;  //change direction	
		else if((rand()%64)==0) *(d+2*i+1)= ((*(d+2*i+1))&0xffcf)+(rand()%4)*16;

       		break;
        	}

       case 1:{  
		*(d+2*i)= (*(d+2*i)+0x0004)&0xfff8;//adjustment
		for(j=1;j<6;j++){
 			if(j!=i && (*(d+2*j+1)&0x01) ) 
			if ( ((*(d+2*i))&0x00ff ) > ((*(d+2*j)-0x10)&0x00ff)) 
			if ( ((*(d+2*i))&0x00ff ) < ((*(d+2*j)+0x10)&0x00ff)) 
			if (  ((*(d+2*i))&0xff00) > ( (*(d+2*j)-0x1000 )&0xff00)  ) 
			if (  ((*(d+2*i))&0xff00) <= ( (*(d+2*j)+0x1100)&0xff00 )  ) 
			check2=1; 
			}
      		 if(!check2
			 &&( (*(c+temp2) == 0||*(c+temp2) ==8||(*(c+temp2) ==5 && (((*(d+2*i)&0xff00)/256-0x11)&0x07) >0x03))
        		 &&(*(c+temp2+26) == 0||*(c+temp2+26) == 8 || (*(c+temp2+26) ==5 && (((*(d+2*i)&0xff00)/256-0x11)&0x07) >0x03))) 
			 &&(((*(d+2*i))&0xff00)>0x1000) ) *(d+2*i) = *(d+2*i) - 0x0100;
 		else { 
			*(d+2*i)=temp_check;
			if (i!=1)  *(d+2*i+1)= ((*(d+2*i+1))&0xffcf)+(rand()%4)*16;
			}

	
        	if (i==1) *(d+2*i+1) = ((*(d+2*i+1))&0xffcf)|0x0010;  //change direction

		else if((rand()%64)==0) *(d+2*i+1)= ((*(d+2*i+1))&0xffcf)+(rand()%4)*16;

		break;}

       case 2:{
		*(d+2*i)= (*(d+2*i)+0x0400)&0xf8ff;
		for(j=1;j<6;j++){
			if(j!=i && (*(d+2*j+1)&0x01) ) 
			if ( ((*(d+2*i))&0x00ff ) >= ((*(d+2*j)-0x11)&0x00ff)) 
			if ( ((*(d+2*i))&0x00ff ) < ((*(d+2*j)+0x10)&0x00ff)) 
			if (  ((*(d+2*i))&0xff00) > ( (*(d+2*j)-0x1000 )&0xff00)  ) 
			if (  ((*(d+2*i))&0xff00) < ( (*(d+2*j)+0x1000)&0xff00 )  ) 
           		   check3=1;  
			}

		if(!check3 
  			 && ( (*(c+temp3) == 0||*(c+temp3) ==8||(*(c+temp3) ==4 && (((*(d+2*i)&0x00ff)%256+0x08)&0x07) <0x04))
         		&&(*(c+temp3+1) == 0||*(c+temp3+1) == 8 || (*(c+temp3+1) ==4 && (((*(d+2*i)&0x00ff)%256+0x08)&0x07) <0x04))) 
	 		&& ((*(d+2*i)&0x00ff)<200) ) *(d+2*i) = *(d+2*i) + 0x01;
		else { 
			*(d+2*i)=temp_check;
			if (i!=1)  *(d+2*i+1)= ((*(d+2*i+1))&0xffcf)+(rand()%4)*16;

			}
        	if (i==1)  *(d+2*i+1) = ((*(d+2*i+1))&0xffcf)|0x0020;  //change direction

		else if((rand()%64)==0) *(d+2*i+1)= ((*(d+2*i+1))&0xffcf)+(rand()%4)*16;

    		break;}


       case 3:{           	
		*(d+2*i)= (*(d+2*i)+0x0004)&0xfff8;
		for(j=1;j<6;j++){
			if(j!=i && (*(d+2*j+1)&0x01) ) 
			if ( ((*(d+2*i))&0x00ff ) > ((*(d+2*j)-0x10)&0x00ff)) 
			if ( ((*(d+2*i))&0x00ff ) < ((*(d+2*j)+0x10)&0x00ff)) 
			if (  ((*(d+2*i))&0xff00) >= ( (*(d+2*j)-0x1100 )&0xff00)  ) 
			if (  ((*(d+2*i))&0xff00) < ( (*(d+2*j)+0x1000)&0xff00 )  ) 
             		 check4=1;   
		}
		if(!check4 
		&& ( (*(c+temp4) == 0||*(c+temp4) ==8||(*(c+temp4) ==3 && (((*(d+2*i)&0xff00)/256+0x00)&0x07) <0x04))
         	&&(*(c+temp4+26) == 0||*(c+temp4+26) == 8 || (*(c+temp4+26) ==3 && (((*(d+2*i)&0xff00)/256+0x00)&0x07) <0x04))) 
		 &&(((*(d+2*i))&0xff00)<0xd000) ) *(d+2*i) = *(d+2*i) + 0x0100;
 

		else { 
			*(d+2*i)=temp_check;
			if (i!=1)  *(d+2*i+1)= ((*(d+2*i+1))&0xffcf)+(rand()%4)*16;

			}    	     

        	if (i==1)  *(d+2*i+1)= ((*(d+2*i+1))&0xffcf)|0x0030;  //change direction

		else if((rand()%64)==0) *(d+2*i+1)= ((*(d+2*i+1))&0xffcf)+(rand()%4)*16;

	 	
         	break;}
       }
}

int main()
{
  vga_ball_arg_t vla;

  struct sockaddr_in serv_addr;

  struct usb_keyboard_packet packet;
   char map[][26]={{0,0,0,0,1,1,0,0,0,0,1,1,0,0,0,0,0,0,1,1,0,0,0,0,0,0},
                  {0,0,0,0,1,1,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,0,0,0},
                  {8,8,1,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0,1,1,1,0,0,0,0,0},
                  {8,8,1,1,1,1,1,1,0,0,1,1,0,0,6,6,0,0,1,1,1,0,0,0,0,0},
                  {8,8,8,8,8,8,0,0,0,0,1,1,0,0,1,1,0,0,1,1,0,0,0,1,1,0},
                  {8,8,8,8,8,8,0,0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,1,1,0},
                  {8,8,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,0,0,11,11},
	          {8,8,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,0,0,11,11},
                  {0,0,1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	          {0,0,1,1,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,1,1,0,0,0,0,0,1,1,1,1,1,1,1,1,1,1,1,6,6,6,6},
                  {0,0,0,0,1,1,0,0,0,0,0,1,1,1,1,1,0,0,1,1,0,0,0,0,0,0},
                  {1,1,1,1,0,0,1,1,0,0,0,1,1,1,1,1,8,8,1,1,0,0,0,0,1,1},
                  {1,1,1,1,0,0,1,1,0,0,0,1,1,1,1,1,8,8,1,1,6,6,6,6,1,1},
                  {0,0,0,0,0,0,6,6,0,0,0,0,0,0,8,8,8,8,8,8,8,8,0,0,0,0},
                  {0,0,0,0,0,0,6,6,0,0,6,6,0,0,8,8,8,8,8,8,8,8,0,0,0,0},
                  {11,11,11,11,0,0,11,11,11,11,11,11,11,11,11,11,0,0,11,11,11,11,11,11,11,11},
                  {11,11,11,11,0,0,11,11,11,11,11,11,11,11,11,11,0,0,11,11,11,11,11,11,11,11},
                  {8,8,8,8,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {8,8,8,8,0,0,0,1,0,0,0,0,1,1,1,1,0,0,0,0,0,0,0,0,0,0},
                  {8,8,8,8,1,1,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1,0,0},
                  {8,8,8,8,1,1,0,0,1,0,0,0,0,0,0,1,0,0,6,6,1,1,1,1,0,0},
                  {8,8,0,0,1,1,0,0,1,0,0,0,0,0,0,0,0,0,1,1,0,0,1,1,0,0},
                  {8,8,6,6,1,1,0,0,1,0,0,1,1,1,1,0,0,0,0,0,0,0,1,1,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,1,12,13,1,0,0,0,0,0,0,0,1,1,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,1,14,15,1,0,0,0,1,1,0,0,0,0,0,0}};


   char map2[][26]={{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {0,0,1,0,0,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0},
                  {0,0,1,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0},
                  {0,0,1,0,0,0,0,0,1,0,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0},
                  {0,0,1,0,0,0,0,0,1,0,1,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0},
	          {0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0,1,1,1,0,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	          {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,1,1,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,1,0,0,0,1,0,0,0,1,0,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,1,0,1,1,1,1,1,0,1,0,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,1,1,1,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,1,1,1,0,1,0,1,1,1,0,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,1,1,1,0,1,0,1,1,1,0,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,1,1,1,0,0,0,1,1,1,0,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,1,1,1,1,1,1,1,1,1,0,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,1,0,1,1,1,1,1,0,1,0,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}};

   char map3[][26]={{0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {0,1,0,1,0,1,0,1,1,0,1,1,1,0,1,1,1,0,1,1,1,0,1,0,1,0},
                  {0,1,0,1,0,1,0,1,0,0,0,1,0,0,1,0,1,0,1,0,1,0,1,0,1,0},
                  {0,1,0,1,0,1,0,1,0,0,0,1,0,0,1,0,1,0,1,1,1,0,1,1,1,0},
                  {0,1,0,1,0,1,0,1,0,0,0,1,0,0,1,0,1,0,1,1,0,0,0,1,0,0},
                  {0,0,1,0,0,1,0,1,1,0,0,1,0,0,1,1,1,0,1,0,1,0,0,1,0,0},
	          {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
	          {0,0,0,0,0,0,0,0,1,1,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,0,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,1,0,0,1,0,1,0,0,1,1,0,0,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,1,0,0,0,1,0,0,1,0,0,1,1,0,0,0,0,0,0,0},
                  {0,0,0,0,0,0,1,1,1,0,0,1,0,0,1,0,0,1,0,1,0,0,0,0,0,0},
                  {0,0,0,0,0,1,0,0,0,1,1,1,0,0,1,0,0,1,0,0,1,0,0,0,0,0},
                  {0,0,0,0,0,1,0,0,0,0,0,0,1,0,1,0,0,1,0,0,1,0,0,0,0,0},
                  {0,0,0,0,0,1,0,0,0,0,0,0,0,1,1,0,0,1,0,0,1,0,0,0,0,0},
                  {0,0,0,0,0,1,0,0,0,1,0,0,0,1,0,1,1,1,0,0,1,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,0,0,1,1,1,0,0,0,0,0,1,1,1,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
                  {0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},
                  {0,0,0,0,0,0,0,1,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0},
                  {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0}};


  int transferred;
  char keystate[12];

  int i;
  char flag_enemy1=0;
  char flag=0;
  char flag2=0;
  char flag4 = 0;
  char flag8 =0;
  char flag16 =0;
  char flag32 = 0;

  char game = 0x00;

  char flag_count=0x00;

  char tank_num1 = 16;   // total tank
  char tank_num2 = 0;    //current tank number
  char tank_ku[] = {0x42,0x52,0x62,0x72,0x42,0x52,0x62,0x72,
		    0x42,0x52,0x62,0x72,0x42,0x52,0x62,0x72};
  
  char life =0x03;

  char bullet1[]={0x00,0x00,0x00,0x00};      // x,y,direction,en;
  char bullet2[]={0x00,0x00,0x00,0x00};      // x,y,direction,en;
  char bullet3[]={0x00,0x00,0x00,0x00};      // x,y,direction,en;
  char bullet4[]={0x00,0x00,0x00,0x00};      // x,y,direction,en;
  char bullet5[]={0x00,0x00,0x00,0x00};      // x,y,direction,en;

  short table[]={0x0000,0x0000,0x50c8,0x0001,0xa008,0x5200,0x1008,0x4200,
                 0x1038,0x7100,0x7008,0x4200,0x0000,0x0000,0x0000,0x0000,
                 0x0000,0x0000,0x0000};

  static const char filename[] = "/dev/vga_ball";
  printf("VGA ball Userspace program started\n");
  if ( (vga_ball_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n",filename);
    return -1;
  }

  printf("initial state: ");
  print_background_color();

// clear map
for(int j=0;j<26;j++)
{
   for(int i=0;i<32;i++)
{  table[0] = i*2048+j*64+1;
   set_background_color(&table);
}
}
   table[0] = table[0]-1;
   set_background_color(&table);
    usleep(40000);

// load one map
for(int j=0;j<26;j++)
{
   for(int i=0;i<26;i++)
{  

   table[0] = i*2048+j*64+map[j][i]*2+1;
   set_background_color(&table);
 //  print_background_color();
}
    usleep(10000);
}

   table[0] = table[0]-1;
   set_background_color(&table);

// load other item
for(int j=1;j<9;j++)
{
   for(int i=27;i<29;i++)
{  
   table[0] = i*2048+j*64+16*2+1;
   set_background_color(&table);
}
}

   table[0] = 27*2048+17*64+17*2+1;
   set_background_color(&table);
   table[0] = 28*2048+17*64+21*2+1;
   set_background_color(&table);
   table[0] = table[0]-1;
   set_background_color(&table);

// initail tank 

   table[12] = 0x3030;
   table[17] = 0x0000;

   set_background_color(&table);
   print_background_color();

  /* Open the keyboard */
  if ( (keyboard = openkeyboard(&endpoint_address)) == NULL ) {
    fprintf(stderr, "Did not find a keyboard\n");
    exit(1);
  }

 /* Look for and handle keypresses */
  for (;;) {
    libusb_interrupt_transfer(keyboard, endpoint_address,
			      (unsigned char *) &packet, sizeof(packet),
			      &transferred, 0);
    if (transferred == sizeof(packet)) {
    //  sprintf(keystate, "%02x %02x %02x %02x %02x %02x %02x %02x", packet.keycode[0],
//	     packet.keycode[1],packet.keycode[2],packet.keycode[3],
    //          packet.keycode[4],packet.keycode[5],packet.keycode[6],packet.keycode[7]);
    //  printf("%s\n", keystate);
   	flag = ~flag;
        flag_count=flag_count+1;
        if(flag) flag2 = ~flag2;
        if(flag2) flag4 = ~flag4;
        if(flag4) flag8 = ~flag8;
        if(flag8) flag16 = ~flag16;
        if(flag16) flag32 = ~flag32;



    if(flag){	

	                  table[18]=table[18]&0xfffc;
    
      //************************************************************************
      //******************** detect key press **********************************
      //************************************************************************

      // up,down,left,right
      if (packet.keycode[4] == 0x00)
	{
             rote(1,0,map,table);
	}
      
      else if (packet.keycode[4] == 0xff)
	{
             rote(1,2,map,table);
	}

      else if (packet.keycode[3] == 0x00)
	{
 	     rote(1,1,map,table);
	}

      else if (packet.keycode[3] == 0xff)
	{
 	     rote(1,3,map,table);
	}

    // press b get new player tank
    if (packet.keycode[5] == 0x4f)
	{
		if ((table[3]&0x01)==0x00 ) {	
			table[2]=0x50c8;
               		table[3]=table[3]|0x01;
	        life = life -1;
		switch (life) {
		case 2: {table[0] = 28*2048+17*64+20*2+1; break;}
		case 1: {table[0] = 28*2048+17*64+19*2+1;break;}
		case 0: {table[0] = 28*2048+17*64+18*2+1;break;}
		}
		  set_background_color(&table);	
		}
	}

    // press a
     if (packet.keycode[5] == 0x2f)
	{
		if((table[3]&0x01)==0x01 && bullet1[3]==0x00)
               {
                    bullet1[0] = table[2]/256+6;
                    bullet1[1] = table[2]%256+6;
                    bullet1[2] = (table[3]/16)&0x03;
                    bullet1[3] =  0x01;
		    table[18]=table[18]&0xfffc|0x0001;
	
                }
	}

      //************************************************************************
      //*********************** end key press **********************************
      //************************************************************************
	if( ((table[3]&0xf000)==0x2000 )|| ( (table[3]&0xf000)==0x3000))   bullet_cal(bullet1,table,map,1);     
	bullet_cal(bullet1,table,map,1);
        table[12] = bullet1[0]*256+bullet1[1];
        table[17] = (table[17]&0xfffe)|(bullet1[3]&0x01);


//************************* movement of tank ******************************

   //enemy tank1 
	if ((table[5]&0x01)==0x01&&flag2){      
   		
            rote(2,(table[5]&0x0030)/16,map,table);

	if((table[5]&0xf000)==0x5000)   rote(2,(table[5]&0x0030)/16,map,table);

		if(bullet2[3]==0x00 && !(rand()%32))
           	    {
                 	   bullet2[0] = table[4]/256+6;
                	   bullet2[1] = table[4]%256+6;
                	   bullet2[2] = (table[5]/16)&0x03;
                 	   bullet2[3] =  0x01;
		

               	    }
	}
	if((table[5]&0xf000)==0x6000)   bullet_cal(bullet2,table,map,0);

	bullet_cal(bullet2,table,map,0);
	table[13] = bullet2[0]*256+bullet2[1];
 	table[17] = (table[17]&0xfffd)|((bullet2[3]&0x01)*0x02);


   //enemy tank2 
        if ((table[7]&0x01)==0x01&&flag2){
	
	if((table[7]&0xf000)==0x5000) rote(3,(table[7]&0x0030)/16,map,table);
            rote(3,(table[7]&0x0030)/16,map,table);
		if(bullet3[3]==0x00 && !(rand()%32))
           	    {
                 	   bullet3[0] = table[6]/256+6;
                	   bullet3[1] = table[6]%256+6;
                	   bullet3[2] = (table[7]/16)&0x03;
                 	   bullet3[3] =  0x01;
	
	
               	    }
	}
        if((table[7]&0xf000)==0x6000)   bullet_cal(bullet3,table,map,0);
	bullet_cal(bullet3,table,map,0);
	table[14] = bullet3[0]*256+bullet3[1];
	table[17] = (table[17]&0xfffb)|((bullet3[3]&0x01)*0x04);
        

       //enemy tank3 
        if ((table[9]&0x01)==0x01&&flag2){       
        if((table[9]&0xf000)==0x5000)   rote(4,(table[9]&0x0030)/16,map,table);
            rote(4,(table[9]&0x0030)/16,map,table);
		if(bullet4[3]==0x00&& !(rand()%32))
           	    {
                 	   bullet4[0] = table[8]/256+6;
                	   bullet4[1] = table[8]%256+6;
                	   bullet4[2] = (table[9]/16)&0x03;
                 	   bullet4[3] =  0x01;
	
	
               	    }
	}

        if((table[9]&0xf000)==0x6000)   bullet_cal(bullet4,table,map,0);
       	bullet_cal(bullet4,table,map,0);
       	table[15] = bullet4[0]*256+bullet4[1];
        table[17] = (table[17]&0xfff7)|((bullet4[3]&0x01)*0x08);
	
 
       //enemy tank4 
        if ((table[11]&0x01)==0x01&&flag2){       
if((table[11]&0xf000)==0x5000)  rote(5,(table[11]&0x0030)/16,map,table); 	
            rote(5,(table[11]&0x0030)/16,map,table); 	
		if(bullet5[3]==0x00 && !(rand()%32))
           	    {
                 	   bullet5[0] = table[10]/256+6;
                	   bullet5[1] = table[10]%256+6;
                	   bullet5[2] = (table[11]/16)&0x03;
                 	   bullet5[3] =  0x01;

		
              	    }
       	}
       	
        if((table[11]&0xf000)==0x6000)   bullet_cal(bullet5,table,map,0);
	bullet_cal(bullet5,table,map,0);
       	table[16] = bullet5[0]*256+bullet5[1];
        table[17] = (table[17]&0xffef)|((bullet5[3]&0x01)*0x10);


		set_background_color(&table);

if( ((flag_count%128)==1) && tank_num1){

    for(i=0;i<4;i++)
	if ((table[5+2*i]&0x01)==0x00)
	{
		switch (tank_num1%3) 
		{
		case 0: {table[4+2*i]=0x7008;break;}
		case 1: {table[4+2*i]=0x1008;break;}
		case 2:	{table[4+2*i]=0xd008;break;}
		}
		table[5+2*i] = tank_ku[16-tank_num1]*256+0x21;
		tank_num1 = tank_num1 -1;
		if (tank_num1 >=8) {table[0] = 28*2048+(tank_num1-7)*64+1;}
		else  { table[0] = 27*2048+(tank_num1+1)*64+1;}
		
		switch(tank_num1) {
		case 10: {table[3] = table[3]&0x0fff|0x1000;break;}
		case 6: {table[3] = table[3]&0x0fff|0x2000;break;}
		case 1: {table[3] = table[3]&0x0fff|0x3000;break;}
		}
		break;
	}
}       
  
	set_background_color(&table);
        table[0] = 0x0000;
	set_background_color(&table);

  
 
   if ((table[18]&0xf000)||life==0x00) {game = 1;break;}  // game over

   if (  (table[5]&0x01)==0x00 && (table[7]&0x01)==0x00 && (table[9]&0x01)==0x00 
          &&(table[11]&0x01)==0x00   && tank_num1==0x00) {game = 2;break;} //win
   
   if (packet.keycode[6] == 0x20) { /* ESC pressed? */
	break;

      }
    }
  }
}

   
usleep(100000);

for (i=0;i<18;i++)
{
	table[i] = 0x00;
}

// clear map
for(int j=0;j<26;j++)
{
   for(int i=0;i<32;i++)
{  table[0] = i*2048+j*64+1;
   set_background_color(&table);
}
}
   table[0] = table[0]-1;
   set_background_color(&table);
    usleep(40000);

if(game==1) {
// load one map
for(int j=0;j<26;j++)
{
   for(int i=0;i<26;i++)
{  

   table[0] = i*2048+j*64+map2[j][i]*2*6+1;
   set_background_color(&table);
}
    usleep(10000);
}

   table[0] = table[0]-1;
   set_background_color(&table);
}

else {
// load one map
for(int j=0;j<26;j++)
{
   for(int i=0;i<26;i++)
{  

   table[0] = i*2048+j*64+map3[j][i]*2*6+1;
   set_background_color(&table);
}
    usleep(10000);
}

   table[0] = table[0]-1;
   set_background_color(&table);
}
   table[18] = 0x0000;
   set_background_color(&table);
  usleep(100000);

  printf("VGA BALL Userspace program terminating\n");
  return 0;
}
