# Invoke as
#
# quartus_sh -t ultranes.tcl

# $moduleName.sv should include a module named $moduleName

set moduleName "ultranes"
set systemVerilogSource "${moduleName}.sv"

project_new $moduleName -overwrite

foreach {name value} {
    FAMILY "Cyclone V"
    DEVICE 5CSEMA5F31C6
    PROJECT_OUTPUT_DIRECTORY output_files
    MIN_CORE_JUNCTION_TEMP 0
    MAX_CORE_JUNCTION_TEMP 85
    CYCLONEII_RESERVE_NCEO_AFTER_CONFIGURATION "USE AS REGULAR IO"
    NUM_PARALLEL_PROCESSORS 8
} { set_global_assignment -name $name $value }

set_global_assignment -name TOP_LEVEL_ENTITY $moduleName

foreach filename $systemVerilogSource {
    set_global_assignment -name SYSTEMVERILOG_FILE $filename
}

set_global_assignment -name VERILOG_FILE "cpu.v"

foreach {port pin} {    
    CLOCK_50 PIN_AF14
} {
    set_location_assignment $pin -to $port
    set_instance_assignment -name IO_STANDARD "3.3-V LVTTL" -to $port
}

set sdcFilename "${moduleName}.sdc"

set_global_assignment -name SDC_FILE $sdcFilename

set sdcf [open $sdcFilename "w"]
puts $sdcf {
    create_clock -period 20 [get_ports CLOCK_50]

    derive_pll_clocks -create_base_clocks
    derive_clock_uncertainty
}
close $sdcf

project_close
