/*
 * PPU State machine
 * 
 * Currently ignoring sprite rendering
 * 
 * Derived form NTSC PPU Fram form NES DEV
 * All combinational logiv - no clock required, or reset
 * Inputs
 *   hcount
 *   vcoutn
 * 
 * OUTPUTS
 * fectch_state - 2 bits
 *   0 - NT byte
 *   1 - AT byte
 *   2 - low BG tile byte
 *   3 - high BG tile byte
 * 
 * vram_fetch - active high
 * idle - active high
 * 
 * flag_ops - flag operation / misc (not too sure what this is yet) - active high
 *   VBLANK flag
 *   Sprite_0
 *   Overflow
 */

module ppu_state_machine(input logic        clk50,
			 input logic 	    ppu_en,
			 input logic [8:0]  hcount,
			 input logic [8:0]  vcount,

			 output logic [3:0] fetch_state,
			 output logic 	    vram_fetch,
			 output logic 	    idle,
			 output logic 	    Vblank,
			 output logic 	    re_scroll
			 //output logic       Sprite_0,
			 //output logic       Overflow
			 );

/*   parameter VRAM_FETCH_LOW  = 8'd256,
             VRAM_FETCH_HIGH = 8'd321,
             IDLE_LOW        = 8'd257,
             IDLE_HIGH       = 8'd320,
             VIS_VERT        = 8'd239,
             PRE_RENDER      = 8'd261; */

   logic [8:0] hcount_for_fetch;
   assign hcount_for_fetch = hcount - 1'b1;
   assign fetch_state = hcount_for_fetch[2:0];
   
   always_ff @(posedge clk50) begin
      if (vcount <= 8'd239) begin
	 if (hcount == 8'd0) begin
	    //if (vcount == 0) re_scroll <= 1b'1;
	    vram_fetch <= 1'b0;
	    idle <= 1'b1;
	 end else if (hcount <= 8'd256) begin
	    //re_scroll < 1'b0;
	    vram_fetch <= 1'b1;
	    idle <= 1'b0;
	 end else if (hcount > 8'd320) begin
	    vram_fetch <= 1'b1;
	    idle <= 1'b0;
	 end else begin
	    idle <= 1'b1;
	    vram_fetch <= 1'b0;
	 end
      end else if (vcount < 8'd261) begin// if (vcount < VIS_VERT + 1)
	 if (vcount == 8'd241)
	   if (hcount == 8'd1)
	     Vblank <= 1'b1;
      end else begin
	 if (hcount == 8'b1) begin
	    vram_fetch <= 1;
	    //Sprite_0 <= 0;
	    Vblank <= 0;
	    //Overflow <= 0;
	 end else if (hcount <= 8'd256)
	    vram_fetch <= 1'b1;
	 else if (hcount > 8'd320) begin
	    if (hcount == 8'd321) re_scroll <= 1'b1;
	    else re_scroll <= 1'b0;
	    vram_fetch <= 1'b1;
	 end else if (hcount > 8'd336)
	   vram_fetch <= 1'b0;
	 else
	   vram_fetch <= 1'b0;
      end // else: !if(vcount < PRE_RENDER)
   end // always_comb
endmodule // ppu_state_machine


   
   
   
   
