module ppu(input   logic   clk50,
	   input logic 	      reset,
	   input logic [7:0]  writedata,
	   input logic 	      write,
	   input 	      chipselect,
	   input logic [16:0] address,
	   input logic 	      ppu_en,
	   input logic 	      vga_en,
	   

	   output logic [5:0] ppu_data,
	   output logic [8:0] ppu_hcount,
	   output logic [8:0] ppu_vcount,
	   output logic [9:0] hcount,
	   output logic [9:0] vcount
       );

    logic [15:0] addr;
    logic [15:0] addr2;
    logic [7:0] DI;
    logic [7:0] DO;
    logic 	WE;
    logic [7:0] DI2;
    logic [7:0] DO2;
    logic 	WE2;

    assign WE2 = write;

	dpram #(8, 14) vram (
	    .clk1(clk50),
	    .data_a(DO),
	    .data_b(DO2),
	    .addr_a(addr),
	    .addr_b(addr2),
	    .we_a(WE),
	    .we_b(WE2),
	    .q_a(DI),
	    .q_b(DI2),
	);


    // avalon bus to write to PPU RAM
    always_ff @(posedge clk50) begin
        if (reset) begin
        end else if (chipselect && write) begin
            if ( address[16] & !address[15] ) begin
                addr2 <= address[13:0];
                DO2 <= writedata[7:0];
            end
        end
        //end else if (chipselect) begin

        //    if (address == 0)
        //        readdata <= addr[7:0];
        //    else if (address == 1)
        //        readdata <= addr[15:8];
    end


   // Generates vga hcount and vcount
   // PPU hcount and vcount ignores the LSB
   parameter HTOTAL = 10'd 682;
   parameter VTOTAL = 10'd 524;
   logic endOfLine;
   logic enfOfField;
   assign endOfLine = hcount == HTOTAL - 1;
   assign endOfField = vcount == VTOTAL - 1;

   always_ff @(posedge clk50 or posedge reset)
     if (reset)          hcount <= 0;
     else if (vga_en)
       if (endOfLine)    hcount <= 0;
       else              hcount <= hcount + 10'd 1;

   always_ff @(posedge clk50 or posedge reset)
     if (reset)          vcount <= 0;
     else if (vga_en)
       if (endOfLine)
	 if (endOfField)   vcount <= 0;
   	 else              vcount <= vcount + 10'd 1;

    assign ppu_hcount = hcount[9:1];
    assign ppu_vcount = vcount[9:1];

   // for dummy reading form VRAM
   always_ff @(posedge clk50 or posedge reset) begin
      //if (reset)           ata <= 0;
      //else if (ppu_en) begin
	    addr[13:7] <= ppu_vcount[7:1]; 
	    addr[6:0]  <= ppu_hcount[7:1];
	    //ppu_data <= DI;
      //end
   end
   
   
// +-----------------+ //
// | palette RAM | //
// +-----------------+ //



// +----------------+ //
// | sprite RAM | //
// +----------------+ //



// +-----------------------+ //
// | VGA output module | //
// +-----------------------+ // -- currently included in ultranes


   

// +-----------------------------+ //
// | sprite rendering | //
// +-----------------------------+ //



// VRAM SPOOFER
   assign ppu_data = {2'b01, bg_pixel_out};
   vram_spoofer spoof( .clock_in(clk50), .reset_in(reset),
		       .addr_in({2'b00, bg_vram_address}),
		       .data_out(vram_data)
		       );
   
				

// +---------------------------------+ //
// | background rendering | //
// +---------------------------------+ //
   // dummy logic for outputs
   logic [3:0] bg_pixel_out;
   logic [13:0] bg_vram_address;
   logic [7:0] 	vram_data;
   bg bg1 ( .clk50(clk50), .reset(reset), .ppu_en(ppu_en), .hcount(ppu_hcount),
	    .vcount(ppu_vcount), .reg_x_scroll(8'h00), .reg_y_scroll(8'h00),
	    .nametable_select(2'b00), .pt_select(1'b1), .vram_data_in(vram_data),
	    .pixel_out(bg_pixel_out), .address_out(bg_vram_address)
	    );
   
   //logic 	re_scroll;
   //logic 	vram_rd; //rd signal for vram
   // currently have rd set in background render -> we should move to state
   // machine so that backgrounda and sprite are not competing for rd signal
   /*background_render bg1( .clk50(clk50), .reset(reset), .ppu_en(ppu_en),
			  .hcount(ppu_hcount), .vcount(ppu_vcount),
			  .reg_x_scroll(8'd0), .reg_y_scroll(8'd0),
			  .nametable_select(2'd0), .pt_select(1'b1),
			  .vram_data_in(vram_data), .vram_fetch(F_VRAM_FETCH),
			  .fetch_state(vram_fetch_state), .re_scroll(re_scroll),
			  .pixel_out(bg_pixel_out), .address_out(bg_vram_address), 
			  .rd(vram_rd)
			  );
   

// +----------------------+ //
// | ppu state machine    | //
// +----------------------+ //
   // other flags needed to be added for interfacing with registers
   // as well as BG and sprite renderers
   logic [2:0] vram_fetch_state;
   logic       F_VRAM_FETCH, F_IDLE, F_VBLANK;
   ppu_state_machine sm1( .clk50(clk50), .hcount(ppu_hcount), .vcount(ppu_vcount),
			  .fetch_state(vram_fetch_state), .vram_fetch(F_VRAM_FETCH),
			  .idle(F_IDLE), .Vblank(F_VBLANK), .re_scroll(re_scroll)
			  ); 
    */

   


// ++++++++++++++++++++++++++++++ //
// ------ I/O CONTROL ------ //
// ++++++++++++++++++++++++++++++ //





// ++++++++++++++++++++++++++++ //
// ------ PRIORITY MUX ------ //
// ++++++++++++++++++++++++++++ //
   logic [4:0] sp_pixel_out;
   logic       sp_priority;
   logic [5:0] out_pixel;
   priority_mux mux1( .clk50(clk50), .reset(reset), .ppu_en(ppu_en),
		      .bg_in(bg_pixel_out), .sp_in(sp_pixel_out),
		      .sp_priority(sp_priority),
		      .out_pixel(out_pixel)
		      );
   




// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //
// ------ CPU AND ACCESS TO REGISTERS ------ //
// ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ //





// +++++++++++++++++++++++++++++++++++++++++++++++++ //
// ------ REGISTER CONTROL ------ //
// +++++++++++++++++++++++++++++++++++++++++++++++++ //

endmodule // ppu
