/*
 * Avalon memory-mapped peripheral that generates VGA
 *
 * Stephen A. Edwards
 * Columbia University
 */

module vga_ball(input logic        clk,
	        input logic 	   reset,
		input logic [7:0]  writedata,
		input logic 	   write,
		input 		   chipselect,
		input logic [7:0]  address,

		output logic [7:0] VGA_R, VGA_G, VGA_B,
		output logic 	   VGA_CLK, VGA_HS, VGA_VS,
		                   VGA_BLANK_n,
		output logic 	   VGA_SYNC_n);



/////CONTROL REGISTERS////////////
  logic [5:0] gnd_0;
  logic [5:0] gnd_1;
  logic [5:0] gnd_2;
  logic [5:0] gnd_3;
  logic [5:0] gnd_4;
  logic [5:0] gnd_5;
  logic [5:0] gnd_6;
  logic [5:0] gnd_7;
  logic [5:0] gnd_8;
  logic [5:0] gnd_9;
  logic [5:0] gnd_10;
  logic [5:0] gnd_12;
  logic [5:0] gnd_11;
  logic [5:0] gnd_13;
  logic [5:0] gnd_14;
  logic [5:0] gnd_15;
  logic [5:0] gnd_16;
  logic [5:0] gnd_17;
  logic [5:0] gnd_18;
  logic [5:0] unit_creg;
  logic [5:0] ten_creg;
  logic [5:0] car_xcord;
  logic [5:0] space_xcord;
  logic [5:0] bullet_ycord;
   logic [10:0]	   hcount;
   logic [10:0]	   hcount_score;
   logic [4:0]	   hcount_reg;
   logic [9:0]     vcount;
   logic [9:0]     vcount_my;
   logic [9:0]     vcount_up;
   logic [9:0]     vcount_stone;
   logic [9:0]     vcount_mount;
   logic [9:0]     vcount_mount2;
   logic [9:0]     vcount_star;
   logic [10:0]    hcount_bullet;

        assign hcount_bullet = hcount -6;
	assign vcount_my = vcount - 18;
	assign vcount_up = vcount - 8;
	assign vcount_stone = vcount - 2;
	assign vcount_mount = vcount - 156;
	assign vcount_star = vcount - 4;
	assign hcount_score = hcount-8;
   logic [4:0]     vcount_reg;
   logic up;
   
   logic [7:0] 	   background_r, background_g, background_b;
 
  //////////// ROM FOR SPIRES/////////////
   logic [0:127]buggy  [0:63];	
   logic [0:31] stone [0:31];
   logic [0:255] mountain3 [0:255];
   logic [0:127] mountain2 [0:127];
   logic [0:15] star_filled [0:15];
   logic  [0:31] spaceship [0:31];
   logic  [0:31] gnd [0:31];
   logic [0:15] number_zero  [0:15];
   logic [0:15] number_one   [0:15];
   logic [0:15] number_two   [0:15];
   logic [0:15] number_three [0:15];
   logic [0:15] number_four[0:15];
   logic [0:15] number_five[0:15];
   logic [0:15]  number_six[0:15];
   logic [0:15]  number_seven[0:15];
   logic [0:15]  number_eight[0:15];
   logic [0:15]  number_nine[0:15];
   logic [0:31] bullet [0:31];

///////////////////////////////////////////

 vga_counters counters(.clk50(clk), .*);
nor_cnt cnt(.clk50(clk), .*);
   always_ff @(posedge clk)
     if (reset) begin
	background_r <= 8'h00;
	background_g <= 8'h00;
	background_b <= 8'h00;
	hcount_reg <= 5'd19;
	vcount_reg <= 5'd5;
	 gnd_0<=0;		
  	 gnd_1<=1;
  	 gnd_2<=2;
  	 gnd_3<=3;
  	 gnd_4<=4;
  	 gnd_5<=5;
  	 gnd_6<=6;
  	 gnd_7<=7;
  	 gnd_8<=8;
  	 gnd_9<=9;
  	 gnd_10<=10;
  	 gnd_11<=11;
  	 gnd_12<=12;
  	 gnd_13<=13;
  	 gnd_14<=14;
  	 gnd_15<=15;
  	 gnd_16<=16;
  	 gnd_17<=17;
  	 gnd_18<=18;
	unit_creg <=0;
	ten_creg<=0;
	car_xcord <=0;
	space_xcord <=-1;
	bullet_ycord <=-1;
buggy[0][0:127] <=      128'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[1][0:127] <=      128'b00000000000000000000000000000000001111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[2][0:127] <=      128'b00000000000000000000000000000000001111110111110000000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[3][0:127] <=      128'b00000000000000000000000000000000001111100111110000000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[4][0:127] <=      128'b00000000000000000000000000000000001111100111110000000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[5][0:127] <=      128'b00000000000000000000000000000000001111100111110000000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[6][0:127] <=      128'b00000000000000000000000000000000001111100111110000000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[7][0:127] <=      128'b00000000000000000000000000000000001111100111111000000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[8][0:127] <=      128'b00000000000000000000000000000001111111100111111111000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[9][0:127] <=      128'b00000000000000000000000000000011111111111110111111000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[10][0:127] <=     128'b00000000000000000000000000000011111111111110011111000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[11][0:127] <=     128'b00000000000000000000000000000011111111111110011111000000000000000000000000000000000000000000000000000000000000000000000000000000;
buggy[12][0:127] <=     128'b00000000000000000000000000000011111111111110011111000000000000001111111111111111111111111111100000000000000000000000000000000000;
buggy[13][0:127] <=     128'b00000000000000000000000000000011111111111110011111000000000000011111111111111111111111111111110000000000000000000000000000000000;
buggy[14][0:127] <=     128'b00000000000000000000000000000011111111111110011111000000000000011111111111111111111111100111111000000000000000000000000000000000;
buggy[15][0:127] <=     128'b00000000000000000000000000000011111111111110011111000000111111111111111111111111111111100111111111000000000000000000000000000000;
buggy[16][0:127] <=     128'b00000000000000000000000000000011111111100111111111000000111111111111111110000000000000000000011111000000000000000000000000000000;
buggy[17][0:127] <=     128'b00000000000000000000000000000011111111100111111111000111111111111111111110000000000000000000000111111000000000000000000000000000;
buggy[18][0:127] <=     128'b00000000000000000000000000000011111111111111111111001111111111111100000000000000000000000000000011111000000000000000000000000000;
buggy[19][0:127] <=     128'b00000000000000000000000000000011111111111110011111111111111111111100000000000000000000000000000000111111000000000000000000000000;
buggy[20][0:127] <=     128'b00000000000000000000000000000011111111111110011111111111111111111000000000000000000000000000000000011111100000000000000000000000;
buggy[21][0:127] <=     128'b00000000000000000000000000000111111111111110011111111111111111000000000000000000000000000000000000000011111000000000000000000000;
buggy[22][0:127] <=     128'b00000000000000000000000111111111111111111110011111111111111111000000000000000000000000000000000000000011111111110000000000000000;
buggy[23][0:127] <=     128'b00000000000000000000000111111111111111111111111111111111111111000000000000000000011111111111111110011111100111111000000000000000;
buggy[24][0:127] <=     128'b00000000000000001111111111111111111111111111111111011111111111000000000000000000011111111111111111111111100111111111111111111110;
buggy[25][0:127] <=     128'b00000000000000001111111111111111111111111111111111111111111111100000000000000000111100000001111111111111111111111111111101111110;
buggy[26][0:127] <=     128'b00000000011111111111111111111111111110001111110111111111111111111111111111111111111100000001111111111111111111111111100000111110;
buggy[27][0:127] <=     128'b00000000111111111111111111111111111111111111111111111111111111111111111111111111111100000001111111111111111111111111100000111110;
buggy[28][0:127] <=     128'b00000011111111111111111111111111111110001111111111111111111111111111111111111111111111111111111111111111111100000111100000111110;
buggy[29][0:127] <=     128'b00000111111111111111111111111111111110001111111111111111111111111111111111111111111111111111111111111111111111111111100000111110;
buggy[30][0:127] <=     128'b00001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111110;
buggy[31][0:127] <=     128'b01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000111110;
buggy[32][0:127] <=     128'b01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111110;
buggy[33][0:127] <=     128'b01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111010011111111111100;
buggy[34][0:127] <=     128'b01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111100000000;
buggy[35][0:127] <=     128'b01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111100000000;
buggy[36][0:127] <=     128'b01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111100000000;
buggy[37][0:127] <=     128'b01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111100000000;
buggy[38][0:127] <=     128'b01111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111100000000;
buggy[39][0:127] <=     128'b01111111111111111111110001111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111100000000;
buggy[40][0:127] <=     128'b01111111111111111111110000111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111100000000;
buggy[41][0:127] <=     128'b01111111111111111111111111111111111111111111111111100001111111111111111111111111111111111111111000011111111100011111111100000000;
buggy[42][0:127] <=     128'b01111111111000101111111111111111111111111111111111100001111111111111111111111111111111111111111000011111111100011111111000000000;
buggy[43][0:127] <=     128'b01111111111000111111111111111111111111111111111111100001111111111111111111111111111111111111111000011111111100011111000000000000;
buggy[44][0:127] <=     128'b01111111111111111111111111111000011111111111111111111111111111000011111111111111111111111111111111111111111100011111000000000000;
buggy[45][0:127] <=     128'b00001111111111111111111111111000011111111111111111111111111111000011111111111111111111111111111111111111111100011111000000000000;
buggy[46][0:127] <=     128'b00000111111111111110000001111111111101111111000111111111111111111011111111111111111111111111111111111111100111111111000000000000;
buggy[47][0:127] <=     128'b00000111111111111100000001111111111101111111000111111111111111111001111111111111111111111111111111111111100111111111000000000000;
buggy[48][0:127] <=     128'b00000111111111111100000001111111111101111111111111111111101111111111111111110000000001110001111000000011110000011111000000000000;
buggy[49][0:127] <=     128'b00000110000111111100000001111111111101111111111111100000001111111111101111110000000001110000111000000001110000000111000000000000;
buggy[50][0:127] <=     128'b00000111011111111100000001111111111101111111111111100000001111111111101111110000000001110001111000000011110000011111000000000000;
buggy[51][0:127] <=     128'b00000111111111111100000001111111100000001111111111100000001111111100000001110000000001111111111000000011111110111111000000000000;
buggy[52][0:127] <=     128'b00000111111111111110000001111111100000001111111111100000001111111100000001110000000001111111111000000011111110111111000000000000;
buggy[53][0:127] <=     128'b00000111111111111111111111111111001111110000111111100000001111111111101111110000000001111111111111111111100111111111000000000000;
buggy[54][0:127] <=     128'b00000011111111111111111111111111001111110000111111100000001111111111101111110000000000111111111111111111100111111110000000000000;
buggy[55][0:127] <=     128'b00000000111111111111111111010111001111111111111111111111111111111111111111110000000000000111111111111111100111110000000000000000;
buggy[56][0:127] <=     128'b00000000111111100011111111000111001111111111111111111111111111111011111111100000000000000111111111111111100111110000000000000000;
buggy[57][0:127] <=     128'b00000000111111101011111111010111111111100111111111111111111111111001111100000000000000000111111111111111101111110000000000000000;
buggy[58][0:127] <=     128'b00000000011111111111111110111111111111100111000111111111111111000000011100000000000000000111111111100000001111110000000000000000;
buggy[59][0:127] <=     128'b00000000000000011111111110111111000000000111000111111111111111000001011100000000000000000000111111100000101110000000000000000000;
buggy[60][0:127] <=     128'b00000000000000001111111111111111000000000111111111111110000000111111111100000000000000000000011111111111111110000000000000000000;
buggy[61][0:127] <=     128'b00000000000000000111111111111100000000000001111111111110000000111111110000000000000000000000001111111111111000000000000000000000;
buggy[62][0:127] <=     128'b00000000000000000000000000000000000000000000000001111111111111111000000000000000000000000000000000000000000000000000000000000000;
buggy[63][0:127] <=     128'b00000000000000000000000000000000000000000000000001111111111111110000000000000000000000000000000000000000000000000000000000000000;


//////////////////////////// PINE TREE ///////////////////////////////////

////////////////////////////////////////////////////////////////////////

stone[0][0:31] <=        32'b00000000000000000000000000000000;
stone[1][0:31] <=        32'b00000000111111001111100000000000;
stone[2][0:31] <=        32'b00000001111111011111111100000000;
stone[3][0:31] <=        32'b00000011111111011111111110000000;
stone[4][0:31] <=        32'b00000111111111001111111111000000;
stone[5][0:31] <=        32'b00001101101111111111000000100000;
stone[6][0:31] <=        32'b00011001001111111111100100010000;
stone[7][0:31] <=        32'b00111111111111111111111111111000;
stone[8][0:31] <=        32'b00111111111111111111111111111000;
stone[9][0:31] <=        32'b00111111111111011111111111111000;
stone[10][0:31] <=       32'b00111111111011101111111110001000;
stone[11][0:31] <=       32'b00100111111111110111111111001000;
stone[12][0:31] <=       32'b00111111111101101111111111111000;
stone[13][0:31] <=       32'b00111111111110011111111111111000;
stone[14][0:31] <=       32'b01111111111111111111111111111100;
stone[15][0:31] <=       32'b01111111111111111111100001111100;
stone[16][0:31] <=       32'b01111111110101111111011111111100;
stone[17][0:31] <=       32'b01111111111110111110111111111100;
stone[18][0:31] <=       32'b01111101101111001101111111111100;
stone[19][0:31] <=       32'b01111111011111111011111111111000;
stone[20][0:31] <=       32'b00111111111111100011111111110000;
stone[21][0:31] <=       32'b00001111111111111110111111101100;
stone[22][0:31] <=       32'b01011111111111111111010111111100;
stone[23][0:31] <=       32'b01101111111111111111111111111000;
stone[24][0:31] <=       32'b01111111111111111111101111111100;
stone[25][0:31] <=       32'b01111111110111111111111111101100;
stone[26][0:31] <=       32'b01111010110111111111111111111100;
stone[27][0:31] <=       32'b01110101001011111111111111011100;
stone[28][0:31] <=       32'b01111111111111111111111110111100;
stone[29][0:31] <=       32'b01111111111110101011111111111100;
stone[30][0:31] <=       32'b01111111111111111101001001111100;
stone[31][0:31] <=       32'b01111111111111111111111111111100;


//////////////////////////  MOUNTAIN////////////////////////////////////////
mountain3[0][0:255] <=  256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[1][0:255] <=  256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[2][0:255] <=  256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[3][0:255] <=  256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[4][0:255] <=  256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[5][0:255] <=  256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[6][0:255] <=  256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[7][0:255] <=  256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[8][0:255] <=  256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[9][0:255] <=  256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[10][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[11][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[12][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[13][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[14][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[15][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[16][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[17][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[18][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[19][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[20][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[21][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[22][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[23][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000101010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[24][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[25][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[26][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[27][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[28][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[29][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011101111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[30][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011101111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[31][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111001111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[32][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111001111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[33][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111001111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[34][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110001111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[35][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110001111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[36][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110011111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[37][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[38][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[39][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[40][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[41][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[42][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000011111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[43][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000011111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[44][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[45][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[46][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110000111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[47][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000111111111110000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[48][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000111111111110000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[49][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000111111111110000000000000000110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[50][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100000101111111111000000000000001110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[51][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000000101111111111000000000000001111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[52][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000111111111111000000000000011011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[53][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110000000000111000001111111111101000000000000011011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[54][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111000000000110000001111111111101000000000000011111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[55][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111000000001110000001111111111111100000000000111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[56][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001101000000001110000001111111111111100000000000111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[57][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001001100000001100000001111111111111100000000000111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[58][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011001100000011100000001111111111111100000000000111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[59][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011000100000011100000001111111111111100000000000101111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[60][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011110110000011000000001111111111111110000000001111111010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[61][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111110000011000000011111111111111110000000001111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[62][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111011110000111000000011111111111111110000000001111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[63][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110001010000111000000011111111111111111000000010111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[64][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110001111000110000000011111111111111111000000010111111101000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[65][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110001111001110000000111111111111111111000000010101111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[66][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000111001100000000111111111111111111000000110101111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[67][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001100000111111100000000101111111111111101000000111001111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[68][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011100111111111100000000100111111111111111100000111001111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[69][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011001111111111000000001100001111111111111100000111011111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[70][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011001111111001000000001111111111111111111100001110010111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[71][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111001111111011000000001111111111111111111100001110010111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[72][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000110011111111011000000001111111100111111111100001110010111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[73][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110011111111010000000001100001100111111111110001110010111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[74][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110111111111110000000000100001111111111111110011110011111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[75][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001101111111111110000000000000000111111111111110010100011111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[76][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001101111111110100000000000000000011111111111111110100111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[77][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011101011111111100000000000000000001111111111111110100111111111101100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[78][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111011111111100000000000000000000111111111111111100111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[79][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111000000000000000000000111111111111111100111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[80][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111011000000000000000000000111111111111111100111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[81][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111000000000000000000000111111111111011100101111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[82][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111110000000000000000000000111111111111011000101111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[82][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111110000000000000000000000111111111111011000101111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[83][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111110000000000000000000001111111111111111000101111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[84][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111110110000000000000000000001111111111111111000101111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[85][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001011111111111100000000000000000000011111111111111111000111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[86][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111100000000000000000000111111111111111111001111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[87][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111000000000000000000001111111111111111110001111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[88][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111000000000000000000001101111111111111110001111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[89][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111000000000000000000011101111111111111110001111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[90][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111110000000000000000000111111111111111111110001111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[91][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111110110000000000000000000111111111111111110110001111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[92][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111110000000000000000001101111111111111111100001111111111111110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[93][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111100000000000000000001101111111111111111100001111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[94][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111101100000000000000000011111111111111111111100011111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[95][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111000000000000000000011111111111111111101100011111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[96][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111000000000000000000110111111111111111111000011111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[97][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111110000000000000000000111111111111111111111000011111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[98][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111101100000000000000000001111111111111111111110000011111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[99][0:255] <= 256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111100000000000000000001111111111111111111110000011111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[100][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111100000000000000000001111111111111111111110000011111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[101][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111000000000000000000011111111111111111111100000011111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[102][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111110000000000000000000011111111111111111111100000111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[103][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111110000000000000000000111111111111111111111100000111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[104][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111100000000000000000001111111111111111111111000000111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[105][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111111101100000000000000000011111111111111111111111000000111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[106][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000001111011111111111000000000000000000011111111111111111111111000000111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[107][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000111111011111111111000000000000000000111111111111111111111111000000111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[108][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111110000000000000000011111111111111111111111110000000111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[109][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000111111111111111111110000000000000000011111111111111111111111110000000011111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[110][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000001111011111111111111100000000000000000011011111111111111111111100000000011111111111111111111110100000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[111][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111100000000000000000111011111111111111111111100000000011111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[112][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000111111111001111111111000000000000000001111111111111111111111111100000000011111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[113][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000111111110001111111111000000000000000011111111111111111111111101000000000011111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[114][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000001111111100001111111111000000000000000111011111111111111111111111000000000011111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[115][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000011111111000001111111110000000000000001111111111111111111111111111000000000011111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[116][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000011111000000001111111010000000000000011111111111111111111111111011000000000011111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[117][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000010111000000011111111110000000000000011111111111111111111111111110000000000011111111111111111111111111000111111111111000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[118][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000110110000000011111111110000000000001111111111111111111111111111110000000000011111111111111111111111111100111111111111100000000000000000000000000000000000000000000000000000000000000000000;
mountain3[119][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000111110000000111111111100000000000111111111111111111111111111111110000000000001111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000;
mountain3[120][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000101100000000111111111100000000000111110011111111111111111111111100000000000001111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000;
mountain3[121][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000001011000000000101111111100000000000111110011111111111111111111111100000000000001111111111111111111111111111111111111110010000000000000000000000000000000000000000000000000000000000000000000;
mountain3[122][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000001011000000001111111111100000000000111100011111111111111111111111100000000000001111111111111111111111111111111110011111011000000000000000000000000000000000000000000000000000000000000000000;
mountain3[123][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000011011000000001111111111000000000000000000111111111111111111111111000000000000001111111111111111111111111111111010011111111000000000000000000000000000000000000000000000000000000000000000000;
mountain3[124][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000010110000000011111111111000000000000000000111111111111111111111111000000000000001111111111111111111111111111111100011111111100000000000000000000000000000000000000000000000000000000000000000;
mountain3[125][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000010110000000011111111111000000000000000000111111111111111111111111000000000000001111111111111111111111111111111100011111111100000000000000000000000000000000000000000000000000000000000000000;
mountain3[126][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000110110000001111111111111000000000000000001111111111111111111111010000000000010001111111111111111111111111111111100001111111110000000000000000000000000000000000000000000000000000000000000000;
mountain3[127][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000111100000011111111111111000000000000000011111111111111111111111010000000000111001111111111111111111111111111111000001111111110000000000000000000000000000000000000000000000000000000000000000;
mountain3[128][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000111100000111101111111011000000000000000011111111111111111111111110000000000111001111111111111111111111111111111000001111111010000000000000000000000000000000000000000000000000000000000000000;
mountain3[129][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000111000011111101111111110000000000000000111111111111111111111111110000000001111101111111111111111111111111111111000001111111111000000000000000000000000000000000000000000000000000000000000000;
mountain3[130][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000001111000111111111111111110000000000000001111111111111111111111111100000000001111100111111111111111111111111111110000000111111111000000000000000000000000000000000000000000000000000000000000000;
mountain3[131][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000001111000111111111111111110000000000000001111111111111111111111111100000000011111100101111111111111111111111111100000000101111111000000000000000000000000000000000000000000000000000000000000000;
mountain3[132][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000001110001110011111111111110000000000000011101111111111111111111111100000000011010110101111111111111111111111111100000000111111111100000000000000000000000000000000000000000000000000000000000000;
mountain3[133][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000001110011111111111111111100000000000000111111111111111111111111111000000000111111110101111111111111111111111111100000000111111111100000000000000000000000000000000000000000000000000000000000000;
mountain3[134][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000011100111111111111111110100000000000011111111111111111111111111111000000000111111110101111111111111111111111101000000000011111111110000000000000000000000000000000000000000000000000000000000000;
mountain3[135][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000011100110111111111111111100000000000111101111111111111111111111111000000000111111110111111111111111111111111111000000000011111111110000000000000000000000000000000000000000000000000000000000000;
mountain3[136][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000011100110111111111111111000000000011111101111111111111111111111110000000001111111110111111111111111111111111111000000000011111111110000000000000000000000000000000000000000000000000000000000000;
mountain3[137][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000111001111111111111111111000000001111111111111111111111111111111110000011011111111111111111111111111111111111111000000000001111111111000000000000000000000000000000000000000000000000000000000000;
mountain3[138][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000111011111111111111111111000000001111111111111111111111111111111110000111111111111111111111111111111111111111010000000000001111111111000000000000000000000000000000000000000000000000000000000000;
mountain3[139][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000111011011111111111111111000000011100011111111111111111111111111110000111111111111111111111111111111111111111110000000000001111111111000000000000000000000000000000000000000000000000000000000000;
mountain3[140][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000111111111111111111111110000000111111111111111111111111111111111100000111111111111111111111111111111111111111110000000000001111111111100000000000000000000000000000000000000000000000000000000000;
mountain3[141][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000001111111111111111111111110000000111111111111111111111111111111111100001111111111111111111111111111111111111111110000110000000111111111100000000000000000000000000000000000000000000000000000000000;
mountain3[142][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000001111111111111111111111110000000111111111111111111111111111111111100001111111111111111111111111111111111111111110000110000000101111111100000000000000000000000000000000000000000000000000000000000;
mountain3[143][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000001111111111111111111111110000001101111111111111111111111111111111000011011111111111111111111111111111111111111100001110000000101111111110000000000000000000000000000000000000000000000000000000000;
mountain3[144][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000001111111111111111111111100000011111111111111111111111111111111111000111111111111111111111111111111111111111111100011110000000101111111110000000000000000000000000000000000000000000000000000000000;
mountain3[145][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000011111111111111111111110100000011111111111111111011111111111111111000111111111111111111111111111111111111111111100011100000000101111111111000000000000000000000000000000000000000000000000000000000;
mountain3[146][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000011111111111111111111111100000011111111111111111110111111111111110000110111111111111111111111111111111111111111100010100000000101111111111000000000000000000000000000000000000000000000000000000000;
mountain3[147][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000011111111111111111111111100000111111111111111111110111111111111110001111111111111111111111111111111111111111111000110100000000101111111111000000000000000000000000000000000000000000000000000000000;
mountain3[148][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000111111111111111111111111000000111111111111111111110111111111111110011111111111111111111111111111111111111111111000111100000000101111111111100000000000000000000000000000000000000000000000000000000;
mountain3[149][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000111111111111111111111111000001111111111111111111100111111111110110011111111111111111111111111111111111111111111000111100000000101111111111100000000000000000000000000000000000000000000000000000000;
mountain3[150][0:255] <=        256'b0000000000000000000000000000000000000000000000000000011000000101111111111111111111111000001011111111111111111100111111111111100010111111111111111111111111111111111111111111000101100000001111111111111100000000000000000000000000000000000000000000000000000000;
mountain3[151][0:255] <=        256'b0000000000000000000000000000000000000000000000000000111100001111111111111111111111110000011111111111111111111100111111111111100111111111111111111111111111111111111111111111001101000000001111111111111110000000000000000000000000000000000000000000000000000000;
mountain3[152][0:255] <=        256'b0000000000000000000000000000000000000000000000000001111110001111111111111111111111110000011111111111111111111001111111111111100111111111111111111111111111111111111111111010001101000000001111111111111110000000000000000000000000000000000000000000000000000000;
mountain3[153][0:255] <=        256'b0000000000000000000000000000000000000000000000000001100110001111111111111111111111110000110111111111111111111001111111111111101101111111111111111111111111111111111111111110001111000000001111111111111111000000000000000000000000000000000000000000000000000000;
mountain3[154][0:255] <=        256'b0000000000000000000000000000000000000000000000000011100111001111111111111111111111110000110111111111111111111001111111111111001111111111111111111111111111111111111111111110011011000000001111111111111111000000000000000000000000000000000000000000000000000000;
mountain3[155][0:255] <=        256'b0000000000000000000000000000000000000000000000000011111111111111111111111111111110110001111111111111111111010001111111111111001111111111111111111111111111111111111111111110011011000000001111111111111111100000000000000000000000000000000000000000000000000000;
mountain3[156][0:255] <=        256'b0000000000000000000000000000000000000000000000000111111111111111111111111111111110100001111111111111111111010001111111111110011111111111111111111111111111111111111111111110011010000000011111111111111111100000000000000000000000000000000000000000000000000000;
mountain3[157][0:255] <=        256'b0000000000000000000000000000000000000000000000000110111101111111111111111111111111100011111111111111111111110011111111111110010111111111111111111111111111111111111111111110010110000000011111111111111111100000000000000000000000000000000000000000000000000000;
mountain3[158][0:255] <=        256'b0000000000000000000000000000000000000000000000001110111101110111111111111111111111100111111111111111111111110011111111111110111111111111111111111111111111111111111111111100010110000000011111111111111111110000000000000000000000000000000000000000000000000000;
mountain3[159][0:255] <=        256'b0000000000000000000000000000000000000000000000001111001111100011111111111111111111000111111111111111111001100011111111111110111111111111111111111111111111111111111111110100110110000000011111111111111111110000000000000000000000000000000000000000000000000000;
mountain3[160][0:255] <=        256'b0000000000000000000000000000000000000000000000011111111111111111111111111111111111001111111111111111111111100011111111110111101111111111111111111111111111111111111111111100110100000000011111111111111111111000000000000000000000000000000000000000000000000000;
mountain3[161][0:255] <=        256'b0000000000000000000000000000000000000000000000011011111111111111111111111111111111001101111111111111111111000011111111111101101111111111111111111111111111111111111111111100111110000000111111111111111111111000000000000000000000000000000000000000000000000000;
mountain3[162][0:255] <=        256'b0000000000000000000000000000000000000000000000111101111111111111111111111111111111011111111111111111111111000011111111111101111111111111111111111111111111111111111111111000111110000000111111111111111111111100000000000000000000000000000000000000000000000000;
mountain3[163][0:255] <=        256'b0000000000000000000000000000000000000000000001111101100000000011111111111111111110111111111111111111111110000010111111111111111111111111111111111111111111111111111111111000111110000000111111111111111111111110000000000000000000000000000000000000000000000000;
mountain3[164][0:255] <=        256'b0000000000000000000000000000000000000000000001101111100000000011111111111111111111110111111111111111111000000010111111111111111111111111111111111111111111111111111111111001111111000000101111111111111111110111000000000000000000000000000000000000000000000000;
mountain3[165][0:255] <=        256'b0000000000000000000000000000000000000000000011101111000000000011111111111111111111111111111111111111110000000010111111111111111111111111111111111111111111111111111111111001111111000000111111111111111111111111110000000000000000000000000000000000000000000000;
mountain3[166][0:255] <=        256'b0000000000000000000000000000000000000000000011111111000000000111111111111111111111111111111111111111100000000010111111111111111111111111111111111111111111111111111111110001111111000001111111111111111111111111111000000000000000000000000000000000000000000000;
mountain3[167][0:255] <=        256'b0000000000000000000000000000000000000000000111111110000000000111111111111111111111111111111111111111100000000011111111111111111111111111111111111111111111111111111111110011111111000001111111111111111111111100111000000000000000000000000000000000000000000000;
mountain3[168][0:255] <=        256'b0000000000000000000000000000000000000000000110111110000000000111111111111111111110111111111111111111100000000111111111111111111111111111111111111111111111111111111111110010111111000001111111111111111111111111001100000000000000000000000000000000000000000000;
mountain3[169][0:255] <=        256'b0000000000000000000000000000000000000000001111111100000000001111111111111111111111111111111111111111000000000111111111111111111111111111111111111111111111111111111111110111111010000001111111111111111111111111101110000000000000000000000000000000000000000000;
mountain3[170][0:255] <=        256'b0000000000000000000000000000000000000000001111111000000000001111111111111111111111111111111111111011000000000111111111111111111111111111111111111111111111111111111110100111111010000001111111111111111111111101101111000000000000000000000000000000000000000000;
mountain3[171][0:255] <=        256'b0000000000000000000000000000000000000000001111111000000000001111111111111111111111111111111111111110000000000111111111111111111111111111111111111111111111111111111111100111111110000001011111111111111111111100111011000000000000000000000000000000000000000000;
mountain3[172][0:255] <=        256'b0000000000000000000000000000000000000000011111111000000000011111111111111111111111111111111111111110000000000111111111111111111111111111111111111111111111111111111111101111111110000011111111111111111111111100111011100000000000000000000000000000000000000000;
mountain3[173][0:255] <=        256'b0000000000000000000000000000000000000000111111110000000000011111111111111111111111111111111111011100000000000111111111111111111111111111111111111111111111111111111111101111111100000011111111111111111111111100111111110000000000000000000000000000000000000000;
mountain3[174][0:255] <=        256'b0000000000000000000000000000000000000000111110110000000000111111111111111111111111111111111111011000000000000111111111111111111111111111111111111111111111111111111111001111111100000011111111111111111111111000011111111000000000000000000000000000000000000000;
mountain3[175][0:255] <=        256'b0000000000000000000000000000000000000001101111100000000000101111111111111111111111111111111111111000000000000111111111111111111111111111111111111111111111111111111111011111111100000011111111111111111111111000011111011000000000000000000000000000000000000000;
mountain3[176][0:255] <=        256'b0000000000000000000000000000000000000011111111100000000001111111111111111111111111111111111111110000000000000111111111111111111111111111111111111111111111111111111111111111111000000011111111111111111111101000011111011100000000000000000000000000000000000000;
mountain3[177][0:255] <=        256'b0000000000000000000000000000000000000011111011000000000011111111111111111111111111111111111111100000000000000111111111111111111111111111111111111111111111111111111111111111011000000111111111111111111111101000011111111110000000000000000000000000000000000000;
mountain3[178][0:255] <=        256'b0000000000000000000000000000000000000111111011000000000011011111111111111111111111111111111111100000000000000111111111111111111111111111111111111111111111111111111111101111011000000111111111111111111111101000001111111110000000000000000000000000000000000000;
mountain3[179][0:255] <=        256'b0000000000000000000000000000000000000110111110000000000111011111111111111111111111111111111111000000000000000111111111111111111111111111111111111111111111111111111111101111110000001111111111111111111111110000001111110011000000000000000000000000000000000000;
mountain3[180][0:255] <=        256'b0000000000000000000000000000000000001111110110000000011111111111111111111111111111111111111111000000000000000111111111111111111111111111111111111111111111111111111111111111110000011111111111111111111111110000001111111111100000000000000000000000000000000000;
mountain3[181][0:255] <=        256'b0000000000000000000000000000000000011111110100000000111111111111111111111111111111111111111110000000000010000111111111111111111111111111111111111111111111111111111111111111100000011111111111111111111111110000001111111111110000000000000000000000000000000000;
mountain3[182][0:255] <=        256'b0000000000000000000000000000000000011011111100000000111011111111111111111111111111111111111100000000000110000111111111111111111111111111111111111111111111111111111111111111100000110111111111111111111111110000001101111111110000000000000000000000000000000000;
mountain3[183][0:255] <=        256'b0000000000000000000000000000000001111111111100000011111011111111111111111111111111111111111100000000000110000111111111111111111111111111111111111111111111111111111111111111100000110111111111111111111111100000000101111111111000000000000000000000000000000000;
mountain3[184][0:255] <=        256'b0000000000000000000000000000000001111111011000000111111111111111111111111111111111111111011000000000000110000111111111111111111111111111111111111111111111111111111111111111000001111111111111111111111111100000000110111111111100000000000000000000000000000000;
mountain3[185][0:255] <=        256'b0000000000000000000000000000000011111111110000001111111111111111111111111111111111111111010000000000000110000111111111111111111111111111111111111111111111111111111111111011000001111111111111111111111111100000000110111111111100000000000000000000000000000000;
mountain3[186][0:255] <=        256'b0000000000000000000000000000000011011111110000001110111111111111111111111111111111111111110000000000000111000111111111111111111111111111111111111111111111111111111111111111000011011111111111111111111111100000000111111111101100000000000000000000000000000000;
mountain3[187][0:255] <=        256'b0000000000000000000000000000000111111111110000111111111111111111111111111111111111111111110000000000011111000111111111111111111111111111111111111111111111111111111111111110000111111111111111111111111111000000000011111111111110000000000000000000000000000000;
mountain3[188][0:255] <=        256'b0000000000000000000000000000001111111101100000111111111111111111111111111111111111111111100000000111111111000111111111111111111111111111111111111111111111111111111111110110000111111111111111111111111101000110000001110111111110000000000000000000000000000000;
mountain3[189][0:255] <=        256'b0000000000000000000000000000001011111111000001100111111111111111111111111111111111111111000000000111111011000111111111111111111111111111111111111111111111111111111111111110001111111111111111111111111111001110000000111111111111000000000000000000000000000000;
mountain3[190][0:255] <=        256'b0000000000000000000000000000011011111111000011100111111111111111111111111111111111111111000000011111111011000111111111111111111111111111111111111111111111111111111111111100001111111111111111111111111111001111100000111111111111000000000000000000000000000000;
mountain3[191][0:255] <=        256'b0000000000000000000000000000111111111110000111111111111111111111111111111111111111110110000000111111111111000111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111110001111111000011111111111100000000000000000000000000000;
mountain3[192][0:255] <=        256'b0000000000000000000000000000111111101100000111111111111111111111111111111111111111110100000000111111111111000111111111111111111111111111111111111111111111111111111111111000011111111111111111111111111110011111111100001110111111100000000000000000000000000000;
mountain3[193][0:255] <=        256'b0000000000000000000000000001111111111100001110111111111111111111111111111111111111111100000001110011111111000111111111111111111111111111111111111111111111111111111111111000110111111111111111111111111110011010111100000111111110110000000000000000000000000000;
mountain3[194][0:255] <=        256'b0000000000000000000000000011111111111000011111111111111111111111111111111111111111111100000011110111111111000111111111111111111111111111111111111111111111111111111111111000110111111111111111111111111100011110111111000111111111110000000000000000000000000000;
mountain3[195][0:255] <=        256'b0000000000000000000000000111111111111000111111111111111111111111111111111111111110111000000011111111111111000111111111111111111111111111111111111111111111111111111111110001111111111111111111111111111100111111111111100001101111111000000000000000000000000000;
mountain3[196][0:255] <=        256'b0000000000000000000000000110111111110000111111111111111111111111111111111111111110110000000110111111111111000101111111111111111111111111111111111111111111111111111111110001111111111111111111111111111100111111111111100001111111111000000000000000000000000000;
mountain3[197][0:255] <=        256'b0000000000000000000000001110111111110001110111111111111111111111111111111111111111110000000110111111111111100101111111111111111111111111111111111111111111111111111111110011111111111111111111111111111100101111111001110001111111111000000000000000000000000000;
mountain3[198][0:255] <=        256'b0000000000000000000000011111111111100011111111111111111111111111111111111111111101100000001111111111111111100101111111111111111111111111111111111111111111111111111111100011111111111111111111111111111001111111111111111100111111111100000000000000000000000000;
mountain3[199][0:255] <=        256'b0000000000000000000000011111111011000111111111111111111111111111111111111111111101000000001111111111111111100111111111111111111111111111111111111111111111111111111101100111111111111111111111111111111001111111111111111100011111111100000000000000000000000000;
mountain3[200][0:255] <=        256'b0000000000000000000000110111111111000110111111111111111111111111111111111111111111000000011011111111111110101111111111111111111111111111111111111111111111111111111111000110111111111111111111111111111001011111111111101110001111110110000000000000000000000000;
mountain3[201][0:255] <=        256'b0000000000000000000001110111111110001110111111111111111111111111111111111111111111000000011111111111111110101111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111001011111111111101111111111111110000000000000000000000000;
mountain3[202][0:255] <=        256'b0000000000000000000011111111111100011111111111111111111111111111111111111111101110000000111111111111111110101111111111111111111111111111111111111111111111111111111110011111111111111111111111111111010011111111111111111111111111111111000000000000000000000000;
mountain3[203][0:255] <=        256'b0000000000000000000011111111101100011111111111111111111111111111111111111111101100000000111111111111111110101111111111111111111111111111111111111111111111111111111110011111111111111111111111111111010011111111111111111111111111111111000000000000000000000000;
mountain3[204][0:255] <=        256'b0000000000000000000110011111111100111011111111111111111111111111111111111111111100000001111111111111111111111111111111111111111111111111111111111111111111111111111100110111111111111111111111111111110011111111111111111100011111111111100000000000000000000000;
mountain3[205][0:255] <=        256'b0000000000000000001111111111111001111111111111111111111111111111111111111111111000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111100000000000000000000000;
mountain3[206][0:255] <=        256'b0000000000000000011111111111010011111111111111111111111111111111111111111110110000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111110000000000000000000000;
mountain3[207][0:255] <=        256'b0000000000000000011011111111110011011111111111111111111111111111111111111111110000000110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111110000000000000000000000;
mountain3[208][0:255] <=        256'b0000000000000000111011111111110111011111111111111111111111111111111111111111100000011110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111111110000000000000000000000;
mountain3[209][0:255] <=        256'b0000000000000001111111111111111111111111111111111111111111111111111111111111100001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111111111000000000000000000000;
mountain3[210][0:255] <=        256'b0000000000000001111111111111001111111111111111111111111111111111111111111111000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011001111111111111111111111111111111111111000000000000000000000;
mountain3[211][0:255] <=        256'b0000000000000011011111111111011011111111111111111111111111111111111111111111000111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001011111111111111111111111111111111111000000000000000000000;
mountain3[212][0:255] <=        256'b0000000000000011011111111111111011111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111100000000000000000000;
mountain3[213][0:255] <=        256'b0000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110011111111111111111111111111111111111111110000000000000000000;
mountain3[214][0:255] <=        256'b0000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111111110000000000000000000;
mountain3[215][0:255] <=        256'b0000000000001111111111111111111111111111111111111111111111111111111111111111100011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100111111111111111111111111111111111111111110000000000000000000;
mountain3[216][0:255] <=        256'b0000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000111111111111111111111111111111111111111111000000000000000000;
mountain3[217][0:255] <=        256'b0000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111111111111111000000000000000000;
mountain3[218][0:255] <=        256'b0000000000011011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111001111111111111111111111111111111111111111111000000000000000000;
mountain3[219][0:255] <=        256'b0000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111011111111111111111111111111111111111111111111100000000000000000;
mountain3[220][0:255] <=        256'b0000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000;
mountain3[221][0:255] <=        256'b0000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000;
mountain3[222][0:255] <=        256'b0000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111111111111111111111111111111010000000000000000;
mountain3[223][0:255] <=        256'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000;
mountain3[224][0:255] <=        256'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000;
mountain3[225][0:255] <=        256'b0000000001011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101000000000000000;
mountain3[226][0:255] <=        256'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100000000000000;
mountain3[227][0:255] <=        256'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000;
mountain3[228][0:255] <=        256'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000;
mountain3[229][0:255] <=        256'b0000000110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000;
mountain3[230][0:255] <=        256'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000;
mountain3[231][0:255] <=        256'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000;
mountain3[232][0:255] <=        256'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000;
mountain3[233][0:255] <=        256'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100000000000;
mountain3[234][0:255] <=        256'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000;
mountain3[235][0:255] <=        256'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000;
mountain3[236][0:255] <=        256'b0000010111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000;
mountain3[237][0:255] <=        256'b0000110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000;
mountain3[238][0:255] <=        256'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000;
mountain3[239][0:255] <=        256'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000;
mountain3[240][0:255] <=        256'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111101100000000;
mountain3[241][0:255] <=        256'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000;
mountain3[242][0:255] <=        256'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000;
mountain3[243][0:255] <=        256'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110000000;
mountain3[244][0:255] <=        256'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110110000000;
mountain3[245][0:255] <=        256'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000;
mountain3[246][0:255] <=        256'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000;
mountain3[247][0:255] <=        256'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000;
mountain3[248][0:255] <=        256'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000;
mountain3[249][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000;
mountain3[250][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[251][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[252][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[253][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
                                                                                                                                      
mountain3[254][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain3[255][0:255] <=        256'b0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

///////////////////////////////////////////////////////////////////// STAR//////////////////////////////

star_filled[0][0:15] <= 16'b0000001111000000;
star_filled[1][0:15] <= 16'b0000001111000000;
star_filled[2][0:15] <= 16'b0000011111100000;
star_filled[3][0:15] <= 16'b0011111111111100;
star_filled[4][0:15] <= 16'b1111111111111111;
star_filled[5][0:15] <= 16'b1111111111111111;
star_filled[6][0:15] <= 16'b1101111111111011;
star_filled[7][0:15] <= 16'b1111111111111111;
star_filled[8][0:15] <= 16'b0111111111111110;
star_filled[9][0:15] <= 16'b0011111111111100;
star_filled[10][0:15] <=16'b0011111111111100;
star_filled[11][0:15] <=16'b0011111111111100;
star_filled[12][0:15] <=16'b0111011111101110;
star_filled[13][0:15] <=16'b1111111111111111;
star_filled[14][0:15] <=16'b1111111001111111;
star_filled[15][0:15] <=16'b0111100000011111;

/////////////////////////////////////////////////SPACSESHIP///////////////////////////////////////////
spaceship[0][0:31] <=   32'b00000000000001111110000000000000;
spaceship[1][0:31] <=   32'b00000000000011111111000000000000;
spaceship[2][0:31] <=   32'b00000000000011111111000000000000;
spaceship[3][0:31] <=   32'b00000000011111111111111000000000;
spaceship[4][0:31] <=   32'b00000000011111101111111000000000;
spaceship[5][0:31] <=   32'b00000000011111101111111000000000;
spaceship[6][0:31] <=   32'b00000000111111111111111100000000;
spaceship[7][0:31] <=   32'b00000001111111111110111110000000;
spaceship[8][0:31] <=   32'b00000001111111111110111110000000;
spaceship[9][0:31] <=   32'b00000001111111111111111110000000;
spaceship[10][0:31] <=  32'b00000001111111111111001110000000;
spaceship[11][0:31] <=  32'b00000001111111111111111110000000;
spaceship[12][0:31] <=  32'b00000001111111111111111110000000;
spaceship[13][0:31] <=  32'b00001111111111111111111111110000;
spaceship[14][0:31] <=  32'b00011111111111111111111111111000;
spaceship[15][0:31] <=  32'b00011111111111111111111111111000;
spaceship[16][0:31] <=  32'b00111100000011111100000001111100;
spaceship[17][0:31] <=  32'b00111100000011111100000001111100;
spaceship[18][0:31] <=  32'b01111100000011111100000001111110;
spaceship[19][0:31] <=  32'b11111100000000000000000000011111;
spaceship[20][0:31] <=  32'b11110100000000000000000000011111;
spaceship[21][0:31] <=  32'b11110100000000000000000000011111;
spaceship[22][0:31] <=  32'b11111100000001111100000000001111;
spaceship[23][0:31] <=  32'b11111100000001111100000000000111;
spaceship[24][0:31] <=  32'b11110000000001111100000000000111;
spaceship[25][0:31] <=  32'b11111111111111111111111101111111;
spaceship[26][0:31] <=  32'b11111111111111111111111111111111;
spaceship[27][0:31] <=  32'b11111111111111111111111111111111;
spaceship[28][0:31] <=  32'b11111111111111111111111111111111;
spaceship[29][0:31] <=  32'b00011111111111100111111111111000;
spaceship[30][0:31] <=  32'b00011111111111000011111111111000;
spaceship[31][0:31] <=  32'b00001111111111000011111111110000;
//////////////////////////////////////////////////////////////////////

mountain2[0][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain2[1][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain2[2][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain2[3][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain2[4][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain2[5][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain2[6][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain2[7][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain2[8][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
mountain2[9][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000;
mountain2[10][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000001111000000000000000000000000000000000000000000000000000000000000000;
mountain2[11][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000001111100000000000000000000000000000000000000000000000000000000000000;
mountain2[12][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000011111110000000000000000000000000000000000000000000000000000000000000;
mountain2[13][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000111111111000000000000000000000000000000000000000000000000000000000000;
mountain2[14][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000000111111111000000000000000000000000000000000000000000000000000000000000;
mountain2[15][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000001111111111100000000000000000000000000000000000000000000000000000000000;
mountain2[16][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000001111111111110000000000000000000000000000000000000000000000000000000000;
mountain2[17][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000001111111111111000000000000000000000000000000000000000000000000000000000;
mountain2[18][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000011111111111111000000000000000000000000000000000000000000000000000000000;
mountain2[19][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000011111111111111100000000000000000000000000000000000000000000000000000000;
mountain2[20][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000011111111111111100000000000000000000000000000000000000000000000000000000;
mountain2[21][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000011111111111111110000000000000000000000000000000000000000000000000000000;
mountain2[22][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000011111111111111111000000000000000000000000000000000000000000000000000000;
mountain2[23][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000011111111111111111000000000000000000000000000000000000000000000000000000;
mountain2[24][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000011111111111111111100000000000000000000000000000000000000000000000000000;
mountain2[25][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000011111111111111111110000000000000000000000000000000000000000000000000000;
mountain2[26][0:127] <=	128'b00000000000000000000000000000000000000000000000000000000011111111111111111111000000000000000000000000000000000000000000000000000;
mountain2[27][0:127] <=	128'b00000000000000000000000000000000000000000000000000000001111111111111111111111000000000000000000000000000000000000000000000000000;
mountain2[28][0:127] <=	128'b00000000000000000000000000000000000000000000000000000011111111111111000011111000000000000000000000000000000000000000000000000000;
mountain2[29][0:127] <=	128'b00000000000000000000000000000000000000000000000000000011111111111111001011111000000000000000000000000000000000000000000000000000;
mountain2[30][0:127] <=	128'b00000000000000000000000000000000000000000000000000001111111111111111111111111100000000000000000000000000000000000000000000000000;
mountain2[31][0:127] <=	128'b00000000000000000000000000000000000000000000000000011111111111111111111111111100000000000000000000000000000000000000000000000000;
mountain2[32][0:127] <=	128'b00000000000000000000000000000000000000000000000000011111111111111111111111111110000000000000000000000000000000000000000000000000;
mountain2[33][0:127] <=	128'b00000000000000000000000000000000000000000000000000011111110111111111111111111110000000000000000000000000000000000000000000000000;
mountain2[34][0:127] <=	128'b00000000000000000000000000000000000000000000000000011111101111111111111111111111000000000000000000000000000000000000000000000000;
mountain2[35][0:127] <=	128'b00000000000000000000000000000000000000000000000000011111111111111111111111111111000000000000000000000000000000000000000000000000;
mountain2[36][0:127] <=	128'b00000000000000000000000000000000000000000000000000111110111111111111111111111111000000000000000000000000000000000000000000000000;
mountain2[37][0:127] <=	128'b00000000000000000000000000000000000000000000000000111111011111100111011111111111100000000000000000000000000000000000000000000000;
mountain2[38][0:127] <=	128'b00000000000000000000000000000000000000000000000001111110011111001111111111111111100000000000000000000000000000000000000000000000;
mountain2[39][0:127] <=	128'b00000000000000000000000000000000000000000000000001111111111110111100111111111111100000000000000000000000000000000000000000000000;
mountain2[40][0:127] <=	128'b00000000000000000000000000000000000000000000000001110111110111111100111111111111110000000000000000000000000000000000000000000000;
mountain2[41][0:127] <=	128'b00000000000000000000000000000000000000000000000001111111000101011100011111111111110000000000000000000000000000000000000000000000;
mountain2[42][0:127] <=	128'b00000000000000000000000000000000000000000000000001111110011000010000111111111111111000000000000000000000000000000000000000000000;
mountain2[43][0:127] <=	128'b00000000000000000000000000000000000000000000000011111111111000110000011111111111111000000000000000000000000000000000000000000000;
mountain2[44][0:127] <=	128'b00000000000000000000000000000000000000000000000011111101000001100000001111111111111000000000000000000000000000000000000000000000;
mountain2[45][0:127] <=	128'b00000000000000000000000000000000000000000000000111111111000011110000001111111111111100000000000000000000000000000000000000000000;
mountain2[46][0:127] <=	128'b00000000000000000000000000000000000000000000000111111111010011100000001111111111111100000000000000000000000000000000000000000000;
mountain2[47][0:127] <=	128'b00000000000000000000000000000000000000000000000111111011010001100000111111111111111100000000000000000000000000000000000000000000;
mountain2[48][0:127] <=	128'b00000000000000000000000000000000000000000000000111111010011111000000111111111111111100000000000000000000000000000000000000000000;
mountain2[49][0:127] <=	128'b00000000000000000000000000000000000000000000001111110000001011000001111111111111111100000000000000000000000000000000000000000000;
mountain2[50][0:127] <=	128'b00000000000000000000000000000000000000000000011111100000000010000000001111111111111100000000000000000000000000000000000000000000;
mountain2[51][0:127] <=	128'b00000000000000000000000000000000000000000000011111000000000000000000100111111111111100000000000000000000000000000000000000000000;
mountain2[52][0:127] <=	128'b00000000000000000000000000000000000000000000011111000000000000000000000111111111111100000000000000000000000000000000000000000000;
mountain2[53][0:127] <=	128'b00000000000000000000000000000000000000000000111110000000000000000001100111111111111100000000000000000000000000000000000000000000;
mountain2[54][0:127] <=	128'b00000000000000000000000000000000000000000000111110000000000001100011111111111111111110000000000000000000000000000000000000000000;
mountain2[55][0:127] <=	128'b00000000000000000000000000000000000000000000111000000000000000000011111011111111111110000000000000000000000000000000000000000000;
mountain2[56][0:127] <=	128'b00000000000000000000000000000000000000000001110000100000000000000111110011111111111111000000000000000000000000000000000000000000;
mountain2[57][0:127] <=	128'b00000000000000000000000000000000000000000001100100000000010000010111100010111111111111000000000000000000000000000000000000000000;
mountain2[58][0:127] <=	128'b00000000000000000000000000000000000000000011111100000000000000011101100001111111111111100000000000000000000000000000000000000000;
mountain2[59][0:127] <=	128'b00000000000000000000000000000000000000000011100000000000111100011000000011111111111111110000000000000000000000000000000000000000;
mountain2[60][0:127] <=	128'b00000000000000000000000000000000000000000111111000000000100000011000001111111111111111110000000000000000000000000000000000000000;
mountain2[61][0:127] <=	128'b00000000000000000000000000000000000000000110100000000000000000000000011101111111111111111000000000000000000000000000000000000000;
mountain2[62][0:127] <=	128'b00000000000000000000000000000000000000000001000000000000000000000001111111111111111111111000000000000000000000000000000000000000;
mountain2[63][0:127] <=	128'b00000000000000000000000000000000000000001100000000000000000000000001110011111111111111111100000000000000000000000000000000000000;
mountain2[64][0:127] <=	128'b00000000000000000000000000000000000000111000100000000000000000000111110111111111111111111111001000000000000000000000000000000000;
mountain2[65][0:127] <=	128'b00000000000000000000000000000000000011111101111000000000000001111011110111111111111111111111111100000000000000000000000000000000;
mountain2[66][0:127] <=	128'b00000000000000000000000000000000000111111011110000000000000011110110110111111111111111111111111110000000000000000000000000000000;
mountain2[67][0:127] <=	128'b00000000000000000000000000000000011110111111000000100000011111111101101111111111111111111111111111000000000000000000000000000000;
mountain2[68][0:127] <=	128'b00000000000000000000000000000000011101111111100110100000000100011001101111111111111111111111111111100000000000000000000000000000;
mountain2[69][0:127] <=	128'b00000000000000000000000000000000111011111111001100000011001000000011011111111111111111111111111111100000000000000000000000000000;
mountain2[70][0:127] <=	128'b00000000000000000000000000000000111011111110111000000111000000001010101011111111111111111111111111110000000000000000000000000000;
mountain2[71][0:127] <=	128'b00000000000000000000000000000000111111111110110000000100000000010111101111111111111111111111111111111000000000000000000000000000;
mountain2[72][0:127] <=	128'b00000000000000000000000000000000111110100001000000000000000000000100001111111111111111101111111111111100000000000000000000000000;
mountain2[73][0:127] <=	128'b00000000000000000000000000000011111000000001000000010000010100000000011111111111111111101111111111111100000000000000000000000000;
mountain2[74][0:127] <=	128'b00000000000000000000000000000011110000000000000000000000111111000000101111111111111111111111111111111110000000000000000000000000;
mountain2[75][0:127] <=	128'b00000000000000000000000000000111000000000011100001110000111001000000111111111111111111111111111111111111100000000000000000000000;
mountain2[76][0:127] <=	128'b00000000000000000000000000000110000000110111000011000000110000000000111111111111111111111111111111111101110000000000000000000000;
mountain2[77][0:127] <=	128'b00000000000000000000000000000100001100111000100111000111110110000011111111111111111111111111111111111110111000000000000000000000;
mountain2[78][0:127] <=	128'b00000000000000000000000000001111111100100000001100101111101100001111111111111111111111111111111111111111011100000000000000000000;
mountain2[79][0:127] <=	128'b00000000000000000000000000001111111001000000011111111111011100011001111111111111111111111111111111111111001110000000000000000000;
mountain2[80][0:127] <=	128'b00000000000000000000000000001111110000000000111111111110111111111111111111111111111111111111111111111111111111000000000000000000;
mountain2[81][0:127] <=	128'b00000000000000000000000000001100000110000000111100111100111111111111111111111111111111111111111111111111111111100000000000000000;
mountain2[82][0:127] <=	128'b00000000000000000000000000001000000110001001111000111000011111111011111111111111111101111111111111111111110111111000000000000000;
mountain2[83][0:127] <=	128'b00000000000000000000000000001000001110111111110000001000011111111110111111111111111100111111111111111111111011111100000000000000;
mountain2[84][0:127] <=	128'b00000000000000000000000000000011111101111111100000000000001111111111111111111111111111111111111111111111111101111110000000000000;
mountain2[85][0:127] <=	128'b00000000000000000000000000010111111111111111000000000000011111111111111111111111111111111111111111111111111101111111000000000000;
mountain2[86][0:127] <=	128'b00000000000000000000000000011111111111111111000000000000001111111111110111111111111111111111111111111111111110111110100000000000;
mountain2[87][0:127] <=	128'b00000000000000000000000000011100111111111111000000000000001111111111100111111111111111111111111111111111111111111111011000000000;
mountain2[88][0:127] <=	128'b00000000000000000000000000011111111111111110000000000000000111111110101111111111111111111111111111111111111111111111001100000000;
mountain2[89][0:127] <=	128'b00000000000000000000000000111111111111111100000000000000000001111111011111011111111111111111111111111111111111111111111110000000;
mountain2[90][0:127] <=	128'b00000000000000000000000000111111111111111000000000000000000000011001111011101111111111111111111111111111111111111111110111100000;
mountain2[91][0:127] <=	128'b00000000000000000000000011111111111111110000010000010000000000011000010111111111111111111011111111111111111111111111111011110000;
mountain2[92][0:127] <=	128'b00000000000000000000000011111111111111100011000011111100000000000100011111111111111111111111111111111111111111111110111001110000;
mountain2[93][0:127] <=	128'b00000000000000000000001111111111111111100010010111111000000000001100111111111111111111111111111111111111111111111111011110110000;
mountain2[94][0:127] <=	128'b00000000000000000000011111111111111111000000110001111110000111000000011111111111111111111111111111111111111111111111111111100000;
mountain2[95][0:127] <=	128'b00000000000000000001111111111111111110000001111111110001001111000000011111111111111111111111111111111111111111111111101111100000;
mountain2[96][0:127] <=	128'b11111111111111011111111111111111111000011011111111000000000110000000111111011111111111111110011111111111111111111111110111111111;
mountain2[97][0:127] <=	128'b11111111111111111111111111111111100000111111111111100000000010000001111011111111111111101100011111111111111111111111110011111111;
mountain2[98][0:127] <=	128'b11111111111111111111111111111110000011111111111111111110000000000011111001101111111111100000001110111111111111111111110001111111;
mountain2[99][0:127] <=	128'b11111111111111111111111111111100001111111111111111110000000000000000111101111011111111100000000100011111111111111111111001111111;
mountain2[100][0:127] <=128'b11111111111111111111111111111000001111111111111111100000001000011001111101111111111111101000000000000111111111111110111100111111;
mountain2[101][0:127] <=128'b11111111111111111111111111110000000111111111111111000000010000111111111110111111111111101110000000100011111111111110011000011111;
mountain2[102][0:127] <=128'b11111111111111111111111111100000000011111111111100000000100001111111111110111111100111100111100000000000111111111100011110011111;
mountain2[103][0:127] <=128'b11111111111111111111111111000000000000111111110000000001100001111111101111011111110011111111111110000000000111111100111111111111;
mountain2[104][0:127] <=128'b11111111111111111111111110000000000000000000000000000001000011111111110111011111111001111111111111111100000000111000001001111111;
mountain2[105][0:127] <=128'b11111111111111111111111000000000000000000000000000000011000111111011111001101111111111111111111111111010000000000000000011111111;
mountain2[106][0:127] <=128'b11111111111111011100000000000000000000000000000000000011101111111111111001100111111111001111111111111111000000000000000000111111;
mountain2[107][0:127] <=128'b11111111111111000000000000000000000000000000000000000111111111111111111100111011111111111001111111111111100000000000000000011111;
mountain2[108][0:127] <=128'b11111111111110000000000000000000000000000100000000000111111111111111111110011111101111111110111111111111111000000000000000011111;
mountain2[109][0:127] <=128'b11111111111110100000001000000000000011111110000000001111111111111111111110011011111111111111111111111111111110000000000000011111;
mountain2[110][0:127] <=128'b11111111111111111001110000000000000011111000000011111111111111111111111111001011111111111111111111111111111111111110000000011111;
mountain2[111][0:127] <=128'b11111111111111111111110000000000000000000000000111111111111111111111111111000110111111111111111111111111111111111111000001111111;
mountain2[112][0:127] <=128'b11111111111111111111111100000000000000000000001111111111111111111111111111100001101111111111111111111111111111011111110000111111;
mountain2[113][0:127] <=128'b11111111111111000000011000000000000000000000011111111111111111111111111111110000110001101111111111111111111111111111111111111111;
mountain2[114][0:127] <=128'b11111111111110000000000000000000000000000000111111111111111111111111111111111011111100111111011111111111111111111111111111111111;
mountain2[115][0:127] <=128'b11111111111100000000000000000000000000000111111111111111111111111111111111111110110111111111111111111111111110111111110111111111;
mountain2[116][0:127] <=128'b11111111110000000000000000000000000001100111111111111111111111111111111111011111101100111111111111111111111111111111111111111111;
mountain2[117][0:127] <=128'b11111100000000001100000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111101111111111;
mountain2[118][0:127] <=128'b11111111111000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
mountain2[119][0:127] <=128'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
mountain2[120][0:127] <=128'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
mountain2[121][0:127] <=128'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
mountain2[122][0:127] <=128'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
mountain2[123][0:127] <=128'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
mountain2[124][0:127] <=128'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
mountain2[125][0:127] <=128'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
mountain2[126][0:127] <=128'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
mountain2[127][0:127] <=128'b11111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
////////////////////////////////////////////////////////////////GROUND///////////////////////////////////////////////////////////////////
gnd[0][0:31] <=   32'b00000000011111111111111111111111;
gnd[1][0:31] <=   32'b00000000011111111111111111111111;
gnd[2][0:31] <=   32'b00000000001000000011111110000011;
gnd[3][0:31] <=   32'b11111000010000000001110000000001;
gnd[4][0:31] <=   32'b00000111100000000000110000000001;
gnd[5][0:31] <=   32'b00000000000000000000000000000001;
gnd[6][0:31] <=   32'b00000000000000000000000000000001;
gnd[7][0:31] <=   32'b00000000000000000000000000000001;
gnd[8][0:31] <=   32'b00000000000000000000000000000001;
gnd[9][0:31] <=   32'b00000000000000000100000000000001;
gnd[10][0:31] <=  32'b10000000000000001010000000000001;
gnd[11][0:31] <=  32'b01000000000000110001000000000001;
gnd[12][0:31] <=  32'b00100000000001000000100000000001;
gnd[13][0:31] <=  32'b00010000000010000000010000000011;
gnd[14][0:31] <=  32'b00001000000000000000001000000101;
gnd[15][0:31] <=  32'b00000100000100000000000100001001;
gnd[16][0:31] <=  32'b00000010001000000000000010010001;
gnd[17][0:31] <=  32'b00000001110000000000000001100001;
gnd[18][0:31] <=  32'b00000000000000000000000000000001;
gnd[19][0:31] <=  32'b00000000000000000000000000000001;
gnd[20][0:31] <=  32'b00000000000000000000000000000001;
gnd[21][0:31] <=  32'b00000000000000000000000000000001;
gnd[22][0:31] <=  32'b00000000000000000000000000000001;
gnd[23][0:31] <=  32'b00000000000000000000000000000001;
gnd[24][0:31] <=  32'b10000000000000100000000000000000;
gnd[25][0:31] <=  32'b01000000000001010000000000000001;
gnd[26][0:31] <=  32'b00100000000010001000000000000001;
gnd[27][0:31] <=  32'b00010000000100000100000000000001;
gnd[28][0:31] <=  32'b00001000001000000010000011111111;
gnd[29][0:31] <=  32'b00000100010000000001000100000001;
gnd[30][0:31] <=  32'b00000010100000000000101000000001;
gnd[31][0:31] <=  32'b00000001000000000000010000000001;


//////////////////////////NUMBER ////////////////////////

  number_zero[0][0:15] <=         16'b0000000000000000;
        number_zero[1][0:15] <=         16'b0000000000000000;
        number_zero[2][0:15] <=         16'b0000000000000000;
        number_zero[3][0:15] <=         16'b0000011111100000;
        number_zero[4][0:15] <=         16'b0000111111110000;
        number_zero[5][0:15] <=         16'b0000110000110000;
        number_zero[6][0:15] <=         16'b0000110000110000;
        number_zero[7][0:15] <=         16'b0000110000110000;
        number_zero[8][0:15] <=         16'b0000110000110000;
        number_zero[9][0:15] <=         16'b0000110000110000;
        number_zero[10][0:15] <=        16'b0000110000110000;
        number_zero[11][0:15] <=        16'b0000111111110000;
        number_zero[12][0:15] <=        16'b0000011111100000;
        number_zero[13][0:15] <=        16'b0000000000000000;
        number_zero[14][0:15] <=        16'b0000000000000000;
        number_zero[15][0:15] <=        16'b0000000000000000;

 //number1
        number_one[0][0:15] <=          16'b0000000000000000;
        number_one[1][0:15] <=          16'b0000000000000000;
        number_one[2][0:15] <=          16'b0000000000000000;
        number_one[3][0:15] <=          16'b0000000110000000;
        number_one[4][0:15] <=          16'b0000001110000000;
        number_one[5][0:15] <=          16'b0000011110000000;
        number_one[6][0:15] <=          16'b0000000110000000;
        number_one[7][0:15] <=          16'b0000000110000000;
        number_one[8][0:15] <=          16'b0000000110000000;
        number_one[9][0:15] <=          16'b0000000110000000;
        number_one[10][0:15] <=         16'b0000000110000000;
        number_one[11][0:15] <=         16'b0000011111100000;
        number_one[12][0:15] <=         16'b0000011111100000;
        number_one[13][0:15] <=         16'b0000000000000000;
        number_one[14][0:15] <=         16'b0000000000000000;
        number_one[15][0:15] <=         16'b0000000000000000;
        //number2
 number_two[0][0:15] <=          16'b0000000000000000;
        number_two[1][0:15] <=          16'b0000000000000000;
        number_two[2][0:15] <=          16'b0000000000000000;
        number_two[3][0:15] <=          16'b0000011111100000;
        number_two[4][0:15] <=          16'b0000111111110000;
        number_two[5][0:15] <=          16'b0000110000110000;
        number_two[6][0:15] <=          16'b0000000001110000;
        number_two[7][0:15] <=          16'b0000000011100000;
        number_two[8][0:15] <=          16'b0000000111000000;
        number_two[9][0:15] <=          16'b0000001110000000;
        number_two[10][0:15] <=         16'b0000011100000000;
        number_two[11][0:15] <=         16'b0000111111110000;
        number_two[12][0:15] <=         16'b0000111111110000;
        number_two[13][0:15] <=         16'b0000000000000000;
        number_two[14][0:15] <=         16'b0000000000000000;
        number_two[15][0:15] <=         16'b0000000000000000;
        //number3
        number_three[0][0:15] <=        16'b0000000000000000;
        number_three[1][0:15] <=        16'b0000000000000000;
        number_three[2][0:15] <=        16'b0000000000000000;
        number_three[3][0:15] <=        16'b0000011111100000;
        number_three[4][0:15] <=        16'b0000111111110000;
        number_three[5][0:15] <=        16'b0000110000110000;
        number_three[6][0:15] <=        16'b0000000000110000;
        number_three[7][0:15] <=        16'b0000000111100000;
        number_three[8][0:15] <=        16'b0000000111100000;
        number_three[9][0:15] <=        16'b0000000000110000;
        number_three[10][0:15] <=       16'b0000110000110000;
        number_three[11][0:15] <=       16'b0000111111110000;
        number_three[12][0:15] <=       16'b0000011111100000;
        number_three[13][0:15] <=       16'b0000000000000000;
        number_three[14][0:15] <=       16'b0000000000000000;
        number_three[15][0:15] <=       16'b0000000000000000;

 //number4
        number_four[0][0:15] <=         16'b0000000000000000;
        number_four[1][0:15] <=         16'b0000000000000000;
        number_four[2][0:15] <=         16'b0000000000000000;
        number_four[3][0:15] <=         16'b0000000011100000;
        number_four[4][0:15] <=         16'b0000000111100000;
        number_four[5][0:15] <=         16'b0000001111100000;
        number_four[6][0:15] <=         16'b0000011101100000;
        number_four[7][0:15] <=         16'b0000111001100000;
        number_four[8][0:15] <=         16'b0000110001100000;
        number_four[9][0:15] <=         16'b0000111111110000;
        number_four[10][0:15] <=        16'b0000111111110000;
        number_four[11][0:15] <=        16'b0000000001100000;
        number_four[12][0:15] <=        16'b0000000001100000;
        number_four[13][0:15] <=        16'b0000000000000000;
        number_four[14][0:15] <=        16'b0000000000000000;
        number_four[15][0:15] <=        16'b0000000000000000;
        //number5
        number_five[0][0:15] <=         16'b0000000000000000;
        number_five[1][0:15] <=         16'b0000000000000000;
        number_five[2][0:15] <=         16'b0000000000000000;
        number_five[3][0:15] <=         16'b0000111111110000;
        number_five[4][0:15] <=         16'b0000111111110000;
        number_five[5][0:15] <=         16'b0000110000000000;
        number_five[6][0:15] <=         16'b0000110000000000;
        number_five[7][0:15] <=         16'b0000111111100000;
        number_five[8][0:15] <=         16'b0000111111110000;
        number_five[9][0:15] <=         16'b0000000000110000;
        number_five[10][0:15] <=        16'b0000000000110000;
        number_five[11][0:15] <=        16'b0000111111110000;
        number_five[12][0:15] <=        16'b0000111111100000;
        number_five[13][0:15] <=        16'b0000000000000000;
        number_five[14][0:15] <=        16'b0000000000000000;
        number_five[15][0:15] <=        16'b0000000000000000;
        //number6
   number_six[0][0:15] <=          16'b0000000000000000;
        number_six[1][0:15] <=          16'b0000000000000000;
        number_six[2][0:15] <=          16'b0000000000000000;
        number_six[3][0:15] <=          16'b0000011111110000;
        number_six[4][0:15] <=          16'b0000111111110000;
        number_six[5][0:15] <=          16'b0000110000000000;
        number_six[6][0:15] <=          16'b0000110000000000;
        number_six[7][0:15] <=          16'b0000111111100000;
        number_six[8][0:15] <=          16'b0000111111110000;
        number_six[9][0:15] <=          16'b0000110000110000;
        number_six[10][0:15] <=         16'b0000110000110000;
        number_six[11][0:15] <=         16'b0000111111110000;
        number_six[12][0:15] <=         16'b0000011111100000;
        number_six[13][0:15] <=         16'b0000000000000000;
        number_six[14][0:15] <=         16'b0000000000000000;
        number_six[15][0:15] <=         16'b0000000000000000;
        //number7
        number_seven[0][0:15] <=        16'b0000000000000000;
        number_seven[1][0:15] <=        16'b0000000000000000;
        number_seven[2][0:15] <=        16'b0000000000000000;
        number_seven[3][0:15] <=        16'b0000111111110000;
        number_seven[4][0:15] <=        16'b0000111111110000;
        number_seven[5][0:15] <=        16'b0000000000110000;
        number_seven[6][0:15] <=        16'b0000000001110000;
        number_seven[7][0:15] <=        16'b0000000011100000;
        number_seven[8][0:15] <=        16'b0000000111000000;
        number_seven[9][0:15] <=        16'b0000001110000000;
        number_seven[10][0:15] <=       16'b0000011100000000;
        number_seven[11][0:15] <=       16'b0000111000000000;
        number_seven[12][0:15] <=       16'b0000110000000000;
        number_seven[13][0:15] <=       16'b0000000000000000;
        number_seven[14][0:15] <=       16'b0000000000000000;
        number_seven[15][0:15] <=       16'b0000000000000000;
        //number8
 number_eight[0][0:15] <=        16'b0000000000000000;
        number_eight[1][0:15] <=        16'b0000000000000000;
        number_eight[2][0:15] <=        16'b0000000000000000;
        number_eight[3][0:15] <=        16'b0000011111100000;
        number_eight[4][0:15] <=        16'b0000111111110000;
        number_eight[5][0:15] <=        16'b0000110000110000;
        number_eight[6][0:15] <=        16'b0000110000110000;
        number_eight[7][0:15] <=        16'b0000011111100000;
        number_eight[8][0:15] <=        16'b0000011111100000;
        number_eight[9][0:15] <=        16'b0000110000110000;
        number_eight[10][0:15] <=       16'b0000110000110000;
        number_eight[11][0:15] <=       16'b0000111111110000;
        number_eight[12][0:15] <=       16'b0000011111100000;
        number_eight[13][0:15] <=       16'b0000000000000000;
        number_eight[14][0:15] <=       16'b0000000000000000;
        number_eight[15][0:15] <=       16'b0000000000000000;
        //number9
        number_nine[0][0:15] <=         16'b0000000000000000;
        number_nine[1][0:15] <=         16'b0000000000000000;
        number_nine[2][0:15] <=         16'b0000000000000000;
        number_nine[3][0:15] <=         16'b0000011111100000;
        number_nine[4][0:15] <=         16'b0000111111110000;
        number_nine[5][0:15] <=         16'b0000110000110000;
        number_nine[6][0:15] <=         16'b0000110000110000;
        number_nine[7][0:15] <=         16'b0000111111110000;
        number_nine[8][0:15] <=         16'b0000011111110000;
        number_nine[9][0:15] <=         16'b0000000000110000;
        number_nine[10][0:15] <=        16'b0000000000110000;
        number_nine[11][0:15] <=        16'b0000111111110000;
        number_nine[12][0:15] <=        16'b0000111111100000;
        number_nine[13][0:15] <=        16'b0000000000000000;
        number_nine[14][0:15] <=        16'b0000000000000000;
        number_nine[15][0:15] <=        16'b0000000000000000;
//////////////////////////////////BULLET///////////////////////////
bullet[0][0:31] <=   32'b00000000000000011000000000000000;
bullet[1][0:31] <=   32'b00000000000001111111000000000000;
bullet[2][0:31] <=   32'b00000000000011111111100000000000;
bullet[3][0:31] <=   32'b00000000000111111111100000000000;
bullet[4][0:31] <=   32'b00000000001111111111111000000000;
bullet[5][0:31] <=   32'b00000000011111111111111000000000;
bullet[6][0:31] <=   32'b00000000111111111111111100000000;
bullet[7][0:31] <=   32'b00000000111111111111111100000000;
bullet[8][0:31] <=   32'b00000000111111111111111100000000;
bullet[9][0:31] <=   32'b00000000111111111111111100000000;
bullet[10][0:31] <=  32'b00000000111111111111111100000000;
bullet[11][0:31] <=  32'b00000000111111111111111100000000;
bullet[12][0:31] <=  32'b00000000111111111111111100000000;
bullet[13][0:31] <=  32'b00000000111111111111111100000000;
bullet[14][0:31] <=  32'b00000000111111100111111100000000;
bullet[15][0:31] <=  32'b00000000111111000011111100000000;
bullet[16][0:31] <=  32'b00000000111110000001111100000000;
bullet[17][0:31] <=  32'b00000000111100000000111100000000;
bullet[18][0:31] <=  32'b00000000111100000000111100000000;
bullet[19][0:31] <=  32'b00000000111000000000011100000000;
bullet[20][0:31] <=  32'b00000000110000000000001100000000;
bullet[21][0:31] <=  32'b00000000000000000000000000000000;
bullet[22][0:31] <=  32'b00000000000000000000000000000000;
bullet[23][0:31] <=  32'b00000000000000000000000000000000;
bullet[24][0:31] <=  32'b00000000000000000000000000000000;
bullet[25][0:31] <=  32'b00000000000000000000000000000000;
bullet[26][0:31] <=  32'b00000000000000000000000000000000;
bullet[27][0:31] <=  32'b00000000000000000000000000000000;
bullet[28][0:31] <=  32'b00000000000000000000000000000000;
bullet[29][0:31] <=  32'b00000000000000000000000000000000;
bullet[30][0:31] <=  32'b00000000000000000000000000000000;
bullet[31][0:31] <=  32'b00000000000000000000000000000000;



     end else if (chipselect && write)
       case (address)
	8'h0 : hcount_reg <=writedata;
	8'h1 : vcount_reg <=writedata;
        8'h2 : car_xcord<=writedata;
        8'h3 :  ten_creg<=writedata;
        8'h4 : unit_creg<=writedata;
        8'h5 : space_xcord<=writedata;
        8'h6 : bullet_ycord<=writedata;
        8'h7 : gnd_3<=writedata;
        8'h8 : gnd_4<=writedata;
        8'h9 : gnd_5<=writedata;
        8'ha : gnd_6<=writedata;
        8'hb : gnd_7<=writedata;
        8'hc : gnd_8<=writedata;
        8'hd : gnd_9<=writedata;
        8'he : gnd_10<=writedata;
        8'hf : gnd_11<=writedata;
        8'h10 : gnd_12<=writedata;
        8'h11 : gnd_13<=writedata;
        8'h12: gnd_14<=writedata;
        8'h13: gnd_15<=writedata;
        8'h14: gnd_16<=writedata;
        8'h15: gnd_17<=writedata;
        8'h16: gnd_18<=writedata;
        8'h17: gnd_0<=writedata;
        8'h18: gnd_1<=writedata;
        8'h19: gnd_2<=writedata;


       endcase

   always_comb begin
      {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
      if (VGA_BLANK_n )  begin
				if (vcount[9:6]==vcount_reg && hcount[10:8]== car_xcord) 
					begin
	             		         if( buggy[vcount[5:0]][hcount[7:1]] == 1 &&  vcount <385 ) begin
							if(vcount_reg== 5'd5)	
 					      			{VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'hff};
							else
								{VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00}; end
			 		
					else if (hcount[10:6]== hcount_reg && vcount > 100 && vcount < 383) begin
                                        	 if( stone[vcount[4:0]][hcount[5:1]] == 1 && vcount > 352 && vcount <385 )
                                                   {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
						  else if(vcount[9:5]== bullet_ycord && hcount > 550 && hcount <585) begin
                                                          if (bullet[vcount[4:0]][hcount_bullet[4:0]] == 1 )
                                                                {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                                  end

						 else if (mountain3[vcount_mount[7:0]][hcount[8:1]] == 1 &&  vcount > 156 && vcount <409  )
                                               	   {VGA_R, VGA_G, VGA_B} = {8'h00, 8'h80, 8'h00};
						
						 else if (mountain2[vcount[6:0]][hcount[7:1]] == 1 &&  vcount > 255  && vcount <409  )
                                                   {VGA_R, VGA_G, VGA_B} = {8'h00, 8'hbf, 8'hff};
						 else if (hcount[10:6]== hcount_reg && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
							{VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
							else
							{VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
							end
						else if (hcount[10:6]== (gnd_18) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						else if (hcount[10:6]== (gnd_17) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_16) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_15) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_14) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_13) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_12) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_11) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_10) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_9) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_8) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_7) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_6) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_5) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_4) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_3) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_2) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						 else if (hcount[10:6]== (gnd_1) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						   else if (hcount[10:6]== (gnd_0) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end

						  else  if(  vcount > 385 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                        	  else
                                                        {VGA_R, VGA_G, VGA_B} = {background_r, background_g, background_b};

							end
				       else if(vcount[9:5]== bullet_ycord && hcount > 550 && hcount <585) begin
                                                          if (bullet[vcount[4:0]][hcount_bullet[4:0]] == 1 )
                                                         {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                                end

				      else if (mountain3[vcount_mount[7:0]][hcount[8:1]] == 1 &&  vcount > 156 && vcount <385  )
                                                {VGA_R, VGA_G, VGA_B} = {8'h00, 8'h80, 8'h00};

				      else if (mountain2[vcount[6:0]][hcount[7:1]] == 1 &&  vcount > 255  && vcount <385  )
                                                   {VGA_R, VGA_G, VGA_B} = {8'h00, 8'hbf, 8'hff};
	
					 else  if(  vcount > 385 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                         else
                                                        {VGA_R, VGA_G, VGA_B} = {background_r, background_g, background_b};
                                         end

				else if (hcount[10:6]== hcount_reg && vcount > 100 && vcount < 382) begin
                                         if( stone[vcount[4:0]][hcount[5:1]] == 1 && vcount > 352 && vcount <385 )
                                                   {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                         else if(vcount[9:5]== bullet_ycord && hcount > 550 && hcount <585) begin
                                                          if (bullet[vcount[4:0]][hcount_bullet[4:0]] == 1 )
                                                         {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                                end
 
					 else if (mountain3[vcount_mount[7:0]][hcount[8:1]] == 1 &&  vcount > 156 && vcount <385  )
                                                   {VGA_R, VGA_G, VGA_B} = {8'h00, 8'h80, 8'h00};
					 else if (mountain2[vcount[6:0]][hcount[7:1]] == 1 &&  vcount > 255  && vcount <385  )
                                                   {VGA_R, VGA_G, VGA_B} = {8'h00, 8'hbf, 8'hff};
					 else if (hcount[10:6]== hcount_reg && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end

					 else if (hcount[10:6]== gnd_18 && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
					 else if (hcount[10:6]== (gnd_17) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_16) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_15) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_14) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_13) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_12) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_11) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};

                                                        end
						 else if (hcount[10:6]== (gnd_10) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_9) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_8) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_7) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_6) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_5) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_4) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
						else if (hcount[10:6]== (gnd_3) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_2) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_1) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_0) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end

					 else  if(  vcount > 385 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                         else
                                                        {VGA_R, VGA_G, VGA_B} = {background_r, background_g, background_b};
                                         end



 			        else if(vcount[9:5]== bullet_ycord && hcount > 550 && hcount <585 &&  bullet[vcount[4:0]][hcount_bullet[4:0]] == 1 )
                                                         {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};

				else if (mountain3[vcount_mount[7:0]][hcount[8:1]] == 1 &&  vcount > 156 && vcount <385  )
						{VGA_R, VGA_G, VGA_B} = {8'h00, 8'h80, 8'h00};
			
				 else if (mountain2[vcount[6:0]][hcount[7:1]] == 1 &&  vcount > 255  && vcount <385  )
                                                   {VGA_R, VGA_G, VGA_B} = {8'h00, 8'hbf, 8'hff};
	
				 else if (star_filled[vcount_star[3:0]][hcount[3:0]] == 1 &&  vcount > 148 && vcount <164  ) begin
                                                        if(hcount > 128  && hcount <160 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                        else if (hcount > 192 && hcount < 224)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else if (hcount >  207 && hcount < 224 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                                                        else if(hcount > 256 && hcount <288 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                        else if (hcount > 320 && hcount < 352)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else if (hcount >   384 && hcount < 416)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                                                        else if (hcount > 448 && hcount < 480)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else if (hcount >   512 && hcount < 544 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                                                        else if(hcount > 576  && hcount <608 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                        else if (hcount > 640 && hcount < 672)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};

                                                        else if (hcount > 704  && hcount < 736)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h14, 8'h93};
                                                        else if (hcount >  768 && hcount < 800 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'h00, 8'h00, 8'hff};


                                                        else if(hcount > 832  && hcount <864 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                        else if (hcount > 896 && hcount < 928)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};

                                                        else if (hcount > 960  && hcount < 992)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else if (hcount >  1024 && hcount < 1056 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                                                        else if(hcount > 1088  && hcount <1120 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                                                        else if (hcount > 1152 && hcount < 1184)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
							 else if(vcount[9:5]== bullet_ycord && hcount > 550 && hcount <585) begin
                                                                  if (bullet[vcount[4:0]][hcount_bullet[4:0]] == 1 )
                                                                    {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                                       end

                                                        end

				 else if (star_filled[vcount_star[3:0]][hcount[3:0]] == 1 &&  vcount > 132 && vcount <148  ) begin
                                                        if(hcount > 96  && hcount <128 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'h00, 8'h00, 8'hff};
                                                        else if (hcount > 160 && hcount < 192)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else if (hcount >   224  && hcount < 256 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                                                        else if(hcount > 288 && hcount <320 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                                                        else if (hcount > 352 && hcount < 384)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else if (hcount >   416 && hcount < 448)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                                                        else if (hcount > 480 && hcount < 512)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h14, 8'h93};
                                                        else if (hcount >  544 && hcount < 576 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                                                        else if(hcount > 608 && hcount <640 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                        else if (hcount >  672 && hcount < 704)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'h00, 8'h00, 8'hff};

                                                       else if (hcount > 736 && hcount < 768)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h14, 8'h93};
                                                        else if (hcount >   800 && hcount < 832 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                                                        else if(hcount > 864 && hcount <896 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                        else if(hcount > 928  && hcount <960 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                        else if (hcount > 992 && hcount < 1024)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else if (hcount >  1056 && hcount < 1088 )
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};

                                                        else if (hcount > 1120  && hcount < 1152)
                                                                 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
							 else if(vcount[9:5]== bullet_ycord && hcount > 550 && hcount <585) begin
                                                                  if (bullet[vcount[4:0]][hcount_bullet[4:0]] == 1 )
                                                                    {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                                       end

                                                         end
				 else if(hcount[10:6]== space_xcord && vcount > 67 && vcount <100) begin
                                       if (spaceship[vcount_star[4:0]][hcount[5:1]] == 1 &&  vcount > 67 && vcount <100  ) begin
								if(vcount < 85)
                                                        {VGA_R, VGA_G, VGA_B} = {8'h00, 8'h00, 8'hff};
								else
							 {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
							end	
					 else if(vcount[9:5]== bullet_ycord && hcount > 550 && hcount <585) begin
                                                         if (bullet[vcount[4:0]][hcount_bullet[4:0]] == 1 )
                                                         {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
                                                        end

                                        else {VGA_R, VGA_G, VGA_B} = {background_r, background_g, background_b};
                                        end
			 else if (hcount[10:6]== (hcount_reg) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end

				 else if (hcount[10:6]== (gnd_18) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
				 else if (hcount[10:6]== (gnd_17) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_16) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_15) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_14) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_13) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_12) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_11) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};

                                                        end
						 else if (hcount[10:6]== (gnd_10) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_9) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_8) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_7) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_6) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_5) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_4) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};

                                                        end
						 else if (hcount[10:6]== (gnd_3) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_2) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_1) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};
                                                        end
                                                 else if (hcount[10:6]== (gnd_0) && vcount > 383) begin
                                                       if( gnd[vcount[4:0]][hcount[5:1]] == 0 )
                                                        {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
                                                        else
                                                        {VGA_R, VGA_G, VGA_B} = {8'h80, 8'h00, 8'h00};

                                                        end
				else  if(vcount < 16 && hcount >639 && hcount <672) begin
               					 case(ten_creg)
               0: begin
                   if(number_zero[vcount[3:0]][hcount[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
               1: begin
                   if(number_one[vcount[3:0]][hcount[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
	        2: begin
                   if(number_two[vcount[3:0]][hcount[4:1]]== 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
		 3: begin
                   if(number_three[vcount[3:0]][hcount[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
		 4: begin
                   if(number_four[vcount[3:0]][hcount[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
		 5: begin
                   if(number_five[vcount[3:0]][hcount[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
		 6: begin
                   if(number_six[vcount[3:0]][hcount[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
		 7: begin
                   if(number_seven[vcount[3:0]][hcount[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
		 8: begin
                   if(number_eight[vcount[3:0]][hcount[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
			 else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end

		 9: begin
                   if(number_nine[vcount[3:0]][hcount[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end

           endcase
        end
			  else  if(vcount < 16 && hcount >672 && hcount <704) begin
                case(unit_creg)
		 0: begin
                   if(number_zero[vcount[3:0]][hcount_score[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
               1: begin
                   if(number_one[vcount[3:0]][hcount_score[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
                2: begin
                   if(number_two[vcount[3:0]][hcount_score[4:1]]== 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
                 3: begin
                   if(number_three[vcount[3:0]][hcount_score[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
                 4: begin
                   if(number_four[vcount[3:0]][hcount_score[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
                 5: begin
                   if(number_five[vcount[3:0]][hcount_score[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
                 6: begin
                   if(number_six[vcount[3:0]][hcount_score[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
                 7: begin
                   if(number_seven[vcount[3:0]][hcount_score[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end
                 8: begin
                   if(number_eight[vcount[3:0]][hcount_score[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                         else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end


                 9: begin
                   if(number_nine[vcount[3:0]][hcount_score[4:1]] == 1 )
                   {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00};
                   else  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
                   end

           endcase
        end

			        else if (vcount > 385)
				      {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h8c, 8'h00};
				else
                                             {VGA_R, VGA_G, VGA_B} = {background_r, background_g, background_b};
                           end
   
	 else 
	  {VGA_R, VGA_G, VGA_B} = {background_r, background_g, background_b};
                        end
	       
endmodule

module nor_cnt (
 input logic clk50, reset,
output logic up);

reg [4:0]cnt;

always_ff @(posedge clk50 or posedge reset)
begin
if(reset)
cnt<=5'b0;
else
cnt<= cnt+1'b1;
end

always_ff @(posedge cnt[4] or posedge reset)
begin
if(reset)
up<=0;
else
up <=~up;
end

endmodule

module vga_counters(
 input logic 	     clk50, reset,
 output logic [10:0] hcount,  // hcount[10:1] is pixel column
 output logic [9:0]  vcount,  // vcount[9:0] is pixel row
 output logic 	     VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n);

/*
 * 640 X 480 VGA timing for a 50 MHz clock: one pixel every other cycle
 * 
 * HCOUNT 1599 0             1279       1599 0
 *             _______________              ________
 * ___________|    Video      |____________|  Video
 * 
 * 
 * |SYNC| BP |<-- HACTIVE -->|FP|SYNC| BP |<-- HACTIVE
 *       _______________________      _____________
 * |____|       VGA_HS          |____|
 */
   // Parameters for hcount
   parameter HACTIVE      = 11'd 1280,
             HFRONT_PORCH = 11'd 32,
             HSYNC        = 11'd 192,
             HBACK_PORCH  = 11'd 96,   
             HTOTAL       = HACTIVE + HFRONT_PORCH + HSYNC +
                            HBACK_PORCH; // 1600
   
   // Parameters for vcount
   parameter VACTIVE      = 10'd 480,
             VFRONT_PORCH = 10'd 10,
             VSYNC        = 10'd 2,
             VBACK_PORCH  = 10'd 33,
             VTOTAL       = VACTIVE + VFRONT_PORCH + VSYNC +
                            VBACK_PORCH; // 525

   logic endOfLine;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          hcount <= 0;
     else if (endOfLine) hcount <= 0;
     else  	         hcount <= hcount + 11'd 1;

   assign endOfLine = hcount == HTOTAL - 1;
       
   logic endOfField;
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          vcount <= 0;
     else if (endOfLine)
       if (endOfField)   vcount <= 0;
       else              vcount <= vcount + 10'd 1;

   assign endOfField = vcount == VTOTAL - 1;

   // Horizontal sync: from 0x520 to 0x5DF (0x57F)
   // 101 0010 0000 to 101 1101 1111
   assign VGA_HS = !( (hcount[10:8] == 3'b101) &
		      !(hcount[7:5] == 3'b111));
   assign VGA_VS = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);

   assign VGA_SYNC_n = 1'b0; // For putting sync on the green signal; unused
   
   // Horizontal active: 0 to 1279     Vertical active: 0 to 479
   // 101 0000 0000  1280	       01 1110 0000  480
   // 110 0011 1111  1599	       10 0000 1100  524
   assign VGA_BLANK_n = !( hcount[10] & (hcount[9] | hcount[8]) ) &
			!( vcount[9] | (vcount[8:5] == 4'b1111) );

   /* VGA_CLK is 25 MHz
    *             __    __    __
    * clk50    __|  |__|  |__|
    *        
    *             _____       __
    * hcount[0]__|     |_____|
    */
   assign VGA_CLK = hcount[0]; // 25 MHz clock: rising edge sensitive
   
endmodule
