#ifndef _VGA_BALL_H
#define _VGA_BALL_H

#include <linux/ioctl.h>
#define GND_SZ 19


typedef struct{
	short bullet_gnd[GND_SZ+1];
} vga_ball_bullet_gnd;

typedef struct{
	short vcount;
} vga_ball_vcount;

typedef struct{
	short hcount;
} vga_ball_hcount;

typedef struct{
	short carx;
} vga_ball_carx;

typedef struct{
	short score_t;
} vga_ball_score_t;

typedef struct{
	short score_u;
} vga_ball_score_u;

typedef struct{
    short spaceship;
} vga_ball_spaceship;

#define VGA_BALL_MAGIC 'q'

#define VGA_BALL_WRITE_VCOUNT      _IOW(VGA_BALL_MAGIC, 1, vga_ball_vcount *)
#define VGA_BALL_WRITE_HCOUNT      _IOW(VGA_BALL_MAGIC, 2, vga_ball_hcount *)
#define VGA_BALL_WRITE_CARX        _IOW(VGA_BALL_MAGIC, 3, vga_ball_carx *)
#define VGA_BALL_WRITE_SCORE_T     _IOW(VGA_BALL_MAGIC, 4, vga_ball_score_t *)
#define VGA_BALL_WRITE_SCORE_U     _IOW(VGA_BALL_MAGIC, 5, vga_ball_score_u *)
#define VGA_BALL_WRITE_SPACESHIP   _IOW(VGA_BALL_MAGIC, 6, vga_ball_spaceship *)
#define VGA_BALL_WRITE_BULLET_GND  _IOW(VGA_BALL_MAGIC, 7, vga_ball_bullet_gnd *)

#endif
