/*
This file was created based on the tonegen.sv file
in the BrickBreaker project from Spring 2019 
developed by Rui Chen, Bingyao Shi, Shao-Fu Wu, and Daijing Xu

Note that this file represents the work that I think is most likely to
integrate with the broader Moon Patrol product, and may not precisely 
reflect some of the iterative improvements I attempted 
that are mentioned in the presentation.
*/

// wave generation

module tone(
    input clk, // 50 MHz clock
    input reset,
    input l_chan,
    input r_chan,
    input logic [1:0] audio_select,
    output logic [15:0] sample_data, // data converted to 16 bit representation
    output logic sample_valid
);

// sample rate to be 8 kHz
logic [2:0] counter; // to convert from 48 kHz, divide by 6
logic [16:0] std_address;
logic [15:0] std_data;
logic [10:0] shoot_address;
logic [15:0] shoot_data;
logic [9:0] jump_address;
logic [15:0] jump_data;
logic flag3; 
logic flag4;
logic [8:0] timer1; // just tracks time
logic [8:0] timer2; // reset to 0 whenever something happens
/* flag -> tone mapping
flag3 and flag4 -> standard tone
flag3 and not flag4 -> shoot tone
not flag3 and not flag4 -> jump tone
*/

// memory instantiation for tones
standard standard0(.address(std_address),.clock(clk),.q(std_data)); // standard tone
shoot shoot0(.address(shoot_address),.clock(clk),.q(shoot_data)); //shooting tone
jump jump0(.address(jump_address),.clock(clk),.q(jump_data)); // shot hit something tone

// tone operation
// if nothing else is happening, play the standard tone
always_ff @(posedge clk) begin
    timer1 <= timer1 + 1;
    if (reset) begin
        counter1 <= 3'b0;
        std_address <= 0
        sample_data <= ( std_data );
        sample_valid ,+ 0;
        flag3 <= 1'b1;
        flag4 <= 1'b1;
        shoot_address <= 0;
        jump_address <= 0;
        timer1 <= 0;
        timer2 <= 0;
    end else if (counter < 3'd6 && (l_chan && r_chan)) begin
        counter <= counter + 1;
        timer2 <= timer2 + 1;
        sample_valid <= 1'b0;
    end else if (counter == 3'd6 && (l_chan && r_chan)) begin
        timer1 <= timer1 + 1;
        if (audio_select == 2'b00 && flag3 == 1'b1 && flag4 == 1'b1) begin
            if (std_address <  17'd121593) begin
                std_address <= std_address + 1;
            end else begin
                std_address <= 0;
            end
            sample_data <= (std_data);
        end else if (audio_select == 2'b01 || (flag3 == 0 && flag4 == 0)) begin // if jump
            if(jump_address < 11'd1815 && std_address < 17'd121593) begin
                jump_address <= jump_address + 1;
                flag3 <= 0;
                flag4 <= 0;
                timer2 <= 0;
            end else if ((std_address = 17'd121593) || (timer1 - timer2 > 15'b100000000000000))begin:
                std_address <= 0;
                flag3 = 1'b1;
                flag4 = 1'b0;
            end else if ((jump_address == 11'd1815) || (timer1 - timer2 > 15'b100000000000000)) begin 
                jump_address <= 0;
                flag3 = 1'b1;
                flag4 = 1'b1;
                timer2 <= 0;
            end
            sample_data <= (jump_data) + (std_data)
        end else if (audio_select == 2'b01 || (flag3 == 1'b0 && flag4 == 0)) begin // if shots= fired
            if(shoot_address < 11'd1815 && std_address < 17'd121593) begin
                shoot_address <= shoot_address + 1;
                flag3 <= 1;
                flag4 <= 0;
            end else if ((std_address = 17'd121593) || (timer1 - timer2 > 15'b100000000000000))begin:
                std_address <= 0;
                flag4 = 1'b0;
                flag3 = 1'b0;
                timer2 <= 0;
            end else if ((shoot_address == 11'd1815) || (timer1 - timer2 > 15'b100000000000000)) begin 
                shoot_address <= 0;
                flag4 = 1'b1;
                flag3 = 1'b1;
                timer2 <= 0;
            end
            sample_data <= (shoot_data) + (std_data)
        end 
        counter <= 0;
        sample_valid = 1'b1;
    end
end



endmodule