module pe_array(
	input logic clk,
	input logic rst_n_pe,
	input logic weight_valid,
	input logic feature_valid,
	input logic[15:0]input_feature,
	input logic[1023:0]input_weight_bias,
	input logic [3:0]conv_num,
	output logic[1023:0]output_feature
);

	genvar i;
	generate
		for (i=1; i<=64; i++)
			begin:mac
			mac_unit mac(
				.clk(clk),
				.rst_n_pe(rst_n_pe),
				.input_feature(input_feature),
				.input_weight_bias(input_weight_bias[(i)*16-1:(i-1)*16]),
				.output_feature(   output_feature   [(i)*16-1:(i-1)*16]),
				.conv_num(conv_num),                  
				.weight_valid(weight_valid),
				.feature_valid(feature_valid)
			);
		end
	endgenerate
endmodule


