module p1024_to_s16(
	input logic clk,
    input logic rst_n,
	//interface to pe
	input logic [1023:0] datain_pe,
	input logic 		 input_en_control,
	//interface to controller
	input logic  [14:0] addr_in_control,
	//avalon interface to output memory
	//input logic [15:0]writedata_input,
	output logic [15:0] writedata_output,	
	output logic [14:0] address_output,
	output logic        write_output,
	input  logic 		waitrequest_output,
	output logic 		chipselect_output,
	output logic [1:0]	byteenable_output
);
	logic [1023:0] buffer;
	logic [5:0]    i;
	logic [14:0]   addr_out_base;
	logic [14:0]   address_output_in;
	enum {IDLE,OUT}state;
	assign byteenable_output=2'b11;

	always_ff@(posedge clk)
	begin
		if(rst_n==0) begin
			buffer<=1024'b0;
			chipselect_output<=0;
			state<=IDLE;
			write_output<=1;
		end

		else begin
			case(state)

				IDLE: begin
					chipselect_output<=0;
					if (input_en_control==1) begin
						
						buffer <= datain_pe;
						i	   <= 0;
						state  <= OUT;
						address_output<=addr_in_control;
					end
				end

				OUT: begin	
					address_output    <= address_output_in;
					address_output_in <= address_output_in+2;
					writedata_output  <= buffer[15:0];
					buffer            <= buffer >> 16;
					chipselect_output <= 1;
					if (i == 63) begin
						state <= IDLE;
					end
					i <= i + 1;
				end
			endcase
		end
	end
endmodule  
		
  
    
