module onchip_read_master_input(//avalon interface
	input  logic clk,
	output logic [10:0]addr_read,
	input  logic [15:0]data_read_input,
	//output logic [15:0]data_write_input,
	output logic [1:0]byteenable,
	output logic chipselect,
	output logic read_en,
	input wait_request,
	//interface to control
	input logic [10:0]addr_read_input,
	input logic read_en_input,
	input logic rst_n,
	//interface to pe array
	output logic [15:0]data_read,
	output logic data_valid
);
enum {idle,read,read_wait,read_consec}state;
assign byteenable=2'b11;
always_ff @(posedge clk)
begin
  	if (rst_n==0)
  	begin
    		state<=idle;
    		chipselect<=1'b0;
    		data_valid<=1'b0;
			read_en<=1'b0;
  	end
  	else 
  	begin
		addr_read<=addr_read_input;
    		case(state)
    		idle:
    		begin
      			if (read_en_input==1)
      			begin
				chipselect<=1'b1; 
        			data_valid<=1'b0;
				state<=read_wait;
      			end
      			else if(read_en_input==0)
      			begin
				
        			chipselect<=1'b0;
        			data_valid<=1'b0;
				state<=idle;
      			end
    		end
    		read_wait:
    		begin
      			data_valid<=0;
      			if(read_en_input==1)
      			begin
				chipselect<=1'b1;
				state<=read_consec;
      			end
      			else if(read_en_input==0)
      			begin
				chipselect<=1'b0;
				state<=read;
      			end
    		end
    		read_consec:
    		begin
      			data_read<=data_read_input;
      			data_valid<=1'b1;
      			if(read_en_input==1)
      			begin
				chipselect<=1'b1;
				state<=read_consec;
      			end
      			else if(read_en_input===0)
      			begin
				chipselect<=1'b0;
				state<=read;
      			end
    		end
    		read:
    		begin
      			data_read<=data_read_input;
      			data_valid<=1'b1; 
      			if(read_en_input==1)
      			begin
				chipselect<=1'b1;
				state<=read_wait;
      			end
      			else  if(read_en_input==0)
      			begin
				chipselect<=1'b0;
				state<=idle;
      			end
    		end
    		endcase
  	end
end
endmodule
	 
		
		
	 
	 
	 
    
	 
