module mac_unit(input logic clk,
                input logic rst_n_pe,
				input logic[15:0] input_feature,
				input logic[15:0] input_weight_bias,
				input logic [3:0]conv_num,
				input logic feature_valid,
				input logic weight_valid,
				output logic[15:0] output_feature
				);

	logic [39:0]mac_result;
	logic [31:0]ac_result;

	always_ff @(posedge clk) begin

  		if (rst_n_pe==0) begin
	 		mac_result='b0;
         	ac_result='b0; 
	 		output_feature='b0;
  		end
  		else if(feature_valid && weight_valid) begin
			ac_result  = input_feature * input_weight_bias;
    		mac_result = mac_result + ac_result;         
  		end
  		else if(weight_valid) begin
    		mac_result = mac_result + input_weight_bias;
  		end
  		else begin
      		//need to be changed according to conv layer.
			case (conv_num)
				4'd0: output_feature = mac_result[31:16];
				4'd1: output_feature = mac_result[30:15];
				4'd2: output_feature = mac_result[29:14];
				4'd3: output_feature = mac_result[28:13];
				4'd4: output_feature = mac_result[27:12];
				4'd5: output_feature = mac_result[26:11];
				4'd6: output_feature = mac_result[25:10];
				4'd7: output_feature = mac_result[24:9];
				4'd8: output_feature = mac_result[23:8];
				4'd9: output_feature = mac_result[22:7];
				4'd10: output_feature = mac_result[21:6];
				4'd11: output_feature = mac_result[20:5];
				4'd12: output_feature = mac_result[19:4];
				4'd13: output_feature = mac_result[18:3];
				4'd14: output_feature = mac_result[17:2];
				4'd15: output_feature = mac_result[16:1];
			endcase
  		end
	end
endmodule
