module dma_state_machine(
	input logic clk,
	input logic rst_n,
	//interface with main controller
	input logic dma_en,
	input logic [31:0]dma_read_addr_in,
	input logic [31:0]dma_write_addr_in,
	input logic[31:0]dma_length_in,
	output logic[4:0] dma_done,
	//interface with dma controller
	input logic dma_control_waitrequest,
	output logic [4:0] dma_control_addr,
	output logic [31:0] dma_control_data_out,
	input logic [31:0] dma_control_data_in,
	output logic dma_control_read,
	output logic dma_control_chipselect
	);
	
	enum {
		idle,
		write_controller_status,
		write_controller_read_addr,
		write_controller_write_addr,
		write_controller_length,
		write_controller_control,
		read_controller_status,
		wait_dma_done,
		wait_write_controller_read_addr,
		wait_write_controller_write_addr,
		wait_write_controller_length,
		wait_write_controller_control,
		wait_read_controller_status,
		STATE_WAIT
     	} dma_control_state;

	logic [31:0]dma_read_addr;
	logic [31:0]dma_write_addr;
	logic [31:0]dma_write_length;

always_ff @(posedge clk or negedge rst_n) begin
	if(rst_n == 0) begin
		dma_control_state<=idle;
		dma_done <= 1'b0;
	end
	else begin
	case(dma_control_state)
	// Initial status: set register0 = 0 to clean it
  		write_controller_status: begin 
    		dma_control_addr<=0;
    		dma_control_data_out<=0;
    		dma_control_read<=0;    		
    		dma_control_state<=wait_write_controller_read_addr;
			dma_control_chipselect <= 1;
  	end
	  	wait_write_controller_read_addr:begin
		   	dma_control_state<=write_controller_read_addr;
			dma_control_chipselect <= 0;
	end
	// set register1 = read address 
  	write_controller_read_addr: begin
    		dma_control_addr<=4;
    		dma_control_data_out<=dma_read_addr;
    		dma_control_read<=0;//wirte_n
    		dma_control_state<=wait_write_controller_write_addr;
			dma_control_chipselect <= 1;
  	end
		wait_write_controller_write_addr:begin
		   	dma_control_state<=write_controller_write_addr;
			dma_control_chipselect <= 0;
	end
	// set register2 = write address
  		write_controller_write_addr: begin
    		dma_control_addr<=8;
    		dma_control_data_out<=dma_write_addr;
    		dma_control_read<=0;
   	 		dma_control_state<=wait_write_controller_length;
			dma_control_chipselect <= 1;
  	end
		wait_write_controller_length:begin
		   	dma_control_state<=write_controller_length;
			dma_control_chipselect <= 0;
	end
	// set register3 = data length
  		write_controller_length: begin
    		dma_control_addr<=12;
    		dma_control_data_out<=dma_write_length; // where is 2*?
    		dma_control_read<=0;
    		dma_control_state<=wait_write_controller_control;
			dma_control_chipselect <= 1;
  	end
		wait_write_controller_control:begin
		   	dma_control_state<=write_controller_control;
			dma_control_chipselect <= 0;
	end
	// set register6 = 'b10001010
	// set bit 1 for half-WORD transfer, set 0,1,2 digit to 1 according to data-width
	// set bit 3 to start DMA0
	// set bit 4 to enalbe interrupt request(IRQ)
	// set bit 7 to stop on byte-count
  		write_controller_control: begin
    		dma_control_addr<=24;
    		dma_control_data_out<=32'b10001010;
    		dma_control_read<=0;
    		dma_control_state<=wait_read_controller_status;
			dma_control_chipselect <= 1;
  	end
		wait_read_controller_status:begin
			dma_control_state<=read_controller_status;
			dma_control_chipselect <= 0;
	end
	// read controller status info to judge current status
  	read_controller_status:  begin
    		dma_control_addr<=0; ///***
    		dma_control_read<=1;
    		dma_control_state<=wait_dma_done;
			dma_control_chipselect <= 1;
  	end
	// dma would change status to BUSY while tranferring data,
	// and would change to DONE status after finishing
  	wait_dma_done: begin
    		if((dma_control_data_in[11:0] & 12'h010) != 0) begin
      			dma_control_state<=idle;
      			dma_done<=1;
      		end
	end
  	idle:begin//when we finish dma transition,dma controller go to idle state to wait for the next transition
		if (dma_en==1)
		begin
  			dma_read_addr<=dma_read_addr_in;
  			dma_write_addr<=dma_write_addr_in;
  			dma_write_length<=dma_length_in;
  			dma_done<=0;
			//if (dma_control_waitrequest == 1)
				//dma_control_state <= STATE_WAIT;
			//else
  				dma_control_state<=write_controller_status;
		end
  	end
	STATE_WAIT: begin 
		//if (dma_control_waitrequest)
			//dma_control_state <= STATE_WAIT;
		//else
			dma_control_state <= idle;
	end
	endcase
	end
end
endmodule



