module controller(input logic clk,
                  input logic rst_n,
                  //interface with dma controller
                  input logic dma_control_waitrequest,
                  output logic [4:0] dma_control_addr,
                  output logic [31:0] dma_control_data_out,
                  input logic [31:0] dma_control_data_in,
                  output logic dma_control_read,
                  output logic dma_control_chipselect,
                  //interface with pe array
                  output logic [10:0]addr_input_pe,
                  output logic [16:0]addr_weight_pe,
                  output logic [14:0]addr_write_pe,
                  output logic input_master_en,
                  output logic weight_master_en,
                  output logic output_master_en,
                  output logic rst_n_pe,
                  output logic [3:0]conv_num,
                  //interface with write buffer
                  output logic [16:0]write_addr_buffer_out,
                  //interface with HPS
                  input logic write,
                  input logic chipselect,
                  input logic [31:0]writedata,
                  output logic [31:0]readdata,
                  input logic [3:0]address
                  );
                  logic dma_en;
                  logic [31:0]dma_read_addr;
                  logic [31:0]dma_write_addr;
                  logic [31:0]dma_length;
                  logic dma_done;
                  logic conv_state_machine_en;
                  logic [9:0]input_channel_in;
                  logic [9:0]output_channel_in;
                  logic [31:0]weight_start_address_in;
                  logic [31:0]input_start_address_in;
                  logic [31:0]bias_start_address_in;
                  logic [9:0]input_size_in;
                  logic [9:0]output_size_in;


 dma_state_machine dma_state(
	.clk(clk),
	.rst_n(rst_n),
	//interface with main controller
	.dma_en(dma_en),
	.dma_read_addr_in(dma_read_addr),
	.dma_write_addr_in(dma_write_addr),
	.dma_length_in(dma_length),
	.dma_done(dma_done),
	//interface with dma controller
	.*
	);

conv_state_machine conv_state(.* );
command_receiver commander(  .*  );

endmodule