module command_receiver(  input logic clk,
                    input logic rst_n,
                    //avalon slave to HPS
                    input logic write,
                    input logic chipselect,
                    input logic [31:0]writedata,
                    output logic [31:0]readdata,
                    input logic [3:0]address,
                    //interface to conv_state_machine
                    output logic [3:0] conv_num,
                    output logic conv_state_machine_en,
                    output logic [31:0] weight_start_address_in,
                    output logic [31:0] bias_start_address_in,
                    output logic [31:0] input_start_address_in,
                    output logic [9:0] input_size_in,
                    output logic [9:0] output_size_in,
                    output logic [9:0] input_channel_in,
                    output logic [9:0] output_channel_in  );
    always_ff@(posedge clk or negedge rst_n)
    begin
        if (rst_n==0 )
        begin
        conv_state_machine_en <= 0;
        end
        else
        begin
            if(write==1 && chipselect)
            begin
                case(address)
                    0:weight_start_address_in <= writedata;
                    1:bias_start_address_in <= writedata;
                    2:input_start_address_in <= writedata;
                    3:input_size_in <= writedata[9:0];
                    4:output_size_in <= writedata[9:0];
                    5:conv_num <= writedata[3:0];
                    6:conv_state_machine_en <= writedata[0];
                    7:input_channel_in<=writedata[9:0];
                    8:output_channel_in<=writedata[9:0];
                endcase
            end
        end
    end
endmodule