#include <stdlib.h>
#include <stdio.h>
#include "Vprocessor.h"
#include "verilated.h"
#include "verilator_test.h"


#define PROC processor__DOT_

void test_register_ops(Vprocessor* tb)
{
    // set state of registers
    tb->processor__DOT__c__DOT__R_registers[0] = 0x037a;
    tb->processor__DOT__c__DOT__R_registers[1] = 0x0132;
    tb->processor__DOT__c__DOT__R_registers[2] = 0x02ff;
    tb->processor__DOT__c__DOT__R_registers[3] = 0x0000;

    while(!Verilated::gotFinish()) {
        tb->clk = 1;

        tb->processor__DOT__c__DOT__I_register = 1;
        tb->processor__DOT__c__DOT__N_register = 2;

        tb->eval();
        printf("%s\n", tb->processor__DOT__c__DOT__fetch_execute ? "execute" : "fetch");
        printf("N_register clock up: %02x\n", tb->processor__DOT__c__DOT__N_register);
        printf("I_register clock up: %02x\n", tb->processor__DOT__c__DOT__I_register);
        printf("R_registers clock up: ");
        print_arr(tb->processor__DOT__c__DOT__R_registers, 16);
        printf("\n");
        tb->clk = 0;
        tb->eval();

#ifdef __PRINT_DOWN__
        printf("%s\n", tb->processor__DOT__c__DOT__fetch_execute ? "execute" : "fetch");
        printf("N_register clock up: %02x\n", tb->processor__DOT__c__DOT__N_register);
        printf("I_register clock up: %02x\n", tb->processor__DOT__c__DOT__I_register);
        printf("R_registers clock down: ");
        print_arr(tb->processor__DOT__c__DOT__R_registers, 16);
        printf("\n");
#endif

        printf("Press any key to move to next clock cycle, n for next test\n");
        if (getchar() == 'n') {
            break;
        }
    }

    printf("Moving on to next test\n");

    while(!Verilated::gotFinish()) {
        tb->clk = 1;

        tb->processor__DOT__c__DOT__I_register = 2;
        tb->processor__DOT__c__DOT__N_register = 1;

        tb->eval();
        printf("%s\n", tb->processor__DOT__c__DOT__fetch_execute ? "execute" : "fetch");
        printf("N_register clock up: %02x\n", tb->processor__DOT__c__DOT__N_register);
        printf("I_register clock up: %02x\n", tb->processor__DOT__c__DOT__I_register);
        printf("R_registers clock up: ");
        print_arr(tb->processor__DOT__c__DOT__R_registers, 16);
        printf("\n");
        tb->clk = 0;
        tb->eval();

#ifdef __PRINT_DOWN__
        printf("%s\n", tb->processor__DOT__c__DOT__fetch_execute ? "execute" : "fetch");
        printf("N_register clock up: %02x\n", tb->processor__DOT__c__DOT__N_register);
        printf("I_register clock up: %02x\n", tb->processor__DOT__c__DOT__I_register);
        printf("R_registers clock down: ");
        print_arr(tb->processor__DOT__c__DOT__R_registers, 16);
        printf("\n");
#endif

        printf("Press any key to move to next clock cycle, n for next test\n");
        if (getchar() == 'n') {
            break;
        }
    }

    printf("\nMoving on to next test\n\n");

    while(!Verilated::gotFinish()) {
        tb->clk = 1;

        tb->processor__DOT__c__DOT__I_register = 6;
        tb->processor__DOT__c__DOT__N_register = 0;

        tb->eval();
        printf("%s\n", tb->processor__DOT__c__DOT__fetch_execute ? "execute" : "fetch");
        printf("N_register clock up: %02x\n", tb->processor__DOT__c__DOT__N_register);
        printf("I_register clock up: %02x\n", tb->processor__DOT__c__DOT__I_register);
        printf("R_registers clock up: ");
        print_arr(tb->processor__DOT__c__DOT__R_registers, 16);
        printf("\n");
        tb->clk = 0;
        tb->eval();

#ifdef __PRINT_DOWN__
        printf("%s\n", tb->processor__DOT__c__DOT__fetch_execute ? "execute" : "fetch");
        printf("N_register clock up: %02x\n", tb->processor__DOT__c__DOT__N_register);
        printf("I_register clock up: %02x\n", tb->processor__DOT__c__DOT__I_register);
        printf("R_registers clock down: ");
        print_arr(tb->processor__DOT__c__DOT__R_registers, 16);
        printf("\n");
#endif

        printf("Press any key to move to next clock cycle, n for next test\n");
        if (getchar() == 'n') {
            break;
        }
    }
}
