/*
 * Userspace program that communicates with the fpga_ram device driver
 * through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */

#include <stdio.h>
#include "fpga_ram.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

int fpga_ram_fd;

/* Read and print the background color */
void print_mem(unsigned char addr) {
  fpga_ram_arg_t real_vla;
  real_vla.address = addr;
  real_vla.data = 0x04;
//  printf("OUTSIDE: %02x\n" , real_vla.address);
  if (ioctl(fpga_ram_fd, FPGA_RAM_READ, &real_vla)) {
      perror("ioctl(FPGA_RAM_READ) failed");
      return;
  }
  printf("%02x\n",
	real_vla.data);

}

/* Set the background color */
void set_mem(fpga_ram_arg_t *vla)
{
  fpga_ram_arg_t real_vla;
  real_vla.address = vla->address;
  real_vla.data = vla->data;
  //printf("OUTSIDE: %02x\n" , real_vla.data);
  if (ioctl(fpga_ram_fd, FPGA_RAM_WRITE, &real_vla)) {
      perror("ioctl(FPGA_RAM_WRITE) failed");
      return;
  }
}

int main()
{
  static const char filename[] = "/dev/vga_ball";
  printf("FPGA RAM Userspace program started\n");
  fpga_ram_arg_t my_mem_args;
  my_mem_args.data = 0x07;
  my_mem_args.address = 0x07;

  if ( (fpga_ram_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

//  for (int i = 0; i < 32; i ++){
//     my_mem_args.data = 0x00;
//     my_mem_args.address = 0x00 + i;
//     set_mem(&my_mem_args);
//  }

  // PROG:
  // E2 
  // 12 
  // F0
  // 52
  // 00

  // X = 1 
  my_mem_args.data = 0xe4;
  my_mem_args.address = 0x00;
  set_mem(&my_mem_args);
  // R(2) +=1
  my_mem_args.data = 0x24;
  my_mem_args.address = 0x01;
  set_mem(&my_mem_args);
  // D -> M(R(x)) = M(R(2)) = 12
  my_mem_args.data = 0x84;
  my_mem_args.address = 0x02;
  set_mem(&my_mem_args);
  // R(2) +=1
  my_mem_args.data = 0xA3;
  my_mem_args.address = 0x03;
  set_mem(&my_mem_args);
  // D -> M(R(2)) = M(1)
  my_mem_args.data = 0x23;
  my_mem_args.address = 0x04;
  set_mem(&my_mem_args);
  // IDLE
  my_mem_args.data = 0x83;
  my_mem_args.address = 0x05;
  set_mem(&my_mem_args);


  my_mem_args.data = 0x00;
  my_mem_args.address = 0x06;
  set_mem(&my_mem_args);
  memset(&my_mem_args, 0, sizeof(fpga_ram_arg_t));
  for (int i = 0; i < 32; i ++){

     printf("%d: ", i);
     print_mem(i);
  }

  for (int i = 0; i < 32; i ++){

     printf("%d: ", i);
     print_mem(i);
  }
  printf("FPGA RAM Userspace program terminating\n");
  return 0;
}
