/*
 * Userspace program that communicates with the fpga_ram device driver
 * through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */

#include <stdio.h>
#include "fpga_ram.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

#define __BUFF_LEN__ 100

int fpga_ram_fd;

/* Read and print the background color */
void print_mem(unsigned char addr) {
  fpga_ram_arg_t real_vla;
  real_vla.address = addr;
  real_vla.data = 0x04;
//  printf("OUTSIDE: %02x\n" , real_vla.address);
  if (ioctl(fpga_ram_fd, FPGA_RAM_READ, &real_vla)) {
      perror("ioctl(FPGA_RAM_READ) failed");
      return;
  }
  printf("%02x\n",
	real_vla.data);

}

/* Set the background color */
void set_mem(fpga_ram_arg_t *vla)
{
  fpga_ram_arg_t real_vla;
  real_vla.address = vla->address;
  real_vla.data = vla->data;
  //printf("OUTSIDE: %02x\n" , real_vla.data);
  if (ioctl(fpga_ram_fd, FPGA_RAM_WRITE, &real_vla)) {
      perror("ioctl(FPGA_RAM_WRITE) failed");
      return;
  }
}

int main(int argc, char *argv[])
{
  if(argc == 1) {
    fprintf(stderr, "Error: Program requires file name to load\n");
    return -1;
  }
  FILE *prog = fopen(argv[1], "rb");
  if(!prog) {
    perror("Error opening file: ");
    return -1;
  }

  static const char filename[] = "/dev/vga_ball";
  printf("FPGA RAM Userspace program started\n");
  fpga_ram_arg_t my_mem_args;
  my_mem_args.data = 0x07;
  my_mem_args.address = 0x07;

  if ( (fpga_ram_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    fclose(prog);
    return -1;
  }

//  for (int i = 0; i < 32; i ++){
//     my_mem_args.data = 0x00;
//     my_mem_args.address = 0x00 + i;
//     set_mem(&my_mem_args);
//  }

  // PROG:
  // E2 
  // 12 
  // F0
  // 52
  // 00
  
  unsigned char buf[__BUFF_LEN__] = {0};
  size_t rd;
  unsigned char cond = 1;
  while(cond) {
    if( (rd = fread(buf, 1, __BUFF_LEN__, prog)) != __BUFF_LEN__) {
      if(ferror(prog)) {
        fprintf(stderr, "Error reading file, exiting.\n");
        fclose(prog);
        return 1;
      }
      cond = 0;
    }
    for(size_t i = 0; i < rd; ++i) {
      my_mem_args.data = buf[i];
      my_mem_args.address = i;
      set_mem(&my_mem_args);
    }
  }

  for (int i = 0; i < 32; i ++){

     printf("%d: ", i);
     print_mem(i);
  }

  for (int i = 0; i < 32; i ++){

     printf("%d: ", i);
     print_mem(i);
  }
  printf("FPGA RAM Userspace program terminating\n");
  return 0;
}
