// we generate a simple square wave here
module tonegen(
   	input clk,     // 50MHz
	input reset,
	input left_chan_ready,
	input right_chan_ready,
        input  logic [1:0]  audio_choose,               
	output logic [15:0] sample_data,  // output data, to fit the data each time can be transferred 16 bits
	output logic sample_valid
        
);

// our testing sampling rate is 8kHz
logic [2:0] counter1;      // change 48kHz to 8kHz, divide by 6
logic [16:0] bg_address;
logic [15:0] bg_data;
logic [10:0] hit_wall_address;
logic [15:0] hit_wall_data;
logic [11:0] hit_brick_address;
logic [15:0] hit_brick_data;
logic        flag;  
logic        flag2;       



// instantiate the memory for back ground music
bgm bgm0(.address(bg_address),.clock(clk),.q(bg_data));

// instantiate the memory for hit_wall sound
hit_wall hit_wall0(.address(hit_wall_address),.clock(clk),.q(hit_wall_data));

// instantiate the memory for hit_brick sound
hit_brick hit_brick0(.address(hit_brick_address),.clock(clk),.q(hit_brick_data));


// keep playing background music
always_ff @(posedge clk) begin
   if (reset) begin
      counter1 <= 3'b0;
      bg_address <= 0;
      sample_data <= (bg_data );
      sample_valid <= 0;
      flag <= 1'b1;
      flag2<= 1'b1;
      hit_brick_address <= 0;
      hit_wall_address <= 0;
   end else if (counter1 < 3'd6 && (left_chan_ready && right_chan_ready)) begin
      counter1 <= counter1 + 1;
      sample_valid <= 1'b0;
   end else if (counter1 == 3'd6 && (left_chan_ready && right_chan_ready)) begin
      if (audio_choose == 2'b00 && flag == 1'b1 && flag2 == 1'b1) begin
         if (bg_address < 17'd121593) begin
            bg_address <= bg_address + 1;
         end else begin
            bg_address <= 0;
         end
         sample_data <= (bg_data);
      end else if (audio_choose == 2'b01 || flag == 1'b0) begin // if hit the wall
         if (hit_wall_address < 11'd1815 && bg_address < 17'd121593) begin
            hit_wall_address <= hit_wall_address + 1;
            bg_address <= bg_address + 1;
            flag <= 1'b0;
         end else if (bg_address == 17'd121593) begin	
	    bg_address <= 0;
            flag <= 1'b0;
         end else if (hit_wall_address == 11'd1815) begin
            hit_wall_address <= 0;
            flag <= 1'b1;
         end
         sample_data <= (hit_wall_data) + (bg_data); 
      end else if (audio_choose == 2'b10 || flag2 == 1'b0) begin // if hit the brick
         if (hit_brick_address < 12'd2869 && bg_address < 17'd121593) begin
            hit_brick_address <= hit_brick_address + 1;
            bg_address <= bg_address + 1;
            flag2 <= 1'b0;
         end else if (bg_address == 17'd121593) begin	
	    bg_address <= 0;
            flag2 <= 1'b0;
         end else if (hit_brick_address == 12'd2869) begin
            hit_brick_address <= 0;
            flag2 <= 1'b1;
         end
         sample_data <= (hit_brick_data) + (bg_data); 
      end
      counter1 <= 0;
      sample_valid = 1'b1;
   end
end







endmodule
