/*
 * Seven-segment LED emulator
 *
 * Stephen A. Edwards, Columbia University
 */

module VGA_LED_Emulator(
 input logic 	    clk50, reset,
 input logic [7:0]  hex0, hex1, hex2, hex3, hex4, hex5, hex6, hex7,
 //input logic [15:0]  x, //centre of circle coordinates
 //input logic [15:0]  y,
 output logic [7:0] VGA_R, VGA_G, VGA_B,
 output logic 	    VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, VGA_SYNC_n);

/*
 * 640 X 480 VGA timing for a 50 MHz clock: one pixel every other cycle
 * 
 * HCOUNT 1599 0             1279       1599 0
 *             _______________              ________
 * ___________|    Video      |____________|  Video
 * 
 * 
 * |SYNC| BP |<-- HACTIVE -->|FP|SYNC| BP |<-- HACTIVE
 *       _______________________      _____________
 * |____|       VGA_HS          |____|
 */
   // Parameters for hcount
   parameter HACTIVE      = 11'd 1280,
             HFRONT_PORCH = 11'd 32,
             HSYNC        = 11'd 192,
             HBACK_PORCH  = 11'd 96,   
             HTOTAL       = HACTIVE + HFRONT_PORCH + HSYNC + HBACK_PORCH; // 1600
   
   // Parameters for vcount
   parameter VACTIVE      = 10'd 480,
             VFRONT_PORCH = 10'd 10,
             VSYNC        = 10'd 2,
             VBACK_PORCH  = 10'd 33,
             VTOTAL       = VACTIVE + VFRONT_PORCH + VSYNC + VBACK_PORCH; // 525
				 
	// Parameter for vcircle

   logic [10:0]			     hcount; // Horizontal counter
                                             // Hcount[10:1] indicates pixel column (0-639)
   logic 			     endOfLine;
	
	wire pclk;
	assign pclk = clk50*50;
	
	// Moles & Hammer
	logic [9:0] mole1_x,mole2_x,mole3_x,hammer_x; 
	logic [9:0] mole1_y,mole2_y,mole3_y,hammer_y;
	logic [9:0] temp_mole1_x,temp_mole2_x,temp_mole3_x;
	logic [9:0] temp_mole1_y,temp_mole2_y,temp_mole3_y;
	
	logic[75:0][63:0] shape2mem,shape3mem,shape4mem,shape5mem,shape6mem,shape7mem;
	
	logic [6:0] mole1pop=0,mole2pop=0,mole3pop=0;
	
	
	
	//Grass
	logic [7:0][7:0] grassmem;
	logic [29:0][63:0] grass1mem;
	logic [39:0][63:0] grass2mem;
	
	//Stones
	logic [51:0][119:0] stonemem;	
	
	//Mud
	logic [18:0][119:0] mudmem;
	
	
	//Score
	logic [74:0][159:0] scoreboardmem;
	logic [78:0][159:0] scoreboard1mem;
	
	logic [3:0] score0,score1,score2;
	//LEVEL
	logic[15:0][95:0] levelmem;
	logic [3:0]  level0,level1;
	
	//LIVES
	 logic [15:0][63:0] livesmem;
	 
	//SCORE
	logic [15:0][117:0] scoremem;
	
	//TIME
	logic [15:0][101:0] timemem; 
	logic [3:0]  time0,time1;
	//WHAC-A-MOLE
	logic [40:0][63:0] momem;
   logic [40:0][63:0] momem2;
   logic [40:0][63:0] momem3;
   logic [40:0][63:0] momemc;
   logic [40:0][63:0] mmem;
   logic [40:0][63:0] omem;
   logic [40:0][63:0] lmem;
   logic [40:0][63:0] emem;
   logic [15:0][15:0] dash;    
	
	//HAMMER
	logic[96:0][96:0] hammermem, hammer2mem;
	logic[31:0][96:0] hammer3mem;
	
	///NUMBERS
	logic [31:0][31:0] zero;
   logic [31:0][31:0] one;
   logic [31:0][31:0] two;
   logic [31:0][31:0] three;
	logic [31:0][31:0] four;
	logic [31:0][31:0] five;
   logic [31:0][31:0] six;
   logic [31:0][31:0] seven;
   logic [31:0][31:0] eight;
	logic [31:0][31:0] nine;
	
	/*//GEORGE'S HEX DIGIT
	
	logic [9:0] d_l_1_x,d_l_1_y;
	assign d_l_1_y = 30;
	assign d_l_1_x = 15;
	logic d_l_1_a,d_l_1_b,d_l_1_c,d_l_1_d,d_l_1_e,d_l_1_f,d_l_1_g;
	
	assign d_l_1_a = ((hcount[10:1]>=d_l_1_x) & (hcount[10:1]<=d_l_1_x+31) & (vcount>=d_l_1_y) & (vcount<=d_l_1_y+9)) ;  
   assign d_l_1_d = ((hcount[10:1]>=d_l_1_x) & (hcount[10:1]<=d_l_1_x+31) & (vcount>=d_l_1_y+50) & (vcount<=d_l_1_y+59)) ;
	assign d_l_1_g = ((hcount[10:1]>=d_l_1_x) & (hcount[10:1]<=d_l_1_x+31) & (vcount>=d_l_1_y+25) & (vcount<=d_l_1_y+34)) ;
	assign d_l_1_b = ((hcount[10:1]>=d_l_1_x+22) & (hcount[10:1]<=d_l_1_x+31) & (vcount>=d_l_1_y) & (vcount<=d_l_1_y+39)) ;
	assign d_l_1_c = ((hcount[10:1]>=d_l_1_x+22) & (hcount[10:1]<=d_l_1_x+31) & (vcount>=d_l_1_y+25) & (vcount<=d_l_1_y+59)) ;
   assign d_l_1_f = ((hcount[10:1]>=d_l_1_x) & (hcount[10:1]<=d_l_1_x+9) & (vcount>=d_l_1_y) & (vcount<=d_l_1_y+39)) ;
   assign d_l_1_e = ((hcount[10:1]>=d_l_1_x) & (hcount[10:1]<=d_l_1_x+9) & (vcount>=d_l_1_y+25) & (vcount<=d_l_1_y+59)) ;*/
	
	//ROCKS
	//logic[19:0][19:0] rockmem,rockmem2;
	
	
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          hcount <= 0;
     else if (endOfLine) hcount <= 0;
     else  	         hcount <= hcount + 11'd 1;

   assign endOfLine = hcount == HTOTAL - 1;

   // Vertical counter
   logic [9:0] 			     vcount;
   logic 			     endOfField;
	
   
   always_ff @(posedge clk50 or posedge reset)
     if (reset)          vcount <= 0;
     else if (endOfLine)
       if (endOfField)   vcount <= 0;
       else              vcount <= vcount + 10'd 1;

   assign endOfField = vcount == VTOTAL - 1;
	

always_ff @(posedge endOfField)begin
	 if (hex0[3:0]!=0)
	   if (mole1pop!=59) mole1pop<=mole1pop+1;
	   else mole1pop<=59;
    else if (mole1pop!=0) mole1pop<=mole1pop-1;
	      else mole1pop<=0;
			
			if (hex0[3:0]!=0) begin
				temp_mole1_x<=mole1_x;
            temp_mole1_y<=mole1_y;
				end
				
   if (hex0[7:4]!=0)
	  if (mole2pop!=59) mole2pop<=mole2pop+1;
	  else mole2pop<=59;
   else if (mole2pop!=0) mole2pop<=mole2pop-1;
	      else mole2pop<=0;	 	
	
	     if (hex0[7:4]!=0) begin
				temp_mole2_x<=mole2_x;
				temp_mole2_y<=mole2_y;
				end
	
	
	 if (hex1[3:0]!=0)
	  if (mole3pop!=59) mole3pop<=mole3pop+1;
	  else mole3pop<=59;
    else if (mole3pop!=0) mole3pop<=mole3pop-1;
	      else mole3pop<=0;	

        if (hex1[3:0]!=0) begin 
				temp_mole3_x<=mole3_x;
            temp_mole3_y<=mole3_y;
        end				
		
   end	

   // Horizontal sync: from 0x520 to 0x5DF (0x57F)
   // 101 0010 0000 to 101 1101 1111
   assign VGA_HS = !( (hcount[10:8] == 3'b101) & !(hcount[7:5] == 3'b111));
   assign VGA_VS = !( vcount[9:1] == (VACTIVE + VFRONT_PORCH) / 2);

   assign VGA_SYNC_n = 1; // For adding sync to video signals; not used for VGA
   
   // Horizontal active: 0 to 1279     Vertical active: 0 to 479
   // 101 0000 0000  1280	       01 1110 0000  480
   // 110 0011 1111  1599	       10 0000 1100  524
   assign VGA_BLANK_n = !( hcount[10] & (hcount[9] | hcount[8]) ) &
			!( vcount[9] | (vcount[8:5] == 4'b1111) );  

   /* VGA_CLK is 25 MHz
    *             __    __    __
    * clk50    __|  |__|  |__|
    *        
    *             _____       __
    * hcount[0]__|     |_____|
    */
   assign VGA_CLK = hcount[0]; // 25 MHz clock: pixel latched on rising edge
	
	
	// this is bagri trying some cool shit
	
	always_comb begin
			 
			 shape2mem[0] = 64'b0000000000000000000000000000111111100000000000000000000000000000;
			 shape2mem[1] = 64'b0000000000000000000001111111111111111111111000000000000000000000;
			 shape2mem[2] = 64'b0000000000000001111111111111111111111111111111111000000000000000;
			 shape2mem[3] = 64'b0000000000111111111111111111111111111111111111111111110000000000;
			 shape2mem[4] = 64'b0000001111111111111111111111111111111111111111111111111111000000;
			 shape2mem[5] = 64'b0001111111111111111111111111111111111111111111111111111111111000;
			 shape2mem[6] = 64'b0111111111111111111111111111111111111111111111111111111111111110;
			 shape2mem[7] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
		    shape2mem[8] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			 shape2mem[9] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[10] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[11] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[12] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[13] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[14] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[15] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[16] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
		   shape2mem[17] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[18] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[19] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[20] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[21] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[22] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[23] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[24] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[25] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[26] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[27] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[28] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[29] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[30] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[31] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[32] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[33] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[34] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[35] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[36] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[37] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[38] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
		   shape2mem[39] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[40] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[41] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[42] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[43] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[44] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[45] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[46] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[47] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[48] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[49] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[50] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[51] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[52] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[53] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[54] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[55] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[56] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[57] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[58] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[59] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[60] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[61] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[62] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[63] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[64] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[65] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[66] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[67] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[68] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape2mem[69] = 64'b0001111111111111111111111111111111111111111111111111111111111000;
			shape2mem[70] = 64'b0000001111111111111111111111111111111111111111111111111111000000;
			shape2mem[71] = 64'b0000000001111111111111111111111111111111111111111111111000000000;
			shape2mem[72] = 64'b0000000000001111111111111111111111111111111111111110000000000000;
			shape2mem[73] = 64'b0000000000000001111111111111111111111111111111110000000000000000;
			shape2mem[74] = 64'b0000000000000000001111111111111111111111111110000000000000000000;
			shape2mem[75] = 64'b0000000000000000000001111111111111111111110000000000000000000000;
			
			//GLASSES
			 shape3mem[0] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			 shape3mem[1] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			 shape3mem[2] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			 shape3mem[3] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			 shape3mem[4] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			 shape3mem[5] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			 shape3mem[6] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			 shape3mem[7] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			 shape3mem[8] = 64'b1111111100000000000111111111111111111111111000000000001111111111;
			 shape3mem[9] = 64'b1111100000000000000000111111111111111111000000000000000001111111;
			shape3mem[10] = 64'b1110000000000000000000001111111111111100000000000000000000011111;
			shape3mem[11] = 64'b1110000000011111110000000111111111111000000001111111110000000111;
			shape3mem[12] = 64'b1100000001111111111100000011111111110000000111111111111000000011;
			shape3mem[13] = 64'b1000000011111111111110000001111111100000011111111111111100000001;
			shape3mem[14] = 64'b1000000111111111111110000000000000000000111111111111111110000000;
			shape3mem[15] = 64'b0000001111111111111111000000000000000111111111111111111110000000;
			shape3mem[16] = 64'b0000000111111111111111100000000000011111111111111111111100000000;
			shape3mem[17] = 64'b0000000111111111111111110000000000011111111111111111111100000000;
		   shape3mem[18] = 64'b1000000011111111111111110000000000011111111111111111111000000001;
			shape3mem[19] = 64'b1000000011111111111111110000000000011111111111111111111000000001;
			shape3mem[20] = 64'b1100000001111111111111100000000000111111111111111111100000000011;
			shape3mem[21] = 64'b1110000000111111111110000000000000001111111111111100000000000111;
			shape3mem[22] = 64'b1111000000000000000000000000110000000000000000000000000000001111;
			shape3mem[23] = 64'b1111100000000000000000000011111111000000000000000000001111111111;
			shape3mem[24] = 64'b1111111111110000000001111111111111111100000000001111111111111111;
			shape3mem[25] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[26] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[27] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[28] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[29] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[30] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[31] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[32] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[33] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[34] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[35] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[36] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[37] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[38] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
		   shape3mem[39] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[40] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[41] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[42] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[43] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[44] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[45] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[46] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[47] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[48] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[49] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[50] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[51] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[52] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[53] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[54] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[55] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[56] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[57] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[58] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[59] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[60] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[61] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[62] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[63] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[64] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[65] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[66] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[67] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[68] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[69] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[70] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[71] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[72] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[73] = 64'b1111111111111111111111111111111111111111111111011111111111111111;
			shape3mem[74] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			shape3mem[75] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
			
			//WHITE OF THE EYES
			shape4mem[0] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[1] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[2] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[3] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[4] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[5] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[6] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[7] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[8] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[9] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[10] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[11] = 64'b0000000000011111110000000000000000000000000001111111110000000000;
			shape4mem[12] = 64'b0000000001111111111100000000000000000000000111111111111000000000;
			shape4mem[13] = 64'b0000000011111111111110000000000000000000011111111111111100000000;
			shape4mem[14] = 64'b0000000111111111111110000000000000000000111111111111111110000000;
			shape4mem[15] = 64'b0000001111111111111111000000000000000111111111111111111110000000;
			shape4mem[16] = 64'b0000000111111111111111100000000000011111111111111111111100000000;
			shape4mem[17] = 64'b0000000111111111000000010000000000000000011111111111111100000000;
		   shape4mem[18] = 64'b0000000011111110000000000000000000000000000111111111111000000000;
			shape4mem[19] = 64'b0000000011111000000000000000000000000000000011111111111000000000;
			shape4mem[20] = 64'b0000000001111100000000000000000000000000000111111111100000000000;
			shape4mem[21] = 64'b0000000000111111000000000000000000000000011111111100000000000000;
			shape4mem[22] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[23] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[24] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[25] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[26] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[27] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[28] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[29] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[30] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[31] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[32] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[33] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[34] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[35] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[36] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[37] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[38] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[39] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[40] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[41] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[42] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[43] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[44] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[45] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[46] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[47] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[48] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[49] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[50] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[51] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[52] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[53] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[54] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[55] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[56] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[57] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[58] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[59] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[60] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[61] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[62] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[63] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[64] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[65] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[66] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[67] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[68] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[69] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[70] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[71] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[72] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[73] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[74] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape4mem[75] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			
			//NOSE
			 shape5mem[0] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape5mem[1] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape5mem[2] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape5mem[3] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape5mem[4] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape5mem[5] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape5mem[6] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape5mem[7] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape5mem[8] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape5mem[9] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[10] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[11] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[12] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[13] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[14] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[15] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[16] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[17] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[18] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[19] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[20] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[21] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[22] = 64'b0000000000000000000000000001111000000000000000000000000000000000;
			shape5mem[23] = 64'b0000000000000000000000001111111111100000000000000000000000000000;
			shape5mem[24] = 64'b0000000000000000000001111111111111111100000000000000000000000000;
			shape5mem[25] = 64'b0000000000000000000011111111111111111110000000000000000000000000;
			shape5mem[26] = 64'b0000000000000000000011111111111111111110000000000000000000000000;
			shape5mem[27] = 64'b0000000000000000000000111111111111110000000000000000000000000000;
			shape5mem[28] = 64'b0000000000000000000000001111111111000000000000000000000000000000;
			shape5mem[29] = 64'b0000000000000000000000000111111110000000000000000000000000000000;
			shape5mem[30] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[31] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[32] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[33] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[34] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[35] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[36] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[37] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[38] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[39] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[40] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[41] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[42] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[43] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[44] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[45] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[46] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[47] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[48] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[49] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[50] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[51] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[52] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[53] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[54] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[55] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[56] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[57] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[58] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[59] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[60] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[61] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[62] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[63] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[64] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[65] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[66] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[67] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[68] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[69] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[70] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[71] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[72] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[73] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[74] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape5mem[75] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			
			//EYES
			
		 	 shape6mem[0] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape6mem[1] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape6mem[2] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape6mem[3] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape6mem[4] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape6mem[5] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape6mem[6] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape6mem[7] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape6mem[8] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape6mem[9] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[10] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[11] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[12] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[13] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[14] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[15] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[16] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[17] = 64'b0000000000000000111111100000000000111111100000000000000000000000;
		   shape6mem[18] = 64'b0000000000000001111111110000000000111111111000000000000000000000;
			shape6mem[19] = 64'b0000000000000111111111110000000001111111111100000000000000000000;
			shape6mem[20] = 64'b0000000000000011111111100000000000111111111000000000000000000000;
			shape6mem[21] = 64'b0000000000000000111110000000000000001111100000000000000000000000;
			shape6mem[22] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[23] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[24] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[25] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[26] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[27] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[28] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[29] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[30] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[31] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[32] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[33] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[34] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[35] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[36] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[37] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[38] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[39] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[40] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[41] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[42] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[43] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[44] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[45] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[46] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[47] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[48] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[49] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[50] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[51] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[52] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[53] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[54] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[55] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[56] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[57] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[58] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[59] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[60] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[61] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[62] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[63] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[64] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[65] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[66] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[67] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[68] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[69] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[70] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[71] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[72] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[73] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[74] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape6mem[75] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			
		   //TEETH
			
			 shape7mem[0] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape7mem[1] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape7mem[2] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape7mem[3] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape7mem[4] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape7mem[5] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape7mem[6] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape7mem[7] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape7mem[8] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			 shape7mem[9] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[10] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[11] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[12] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[13] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[14] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[15] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[16] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[17] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[18] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[19] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[20] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[21] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[22] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[23] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[24] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[25] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[26] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[27] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[28] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[29] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[30] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[31] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[32] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[33] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[34] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[35] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[36] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[37] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[38] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
		   shape7mem[39] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[40] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[41] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[42] = 64'b0000000000011111111111111111111001111111111111111111100000000000;
			shape7mem[43] = 64'b0000000000001111111111111111110000111111111111111111000000000000;
			shape7mem[44] = 64'b0000000000000111111111111111100000011111111111111110000000000000;
			shape7mem[45] = 64'b0000000000000011111111111111000000001111111111111100000000000000;
			shape7mem[46] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[47] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[48] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[49] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[50] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[51] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[52] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[53] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[54] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[55] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[56] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[57] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[58] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[59] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[60] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[61] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[62] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[63] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[64] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[65] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[66] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[67] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[68] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[69] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[70] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[71] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[72] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[73] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[74] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			shape7mem[75] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
			
			//LEVEL
				
				 levelmem[0] = 96'b111111000000000011111111111110001111110000000000100011111111111110001111110000000000000000000000;
            levelmem[1] = 96'b111111000000000011111100000000001111110000000000100011111100000000001111110000000000000000000000;
            levelmem[2] = 96'b111111000000000011111100000000000111111000000001000011111100000000001111110000000000000000000000;
            levelmem[3] = 96'b111111000000000011111100000000000111111000000001000011111100000000001111110000000000000000000000;
            levelmem[4] = 96'b111111000000000011111100000000000011111100000010000011111100000000001111110000000000000000000000;
            levelmem[5] = 96'b111111000000000011111111111110000011111100000010000011111111111110001111110000000000000000000000;
            levelmem[6] = 96'b111111000000000011111100000000000001111110000100000011111100000000001111110000000000000000000000;
            levelmem[7] = 96'b111111000000000011111100000000000001111110000100000011111100000000001111110000000000000000000000;
            levelmem[8] = 96'b111111000000000011111100000000000000111111001000000011111100000000001111110000000000000000000000;
            levelmem[9] = 96'b111111000000000011111100000000000000111111001000000011111100000000001111110000000000000000000000;
           levelmem[10] = 96'b111111000000000011111100000000000000011111110000000011111100000000001111110000000000000000000000;
           levelmem[11] = 96'b111111000000000011111100000000000000011111110000000011111100000000001111110000000000000000000000;
           levelmem[12] = 96'b111111000000000011111100000000000000001111100000000011111100000000001111110000000000000000000000;
           levelmem[13] = 96'b111111000000000011111100000000000000001111100000000011111100000000001111110000000000000000000000;
           levelmem[14] = 96'b111111000000000011111100000000000000000111000000000011111100000000001111110000000000000000000000;
           levelmem[15] = 96'b111111111111100011111111111110000000000111000000000011111111111110001111111111111000000000000000;
			
					 
			//SCORE
					 
					 
					 scoremem[0] = 118'b0000000000011100000000000000000000111000000000000000000000001110000000000000000111111111110000000000000111111111111111;
					 scoremem[1] = 118'b0000000011100011100000000000000111000111000000000000000111111100011100000000000111111110000011100000000111111111111111;
					 scoremem[2] = 118'b0000011111000000011100000000111000000000111000000001111111111100000001110000000111111110000000000111000111111110000000;
					 scoremem[3] = 118'b0011111111000000000000000111110000000000000000001111111111111100000000001110000111111110000000000011100111111110000000;
					 scoremem[4] = 118'b1111111111110000000000001111110000000000000000001111111111111100000000001110000111111110000000000011100111111110000000;
				    scoremem[5] = 118'b1111111111111000000000011111110000000000000000011111111111111100000000000111000111111110000000000011100111111110000000;
					 scoremem[6] = 118'b0011111111111100000000111111110000000000000000011111111111111100000000000111000111111110000000000111000111111110000000;
					 scoremem[7] = 118'b0001111111111110000000111111110000000000000000111111111111111100000000000011100111111110000011100000000111111111110000;
					 scoremem[8] = 118'b0000011111111111000000111111110000000000000000111111111111111100000000000011100111111111110000000000000111111111110000;
					 scoremem[9] = 118'b0000001111111111111000011111110000000000000000011111111111111100000000000111000111111110111000000000000111111110000000;
					 scoremem[10] = 118'b0000000011111111111100001111110000000000000000011111111111111100000000000111000111111110001110000000000111111110000000;
					 scoremem[11] = 118'b0000000001111111111000000111110000000000000000001111111111111100000000001110000111111110000011100000000111111110000000;
					 scoremem[12] = 118'b0000000000111111110000000001110000000000000000001111111111111100000000001110000111111110000001110000000111111110000000;
					 scoremem[13] = 118'b0000000000011110000000000000011100000000011100000001111111111100000001110000000111111110000000011100000111111110000000;
					 scoremem[14] = 118'b1110000111000000000000000000000001110011100000000000000111111100011100000000000111111110000000000111000111111111111111;
				    scoremem[15] = 118'b0001110000000000000000000000000000001110000000000000000000001110000000000000000111111110000000000011100111111111111111;

			
			//TIME
					 
					 timemem[0] = 102'b111111111111111111111000111111111110000000000111111000000000000000001111110000000000111111111111111110;
				    timemem[1] = 102'b111111111111111111111000111111111110000000000111111100000000000000011111110000000000111111111111111110;
				    timemem[2] = 102'b000001111111111100000000111111111110000000001111111110000000000000111111111000000000111111111110000000;
					 timemem[3] = 102'b000001111111111100000000111111111110000000001111111111000000000001111111111000000000111111111110000000;
					 timemem[4] = 102'b000001111111111100000000111111111110000000011111111111100000000011111111111100000000111111111110000000;
					 timemem[5] = 102'b000001111111111100000000111111111110000000011111111111111000001111111111111100000000111111111110000000;
					 timemem[6] = 102'b000001111111111100000000111111111110000000111001111111111110111000111111111110000000111111111110000000;
					 timemem[7] = 102'b000001111111111100000000111111111110000000111000111111111111100000111111111110000000111111111111110000;
					 timemem[8] = 102'b000001111111111100000000111111111110000001110000011111111111000000011111111111000000111111111111110000;
					 timemem[9] = 102'b000001111111111100000000111111111110000001110000001111111110000000011111111111000000111111111110000000;
					 timemem[10] = 102'b000001111111111100000000111111111110000011100000000111111100000000001111111111100000111111111110000000;
					 timemem[11] = 102'b000001111111111100000000111111111110000011100000000011111000000000000111111111100000111111111110000000;
					 timemem[12] = 102'b000001111111111100000000111111111110000111000000000001100000000000000111111111110000111111111110000000;
					 timemem[13] = 102'b000001111111111100000000111111111110000111000000000000000000000000000011111111110000111111111110000000;
					 timemem[14] = 102'b000001111111111100000000111111111110001110000000000000000000000000000011111111111000111111111111111110;
					 timemem[15] = 102'b000001111111111100000000111111111110001110000000000000000000000000000001111111111000111111111111111110;


					 
			//WHAC-A-MOLE
					 
			 momem[0] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[1] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[2] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[3] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[4] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[5] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[6] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[7] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[8] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[9] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[10] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[11] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[12] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[13] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[14] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[15] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[16] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[17] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
            momem[18] = 64'b1111100000000000000000000001111111111000000000000000000000011111;
            momem[19] = 64'b1111100000000000000000000011111001111100000000000000000000011111;
            momem[20] = 64'b1111100000000000000000000111110000111110000000000000000000011111;
            momem[21] = 64'b1111100000000000000000001111100000011111000000000000000000011111;
            momem[22] = 64'b1111100000000000000000011111000000001111100000000000000000011111;
            momem[23] = 64'b1111100000000000000000111110000000001111100000000000000000011111;
            momem[24] = 64'b1111100000000000000001111100000000000011111000000000000000011111;
            momem[25] = 64'b1111100000000000000011111000000000000001111100000000000000011111;
            momem[26] = 64'b1111100000000000000111110000000000000000111110000000000000011111;
            momem[27] = 64'b1111100000000000001111100000000000000000011111000000000000011111;
            momem[28] = 64'b1111100000000000011111000000000000000000001111100000000000011111;
            momem[29] = 64'b1111100000000000111110000000000000000000000111110000000000011111;
            momem[30] = 64'b1111100000000001111100000000000000000000000011111000000000011111;
            momem[31] = 64'b1111100000000011111000000000000000000000000001111100000000011111;
            momem[32] = 64'b1111100000000111110000000000000000000000000000111110000000011111;
            momem[33] = 64'b1111100000001111100000000000000000000000000000011111000000011111;
            momem[34] = 64'b1111100000011111000000000000000000000000000000001111100000011111;
            momem[35] = 64'b1111100000111110000000000000000000000000000000000111110000011111;
            momem[36] = 64'b1111100001111100000000000000000000000000000000000011111000011111;
            momem[37] = 64'b1111100011111000000000000000000000000000000000000001111100011111;
            momem[38] = 64'b1111100111110000000000000000000000000000000000000000111110011111;
            momem[39] = 64'b1111101111100000000000000000000000000000000000000000011111011111;
            momem[40] = 64'b1111111111000000000000000000000000000000000000000000001111111111;
               
                momem2[0] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[1] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[2] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[3] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[4] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[5] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[6] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[7] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[8] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[9] =  64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[10] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[11] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[12] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[13] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[14] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[15] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[16] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[17] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[18] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[19] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem2[20] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem2[21] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem2[22] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem2[23] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem2[24] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[25] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[26] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[27] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[28] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[29] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[30] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[31] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[32] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[33] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[34] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[35] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[36] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[37] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[38] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[39] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem2[40] = 64'b1111100000000000000000000000000000000000000000000000000000011111;

                momem3[0] =64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem3[1] =64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem3[2] =64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem3[3] =64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem3[4] =64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem3[5] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[6] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[7] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[8] =64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[9] =  64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[10] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[11] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[12] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[13] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[14] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[15] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[16] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[17] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[18] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[19] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem3[20] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem3[21] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem3[22] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem3[23] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momem3[24] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[25] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[26] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[27] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[28] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[29] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[30] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[31] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[32] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[33] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[34] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[35] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[36] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[37] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[38] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[39] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
                momem3[40] = 64'b1111100000000000000000000000000000000000000000000000000000011111;

                momemc[0] =64'b1111111111111111111111111111111111111111111111111111111111111111;
                momemc[1] =64'b1111111111111111111111111111111111111111111111111111111111111111;
                momemc[2] =64'b1111111111111111111111111111111111111111111111111111111111111111;
                momemc[3] =64'b1111111111111111111111111111111111111111111111111111111111111111;
                momemc[4] =64'b1111111111111111111111111111111111111111111111111111111111111111;
                momemc[5] =64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[6] =64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[7] =64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[8] =64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[9] =  64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[10] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[11] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[12] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[13] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[14] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[15] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[16] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[17] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[18] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[19] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[20] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[21] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[22] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[23] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[24] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[25] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[26] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[27] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[28] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[29] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[30] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[31] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[32] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[33] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[34] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[35] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
                momemc[36] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momemc[37] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momemc[38] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momemc[39] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
                momemc[40] = 64'b1111111111111111111111111111111111111111111111111111111111111111;

					 mmem[0] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
					 mmem[1] = 64'b1111110000000000000000000000000000000000000000000000000000111111;
					 mmem[2] = 64'b1111111000000000000000000000000000000000000000000000000001111111;
					 mmem[3] = 64'b1111111100000000000000000000000000000000000000000000000011111111;

					mmem[4] = 64'b1111111110000000000000000000000000000000000000000000000111111111;

					mmem[5] = 64'b1111111111000000000000000000000000000000000000000000001111111111;

					mmem[6] = 64'b1111101111100000000000000000000000000000000000000000011111011111;

  mmem[7] = 64'b1111100111110000000000000000000000000000000000000000111110011111;
  mmem[8] = 64'b1111100011111000000000000000000000000000000000000001111100011111;
  mmem[9] = 64'b1111100001111100000000000000000000000000000000000011111000011111;
mmem[10] = 64'b1111100000011111000000000000000000000000000000001111100000011111;
mmem[11] = 64'b1111100000001111110000000000000000000000000000111111000000011111;
mmem[12] = 64'b1111100000000011111100000000000000000000000011111100000000011111;
mmem[13] = 64'b1111100000000000111111000000000000000000001111110000000000011111;
mmem[14] = 64'b1111100000000000001111110000000000000000111111000000000000011111;
mmem[15] = 64'b1111100000000000000011111100000000000011111100000000000000011111;
mmem[16] = 64'b1111100000000000000000111111000000001111110000000000000000011111;
mmem[17] = 64'b1111100000000000000000001111110000111111000000000000000000011111;
mmem[18] = 64'b1111100000000000000000000011111111111100000000000000000000011111;
mmem[19] = 64'b1111100000000000000000000001111111111000000000000000000000011111;
mmem[20] = 64'b1111100000000000000000000001111111111000000000000000000000011111;
mmem[21] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[22] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[23] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[24] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[25] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[26] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[27] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[28] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[29] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[30] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[31] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[32] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[33] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[34] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[35] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[36] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[37] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[38] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[39] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
mmem[40] = 64'b1111100000000000000000000000000000000000000000000000000000011111;

omem[0] = 64'b0000000000000000000000000001111111111000000000000000000000000000;
  omem[1] = 64'b0000000000000000000000011111111111111111100000000000000000000000;
  omem[2] = 64'b0000000000000000000111111111111111111111111110000000000000000000;
  omem[3] = 64'b0000000000000001111111110000000000000000111111111000000000000000;
  omem[4] = 64'b0000000000000111111110000000000000000000000111111110000000000000;
  omem[5] = 64'b0000000000011111110000000000000000000000000000111111100000000000;
  omem[6] = 64'b0000000001111110000000000000000000000000000000000111111000000000;
  omem[7] = 64'b0000000111111000000000000000000000000000000000000001111110000000;
  omem[8] = 64'b0000001111100000000000000000000000000000000000000000011111000000;
  omem[9] = 64'b0000011111000000000000000000000000000000000000000000001111100000;
omem[10] = 64'b0000111110000000000000000000000000000000000000000000000111110000;
omem[11] = 64'b0001111100000000000000000000000000000000000000000000000011111000;
omem[12] = 64'b0011111000000000000000000000000000000000000000000000000001111100;
omem[13] = 64'b0011111000000000000000000000000000000000000000000000000001111100;
omem[14] = 64'b0011111000000000000000000000000000000000000000000000000001111100;
omem[15] = 64'b0011111000000000000000000000000000000000000000000000000001111100;
omem[16] = 64'b0111110000000000000000000000000000000000000000000000000000111110;
omem[17] = 64'b0111110000000000000000000000000000000000000000000000000000111110;
omem[18] = 64'b0111110000000000000000000000000000000000000000000000000000111110;
omem[19] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
omem[20] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
omem[21] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
omem[22] = 64'b1111100000000000000000000000000000000000000000000000000000011111;
omem[23] = 64'b0111110000000000000000000000000000000000000000000000000000111110;
omem[24] = 64'b0111110000000000000000000000000000000000000000000000000000111110;
omem[25] = 64'b0111110000000000000000000000000000000000000000000000000000111110;
omem[26] = 64'b0011111000000000000000000000000000000000000000000000000001111100;
omem[27] = 64'b0011111000000000000000000000000000000000000000000000000001111100;
omem[28] = 64'b0011111000000000000000000000000000000000000000000000000001111100;
omem[29] = 64'b0001111100000000000000000000000000000000000000000000000011111000;
omem[30] = 64'b0000111110000000000000000000000000000000000000000000000111110000;
omem[31] = 64'b0000011111000000000000000000000000000000000000000000001111100000;
omem[32] = 64'b0000001111100000000000000000000000000000000000000000011111000000;
omem[33] = 64'b0000000111111000000000000000000000000000000000000001111110000000;
omem[34] = 64'b0000000001111110000000000000000000000000000000000111111000000000;
omem[35] = 64'b0000000000011111110000000000000000000000000000111111100000000000;
omem[36] = 64'b0000000000000111111110000000000000000000000111111110000000000000;
omem[37] = 64'b0000000000000001111111110000000000000000111111111000000000000000;
omem[38] = 64'b0000000000000000000111111111111111111111111110000000000000000000;
omem[39] = 64'b0000000000000000000000011111111111111111100000000000000000000000;
omem[40] = 64'b0000000000000000000000000001111111111000000000000000000000000000;

lmem[0] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  lmem[1] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  lmem[2] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  lmem[3] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  lmem[4] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  lmem[5] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  lmem[6] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  lmem[7] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  lmem[8] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  lmem[9] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[10] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[11] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[12] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[13] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[14] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[15] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[16] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[17] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[18] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[19] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[20] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[21] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[22] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[23] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[24] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[25] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[26] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[27] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[28] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[29] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[30] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[31] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[32] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[33] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[34] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[35] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
lmem[36] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
lmem[37] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
lmem[38] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
lmem[39] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
lmem[40] = 64'b1111111111111111111111111111111111111111111111111111111111111111;



  emem[0] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
  emem[1] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
  emem[2] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
  emem[3] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
  emem[4] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
  emem[5] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  emem[6] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  emem[7] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  emem[8] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
  emem[9] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[10] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[11] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[12] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[13] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[14] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[15] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[16] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[17] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[18] = 64'b1111111111111111111111111111111111100000000000000000000000000000;
emem[19] = 64'b1111111111111111111111111111111111100000000000000000000000000000;
emem[20] = 64'b1111111111111111111111111111111111100000000000000000000000000000;
emem[21] = 64'b1111111111111111111111111111111111100000000000000000000000000000;
emem[22] = 64'b1111111111111111111111111111111111100000000000000000000000000000;
emem[23] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[24] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[25] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[26] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[27] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[28] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[29] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[30] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[31] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[32] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[33] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[34] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[35] = 64'b1111100000000000000000000000000000000000000000000000000000000000;
emem[36] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
emem[37] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
emem[38] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
emem[39] = 64'b1111111111111111111111111111111111111111111111111111111111111111;
emem[40] = 64'b1111111111111111111111111111111111111111111111111111111111111111;

dash[0]= 16'b0000000000000000;
dash[1]= 16'b0000000000000000;
dash[2]= 16'b0000000000000000;
dash[3]= 16'b1111111111111111;
dash[4]= 16'b1111111111111111;
dash[5]= 16'b1111111111111111;
dash[6]= 16'b1111111111111111;
dash[7]= 16'b1111111111111111;
dash[8]= 16'b1111111111111111;
dash[9]= 16'b1111111111111111;
dash[10]=16'b1111111111111111;
dash[11]=16'b1111111111111111;
dash[12]=16'b1111111111111111;
dash[13]=16'b0000000000000000;
dash[14]=16'b0000000000000000;
dash[15]=16'b0000000000000000;
			
	//HAMMER
 hammermem[0] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammermem[1] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;				
 hammermem[2] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammermem[3] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammermem[4] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammermem[5] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;				
 hammermem[6] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammermem[7] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammermem[8] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammermem[9] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;				
hammermem[10] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammermem[11] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammermem[12] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammermem[13] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;				
hammermem[14] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammermem[15] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammermem[16] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammermem[17] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;				
hammermem[18] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammermem[19] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammermem[20] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammermem[21] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;				
hammermem[22] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammermem[23] = 96'b000000000000000000000000000000000000000000000000000000000000000000000111111111111000000000000000;
hammermem[24] = 96'b000000000000000000000000000000000000000000000000000000000000000001111111111111111111110000000000;
hammermem[25] = 96'b000000000000000000000000000000000000000000000000000000000001111111111111111111111111111110000000;				
hammermem[26] = 96'b000000000000000000000000000000000000000000000000000000011111111111111111111111111111111111110000;
hammermem[27] = 96'b000000000000000000000000000000000000000000000000000111111111111111111111111111111111111111111100;
hammermem[28] = 96'b000000000000000000000000000000000000000000000001111111111111111111111111111111111111111111111100;
hammermem[29] = 96'b000000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111110;				
hammermem[30] = 96'b000000000000000000000000000000000000000111111111111111111111111111111111111111111111111111111110;
hammermem[31] = 96'b000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111110;	
hammermem[32] = 96'b000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111;
hammermem[33] = 96'b000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111;				
hammermem[34] = 96'b000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111111111;
hammermem[35] = 96'b000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111;
hammermem[36] = 96'b000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111;
hammermem[37] = 96'b000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111110;				
hammermem[38] = 96'b000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111100;
hammermem[39] = 96'b000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100;
hammermem[40] = 96'b000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000;
hammermem[41] = 96'b000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000;				
hammermem[42] = 96'b001111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000;
hammermem[43] = 96'b011111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000;
hammermem[44] = 96'b111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000;
hammermem[45] = 96'b111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;				
hammermem[46] = 96'b111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000;
hammermem[47] = 96'b111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000;
hammermem[48] = 96'b111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000;
hammermem[49] = 96'b111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000;				
hammermem[50] = 96'b111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000;
hammermem[51] = 96'b111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000;
hammermem[52] = 96'b011111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000;
hammermem[53] = 96'b011111111111111111111111111111111111111111111111111011111111110000000000000000000000000000000000;				
hammermem[54] = 96'b001111111111111111111111111111111111111111111110000000011111111110000000000000000000000000000000;
hammermem[55] = 96'b000011111111111111111111111111111111111111110000000000011111111110000000000000000000000000000000;
hammermem[56] = 96'b000001111111111111111111111111111111111110000000000000001111111111000000000000000000000000000000;
hammermem[57] = 96'b000000011111111111111111111111111111110000000000000000001111111111000000000000000000000000000000;				
hammermem[58] = 96'b000000001111111111111111111111111110000000000000000000000011111111110000000000000000000000000000;
hammermem[59] = 96'b000000000001111111111111111111110000000000000000000000000001111111111000000000000000000000000000;
hammermem[60] = 96'b000000000000000011111111111000000000000000000000000000000001111111111000000000000000000000000000;
hammermem[61] = 96'b000000000000000000000000000000000000000000000000000000000000111111111100000000000000000000000000;				
hammermem[62] = 96'b000000000000000000000000000000000000000000000000000000000000001111111111000000000000000000000000;
hammermem[63] = 96'b000000000000000000000000000000000000000000000000000000000000000111111111100000000000000000000000;	
hammermem[64] = 96'b000000000000000000000000000000000000000000000000000000000000000011111111110000000000000000000000;
hammermem[65] = 96'b000000000000000000000000000000000000000000000000000000000000000001111111111000000000000000000000;				
hammermem[66] = 96'b000000000000000000000000000000000000000000000000000000000000000000111111111100000000000000000000;
hammermem[67] = 96'b000000000000000000000000000000000000000000000000000000000000000000011111111110000000000000000000;
hammermem[68] = 96'b000000000000000000000000000000000000000000000000000000000000000000001111111111000000000000000000;
hammermem[69] = 96'b000000000000000000000000000000000000000000000000000000000000000000000111111111100000000000000000;				
hammermem[70] = 96'b000000000000000000000000000000000000000000000000000000000000000000000011111111110000000000000000;
hammermem[71] = 96'b000000000000000000000000000000000000000000000000000000000000000000000001111111111000000000000000;
hammermem[72] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000111111111100000000000000;
hammermem[73] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000011111111110000000000000;				
hammermem[74] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000001111111111000000000000;
hammermem[75] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000111111111100000000000;
hammermem[76] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000011111111110000000000;
hammermem[77] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000001111111111000000000;				
hammermem[78] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100000000;
hammermem[79] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000011111111110000000;
hammermem[80] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111000000;
hammermem[81] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100000;				
hammermem[82] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111110000;
hammermem[83] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111000;
hammermem[84] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100;
hammermem[85] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111110;				
hammermem[86] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111;
hammermem[87] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111;
hammermem[88] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111;
hammermem[89] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111;				
hammermem[90] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111;
hammermem[91] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111;
hammermem[92] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110;
hammermem[93] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;				
hammermem[94] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammermem[95] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

 hammer2mem[0] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammer2mem[1] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammer2mem[2] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammer2mem[3] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammer2mem[4] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammer2mem[5] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammer2mem[6] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammer2mem[7] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammer2mem[8] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 hammer2mem[9] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[10] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[11] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[12] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[13] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[14] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[15] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[16] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[17] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[18] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[19] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[20] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[21] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[22] = 96'b000000000000000000000000000000000000000000000000000000000000000000000111111111111000000000000000;
hammer2mem[23] = 96'b000000000000000000000000000000000000000000000000000000000000000000111111111111111111100000000000;
hammer2mem[24] = 96'b000000000000000000000000000000000000000000000000000000000000000001111111111111111111111100000000;
hammer2mem[25] = 96'b000000000000000000000000000000000000000000000000000000000000000001111111111111111111111110000000;
hammer2mem[26] = 96'b000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111110000;
hammer2mem[27] = 96'b000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111100;
hammer2mem[28] = 96'b000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111110;
hammer2mem[29] = 96'b000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111;
hammer2mem[30] = 96'b000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111111;
hammer2mem[31] = 96'b000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111;
hammer2mem[32] = 96'b000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111111;
hammer2mem[33] = 96'b000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111;
hammer2mem[34] = 96'b000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111111;
hammer2mem[35] = 96'b000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111111;
hammer2mem[36] = 96'b000000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111;
hammer2mem[37] = 96'b000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111111;
hammer2mem[38] = 96'b000000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111110;
hammer2mem[39] = 96'b000000100000000000000000000000000000000000000000000000000000000000000000111111111111111111111110;
hammer2mem[40] = 96'b000011100000000000000000000000000000000000000000000000000000000000000000001111111111111111111110;
hammer2mem[41] = 96'b000111000000000000000000000000000000000000000000000000000000000000000000000000111111111111111000;
hammer2mem[42] = 96'b001110000000000000000000000000000000000000000000000000000000000000000000000000000001111111100000;
hammer2mem[43] = 96'b011110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[44] = 96'b111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[45] = 96'b111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[46] = 96'b111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[47] = 96'b111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[48] = 96'b111100000000000000000000000000000000000000000000000111111110000000000000000000000000000000000000;
hammer2mem[49] = 96'b111100000000000000000000000000000000000000000000011111111111000000000000000000000000000000000000;
hammer2mem[50] = 96'b111110000000000000000000000000000000000000000000111111111111100000000000000000000000000000000000;
hammer2mem[51] = 96'b111110000000000000000000000000000000000000000000111111111111100000000000000000000000000000000000;
hammer2mem[52] = 96'b011111000000000000000000000000000000000000000000001111111111110000000000000000000000000000000000;
hammer2mem[53] = 96'b011111100000000000000000000000000000000000000000000011111111110000000000000000000000000000000000;
hammer2mem[54] = 96'b001111110000000000000000000000000000000000000000000000011111111110000000000000000000000000000000;
hammer2mem[55] = 96'b000011111100000000000000000000000000000000000000000000011111111110000000000000000000000000000000;
hammer2mem[56] = 96'b000001111111000000000000000000000000000000000000000000001111111111000000000000000000000000000000;
hammer2mem[57] = 96'b000000011111110000000000000000000000000000000000000000001111111111000000000000000000000000000000;
hammer2mem[58] = 96'b000000001111111111100000000000000000000000000000000000000011111111110000000000000000000000000000;
hammer2mem[59] = 96'b000000000001111111111111110000000000000000000000000000000001111111111000000000000000000000000000;
hammer2mem[60] = 96'b000000000000000011111111111000000000000000000000000000000001111111111000000000000000000000000000;
hammer2mem[61] = 96'b000000000000000000000000000000000000000000000000000000000000111111111100000000000000000000000000;
hammer2mem[62] = 96'b000000000000000000000000000000000000000000000000000000000000001111111111000000000000000000000000;
hammer2mem[63] = 96'b000000000000000000000000000000000000000000000000000000000000000111111111100000000000000000000000;
hammer2mem[64] = 96'b000000000000000000000000000000000000000000000000000000000000000011111111110000000000000000000000;
hammer2mem[65] = 96'b000000000000000000000000000000000000000000000000000000000000000001111111111000000000000000000000;
hammer2mem[66] = 96'b000000000000000000000000000000000000000000000000000000000000000000111111111100000000000000000000;
hammer2mem[67] = 96'b000000000000000000000000000000000000000000000000000000000000000000011111111110000000000000000000;
hammer2mem[68] = 96'b000000000000000000000000000000000000000000000000000000000000000000001111111111000000000000000000;
hammer2mem[69] = 96'b000000000000000000000000000000000000000000000000000000000000000000000111111111100000000000000000;
hammer2mem[70] = 96'b000000000000000000000000000000000000000000000000000000000000000000000011111111110000000000000000;
hammer2mem[71] = 96'b000000000000000000000000000000000000000000000000000000000000000000000001111111111000000000000000;
hammer2mem[72] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000111111111100000000000000;
hammer2mem[73] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000011111111110000000000000;
hammer2mem[74] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000001111111111000000000000;
hammer2mem[75] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000111111111100000000000;
hammer2mem[76] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000011111111110000000000;
hammer2mem[77] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000001111111111000000000;
hammer2mem[78] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100000000;
hammer2mem[79] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000011111111110000000;
hammer2mem[80] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111000000;
hammer2mem[81] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100000;
hammer2mem[82] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111110000;
hammer2mem[83] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111000;
hammer2mem[84] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111100;
hammer2mem[85] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111110;
hammer2mem[86] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111;
hammer2mem[87] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111111;
hammer2mem[88] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111;
hammer2mem[89] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111;
hammer2mem[90] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000111111;
hammer2mem[91] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000011111;
hammer2mem[92] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001110;
hammer2mem[93] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[94] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
hammer2mem[95] = 96'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;




 hammer3mem[0] = 96'b0000000000000000000001000000000000000001000000000000000011000000000000000010000000000000000010000000000000;
 hammer3mem[1] = 96'b0000000000000000000000110000000000000001100000000000000111100000000000000110000000000000001100000000000000;
 hammer3mem[2] = 96'b0000000000000000000000011100000000000001110000000000001111110000000000001110000000000000111000000000000000;
 hammer3mem[3] = 96'b0000000000000000000000001111000000000001111000000000011111111000000000011110000000000011110000000000000000;
 hammer3mem[4] = 96'b0000000000000000000000000111110000000001111100000000111111111100000000111110000000001111100000000000000000;
 hammer3mem[5] = 96'b0000000000000000000000000011111100000001111110000001111111111110000001111110000000111111000000000000000000;
 hammer3mem[6] = 96'b0000000000000000000000000001111111000001111111000011111111111111000011111110000011111110000000000000000000;
 hammer3mem[7] = 96'b0000000000000000000000000000111111110001111111100111111111111111100111111110001111111100000000000000000000;
 hammer3mem[8] = 96'b0000000000000000000000000000011111111101111111111111111111111111111111111110111111111000000000000000000000;
 hammer3mem[9] = 96'b0000000000000000000000000000001111111111111111111111111111111111111111111111111111110000000000000000000000;
hammer3mem[10] = 96'b0000000000000000000000000000000111111111111111111111111111111111111111111111111111100000000000000000000000;
hammer3mem[11] = 96'b0000000000000000000000000000000011111111111111111111111111111111111111111111111111000000000000000000000000;
hammer3mem[12] = 96'b0000000000000000000000000000000001111111111111111111111111111111111111111111111110000000000000000000000000;
hammer3mem[13] = 96'b0000000000000000000000000000000000111111111111111111111111111111111111111111111100000000000000000000000000;
hammer3mem[14] = 96'b0000000000000000000000000000000000011111111111111111111111111111111111111111111000000000000000000000000000;
hammer3mem[15] = 96'b0000000000000000000000000000000000001111111111111111111111111111111111111111110000000000000000000000000000;
hammer3mem[16] = 96'b0000000000000000000000000000000000000111111111111111111111111111111111111111100000000000000000000000000000;
hammer3mem[17] = 96'b0000000000000000000000000000000000000011111111111111111111111111111111111111000000000000000000000000000000;
hammer3mem[18] = 96'b0000000000000000000000000000000000000001111111111111111111111111111111111110000000000000000000000000000000;
hammer3mem[19] = 96'b0000000000000000000000000000000000000000111111111111111111111111111111111100000000000000000000000000000000;
hammer3mem[20] = 96'b0000000000000000000000000000000000000000011111111111111111111111111111111000000000000000000000000000000000;
hammer3mem[21] = 96'b0000000000000000000000000000000000000000001111111111111111111111111111110000000000000000000000000000000000;
hammer3mem[22] = 96'b0000000000000000000000000000000000000000000111111111111111111111111111100000000000000000000000000000000000;
hammer3mem[23] = 96'b0000000000000000000000000000000000000000000011111111111111111111111111000000000000000000000000000000000000;
hammer3mem[24] = 96'b0000000000000000000000000000000000000000000001111111111111111111111110000000000000000000000000000000000000;
hammer3mem[25] = 96'b0000000000000000000000000000000000000000000000111111111111111111111100000000000000000000000000000000000000;
hammer3mem[26] = 96'b0000000000000000000000000000000000000000000000011111111111111111111000000000000000000000000000000000000000;
hammer3mem[27] = 96'b0000000000000000000000000000000000000000000000001111111111111111110000000000000000000000000000000000000000;
hammer3mem[28] = 96'b0000000000000000000000000000000000000000000000000111111111111111100000000000000000000000000000000000000000;
hammer3mem[29] = 96'b0000000000000000000000000000000000000000000000000011111111111111000000000000000000000000000000000000000000;
hammer3mem[30] = 96'b0000000000000000000000000000000000000000000000000001111111111110000000000000000000000000000000000000000000;
hammer3mem[31] = 96'b0000000000000000000000000000000000000000000000000000111111111100000000000000000000000000000000000000000000;		

 /*rockmem[0] = 20'b00000000111000000000;
 rockmem[1] = 20'b00000001111110000000;				
 rockmem[2] = 20'b00001111111111110000;
 rockmem[3] = 20'b00011111111111111000;
 rockmem[4] = 20'b00111111111111111100;
 rockmem[5] = 20'b00111111111111111100;				
 rockmem[6] = 20'b00011111111111111000;
 rockmem[7] = 20'b00011111111111111000;
 rockmem[8] = 20'b00111111111111111100;
 rockmem[9] = 20'b00111111111111111100;				
rockmem[10] = 20'b01111111111111111110;
rockmem[11] = 20'b01111111111111111110;
rockmem[12] = 20'b01111111111111111110;
rockmem[13] = 20'b00111111111111111100;				
rockmem[14] = 20'b00111111111111111100;
rockmem[15] = 20'b01111111111111111110;
rockmem[16] = 20'b00111111111111111100;
rockmem[17] = 20'b00111111111111111100;				
rockmem[18] = 20'b00001111111111110000;
rockmem[19] = 20'b00000000111100000000;

 rockmem2[0] = 20'b00000001111100000000;
 rockmem2[1] = 20'b00000011000111000000;				
 rockmem2[2] = 20'b00011110000001111000;
 rockmem2[3] = 20'b00110000000000001100;
 rockmem2[4] = 20'b01100000000000000110;
 rockmem2[5] = 20'b01100000000000000010;				
 rockmem2[6] = 20'b00100000000000000110;
 rockmem2[7] = 20'b01100000000000000100;
 rockmem2[8] = 20'b01000000000000000110;
 rockmem2[9] = 20'b01000000000000000010;				
rockmem2[10] = 20'b11000000000000000011;
rockmem2[11] = 20'b10000000000000000001;
rockmem2[12] = 20'b11000000000000000011;
rockmem2[13] = 20'b01000000000000000010;				
rockmem2[14] = 20'b01000000000000000010;
rockmem2[15] = 20'b10000000000000000011;
rockmem2[16] = 20'b00000000000000000010;
rockmem2[17] = 20'b01110000000000001110;				
rockmem2[18] = 20'b00011111000011111000;
rockmem2[19] = 20'b00000001111110000000;*/ 

////////////////////////////////////////stones////////////////////////////////////////////////////////////////////

			 stonemem[0] = 120'b000000000000000000000000000000000000000000000000000000000011100000000000000000000000000000000000000000000000000000000000;
			 stonemem[1] = 120'b000000000000000000000000000000000000000001111000000001111111111000000000011111000000000000000000000000000000000000000000;
			 stonemem[2] = 120'b000000000000000000000000000000000000001111111111000011111111111110000001111111111100000000000011000000000000000000000000;
			 stonemem[3] = 120'b000000000000000000000000000000000001111111111111111111111111111111111111111111111111111000011111111100000000000000000000;
			 stonemem[4] = 120'b000000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111000000000000000000;
			 stonemem[5] = 120'b000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
			 stonemem[6] = 120'b000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
			 stonemem[7] = 120'b000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
			 stonemem[8] = 120'b000000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
			 stonemem[9] = 120'b000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000;
			stonemem[10] = 120'b000000000000000001111111111111111111111111111111111111111111111111111111100001111111111111111111111111000000000000000000;
			stonemem[11] = 120'b000000000000000001111111111111111111000000111111111011111100000111111111000000011111111111111111111110010000000000000000;
			stonemem[12] = 120'b000000000000000001111111111111111110000001111111100001111100000001111110000000000011111000000011111111111111100000000000;
			stonemem[13] = 120'b000000000000000001111111000000011100000001111111000000111100000001111110000000000111110000000000111111111110000000000000;
			stonemem[14] = 120'b000000000000000111111111110000000000000000111110000000111000000001111000000000000111110000000000001111111100000000000000;
			stonemem[15] = 120'b000000000000000111111111100000000000000000111110000000011000000000110000000000000111110000000000011111111100000000000000;
			stonemem[16] = 120'b000000000000001111111111111000000000000000111110000000000000000000000000000000000011110000000000111111111000000000000000;
			stonemem[17] = 120'b000000000001111111111111111000000000000000011100000000000000000000000000000000000000000000000000000001111110000000000000;
			stonemem[18] = 120'b000000000001111111111111111110000000000000011100000000000000000000000000000000000000000000000000000111100000000000000000;
			stonemem[19] = 120'b000000000001111111111111111100000000000000000000000000000000000000000000000000000000000000000000000111111111111000000000;
			stonemem[20] = 120'b000000000011111111000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111000000000;
			stonemem[21] = 120'b000000001111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000011111111110000000000;
			stonemem[22] = 120'b000000011111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111110000000000;
			stonemem[23] = 120'b000000111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000001111111111111000000;
			stonemem[24] = 120'b000111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000011111111111111110000;
			stonemem[25] = 120'b000001111111111111100000000000000000000000000000000000000000000000000000000000000000000000111111111111111111111111110000;
			stonemem[26] = 120'b000000111111111111100000000000000000000000000000000000000000000000000000000000000000000011111111111111111111111111100000;
			stonemem[27] = 120'b000001111111111111000001110000000000000000000000000000000000000000000000000000000000000111111111111111111111111110000000;
			stonemem[28] = 120'b000001111111111111100011111110000000000000000000000000000000000000000000000000000000000111111111111111111111111100000000;
			stonemem[29] = 120'b000000111111111111111111111110000000000000000000000000000000000000000000000000000000000001111111111111111111111100000000;
			stonemem[30] = 120'b000000001111111111111011111110000000000000000000000000000000000000000000000000000000000000011111111111111111111110000000;
			stonemem[31] = 120'b111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000011111111111111111100000000;
			stonemem[32] = 120'b111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000001111111111111111000000000;
			stonemem[33] = 120'b111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000011111111111100000000000;
			stonemem[34] = 120'b111111111111111111000000000000000000000000000000000000000000000000000000000000000000000011111111111111110000000000000000;
			stonemem[35] = 120'b111111111111111111111000000000000000000000000000000000000000000000000000000000000000000111111111111111110000000000000000;
			stonemem[36] = 120'b111001111111111111111000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111100000000;
			stonemem[37] = 120'b000000111111111111111000000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111000000;
			stonemem[38] = 120'b000111111111111111111100000000000000000000000000000000000000000000000000000000000000001111111111111111111111111111110000;
			stonemem[39] = 120'b000001111111111111111100000001111111110000000000111111110000000000000000000000000000000011111111111111111111111111110000;
			stonemem[40] = 120'b000000111111111111111111111111111111111100000011111111111111111111111111111111111111111111111111111111111111111111100000;
			stonemem[41] = 120'b000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000;
			stonemem[42] = 120'b000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100001111100000000;
			stonemem[43] = 120'b000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000;
			stonemem[44] = 120'b000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000;
			stonemem[45] = 120'b000000000001111111110001111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
			stonemem[46] = 120'b000000000000011111000000111000111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
			stonemem[47] = 120'b000000000000000000000000000000011111111111111111111111111111111111111111111111111111111111111111111111000000000000000000;
			stonemem[48] = 120'b000000000000000000000000000000000111111111111111111111111111111111111111111111111111111111111111111110000000000000000000;
			stonemem[49] = 120'b000000000000000000000000000000000001111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
			stonemem[50] = 120'b000000000000000000000000000000000000000000000000011111111111111111111111000001111111111100000000000000000000000000000000;
			stonemem[51] = 120'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

			/////////////////////////////////grass //////////////////////////////////////////////////////////////////////////
			grassmem[0] = 8'b00000000;
			grassmem[1] = 8'b00100000;
			grassmem[2] = 8'b01100000;
			grassmem[3] = 8'b01100100;
			grassmem[4] = 8'b11100110;
			grassmem[5] = 8'b11110110;
			grassmem[6] = 8'b11111111;
			grassmem[7] = 8'b11111111;

			 grass1mem[0] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                         grass1mem[1] = 64'b0000000000000000000000000000000011000000000000000000000000000000;
                         grass1mem[2] = 64'b0000000000000000000000000000000011110000000000000000000000000000;
                         grass1mem[3] = 64'b0000000000000000000000000000000001111100000000000000000000000000;
                         grass1mem[4] = 64'b0000000000000000000000000000000001111110000000000000000000000000;
                         grass1mem[5] = 64'b0000000000000000000000000000000000111111100000000000000000000000;
                         grass1mem[6] = 64'b1100000000000000000000000000000000111111110000000000000000000000;
                         grass1mem[7] = 64'b0111000000000000000000000000000000011111111000000000000000000000;
                         grass1mem[8] = 64'b0011110000000000000000000000000000011111111100000000000000000000;
                         grass1mem[9] = 64'b0001111000000000000000000000000000001111111110000000000000000000;
                        grass1mem[10] = 64'b0001111100000000000000000000000000001111111111000000000000000000;
                        grass1mem[11] = 64'b0000111110000000000000000000000110001111111111000000000000000000;
                        grass1mem[12] = 64'b0000111111000000000000000000011110000111111111100000000000000000;
                        grass1mem[13] = 64'b0000011111100000000000000001111100000111111111110000000000000000;
                        grass1mem[14] = 64'b0000011111110000000000000111111000000111111111110000000000000111;
                        grass1mem[15] = 64'b0000001111111000000000011111111000000111111111110000000000011110;
                        grass1mem[16] = 64'b0000001111111000000000111111110000000111111111110000000001111100;
                        grass1mem[17] = 64'b0000000111111100000001111111110000000111111111110000000111111000;
                        grass1mem[18] = 64'b0000000111111110000011111111110000000111111111110000011111110000;
                        grass1mem[19] = 64'b0000000011111111000111111111110000000111111111110001111111100000;
                        grass1mem[20] = 64'b0000000011111111000111111111110000001111111111110011111111000000;
                        grass1mem[21] = 64'b0000000001111111100111111111110000001111111111110111111110000000;
                        grass1mem[22] = 64'b0000000001111111100011111111111000001111111111111111111100000000;
                        grass1mem[23] = 64'b0000000000111111110011111111111100001111111111111111111000000000;
                        grass1mem[24] = 64'b0000000000111111111011111111111110011111111111111111110000000000;
                        grass1mem[25] = 64'b0000000000011111111011111111111110011111111111111111100000000000;
                        grass1mem[26] = 64'b0000000000011111111111111111111111011111111111111111100000000000;
                        grass1mem[27] = 64'b0000000000001111111111111111111111111111111111111111100000000000;
                        grass1mem[28] = 64'b0000000000011111111111111111111111111111111111111111110000000000;
                        grass1mem[29] = 64'b0000000000011111111111111111111111111111111111111111110000000000;


                         grass2mem[0] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                         grass2mem[1] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                         grass2mem[2] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                         grass2mem[3] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                         grass2mem[4] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                         grass2mem[5] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                         grass2mem[6] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                         grass2mem[7] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                         grass2mem[8] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                         grass2mem[9] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[10] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[11] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[12] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[13] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[14] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[15] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[16] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[17] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[18] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[19] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[20] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[21] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[22] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[23] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[24] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[25] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[26] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[27] = 64'b0000000000000000000000000000000000000000000000000000000000000000;
                        grass2mem[28] = 64'b0000011100000000000001111111110000000000000000000000000000000000;
                        grass2mem[29] = 64'b0000111100000000001111111111111100000000000011111111111100000000;
                        grass2mem[30] = 64'b0001111110000000111111111111111111000000011111111111111111100000;
                        grass2mem[31] = 64'b0011111110000011111111111111111111100001111111111111111111111000;
                        grass2mem[32] = 64'b0111111110000111111111111111111111100111111111111111111111111100;
                        grass2mem[33] = 64'b1111111111001111111111111111111111111111111111111111111111111110;
                        grass2mem[34] = 64'b1111111111111111111111111111111111111111111111111111111111111110;
                        grass2mem[35] = 64'b1111111111111111111111111111111111001111111111111111111111111110;
                        grass2mem[36] = 64'b0111111110011111111111111111111110000111111111111111111111111100;
                        grass2mem[37] = 64'b0111111000001111111111111111111100000011111111111111111111111000;
                        grass2mem[38] = 64'b0000000000000111111111111111110000000000011111111111111110000000;
                        grass2mem[39] = 64'b0000000000000001111111111100000000000000000000000000000000000000;
								
								/////////////////////////////////////////score/////////////////////////////////////////////////////////////////////////////////
          			

			scoreboardmem[0] = 160'b0000000000111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 scoreboardmem[1] = 160'b0000001111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 scoreboardmem[2] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000;
 scoreboardmem[3] = 160'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000;
 scoreboardmem[4] = 160'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000;
 scoreboardmem[5] = 160'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000;
 scoreboardmem[6] = 160'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000;
 scoreboardmem[7] = 160'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000;
 scoreboardmem[8] = 160'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000;
 scoreboardmem[9] = 160'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000;
scoreboardmem[10] = 160'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000;
scoreboardmem[11] = 160'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000;
scoreboardmem[12] = 160'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000;
scoreboardmem[13] = 160'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000;
scoreboardmem[14] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000;
scoreboardmem[15] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000;
scoreboardmem[16] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000;
scoreboardmem[17] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000;
scoreboardmem[18] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000;
scoreboardmem[19] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000;
scoreboardmem[20] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
scoreboardmem[21] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000;
scoreboardmem[22] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000;
scoreboardmem[23] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000;
scoreboardmem[24] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000;
scoreboardmem[25] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000;
scoreboardmem[26] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000;
scoreboardmem[27] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000;
scoreboardmem[28] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000;
scoreboardmem[29] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000;
scoreboardmem[30] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000;
scoreboardmem[31] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000;
scoreboardmem[32] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000;
scoreboardmem[33] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000;
scoreboardmem[34] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000;
scoreboardmem[35] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100;
scoreboardmem[36] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110;
scoreboardmem[37] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
scoreboardmem[38] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
scoreboardmem[39] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110;
scoreboardmem[40] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100;
scoreboardmem[41] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000;
scoreboardmem[42] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000;
scoreboardmem[43] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000;
scoreboardmem[44] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000;
scoreboardmem[45] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000;
scoreboardmem[46] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000;
scoreboardmem[47] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000;
scoreboardmem[48] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000;
scoreboardmem[49] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000;
scoreboardmem[50] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000;
scoreboardmem[51] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000;
scoreboardmem[52] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000;
scoreboardmem[53] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000;
scoreboardmem[54] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000;
scoreboardmem[55] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
scoreboardmem[56] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000;
scoreboardmem[57] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000;
scoreboardmem[58] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000;
scoreboardmem[59] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000;
scoreboardmem[60] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000;
scoreboardmem[61] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000;
scoreboardmem[62] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000;
scoreboardmem[63] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000;
scoreboardmem[64] = 160'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000;
scoreboardmem[65] = 160'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000;
scoreboardmem[66] = 160'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000;
scoreboardmem[67] = 160'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000;
scoreboardmem[68] = 160'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000;
scoreboardmem[69] = 160'b0000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000;
scoreboardmem[70] = 160'b0000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000;
scoreboardmem[71] = 160'b0000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000;
scoreboardmem[72] = 160'b0000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000;
scoreboardmem[73] = 160'b0000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000;
scoreboardmem[74] = 160'b0000000000000000000011111111111111111111111111111111111111111110000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;			

			
			 

			scoreboard1mem[0] = 160'b0000000011111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 scoreboard1mem[1] = 160'b0000111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
 scoreboard1mem[2] = 160'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000;
 scoreboard1mem[3] = 160'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000;
 scoreboard1mem[4] = 160'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000;
 scoreboard1mem[5] = 160'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000000;
 scoreboard1mem[6] = 160'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000;
 scoreboard1mem[7] = 160'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000;
 scoreboard1mem[8] = 160'b1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000;
 scoreboard1mem[9] = 160'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000;
scoreboard1mem[10] = 160'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000;
scoreboard1mem[11] = 160'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000;
scoreboard1mem[12] = 160'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000;
scoreboard1mem[13] = 160'b0111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000;
scoreboard1mem[14] = 160'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000;
scoreboard1mem[15] = 160'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000;
scoreboard1mem[16] = 160'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000;
scoreboard1mem[17] = 160'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000;
scoreboard1mem[18] = 160'b0011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000;
scoreboard1mem[19] = 160'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000;
scoreboard1mem[20] = 160'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
scoreboard1mem[21] = 160'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000;
scoreboard1mem[22] = 160'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000;
scoreboard1mem[23] = 160'b0001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000;
scoreboard1mem[24] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000;
scoreboard1mem[25] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000;
scoreboard1mem[26] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000;
scoreboard1mem[27] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000;
scoreboard1mem[28] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000;
scoreboard1mem[29] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000;
scoreboard1mem[30] = 160'b0000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000;
scoreboard1mem[31] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000;
scoreboard1mem[32] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000;
scoreboard1mem[33] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000;
scoreboard1mem[34] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000;
scoreboard1mem[35] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100;
scoreboard1mem[36] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110;
scoreboard1mem[37] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
scoreboard1mem[38] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
scoreboard1mem[39] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
scoreboard1mem[40] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
scoreboard1mem[41] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
scoreboard1mem[42] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
scoreboard1mem[43] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111;
scoreboard1mem[44] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110;
scoreboard1mem[45] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100;
scoreboard1mem[46] = 160'b0000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000;
scoreboard1mem[47] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000;
scoreboard1mem[48] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000;
scoreboard1mem[49] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000;
scoreboard1mem[50] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000;
scoreboard1mem[51] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000;
scoreboard1mem[52] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000;
scoreboard1mem[53] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000;
scoreboard1mem[54] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000;
scoreboard1mem[55] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000;
scoreboard1mem[56] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000;
scoreboard1mem[57] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000;
scoreboard1mem[58] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000;
scoreboard1mem[59] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000;
scoreboard1mem[60] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
scoreboard1mem[61] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000;
scoreboard1mem[62] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000;
scoreboard1mem[63] = 160'b0000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000;
scoreboard1mem[64] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000;
scoreboard1mem[65] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000;
scoreboard1mem[66] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000;
scoreboard1mem[67] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000;
scoreboard1mem[68] = 160'b0000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000;
scoreboard1mem[69] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000;
scoreboard1mem[70] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000;
scoreboard1mem[71] = 160'b0000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000;
scoreboard1mem[72] = 160'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000;
scoreboard1mem[73] = 160'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000000000000000;
scoreboard1mem[74] = 160'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000000000000000000;	
scoreboard1mem[75] = 160'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000;
scoreboard1mem[76] = 160'b0000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000;
scoreboard1mem[77] = 160'b0000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000;
scoreboard1mem[78] = 160'b0000000000000001111111111111111111111111111111111111111111111111111000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;

//NUMBERS
//ZERO

  zero[0] = 32'b00000000000000011000000000000000;
  zero[1] = 32'b00000000000111110001100000000000;
  zero[2] = 32'b00000000111111110000001100000000;
  zero[3] = 32'b00000011111111110000000011000000;
  zero[4] = 32'b00000111111111110000000001100000;
  zero[5] = 32'b00001111111111110000000000110000;
  zero[6] = 32'b00011111111111110000000000011000;
  zero[7] = 32'b00111111111111110000000000001100;
  zero[8] = 32'b01111111111111110000000000000110;
  zero[9] = 32'b11111111111111110000000000000011;
 zero[10] = 32'b11111111111111110000000000000011;
 zero[11] = 32'b11111111111111110000000000000011;
 zero[12] = 32'b11111111111111110000000000000011;
 zero[13] = 32'b11111111111111110000000000000011;
 zero[14] = 32'b11111111111111110000000000000011;
 zero[15] = 32'b11111111111111110000000000000001;
 zero[16] = 32'b11111111111111110000000000000011;
 zero[17] = 32'b11111111111111110000000000000011;
 zero[18] = 32'b11111111111111110000000000000011;
 zero[19] = 32'b11111111111111110000000000000011;
 zero[20] = 32'b11111111111111110000000000000011;
 zero[21] = 32'b11111111111111110000000000000011;
 zero[22] = 32'b01111111111111110000000000000110;
 zero[23] = 32'b00111111111111110000000000001100;
 zero[24] = 32'b00011111111111110000000000011000;
 zero[25] = 32'b00001111111111110000000000110000;
 zero[26] = 32'b00000111111111110000000001100000;
 zero[27] = 32'b00000011111111110000000011000000;
 zero[28] = 32'b00000001111111110000000110000000;
 zero[29] = 32'b00000000011111110000001100000000;
 zero[30] = 32'b00000000000011110001100000000000;
 zero[31] = 32'b00000000000000011000000000000000;

//ONE
one[0] = 32'b00000000000000000000000000001111;
one[1] = 32'b00000000000000000001111111111111;
one[2] = 32'b00000000000111111111111111111111;
one[3] = 32'b00000011111111111111111111111111;
one[4] = 32'b00011111111111111111111111111111;
one[5] = 32'b11111000111111111111111111111111;
one[6] = 32'b00000000111111111111111111111111;
one[7] = 32'b00000000111111111111111111111111;
one[8] = 32'b00000000111111111111111111111111;
one[9] = 32'b00000000111111111111111111111111;
one[10] = 32'b00000000111111111111111111111111;
one[11] = 32'b00000000111111111111111111111111;
one[12] = 32'b00000000111111111111111111111111;
one[13] = 32'b00000000111111111111111111111111;
one[14] = 32'b00000000111111111111111111111111;
one[15] = 32'b00000000111111111111111111111111;
one[16] = 32'b00000000111111111111111111111111;
one[17] = 32'b00000000111111111111111111111111;
one[18] = 32'b00000000111111111111111111111111;
one[19] = 32'b00000000111111111111111111111111;
one[20] = 32'b00000000111111111111111111111111;
one[21] = 32'b00000000111111111111111111111111;
one[22] = 32'b00000000111111111111111111111111;
one[23] = 32'b00000000111111111111111111111111;
one[24] = 32'b00000000111111111111111111111111;
one[25] = 32'b00000000111111111111111111111111;
one[26] = 32'b00000000111111111111111111111111;
one[27] = 32'b00000000111111111111111111111111;
one[28] = 32'b00000000111111111111111111111111;
one[29] = 32'b00000000111111111111111111111111;
one[30] = 32'b00000000111111111111111111111111;
one[31] = 32'b00000000111111111111111111111111;
			
// TWO

two[0] = 32'b00000000000000011110000000000000;
two[1] = 32'b00000000000011000001111000000000;
two[2] = 32'b00000000001100000000011111000000;
two[3] = 32'b00000001100000000000001111110000;
two[4] = 32'b00001100000000000000001111111000;
two[5] = 32'b00011000000000000000011111111100;
two[6] = 32'b00110000000000000000111111111110;
two[7] = 32'b01100000000000000001111111111111;
two[8] = 32'b11000000000000000011111111111111;
two[9] = 32'b11000000000000000111111111111110;
two[10] = 32'b01100000000000001111111111111100;
two[11] = 32'b00011000000000011111111111111000;
two[12] = 32'b00000000000000111111111111110000;
two[13] = 32'b00000000000001111111111111100000;
two[14] = 32'b00000000000011111111111111000000;
two[15] = 32'b00000000000111111111111110000000;
two[16] = 32'b00000000001111111111111100000000;
two[17] = 32'b00000000011111111111111000000000;
two[18] = 32'b00000000111111111111110000000000;
two[19] = 32'b00000001111111111111100000000000;
two[20] = 32'b00000011111111111111000000000000;
two[21] = 32'b00000111111111111110000000000000;
two[22] = 32'b00001111111111111100000000000000;
two[23] = 32'b00011111111111111000000000000000;
two[24] = 32'b00111111111111110000000000000000;
two[25] = 32'b01111111111111100000000000000000;
two[26] = 32'b11111111111111000000000000000000;
two[27] = 32'b11111111111110000000000000000000;
two[28] = 32'b11111111111100000000000000000000;
two[29] = 32'b11111111111000000000000000000000;
two[30] = 32'b11111111111111111111111111111111;
two[31] = 32'b11111111111111111111111111111111;

//THREE
three[0] = 32'b00000000001110000000000000000000;
three[1] = 32'b00000011000000001100000000000000;
three[2] = 32'b00110000000000000111111000000000;
three[3] = 32'b11000000000000000111111111100000;
three[4] = 32'b00000000000000000111111111111000;
three[5] = 32'b00000000000000000111111111111100;
three[6] = 32'b00000000000000000111111111111110;
three[7] = 32'b00000000000000000111111111111111;
three[8] = 32'b00000000000000000111111111111111;
three[9] = 32'b00000000000000000111111111111111;
three[10] = 32'b00000000000000000111111111111111;
three[11] = 32'b00000000000000000111111111111110;
three[12] = 32'b00000000000000000111111111111100;
three[13] = 32'b00000000000000000111111111111000;
three[14] = 32'b00000000000000000111111111000000;
three[15] = 32'b00000000000000000111110000000000;
three[16] = 32'b00000000000000011000000000000000;
three[17] = 32'b00000000000000000111110000000000;
three[18] = 32'b00000000000000000111111111000000;
three[19] = 32'b00000000000000000111111111111000;
three[20] = 32'b00000000000000000111111111111100;
three[21] = 32'b00000000000000000111111111111110;
three[22] = 32'b00000000000000000111111111111111;
three[23] = 32'b00000000000000000111111111111111;
three[24] = 32'b00000000000000000111111111111111;
three[25] = 32'b00000000000000000111111111111111;
three[26] = 32'b00000000000000000111111111111110;
three[27] = 32'b11000000000000000111111111111100;
three[28] = 32'b01100000000000000111111111110000;
three[29] = 32'b00011000000000000111111100000000;
three[30] = 32'b00000001100000000110000000000000;
three[31] = 32'b00000000000111100000000000000000;

//FOUR

four[0] = 32'b00000000000000000000000000110000;
four[1] = 32'b00000000000000000000000001110000;
four[2] = 32'b00000000000000000000000011110000;
four[3] = 32'b00000000000000000000000111110000;
four[4] = 32'b00000000000000000000001111110000;
four[5] = 32'b00000000000000000000011111110000;
four[6] = 32'b00000000000000000000111111110000;
four[7] = 32'b00000000000000000001111111110000;
four[8] = 32'b00000000000000000011111111110000;
four[9] = 32'b00000000000000000111111111110000;
four[10] = 32'b00000000000000001111111111110000;
four[11] = 32'b00000000000000011111111111110000;
four[12] = 32'b00000000000000111111111111110000;
four[13] = 32'b00000000000001111111111111110000;
four[14] = 32'b00000000000011111111111111110000;
four[15] = 32'b00000000000111111111111111110000;
four[16] = 32'b00000000001111111111111111110000;
four[17] = 32'b00000000011011111111111111110000;
four[18] = 32'b00000000110011111111111111110000;
four[19] = 32'b00000001100011111111111111110000;
four[20] = 32'b00000011000011111111111111110000;
four[21] = 32'b00000110000011111111111111110000;
four[22] = 32'b00001100000011111111111111110000;
four[23] = 32'b00011000000011111111111111110000;
four[24] = 32'b00110000000011111111111111110000;
four[25] = 32'b01100000000011111111111111110000;
four[26] = 32'b11111111111111111111111111111111;
four[27] = 32'b11111111111111111111111111111111;
four[28] = 32'b00000000000011111111111111110000;
four[29] = 32'b00000000000011111111111111110000;
four[30] = 32'b00000000000011111111111111110000;
four[31] = 32'b00000000000011111111111111110000;

//FIVE

five[0] = 32'b00000001111111111111111111111111;
five[1] = 32'b00000011111111111111111111111111;
five[2] = 32'b00000110000000000000000000000000;
five[3] = 32'b00001100000000000000000000000000;
five[4] = 32'b00011000000000000000000000000000;
five[5] = 32'b00110000000000000000000000000000;
five[6] = 32'b01100000000000000000000000000000;
five[7] = 32'b11000000000000000000000000000000;
five[8] = 32'b00000011000000000000000000000000;
five[9] = 32'b00000000000011000000000000000000;
five[10] = 32'b00000000000001111110000000000000;
five[11] = 32'b00000000000001111111111100000000;
five[12] = 32'b00000000000001111111111111000000;
five[13] = 32'b00000000000001111111111111110000;
five[14] = 32'b00000000000001111111111111111000;
five[15] = 32'b00000000000000111111111111111100;
five[16] = 32'b00000000000001111111111111111110;
five[17] = 32'b00000000000001111111111111111111;
five[18] = 32'b00000000000001111111111111111111;
five[19] = 32'b00000000000001111111111111111111;
five[20] = 32'b00000000000001111111111111111111;
five[21] = 32'b00000000000001111111111111111111;
five[22] = 32'b00000000000001111111111111111110;
five[23] = 32'b00000000000001111111111111111100;
five[24] = 32'b00000000000001111111111111111000;
five[25] = 32'b00000000000001111111111111110000;
five[26] = 32'b00000000000001111111111111100000;
five[27] = 32'b00000000000001111111111110000000;
five[28] = 32'b11000000000001111111100000000000;
five[29] = 32'b00110000000001111110000000000000;
five[30] = 32'b00001100000001100000000000000000;
five[31] = 32'b00000001111100000000000000000000;

//SIX

six[0] = 32'b00000000000000000011110000000000;
six[1] = 32'b00000000000000110000000001100000;
six[2] = 32'b00000000001111110000000000001100;
six[3] = 32'b00000001111111110000000000000110;
six[4] = 32'b00000111111111110000000000000011;
six[5] = 32'b00001111111111110000000000000000;
six[6] = 32'b00011111111111110000000000000000;
six[7] = 32'b00111111111111110000000000000000;
six[8] = 32'b01111111111111110000000000000000;
six[9] = 32'b11111111111111110000000000000000;
six[10] = 32'b11111111111111110000000000000000;
six[11] = 32'b11111111111111110000000000000000;
six[12] = 32'b11111111111111110000000000000000;
six[13] = 32'b11111111111111110000000000000000;
six[14] = 32'b11111111111111110000000000000000;
six[15] = 32'b11111111111111110000000000000000;
six[16] = 32'b11111111111111110011000000000000;
six[17] = 32'b11111111111111110000000110000000;
six[18] = 32'b11111111111111110000000000110000;
six[19] = 32'b11111111111111110000000000001100;
six[20] = 32'b11111111111111110000000000000110;
six[21] = 32'b11111111111111110000000000000011;
six[22] = 32'b01111111111111110000000000000011;
six[23] = 32'b00111111111111110000000000000011;
six[24] = 32'b00011111111111110000000000000011;
six[25] = 32'b00001111111111110000000000000011;
six[26] = 32'b00000111111111110000000000000011;
six[27] = 32'b00000011111111110000000000000110;
six[28] = 32'b00000000111111110000000000001100;
six[29] = 32'b00000000000111110000000000110000;
six[30] = 32'b00000000000000011000000110000000;
six[31] = 32'b00000000000000000011110000000000;

//SEVEN

seven[0] = 32'b11111111111111111111111111111111;
seven[1] = 32'b11111111111111111111111111111111;
seven[2] = 32'b00000000000000001111111111111110;
seven[3] = 32'b00000000000000011111111111111100;
seven[4] = 32'b00000000000000111111111111111000;
seven[5] = 32'b00000000000001111111111111110000;
seven[6] = 32'b00000000000011111111111111100000;
seven[7] = 32'b00000000000111111111111111000000;
seven[8] = 32'b00000000001111111111111110000000;
seven[9] = 32'b00000000011111111111111100000000;
seven[10] = 32'b00000000111111111111111000000000;
seven[11] = 32'b00000001111111111111110000000000;
seven[12] = 32'b00000011111111111111100000000000;
seven[13] = 32'b00000111111111111111000000000000;
seven[14] = 32'b00001111111111111110000000000000;
seven[15] = 32'b00011111111111111100000000000000;
seven[16] = 32'b00111111111111111000000000000000;
seven[17] = 32'b01111111111111110000000000000000;
seven[18] = 32'b11111111111111100000000000000000;
seven[19] = 32'b11111111111111000000000000000000;
seven[20] = 32'b11111111111110000000000000000000;
seven[21] = 32'b11111111111100000000000000000000;
seven[22] = 32'b11111111111000000000000000000000;
seven[23] = 32'b11111111110000000000000000000000;
seven[24] = 32'b11111111100000000000000000000000;
seven[25] = 32'b11111111000000000000000000000000;
seven[26] = 32'b11111110000000000000000000000000;
seven[27] = 32'b11111100000000000000000000000000;
seven[28] = 32'b11111000000000000000000000000000;
seven[29] = 32'b11110000000000000000000000000000;
seven[30] = 32'b11100000000000000000000000000000;
seven[31] = 32'b11000000000000000000000000000000;

//EIGHT

eight[0] = 32'b00000000000000011000000000000000;
eight[1] = 32'b00000000000110000001100000000000;
eight[2] = 32'b00000001111110000000000110000000;
eight[3] = 32'b00001111111100000000000000110000;
eight[4] = 32'b00111111111100000000000000001100;
eight[5] = 32'b01111111111100000000000000000110;
eight[6] = 32'b11111111111110000000000000000011;
eight[7] = 32'b11111111111111000000000000000011;
eight[8] = 32'b11111111111111100000000000000011;
eight[9] = 32'b11111111111111110000000000000011;
eight[10] = 32'b11111111111111111000000000000011;
eight[11] = 32'b11111111111111111100000000000011;
eight[12] = 32'b01111111111111111110000000000110;
eight[13] = 32'b00111111111111111111000000001100;
eight[14] = 32'b00011111111111111111100001100000;
eight[15] = 32'b00001111111111111111111100000000;
eight[16] = 32'b00000111111111111111111110000000;
eight[17] = 32'b00000001111111111111111111000000;
eight[18] = 32'b00000000111111111111111111100000;
eight[19] = 32'b00000001111111111111111111110000;
eight[20] = 32'b00001100001111111111111111111000;
eight[21] = 32'b00110000000111111111111111111100;
eight[22] = 32'b01100000000011111111111111111110;
eight[23] = 32'b11000000000001111111111111111111;
eight[24] = 32'b11000000000000111111111111111111;
eight[25] = 32'b01100000000000011111111111111111;
eight[26] = 32'b00110000000000001111111111111111;
eight[27] = 32'b00011000000000000111111111111110;
eight[28] = 32'b00001100000000000011111111111100;
eight[29] = 32'b00000000110000000001111111110000;
eight[30] = 32'b00000000000110000000111100000000;
eight[31] = 32'b00000000000000011111000000000000;

//NINE

nine[0] = 32'b00000000000111000000000000000000;
nine[1] = 32'b00000001100000000110000000000000;
nine[2] = 32'b00011000000000000111111000000000;
nine[3] = 32'b01100000000000000111111111000000;
nine[4] = 32'b11000000000000000111111111110000;
nine[5] = 32'b11000000000000000111111111111000;
nine[6] = 32'b11000000000000000111111111111100;
nine[7] = 32'b11000000000000000111111111111111;
nine[8] = 32'b01100000000000000111111111111111;
nine[9] = 32'b00110000000000000111111111111111;
nine[10] = 32'b00011000000000000111111111111111;
nine[11] = 32'b00001100000000000111111111111111;
nine[12] = 32'b00000110000000000111111111111111;
nine[13] = 32'b00000000001100000111111111111111;
nine[14] = 32'b00000000000000110111111111111111;
nine[15] = 32'b00000000000000000111111111111111;
nine[16] = 32'b00000000000000000111111111111111;
nine[17] = 32'b00000000000000000111111111111111;
nine[18] = 32'b00000000000000000111111111111111;
nine[19] = 32'b00000000000000000111111111111111;
nine[20] = 32'b00000000000000000111111111111111;
nine[21] = 32'b00000000000000000111111111111111;
nine[22] = 32'b00000000000000000111111111111110;
nine[23] = 32'b00000000000000000111111111111100;
nine[24] = 32'b00000000000000000111111111111000;
nine[25] = 32'b00000000000000000111111111110000;
nine[26] = 32'b00000000000000000111111111100000;
nine[27] = 32'b11000000000000000111111111000000;
nine[28] = 32'b01100000000000000111111100000000;
nine[29] = 32'b00011000000000000111100000000000;
nine[30] = 32'b00000011000000011000000000000000;
nine[31] = 32'b00000000001110000000000000000000;

//MUD
	
          mudmem[18] = 120'b000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000;
			 mudmem[17] = 120'b000000000000000000000000000000000000011111111000000000000000000000000000011111000000000000000000000000000000000000000000;
			 mudmem[16] = 120'b000000000000000000000000000000000011111111111111100011111110001110000001111111111100000000000011000000000000000000000000;
			 mudmem[15] = 120'b000000000000000000111111111111111111111111111111111111111111111111111111111111111111111000011111111100000000000000000000;
			 mudmem[14] = 120'b000000000000000011111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
			 mudmem[13] = 120'b000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000;
			 mudmem[12] = 120'b000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000;
			 mudmem[11] = 120'b000000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
			 mudmem[10] = 120'b000000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111100000000000000000;
			mudmem[9] = 120'b0000000000001111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000;
			mudmem[8] = 120'b0000000000000111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110000000000000000000;
			mudmem[7] = 120'b0000000000000111111111111111111111111000000111111111111111100000111111111100000111111111111111111111100100000000000000000;
			mudmem[6] = 120'b0000000000000111111111111111111111100000000011000000001100000000001100000000000000011111100011111111111111111000000000000;
			mudmem[5] = 120'b0000000000000111111111110000000111000000000000000000000000000000000000000000000000000000000000001111111111100000000000000;
			mudmem[4] = 120'b0000000000000001111111111100000000000000000000000000000000000000000000000000000000000000000000000011111111000000000000000;
			mudmem[3] = 120'b0000000000000001111111111000000000000000000000000000000000000000000000000000000000000000000000000111111111000000000000000;
			mudmem[2] = 120'b0000000000000011111111111110000000000000000000000000000000000000000000000000000000000000000000001111111110000000000000000;
			mudmem[1] = 120'b0000000000000000011111111110000000000000000000000000000000000000000000000000000000000000000000000000011111100000000000000;
			mudmem[0] = 120'b0000000000000000011111111111100000000000000000000000000000000000000000000000000000000000000000000001111000000000000000000;
	
   end
   /* 
    *    0 1 2 3 4 5 6 7
    * 
    * 0  afa a a a ab
    * 1  f         b
    * 2  f         b
    * 3  f         b
    * 4  f         b
    * 5  f         b
    * 6 efgggggggggbc 
    * 7  e         c
    * 8  e         c
    * 9  e         c
    * 10 e         c
    * 11 e         c
    * 12 edddddddddc
    * 13
    * 14             h
    * 15
    *
    * 640 x 480
    * 
    * Each seven-segment "pixel" is 8x8: 64 pixels across, 512 pixels for
    * 8 characters being displayed
    * 64 + 512 + 64 = 640  Start in column 64, end in column 576
    * 
    * 128 pixels high: start at row 128, end at row 256
    * 128 + 128 + 224 = 480  Start in row 128
    */
	 
	 int i,j=0;
	 int k = 200;
	 
	always_comb begin
	
	//########################################SKY AND GREEN GRASS BACKGROUNG ########################
	if (vcount>80)
	{VGA_R, VGA_G, VGA_B} = {8'h00, 8'h99, 8'h00};
	else
	{VGA_R, VGA_G, VGA_B} = {8'h87, 8'hce, 8'heb};

	
	//############################ CIRCLE EQUATION ###################################
	if ((hcount[10:1]-410)*(hcount[10:1]-410)+(vcount-450)*(vcount-450) < 100000 )  // Equation of circle with centre = (x,y)
	{VGA_R, VGA_G, VGA_B} = {8'hca, 8'h8d, 8'h42};

	// ###################################### SHORT GRASS ##########################
	
    for(i=0;i<=640;i=i+7)begin
		if (((vcount>=76) & (vcount<=76+7)) & ((hcount[10:1]>=i) & (hcount[10:1]<=(i+7))))begin
			if (grassmem[vcount-76][i+7-hcount[10:1]] == 1)
				{VGA_R, VGA_G, VGA_B} = {8'h32, 8'hcd, 8'h32};
		end
	end	
	
	//################################### HOLES #########################################
	
	if ((((hcount[10:1]-290)*(hcount[10:1]-290))>>7)+(((vcount-207)*(vcount-207))>>5) <= 5'b10000 ) //Hole1
	{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};	 
	if ((((hcount[10:1]-510)*(hcount[10:1]-510))>>7)+(((vcount-207)*(vcount-207))>>5) <= 5'b10000 ) //Hole
	{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
	//{VGA_R, VGA_G, VGA_B} = {8'h8b, 8'h45, 8'h13};
	if ((((hcount[10:1]-400)*(hcount[10:1]-400))>>7)+(((vcount-237)*(vcount-237))>>5) <= 5'b10000 ) //Hole
	{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
	//{VGA_R, VGA_G, VGA_B} = {8'h8b, 8'h45, 8'h13};
	if ((((hcount[10:1]-400)*(hcount[10:1]-400))>>7)+(((vcount-317)*(vcount-317))>>5) <= 5'b10000 ) //Hole
	{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
	//{VGA_R, VGA_G, VGA_B} = {8'h8b, 8'h45, 8'h13};
	if ((((hcount[10:1]-400)*(hcount[10:1]-400))>>7)+(((vcount-397)*(vcount-397))>>5) <= 5'b10000 ) //Hole
	{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
	//{VGA_R, VGA_G, VGA_B} = {8'h8b, 8'h45, 8'h13};
	if ((((hcount[10:1]-250)*(hcount[10:1]-250))>>7)+(((vcount-277)*(vcount-277))>>5) <= 5'b10000 ) //Hole
	{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
	//{VGA_R, VGA_G, VGA_B} = {8'h8b, 8'h45, 8'h13};
	if ((((hcount[10:1]-250)*(hcount[10:1]-250))>>7)+(((vcount-357)*(vcount-357))>>5) <= 5'b10000 ) //Hole
	{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
	//{VGA_R, VGA_G, VGA_B} = {8'h8b, 8'h45, 8'h13};
	if ((((hcount[10:1]-550)*(hcount[10:1]-550))>>7)+(((vcount-277)*(vcount-277))>>5) <= 5'b10000 ) //Hole
	{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
	//{VGA_R, VGA_G, VGA_B} = {8'h8b, 8'h45, 8'h13};
	if ((((hcount[10:1]-550)*(hcount[10:1]-550))>>7)+(((vcount-357)*(vcount-357))>>5) <= 5'b10000 ) //Hole
	{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
	//{VGA_R, VGA_G, VGA_B} = {8'h8b, 8'h45, 8'h13};
	
	
	//########################################### STONES ###############################################
	if (((vcount>=181) & (vcount<=(181+51))) & ((hcount[10:1]>=230) & (hcount[10:1]<=(230+119))))begin
                if (stonemem[vcount-181][230+119-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
	end
	if (((vcount>=181) & (vcount<=(181+51))) & ((hcount[10:1]>=450) & (hcount[10:1]<=(450+119))))begin
                if (stonemem[vcount-181][450+119-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
	end
	if (((vcount>=211) & (vcount<=(211+51))) & ((hcount[10:1]>=340) & (hcount[10:1]<=(340+119))))begin
                if (stonemem[vcount-211][340+119-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
	end
	if (((vcount>=291) & (vcount<=(291+51))) & ((hcount[10:1]>=340) & (hcount[10:1]<=(340+119))))begin
                if (stonemem[vcount-291][340+119-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
	end
	if (((vcount>=371) & (vcount<=(371+51))) & ((hcount[10:1]>=340) & (hcount[10:1]<=(340+119))))begin
                if (stonemem[vcount-371][340+119-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
	end
	if (((vcount>=251) & (vcount<=(251+51))) & ((hcount[10:1]>=190) & (hcount[10:1]<=(190+119))))begin
                if (stonemem[vcount-251][190+119-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
	end
	if (((vcount>=331) & (vcount<=(331+51))) & ((hcount[10:1]>=190) & (hcount[10:1]<=(190+119))))begin
                if (stonemem[vcount-331][190+119-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
	end
	if (((vcount>=251) & (vcount<=(251+51))) & ((hcount[10:1]>=490) & (hcount[10:1]<=(490+119))))begin
                if (stonemem[vcount-251][490+119-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
	end
	if (((vcount>=331) & (vcount<=(331+51))) & ((hcount[10:1]>=490) & (hcount[10:1]<=(490+119))))begin
                if (stonemem[vcount-331][490+119-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
	end
	
	//################################## TALL GRASS########################################
		
		  if (((vcount>=400) & (vcount<=(400+29))) & ((hcount[10:1]>=566) & (hcount[10:1]<=(566+63))))
                if (grass1mem[vcount-400][63+566-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'h32, 8'hcd, 8'h32};
        if (((vcount>=400) & (vcount<=(400+39))) & ((hcount[10:1]>=566) & (hcount[10:1]<=(566+63))))
                if (grass2mem[vcount-400][63+566-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
			if (((vcount>=440) & (vcount<=(440+29))) & ((hcount[10:1]>=500) & (hcount[10:1]<=(500+63))))
                if (grass1mem[vcount-440][63+500-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'h32, 8'hcd, 8'h32};
        if (((vcount>=440) & (vcount<=(440+39))) & ((hcount[10:1]>=500) & (hcount[10:1]<=(500+63))))
                if (grass2mem[vcount-440][63+500-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
								
		 if (((vcount>=440) & (vcount<=(440+29))) & ((hcount[10:1]>=300) & (hcount[10:1]<=(300+63))))
                if (grass1mem[vcount-440][63+300-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'h32, 8'hcd, 8'h32};
        if (((vcount>=440) & (vcount<=(440+39))) & ((hcount[10:1]>=300) & (hcount[10:1]<=(300+63))))
                if (grass2mem[vcount-440][63+300-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
			if (((vcount>=440) & (vcount<=(440+29))) & ((hcount[10:1]>=250) & (hcount[10:1]<=(250+63))))
                if (grass1mem[vcount-440][63+250-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'h32, 8'hcd, 8'h32};
        if (((vcount>=440) & (vcount<=(440+39))) & ((hcount[10:1]>=250) & (hcount[10:1]<=(250+63))))
                if (grass2mem[vcount-440][63+250-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
			if (((vcount>=440) & (vcount<=(440+29))) & ((hcount[10:1]>=200) & (hcount[10:1]<=(200+63))))
                if (grass1mem[vcount-440][63+200-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'h32, 8'hcd, 8'h32};
        if (((vcount>=440) & (vcount<=(440+39))) & ((hcount[10:1]>=200) & (hcount[10:1]<=(200+63))))
                if (grass2mem[vcount-440][63+200-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
								
			if (((vcount>=207) & (vcount<=(207+29))) & ((hcount[10:1]>=575) & (hcount[10:1]<=(575+63))))
                if (grass1mem[vcount-207][63+575-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'h32, 8'hcd, 8'h32};
        if (((vcount>=207) & (vcount<=(207+39))) & ((hcount[10:1]>=575) & (hcount[10:1]<=(575+63))))
                if (grass2mem[vcount-207][63+575-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
								
		if (((vcount>=185) & (vcount<=(185+29))) & ((hcount[10:1]>=200) & (hcount[10:1]<=(200+63))))
                if (grass1mem[vcount-185][63+200-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'h32, 8'hcd, 8'h32};
        if (((vcount>=185) & (vcount<=(185+39))) & ((hcount[10:1]>=200) & (hcount[10:1]<=(200+63))))
                if (grass2mem[vcount-185][63+200-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
		if (((vcount>=207) & (vcount<=(207+29))) & ((hcount[10:1]>=150) & (hcount[10:1]<=(150+63))))
                if (grass1mem[vcount-207][63+150-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'h32, 8'hcd, 8'h32};
        if (((vcount>=207) & (vcount<=(207+39))) & ((hcount[10:1]>=150) & (hcount[10:1]<=(150+63))))
                if (grass2mem[vcount-207][63+150-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
								
		if (((vcount>=100) & (vcount<=(100+29))) & ((hcount[10:1]>=540) & (hcount[10:1]<=(540+63))))
                if (grass1mem[vcount-100][63+540-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'h32, 8'hcd, 8'h32};
        if (((vcount>=100) & (vcount<=(100+39))) & ((hcount[10:1]>=540) & (hcount[10:1]<=(540+63))))
                if (grass2mem[vcount-100][63+540-hcount[10:1]] == 1)
                        {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
	
	//#############################  MOLE 1 ####################################
	case (hex0[3:0])
	 default :if (mole1pop==0) 
	        begin
				mole1_x=1000;
				mole1_y=1000;
			  end
			  else begin 
			   mole1_x=temp_mole1_x;
				mole1_y=temp_mole1_y;
			  end
	 4'h1 : begin
				mole1_x=258;
				mole1_y=141;
			  end
	 4'h2 : begin
				mole1_x=368;
				mole1_y=171;
			  end
	 4'h3 : begin
				mole1_x=478;
				mole1_y=141;
			  end
	 4'h4 : begin
				mole1_x=218;
				mole1_y=217;
			  end
	 4'h5 : begin
				mole1_x=368;
				mole1_y=251;
			  end
	 4'h6 : begin
				mole1_x=518;
				mole1_y=217;
			  end
	 4'h7 : begin
				mole1_x=218;
				mole1_y=291;
			  end
	 4'h8 : begin
				mole1_x=368;
				mole1_y=331;
			  end
	 4'h9 : begin
				mole1_x=518;
				mole1_y=291;
			  end
	endcase
	
	if (((vcount>=mole1_y+59-mole1pop) & (vcount<=(mole1_y+75))) & ((hcount[10:1]>=mole1_x) & (hcount[10:1]<=(mole1_x+63))))begin
		if (shape2mem[vcount-mole1_y-59+mole1pop][hcount[10:1]-mole1_x] == 1) 
			{VGA_R, VGA_G, VGA_B} = {8'h66, 8'h33, 8'h00};
		if (shape3mem[vcount-mole1_y-59+mole1pop][hcount[10:1]-mole1_x] == 0)	
			{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
		if (shape4mem[vcount-mole1_y-59+mole1pop][hcount[10:1]-mole1_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
		if (shape5mem[vcount-mole1_y-59+mole1pop][hcount[10:1]-mole1_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'hff, 8'h0, 8'hff};
		if (shape6mem[vcount-mole1_y-59+mole1pop][hcount[10:1]-mole1_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'h00, 8'h0, 8'h0};
		if (shape7mem[vcount-mole1_y-59+mole1pop][hcount[10:1]-mole1_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
	end
	
	
	//#############################  MOLE 2 ####################################
	case (hex0[7:4])
	 default : if (mole2pop==0)
	        begin
				mole2_x=1000;
				mole2_y=1000;
			  end
			  else begin 
			   mole2_x=temp_mole2_x;
				mole2_y=temp_mole2_y;
			  end
	  4'h1 : begin
				mole2_x=258;
				mole2_y=141;
			  end
	 4'h2 : begin
				mole2_x=368;
				mole2_y=171;
			  end
	 4'h3 : begin
				mole2_x=478;
				mole2_y=141;
			  end
	 4'h4 : begin
				mole2_x=218;
				mole2_y=217;
			  end
	 4'h5 : begin
				mole2_x=368;
				mole2_y=251;
			  end
	 4'h6 : begin
				mole2_x=518;
				mole2_y=217;
			  end
	 4'h7 : begin
				mole2_x=218;
				mole2_y=291;
			  end
	 4'h8 : begin
				mole2_x=368;
				mole2_y=331;
			  end
	 4'h9 : begin
				mole2_x=518;
				mole2_y=291;
			  end
	endcase
	
	
	if (((vcount>=mole2_y+59-mole2pop) & (vcount<=(mole2_y+75))) & ((hcount[10:1]>=mole2_x) & (hcount[10:1]<=(mole2_x+63))))begin
		if (shape2mem[vcount-mole2_y-59+mole2pop][hcount[10:1]-mole2_x] == 1) 
			{VGA_R, VGA_G, VGA_B} = {8'h66, 8'h33, 8'h00};
		if (shape3mem[vcount-mole2_y-59+mole2pop][hcount[10:1]-mole2_x] == 0)	
			{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
		if (shape4mem[vcount-mole2_y-59+mole2pop][hcount[10:1]-mole2_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
		if (shape5mem[vcount-mole2_y-59+mole2pop][hcount[10:1]-mole2_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'hff, 8'h0, 8'hff};
		if (shape6mem[vcount-mole2_y-59+mole2pop][hcount[10:1]-mole2_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'h00, 8'h0, 8'h0};
		if (shape7mem[vcount-mole2_y-59+mole2pop][hcount[10:1]-mole2_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
	end
	
	//#############################  MOLE 3 ####################################
	case (hex1[3:0])
	 default : if (mole3pop==0)
	        begin
				mole3_x=1000;
				mole3_y=1000;
			  end
			  else begin 
			   mole3_x=temp_mole3_x;
				mole3_y=temp_mole3_y;
			  end
	  4'h1 : begin
				mole3_x=258;
				mole3_y=141;
			  end
	 4'h2 : begin
				mole3_x=368;
				mole3_y=171;
			  end
	 4'h3 : begin
				mole3_x=478;
				mole3_y=141;
			  end
	 4'h4 : begin
				mole3_x=218;
				mole3_y=217;
			  end
	 4'h5 : begin
				mole3_x=368;
				mole3_y=251;
			  end
	 4'h6 : begin
				mole3_x=518;
				mole3_y=217;
			  end
	 4'h7 : begin
				mole3_x=218;
				mole3_y=291;
			  end
	 4'h8 : begin
				mole3_x=368;
				mole3_y=331;
			  end
	 4'h9 : begin
				mole3_x=518;
				mole3_y=291;
			  end
	endcase
	
	
	if (((vcount>=mole3_y+59-mole3pop) & (vcount<=(mole3_y+75))) & ((hcount[10:1]>=mole3_x) & (hcount[10:1]<=(mole3_x+63))))begin
		if (shape2mem[vcount-mole3_y-59+mole3pop][hcount[10:1]-mole3_x] == 1) 
			{VGA_R, VGA_G, VGA_B} = {8'h66, 8'h33, 8'h00};
		if (shape3mem[vcount-mole3_y-59+mole3pop][hcount[10:1]-mole3_x] == 0)	
			{VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0};
		if (shape4mem[vcount-mole3_y-59+mole3pop][hcount[10:1]-mole3_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
		if (shape5mem[vcount-mole3_y-59+mole3pop][hcount[10:1]-mole3_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'hff, 8'h0, 8'hff};
		if (shape6mem[vcount-mole3_y-59+mole3pop][hcount[10:1]-mole3_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'h00, 8'h0, 8'h0};
		if (shape7mem[vcount-mole3_y-59+mole3pop][hcount[10:1]-mole3_x] == 1)	
			{VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'hff};
	end
	
					
	//################################ LEVEL ######################################
	 
	 if (((vcount>=5) & (vcount<=83)) & ((hcount[10:1]>=10) & (hcount[10:1]<=169)))
           if (scoreboard1mem[vcount-5][169-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'hb6, 8'h9b, 8'h4c};
	    if (((vcount>=5) & (vcount<=79)) & ((hcount[10:1]>=10) & (hcount[10:1]<=169)))
           if (scoreboardmem[vcount-5][169-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h82, 8'h52, 8'h01};
	 if (((vcount>=10) & (vcount<=25)) & ((hcount[10:1]>=40) & (hcount[10:1]<=135)))
           if (levelmem[vcount-10][135-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h33, 8'h99, 8'hff};
	
					
	//################################ SCORE ######################################
	if (((vcount>=135) & (vcount<=213)) & ((hcount[10:1]>=10) & (hcount[10:1]<=169)))
           if (scoreboard1mem[vcount-135][169-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'hb6, 8'h9b, 8'h4c};
	    if (((vcount>=135) & (vcount<=209)) & ((hcount[10:1]>=10) & (hcount[10:1]<=169)))
           if (scoreboardmem[vcount-135][169-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h82, 8'h52, 8'h01};
     if (((vcount>=142) & (vcount<=157)) & ((hcount[10:1]>=17) & (hcount[10:1]<=134)))
           if (scoremem[vcount-142][134-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h33, 8'h99, 8'hff};
					
	//################################ TIME ######################################
	if (((vcount>=275) & (vcount<=353)) & ((hcount[10:1]>=10) & (hcount[10:1]<=169)))
           if (scoreboard1mem[vcount-275][169-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'hb6, 8'h9b, 8'h4c};
	    if (((vcount>=275) & (vcount<=349)) & ((hcount[10:1]>=10) & (hcount[10:1]<=169)))
           if (scoreboardmem[vcount-275][169-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h82, 8'h52, 8'h01};
     if (((vcount>=280) & (vcount<=295)) & ((hcount[10:1]>=25) & (hcount[10:1]<=126)))
           if (timemem[vcount-280][126-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h33, 8'h99, 8'hff};				
					
	 //################################ W ##########################################
     if (((vcount>=20) & (vcount<=60)) & ((hcount[10:1]>=180) & (hcount[10:1]<=243)))
           if (momem[vcount-20][243-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'hff};
                   
     //################################ H ##########################################
     if (((vcount>=20) & (vcount<=60)) & ((hcount[10:1]>=253) & (hcount[10:1]<=316)))
           if (momem2[vcount-20][316-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'hff};
                   
     //################################ A ##########################################
     if (((vcount>=20) & (vcount<=60)) & ((hcount[10:1]>=326) & (hcount[10:1]<=389)))
           if (momem3[vcount-20][389-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'hff};
   
    //################################ C ##########################################
     if (((vcount>=20) & (vcount<=60)) & ((hcount[10:1]>=399) & (hcount[10:1]<=462)))
           if (momemc[vcount-20][462-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'hff};
               
     //################################ M ##########################################
     if (((vcount>=80) & (vcount<=120)) & ((hcount[10:1]>=253) & (hcount[10:1]<=316)))
           if (mmem[vcount-80][316-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'hff};
               
     //################################ O ##########################################
     if (((vcount>=80) & (vcount<=120)) & ((hcount[10:1]>=326) & (hcount[10:1]<=389)))
           if (omem[vcount-80][389-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'hff};
   
    //################################ L ##########################################
     if (((vcount>=80) & (vcount<=120)) & ((hcount[10:1]>=399) & (hcount[10:1]<=462)))
           if (lmem[vcount-80][462-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'hff};
               
     //################################ E ##########################################
     if (((vcount>=80) & (vcount<=120)) & ((hcount[10:1]>=472) & (hcount[10:1]<=535)))
           if (emem[vcount-80][535-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'hff};
                   
     //################################ DASH ##########################################
     if (((vcount>=36) & (vcount<=51)) & ((hcount[10:1]>=472) & (hcount[10:1]<=487)))
           if (dash[vcount-36][487-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'hff};
               
     //################################ A ##########################################
     if (((vcount>=20) & (vcount<=60)) & ((hcount[10:1]>=497) & (hcount[10:1]<=560)))
           if (momem3[vcount-20][560-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'hff};
               
     //################################ DASH ##########################################
     if (((vcount>=36) & (vcount<=51)) & ((hcount[10:1]>=570) & (hcount[10:1]<=585)))
           if (dash[vcount-36][585-hcount[10:1]] == 1)
               {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'hff}; 
		
		
	/*//DIGITS	
		if ( d_l_1_a|d_l_1_b|d_l_1_c|d_l_1_d|d_l_1_e|d_l_1_f|d_l_1_g )        // In any (inactive) segment?
	  {VGA_R, VGA_G, VGA_B} = {8'h20, 8'h20, 8'h20}; // Dark Gray	*/	
	 
	//MUD TO COVER THE POPPING

//MUD TO HOLE 1
if (((vcount>=201) & (vcount<=(219))) & ((hcount[10:1]>=230) & (hcount[10:1]<=(350))))			
			if (mudmem[vcount-201][350-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};			
if (((vcount>=205) & (vcount<=(223))) & ((hcount[10:1]>=230) & (hcount[10:1]<=(350))))			
			if (mudmem[vcount-205][350-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};

//MUD TO HOLE 2			
if (((vcount>=231) & (vcount<=(249))) & ((hcount[10:1]>=340) & (hcount[10:1]<=(460))))			
			if (mudmem[vcount-231][460-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
if (((vcount>=235) & (vcount<=(253))) & ((hcount[10:1]>=340) & (hcount[10:1]<=(460))))			
			if (mudmem[vcount-235][460-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
			
//MUD TO HOLE 3			
if (((vcount>=201) & (vcount<=(219))) & ((hcount[10:1]>=450) & (hcount[10:1]<=(570))))			
			if (mudmem[vcount-201][hcount[10:1]-570]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
if (((vcount>=205) & (vcount<=(223))) & ((hcount[10:1]>=450) & (hcount[10:1]<=(570))))			
			if (mudmem[vcount-205][570-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};

//MUD TO HOLE 4			
if (((vcount>=271) & (vcount<=(289))) & ((hcount[10:1]>=190) & (hcount[10:1]<=(310))))			
			if (mudmem[vcount-271][310-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
if (((vcount>=275) & (vcount<=(293))) & ((hcount[10:1]>=190) & (hcount[10:1]<=(310))))			
			if (mudmem[vcount-275][310-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
if (((vcount>=217+73) & (vcount<=217+75)) & ((hcount[10:1]>=218) & (hcount[10:1]<=218+63)))
			{VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
			
//MUD TO HOLE 5			
if (((vcount>=311) & (vcount<=(329))) & ((hcount[10:1]>=340) & (hcount[10:1]<=(460))))			
			if (mudmem[vcount-311][460-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
if (((vcount>=315) & (vcount<=(333))) & ((hcount[10:1]>=340) & (hcount[10:1]<=(460))))			
			if (mudmem[vcount-315][460-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};

//MUD TO HOLE 6			
if (((vcount>=271) & (vcount<=(289))) & ((hcount[10:1]>=490) & (hcount[10:1]<=(610))))			
			if (mudmem[vcount-271][610-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
if (((vcount>=275) & (vcount<=(293))) & ((hcount[10:1]>=490) & (hcount[10:1]<=(610))))			
			if (mudmem[vcount-275][610-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
if (((vcount>=217+73) & (vcount<=217+75)) & ((hcount[10:1]>=518) & (hcount[10:1]<=518+63)))
			{VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
			
//MUD TO HOLE 7			
if (((vcount>=351) & (vcount<=(369))) & ((hcount[10:1]>=190) & (hcount[10:1]<=(310))))			
			if (mudmem[vcount-351][310-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
if (((vcount>=355) & (vcount<=(373))) & ((hcount[10:1]>=190) & (hcount[10:1]<=(310))))			
			if (mudmem[vcount-355][310-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};

//MUD TO HOLE 8			
if (((vcount>=391) & (vcount<=(409))) & ((hcount[10:1]>=340) & (hcount[10:1]<=(460))))			
			if (mudmem[vcount-391][460-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
if (((vcount>=395) & (vcount<=(413))) & ((hcount[10:1]>=340) & (hcount[10:1]<=(460))))			
			if (mudmem[vcount-395][460-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};			
			

//MUD TO HOLE 9			
if (((vcount>=351) & (vcount<=(369))) & ((hcount[10:1]>=490) & (hcount[10:1]<=(610))))			
			if (mudmem[vcount-351][610-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};
if (((vcount>=355) & (vcount<=(373))) & ((hcount[10:1]>=490) & (hcount[10:1]<=(610))))			
			if (mudmem[vcount-355][610-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'ha0, 8'h52, 8'h2d};					
	
	
	//################################# HAMMER ########################################
	
	case (hex1[7:4])
	 default : begin
				hammer_x=119;
				hammer_y=69;
			  end
	 4'h1 : begin
				hammer_x=290;
				hammer_y=207;
			  end
	 4'h2 : begin
				hammer_x=400;
				hammer_y=237;
			  end
	 4'h3 : begin
				hammer_x=510;
				hammer_y=207;
			  end
	 4'h4 : begin
				hammer_x=250;
				hammer_y=277;
			  end
	 4'h5 : begin
				hammer_x=400;
				hammer_y=317;
			  end
	 4'h6 : begin
				hammer_x=550;
				hammer_y=277;
			  end
	 4'h7 : begin
				hammer_x=250;
				hammer_y=357;
			  end
	 4'h8 : begin
				hammer_x=400;
				hammer_y=397;
			  end
	 4'h9 : begin
				hammer_x=550;
				hammer_y=357;
			  end
	endcase
	
	if ((hex1[7:4]==0)&((vcount>=hammer_y) & (vcount<=(hammer_y+95))) & ((hcount[10:1]>=hammer_x) & (hcount[10:1]<=(hammer_x+95)))) begin
			if (hammermem[vcount-hammer_y][hammer_x+95-hcount[10:1]] == 1) 
				{VGA_R, VGA_G, VGA_B} = {8'h99, 8'h4c, 8'h00};
			if (hammer2mem[vcount-hammer_y][hammer_x+95-hcount[10:1]] == 1)
            {VGA_R, VGA_G, VGA_B} = {8'hcc, 8'h66, 8'h00};
	end
	
	
	if ((hex1[7:4]!=0)&((vcount>=hammer_y-117) & (vcount<=(hammer_y-22))) & ((hcount[10:1]>=hammer_x-52) & (hcount[10:1]<=(hammer_x+43)))) begin
			if (hammermem[hcount[10:1]-hammer_x+52][vcount-hammer_y+117] == 1) 
				{VGA_R, VGA_G, VGA_B} = {8'h99, 8'h4c, 8'h00};
			if (hammer2mem[hcount[10:1]-hammer_x+52][vcount-hammer_y+117] == 1)
            {VGA_R, VGA_G, VGA_B} = {8'hcc, 8'h66, 8'h00};
			if ((hex1[7:4]==hex1[3:0])|(hex1[7:4]==hex0[7:4])|(hex1[7:4]==hex0[3:0]))
			   if ((vcount>=(hammer_y-53)) & (vcount<=(hammer_y-22)))
		        if 	(hammer3mem[vcount-hammer_y+53][hammer_x+43-hcount[10:1]] == 1) 
				{VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
	end
	
	//################################# SCORE DECODER #################################
	
	score2=hex3/100;
	score1=(hex3-score2*100)/10;
	score0=(hex3-score2*100-score1*10);
	
	if (((vcount>=170) & (vcount<=201)) & ((hcount[10:1]>=107) & (hcount[10:1]<=138)))
	case(score0)
		//default:;
		default:if (zero[vcount-170][138-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		1:if (one[vcount-170][138-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		2:if (two[vcount-170][138-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		3:if (three[vcount-170][138-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		4:if (four[vcount-170][138-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		5:if (five[vcount-170][138-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		6:if (six[vcount-170][138-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		7:if (seven[vcount-170][138-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		8:if (eight[vcount-170][138-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		9:if (nine[vcount-170][138-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
	endcase
	
	if (((vcount>=170) & (vcount<=201)) & ((hcount[10:1]>=66) & (hcount[10:1]<=97)))
	case(score1)
		//default:;
		default:if (zero[vcount-170][97-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		1:if (one[vcount-170][97-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		2:if (two[vcount-170][97-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		3:if (three[vcount-170][97-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		4:if (four[vcount-170][97-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		5:if (five[vcount-170][97-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		6:if (six[vcount-170][97-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		7:if (seven[vcount-170][97-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		8:if (eight[vcount-170][97-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		9:if (nine[vcount-170][97-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
	endcase
	
	if (((vcount>=170) & (vcount<=201)) & ((hcount[10:1]>=25) & (hcount[10:1]<=56)))
	case(score2)
		//default:;
		default:if (zero[vcount-170][56-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		1:if (one[vcount-170][56-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		2:if (two[vcount-170][56-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		3:if (three[vcount-170][56-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		4:if (four[vcount-170][56-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		5:if (five[vcount-170][56-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		6:if (six[vcount-170][56-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		7:if (seven[vcount-170][56-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		8:if (eight[vcount-170][56-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		9:if (nine[vcount-170][56-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};		
	endcase
	
	// ################################## TIME DECODER #################################
	time1=(hex4/10);
	time0=(hex4-time1*10);
	
	if (((vcount>=310) & (vcount<=341)) & ((hcount[10:1]>=81) & (hcount[10:1]<=112)))
	case(time0)
		//default:;
		default:if (zero[vcount-310][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		1:if (one[vcount-310][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		2:if (two[vcount-310][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		3:if (three[vcount-310][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		4:if (four[vcount-310][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		5:if (five[vcount-310][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		6:if (six[vcount-310][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		7:if (seven[vcount-310][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		8:if (eight[vcount-310][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		9:if (nine[vcount-310][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
	endcase
	
	if (((vcount>=310) & (vcount<=341)) & ((hcount[10:1]>=40) & (hcount[10:1]<=71)))
	case(time1)
		//default:;
		default:if (zero[vcount-310][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		1:if (one[vcount-310][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		2:if (two[vcount-310][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
      3:if (three[vcount-310][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
      4:if (four[vcount-310][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
      5:if (five[vcount-310][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
      6:if (six[vcount-310][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
      7:if (seven[vcount-310][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
      8:if (eight[vcount-310][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
      9:if (nine[vcount-310][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};		
	endcase			
		// ################################## LEVEL DECODER #################################		
	level1=(hex5/10);
	level0=(hex5-level1*10);
	
	if (((vcount>=40) & (vcount<=71)) & ((hcount[10:1]>=81) & (hcount[10:1]<=112)))
	case(level0)
		//default:;
		default:if (zero[vcount-40][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		1:if (one[vcount-40][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		2:if (two[vcount-40][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		3:if (three[vcount-40][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		4:if (four[vcount-40][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		5:if (five[vcount-40][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		6:if (six[vcount-40][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		7:if (seven[vcount-40][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		8:if (eight[vcount-40][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		9:if (nine[vcount-40][112-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
	endcase	
	
	if (((vcount>=40) & (vcount<=71)) & ((hcount[10:1]>=40) & (hcount[10:1]<=71)))
	case(level1)
		//default:;
		default:if (zero[vcount-40][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		1:if (one[vcount-40][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		2:if (two[vcount-40][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		3:if (three[vcount-40][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		4:if (four[vcount-40][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		5:if (five[vcount-40][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		6:if (six[vcount-40][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		7:if (seven[vcount-40][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		8:if (eight[vcount-40][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};
		9:if (nine[vcount-40][71-hcount[10:1]]==1) {VGA_R, VGA_G, VGA_B} = {8'hff, 8'hff, 8'h00};		
	endcase
			
			

			
end
	
   /* logic 			     inChar; // In any character

   assign inChar = (vcount[9:7] == 3'd1) &
		   (hcount[10:7] != 4'd0 & hcount[10:7] != 4'd9);
   
   logic [2:0] 			     charx; // Coordinate within the 8x16 char
   logic [3:0] 			     chary;

   assign charx = hcount[6:4];
   assign chary = vcount[6:3];

   logic horizBar, leftCol, rightCol, topCol, botCol; // Parts of the disp.

   assign horizBar = !(charx[2:1] == 2'b11);  // When in any horizontal bar
   assign leftCol  = (charx == 3'd0);         // When in left column
   assign rightCol = (charx == 3'd5);         // When in right column
   assign topCol   = !chary[3] & !(chary[2:0] == 3'd7); // Top columns
   assign botCol   = (chary >= 4'd6) & (chary <= 4'd12); // Bottom columns

   logic [7:0] segment; // True when in each segment
   assign segment[0] = horizBar & (chary == 4'd 0);
   assign segment[1] = rightCol & topCol;
   assign segment[2] = rightCol & botCol;
   assign segment[3] = horizBar & (chary == 4'd 12);
   assign segment[4] = leftCol & botCol;
   assign segment[5] = leftCol & topCol;
   assign segment[6] = horizBar & (chary == 4'd 6);
   assign segment[7] = (charx == 3'd6) & (chary == 4'd14);

   logic [2:0] column; // Being displayed
   assign column = hcount[9:7];
   
   logic [7:0] curSegs;
   assign curSegs = column == 3'd1 ? hex0 :
		    column == 3'd2 ? hex1 :
		    column == 3'd3 ? hex2 :
		    column == 3'd4 ? hex3 :
		    column == 3'd5 ? hex4 :
		    column == 3'd6 ? hex5 :
		    column == 3'd7 ? hex6 :
		    hex7; //
			 
   
   always_comb begin
      {VGA_R, VGA_G, VGA_B} = {8'h0, 8'h0, 8'h0}; // Black
      if (inChar)
	if ( |(curSegs & segment) ) // In any active segment?
	  {VGA_R, VGA_G, VGA_B} = {8'hff, 8'h00, 8'h00}; // Red
	else if ( |segment )        // In any (inactive) segment?
	  {VGA_R, VGA_G, VGA_B} = {8'h20, 8'h20, 8'h20}; // Dark Gray
   end  
	*/
    
	
endmodule // VGA_LED_Emulator
