
clear all;
close all;
clc;


stream = [];
%image =imread('3.JPG');
%% Convert Image To YCBCR
%image = rgb2ycbcr(image);
image = randi([0 256],8, 8)


image = [100 0 0 100 0 77 0 88;
         100 0 0 0 0 0 0 0;
         100 0 0 0 0 0 0 0;
         100 200 0 0 0 0 0 32;
         100 0 0 0 0 0 0 0;
         100 0 0 0 0 0 0 0;
         0 0 0 0 0 0 0 100;
         0 0 0 0 0 0 0 100];
       
[row, col, dim] = size(image);
image = image - 128;
q=  [16 16 16 16 32 64 64 64;
      16 16 16 16 54 64 64 64;
      16 16 16 32 32 64 64 64;
      16 16 32 32 32 64 64 64;
      32 32 32 64 128 128 128 128;
      64 64 64 64 128 128 128 128;
      128 128 128 128 128 128 128 128;
      128 128 128 128 128 128 128 128];


%% Segmenting Image Blocks Of 8x8
%% DCT operation
k=0;
image_arr = zeros(row,col);
for i = 1:row
    for j = 1:col
    image_arr(i,j) = image(i,j);
    end
end
fileInput = fopen('input.txt','w');
for i=1:8:col
    for j=1:8:row
        input =image_arr(i:i+7,j:j+7);
   
        for x = 1:8
            for y = 1:8
                fprintf(fileInput,'%d ', (input(x,y)+128));
                
            end
            fprintf(fileInput,'\n');
        end
        
        
        for a=1:8
            input(:,a) = dct1(input(:,a));
        end
        for a=1:8
            input(a,:) = dct1(input(a,:));
        end     
        output = input ./ q;
        k=k+1; 
        for b=1:8
             for c=1:8
                if output(b,c) < 0
                   output(b,c) = floor(output(b,c)) + 1;
                else 
                    output(b,c) = floor(output(b,c));
                end
             end
        end; 
        out(k,:) = zigzag(output);
    end
end
fclose(fileInput);

%% Huffman Compression
dpcm(1,1)=out(1,1);
stream = cat(2,stream,huffman_dc(dpcm(1,1)),huffman_ac(out(1,2:64)));


for m=2:k
    dpcm(m,1)=out(m,1)-out(m-1,1);
    stream=cat(2,stream,huffman_dc(dpcm(m,1)),huffman_ac(out(m,2:64)));
    huffman_dc(dpcm(m,1))
end
stream

fileOutput = fopen('result_matlab.txt','w');
fprintf(fileOutput,'%s', stream);
fclose(fileOutput);

%% Byte Stuffing
%{
p=0;
G=size(stream,2);
for i=1:8:size(stream,2)
    bit_val(1,1:8)=stream(1,i:i+7);
    if strcmp(bit_val(1,1:8),'11111111')==1
        tempbitstream = stream(1,i+8:G+p);
        stream(1,i+8:i+15)='00000000';
        p=p+8;
        temp2_bitstream=stream(1,1:i+15);
        stream(1,1:G+p)=cat(2,temp2_bitstream,tempbitstream);
    end
end
%}



%% Convert String To Decimal
numbytes=floor(length(stream)/8);
diff_stream=length(stream)-numbytes*8;
if diff_stream==0
    matrix_code_decimal= zeros(numbytes+2,8);
else
    matrix_code_decimal= zeros(numbytes+3,8);
end
s=0;
for count2=1:8:numbytes*8
    s=s+1;
    matrix_code_decimal(s,1)=bin2dec(stream(1,count2:count2+7));
end

if diff_stream~=0
    s=s+1;
    matrix_code_decimal(s,1)=bin2dec(stream(1,numbytes*8+1:length(stream)));
end

matrix_code_decimal(s+1,1)=255;
matrix_code_decimal(s+2,1)=217;


%% Header JFIF
signal=[255	216	255	224	000	016	074	070	073	070	000	001	002	000	000	096	000	096	000	000	...
        255	219	000	067	000 016 016 016 016 016 016 016 016 016 016 032 016 016 016 032 ...
        064 054 032 032 032 064 128 064 032 032 032 064 064 064 064 064 032 064 064 128 ...
        128 128 128 064 128 064 064 064 064 064 128 128 128 128 128 128 128 128 064 128 ...
        128 128 128 128 128 128 128 128 128 255	219	000	067	001	016 016 016 016 016 016 ...
        016 016 016 016 032 016 016 016 032 064 054 032 032 032 064 128 064 032 032 032 ...
        064 064 064 064 064 032 064 064 128 128 128 128 064 128 064 064 064 064 064 128 ...
        128 128 128 128 128 128 128 064 128 128 128 128 128 128 128 128 128 128 255	192 ...
        000	011	008	000	000	000	000	001	001	034	000	255	196	000	031	000	000	001	005	001	...
        001	001	001	001	001	000	000	000	000	000	000	000	000	001	002	003	004	005	006	007	...
        008	009	010	011	255	196	000	181	016	000	002	001	003	003	002	004	003	005 005	004	...
        004	000	000	001	125	001	002	003	000	004	017	005	018	033	049	065	006	019	081	097	...
        007	034	113	020	050	129	145	161	008	035	066	177	193	021	082	209	240	036	051	098	...
        114	130	009	010	022	023	024	025	026	037	038	039	040	041	042	052	053	054	055	056	...
        057	058	067	068	069	070	071	072	073	074	083	084	085	086	087	088	089	090	099	100	...
        101	102	103	104	105	106	115	116	117	118	119	120	121	122	131	132	133	134	135	136	...
        137	138	146	147	148	149	150	151	152	153	154	162	163	164	165	166	167	168	169	170	...
        178	179	180	181	182	183	184	185	186	194	195	196	197	198	199	200	201	202	210	211	...
        212	213	214	215	216	217	218	225	226	227	228	229	230	231	232	233	234	241	242	243	...
        244	245	246	247	248	249	250	255	218	000	008	001	001	000	000	063	000];
  
    % Start of Image (SOI) marker:FFD8=255,216
% JFIF marker:FFE0=255,224
%        Length=000,016
%        Identifier:4A46494600=074,070,073,070,000
%        Version=001,002
%        Units=000
%        Xdensity=000,096
%        Ydensity=000,096
%        Xthumbnail=000
%        Ythumbnail=000
%        (RGB)n, n=Xthumbnail*Ythumbnail required 3*n bytes=null

% Define Quantization table marker (luma):FFDB=255,219
%         Length:two bytes that indicate the number of bytes, including the two length bytes, that this header contains=000,067
%         Precision=000 (baseline)
%         Quantization values=016,011,012,014,012,010,016,...,101,103,099 (zigzag)

% Define Quantization table marker (Chroma):FFDB=255,219
%         Length:two bytes that indicate the number of bytes, including the two length bytes, that this header contains=000,067
%         Precision=000 (baseline)
%         Quantization values=017,018,018,024,021,024,047,...,099,099,099 (zigzag)

% Start of frame marker:FFC0=255,192
%         Length:two bytes that indicate the number of bytes, including the two length bytes, that this header contains=000,011
%         Sample precision=008
%         X=000,000 (This will be defined later)
%         Y=000,000 (This will be defined later)
%         Number of components in the image=001
%             * 3 for color baseline
%             * 1 for grayscale baseline
%         Component ID=001
%         H and V sampling factors=034
%         Quantization table number=000

% Define Huffman table marker (DC):FFC4=255,196
%        Length:two bytes that indicate the number of bytes, including the two length bytes, that this header contains=000,031
%        Index=000 (Huffman DC)
%        Bits=The next 16 bytes from an array of unsigned 1-byte integers whose elements give the number of Huffman codes for each possible code length (1-16).
%        Huffman values=000,001,002,...,010,011

% Define Huffman table marker (AC):FFC4=255,196
%        Length:two bytes that indicate the number of bytes, including the two length bytes, that this header contains=000,181
%        Index=016 (Huffman AC)
%        Bits=The next 16 bytes from an array of unsigned 1-byte integers whose elements give the number of Huffman codes for each possible code length (1-16).
%        Huffman values=001,002,003,...,249,250

% Start of Scan marker:FFDA=255,218
%        Length:two bytes that indicate the number of bytes, including the two length bytes, that this header contains=000,008
%        Number of components=001
%        Component ID=001
%        DC and AC table numbers=000
%        Ss=000
%        Se=063
%        Ah and Al=000

%% Define Size Image
Y = dec2hex(row,4);
X = dec2hex(col,4);
signal(1,164) = hex2dec(Y(1,1:2));
signal(1,165) = hex2dec(Y(1,3:4));
signal(1,166) = hex2dec(X(1,1:2));
signal(1,167) = hex2dec(X(1,3:4));

%% Concatenate Coding + Header
JP_STREAM(1,1:size(signal,2))=signal(1,1:size(signal,2));
    
for j=1:1:size(matrix_code_decimal,1)
    JP_STREAM(1,size(signal,2)+j)=matrix_code_decimal(j,1);
end

%% JPG Data Store
JP_STREAM=JP_STREAM';
fid = fopen(['compressed2.JPG'], 'wb');
if fid < 0
    error('Failed to open data file for write');
end
fwrite(fid,JP_STREAM,'uint8'); 
fclose(fid);




