#ifndef _VGA_LED_H
#define _VGA_LED_H

#include <linux/ioctl.h>

#define VGA_LED_DIGITS 8

typedef struct {
  unsigned char digit;    /* 0, 1, .. , VGA_LED_DIGITS - 1 */
  unsigned char segments; /* LSB is segment a, MSB is decimal point */
} vga_led_arg_t;




#define DCT_MAGIC 'q'

/* ioctls and their arguments */
#define DCT_WRITE32_DIGIT  _IOW(DCT_MAGIC, 3, long)
#define DCT_READ_DIGIT  _IOWR(DCT_MAGIC, 2, long)
#endif
