/*
 * Userspace program that communicates with the led_vga device driver
 * primarily through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */

#include <stdio.h>
#include "vga_led.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>

int vga_led_fd;

unsigned long read_data() {
	unsigned long number;
	number = ioctl(vga_led_fd, DCT_READ_DIGIT, 0);
	return number;
}

void write_data(unsigned long number)
{
	ioctl(vga_led_fd, DCT_WRITE32_DIGIT, number);
}

int main(){
		static const char filename[] = "/dev/vga_led";
  		if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
    			fprintf(stderr, "could not open %s\n", filename);
    			return -1;
  		}
		int i = 0;
		int numBlocks = 1;
	/*
		int input[64] = {100, 	0, 	0, 	100,0, 	77, 0, 	88, 
                         100, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 
						 100, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 	
					     100,	200,0, 	0, 	0, 	0, 	0, 	32, 
					     100, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 
					     100, 	0, 	0, 	0, 	0, 	0, 	0, 	0, 
					     0  , 	0, 	0, 	0, 	0, 	0, 	0, 	0, 
						 0  , 	0, 	0, 	0, 	0, 	0, 	0, 	100};
	    
		*/
		int num;
		int input[64];
		FILE *file 		= fopen("rand.txt"	,"r");
		FILE *file_out 	= fopen("output_rand.txt","w");
		
		int input_i = 0;
		int blocks = 1;
		while(blocks <= numBlocks){
					input_i = 0;
					while (input_i < 64){
						fscanf(file, "%d", &num);
						input[input_i] = num;
						input_i += 1;			
					}
					unsigned long message = 0x00000064;	
					printf("\n\nStart\n");		
				    printf("Input:");
					printf("Block:%d", blocks);
					int index;
					for (i = 0; i < 16; i++){
							index = i * 4;
							message = input[index] + 256*input[index+1] + 65536*input[index+2] + 16777216*input[index+3];
							if (i % 2 == 0){
								printf("\n");
							}
							printf("%d, %d, %d, %d, ", input[index], input[index+1], input[index+2], input[index+3]);
			    			write_data(message);			
			  		}
				    unsigned long num;
					int g,j;	
					char zero[6] = "001010";
				    printf("\n\nOutput:");
					for (g = 0; g < 64; g++){
							if (g % 8 == 0){
								printf("\n");
							}
							num = read_data();
							if (num == 0){
							break;
							}
						    //fprintf(file_out, "%lu,", num);
							//printf(" ,%lu, ", num);
						    int category = 0;
						    unsigned long temp[32];
						    unsigned long decimalNum = num;
						    long bitCodedValue[32] = {0};
						    while(decimalNum > 0){
						        temp[category] = decimalNum % 2;
						        category++;
						        decimalNum = decimalNum/2;
						    }
						    int start =  32 - category;
						    for(i = start; i < 32; i ++){
						        bitCodedValue[i]= temp[31-i];
						    }

						    int last = 32;
						    int add = 0;
						    for(i = 31; i > 3; i --){
						        if(bitCodedValue[i] == 0 && bitCodedValue[i-1] == 1 && bitCodedValue[i-2] == 0 && bitCodedValue[i-3] == 1) {
						            for (j = i; j < 32; j++) {
						                add = add + bitCodedValue[j];
						            }
						            if(add == 0) {
						                last = i+1;
						            } 
						        }
						    }
							
						    for(i = 0; i <last; i++) {
						        printf("%ld", bitCodedValue[i]);
								fprintf(file_out, "%ld", bitCodedValue[i]);
						    }
						    //fprintf(file_out, "\n");
							//printf("\n");
			  		}
					//
					blocks = blocks + 1;
		}
		printf("\nEnd");
		fclose(file);
		fclose(file_out);
		return 0;
}

