module PrintCycle(input logic clk, print_reset,
                   /*Vertmat Read Inputs*/
                   input logic [`VERT_WIDTH:0] vertmat_q_b,
                   /*VertMat Memory*/
                   output logic [`VERT_WIDTH:0] vertmat_data_b,
                   output logic [`PRED_WIDTH:0] vertmat_addr_b,
                   output logic vertmat_we_b,
                   /*Screen*/
                   output logic [5:0] frame_char,
                   output logic [5:0] frame_x,
                   output logic [5:0] frame_y,
                   output logic [5:0] line_start,
                   output logic [5:0] line_end,
                   output logic frame_we,
                   output logic print_done);

    enum logic [3:0] {READ, IDLE, CHECK_CYCLE, START_WRITE, FIRST_DIGIT, SECOND_DIGIT, ARROW, RECHECK_CYCLE, FINISH_CYCLE, CLEAN, DONE} state;

    logic [`PRED_WIDTH:0] i, j, k, l; //Indices

    logic [5:0] px, py = -1;
    assign frame_x = px;
    assign frame_y = py;

    always_comb begin
      frame_we = 0;
      frame_char = 0;
      vertmat_addr_b = j;
      vertmat_data_b = 0;
      vertmat_we_b = 0;
      case (state)
        READ: ;
        IDLE: ;
        CHECK_CYCLE: begin
          vertmat_addr_b = j;
          //if (vertmat_q_b[`VERT_WIDTH]) vertmat_addr_b = l;
        end
        START_WRITE: begin
          vertmat_addr_b = j;
        end
        FIRST_DIGIT: begin
          vertmat_addr_b = l;
          vertmat_data_b = {1'b0, vertmat_q_b[`VERT_WIDTH - 1:0]};
          vertmat_we_b = 1;
          frame_we = 1;
          if (l < 10) frame_char = 10;
          else if (l >= 60) frame_char = 6; //To avoid division
          else if (l >= 50) frame_char = 5;
          else if (l >= 40) frame_char = 4;
          else if (l >= 30) frame_char = 3;
          else if (l >= 20) frame_char = 2;
          else frame_char = 1;
        end
        SECOND_DIGIT: begin
          vertmat_we_b = 0;
          vertmat_addr_b = l;
          frame_we = 1;
			   if (l == 0) frame_char = 0;
          else if (l < 10) frame_char = l;
          else if (l >= 60) frame_char = l - 60;
          else if (l >= 50) frame_char = l - 50;
          else if (l >= 40) frame_char = l - 40;
          else if (l >= 30) frame_char = l - 30;
          else if (l >= 20) frame_char = l - 20;
          else frame_char = l- 10;
        end
        ARROW: begin
          vertmat_addr_b = l;
          if (l != k) begin
            frame_we = 1;
            frame_char = 37;
          end
          else begin
		  	 frame_we = 1;
            frame_char = 0;
  		  end
        end
        RECHECK_CYCLE: vertmat_addr_b = l;
        CLEAN: begin
        	frame_we =1;
        	frame_char =0;
       	end
        default: ;
      endcase
    end

    always_ff @(posedge clk) begin
      if (print_reset) begin
        i <= 0;
        j <= 0;
        k <= -1;
        l <= 0;
        print_done <= 0;
        state <= READ;
        line_start <= py +1;
      end else case (state)
        READ: begin
          k <= -1;
          if (j + 1 == `NODES) begin
            state <= DONE;
          end else begin
            j <= j + 1;
            state <= IDLE;
          end
        end
        IDLE: begin
          k <= j;
          state <= CHECK_CYCLE;
        end
        CHECK_CYCLE: begin
          //l <= vertmat_q_b[(`VERT_WIDTH-1):(`WEIGHT_WIDTH+1)];
          if (vertmat_q_b[`VERT_WIDTH]) state <= START_WRITE;
          else state <= READ;
        end
        START_WRITE: begin
          if (py + 1 == 30) begin
            py <= 0;
            px <= 0;
          end else begin
            py <= py + 1;
            px <= 0;
          end
			 state <= FIRST_DIGIT;
        end
        FIRST_DIGIT: begin
          l <= vertmat_q_b[(`VERT_WIDTH-1):(`WEIGHT_WIDTH+1)];
          if (px + 1 == 40 && py + 1 == 30) begin
            py <= 0;
            px <= 0;
          end else if (px + 1 == 40) begin
            py <= py + 1;
            px <= 0;
          end else px <= px + 1;
          state <= SECOND_DIGIT;
        end
        SECOND_DIGIT: begin
          if (px + 1 == 40 && py + 1 == 30) begin
            py <= 0;
            px <= 0;
          end else if (px + 1 == 40) begin
            py <= py + 1;
            px <= 0;
          end else px <= px + 1;
          state <= ARROW;
        end
        ARROW: begin
          if (px + 1 == 40 && py + 1 == 30) begin
            py <= 0;
            px <= 0;
          end else if (px + 1 == 40) begin
            py <= py + 1;
            px <= 0;
          end else px <= px + 1;
          state <= RECHECK_CYCLE;
        end
        RECHECK_CYCLE: begin
          if (l == k) state <= CLEAN;
          else begin
            state <= FIRST_DIGIT;
          end
        end
        CLEAN: begin
        	if(px+1==40) state <= READ;
        	else px <= px +1;
       	end
        DONE: begin
			print_done <= 1;
			line_end <= py;
		end
        default: state <= DONE;
      endcase
    end
endmodule
