//control function definition

#include "control.h"
#include <stdio.h>
#include <stdlib.h>
#include "vga_led.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include "usbkeyboard.h"
#include "fbputchar.h"
#include "control.h"


char file_name[5];
int x = 0;
int y = 0;
int last_map_num = 0;
unsigned char message[18] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};
char facing_state = 'U';
int if_event = 0;
char possession[];
int map_num;


/* Read and print the segment values */
void print_segment_info() {
  vga_led_arg_t vla;
  int i;

  for (i = 0 ; i < VGA_LED_DIGITS ; i++) {
    vla.digit = i;
    if (ioctl(vga_led_fd, VGA_LED_READ_DIGIT, &vla)) {
      perror("ioctl(VGA_LED_READ_DIGIT) failed");
      return;
    }
    printf("%02x ", vla.segments);
  }
  printf("\n");
}

/* Write the contents of the array to the display */
void write_segments(const unsigned char segs[8])
{
  vga_led_arg_t vla;
  int i;
  for (i = 0 ; i < VGA_LED_DIGITS ; i++) {
    vla.digit = i;
    vla.segments = segs[i];
    if (ioctl(vga_led_fd, VGA_LED_WRITE_DIGIT, &vla)) {
      perror("ioctl(VGA_LED_WRITE_DIGIT) failed");
      return;
    }
  }
}




//get start location function
void set_start_location(int map_num){
  switch(map_num){
      case 1: 
	if (last_map_num < map_num){  
        	x = 14;
        	y = 12;
	}
	else{
		x = 4;
		y = 5;
		face_down();
	}
        break;

      case 2: 
        if (last_map_num < map_num){
        	x = 6;
        	y = 15;
		face_down();
	}
	else{
		x = 30;
		y = 17;
		face_left();
	}
        break;

      case 3: 
        if (last_map_num < map_num){
        	x = 2;
        	y = 17;
		face_right();
	}
	else if (last_map_num == 4){
		x = 31;
		y = 17;
		face_left();
	}
	else if (last_map_num == 8){
		x = 17;
		y = 15;
		face_down();
	}
        break;

      case 4: 
        if (last_map_num < map_num){
        	x = 1;
        	y = 3;
		face_down();
	}
	else{
		x = 26;
		y = 18;
		face_up();
	}
        break;

      case 5: 
        if (last_map_num < map_num){
        	x = 4;
        	y = 7;
		face_down();
	}
	else{
		x = 26;
		y = 18;
		face_up();
	}
        break;

      case 6: 
        if (last_map_num < map_num){
        	x = 1;
        	y = 16;
		face_right();
	}
	else{
		x = 26;
		y = 18;
		face_up();
	}
        break;

      case 7: 
        if (last_map_num < map_num){
        	x = 1;
        	y = 6;
		face_right();
	}
	else{
		x = 26;
		y = 18;
		face_up();
	}
        break;

      case 8: 
        if (last_map_num < map_num){
        	x = 30;
        	y = 7;
		face_down();
	}
	else{
		x = 26;
		y = 18;
		face_up();
	}
        break;

      case 9: 
        x = 14;
        y = 19;
	face_up();
        break;

      case 10: 
        x = 15;
        y = 11;
	face_down();
        break;

      case 11: 
        x = 16;
        y = 11;
	face_down();
        break;
    }
}


//assign new map information

void get_map_info(int map_num){
  switch(map_num){
      case 1: 
        map = map1;
        break;
      case 2: 
        map = map2;
        break;
      case 3: 
        map = map3;
        break;
      case 4: 
        map = map4;
        break;

/**********************/
      case 5: 
        map = map5;
        break;
      case 6: 
        map = map6;
        break;
      case 7: 
        map = map7;
        break;
      case 8: 
        map = map8;
        break;
      case 9: 
        map = map9;
        break;
      case 10: 
        map = map10;
        break;
      case 11: 
        map = map11;
        break;
/**********************/
    }
}

int get_facing_state(){
    int temp;
    switch(facing_state){
      case 'U':
        temp = 5;
        return temp;
        break;
      case 'D': 
        temp = 2;
        return temp;
        break;
      case 'L': 
        temp = 8;
        return temp;
        break;
      case 'R': 
        temp = 11;
        return temp;
        break;
    }
}




//eric void
void eric_void(){
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = 0;
    message[7] = 0; 
    message[8] = 0;
    message[9] = 0;
    message[10] = 5;
    message[11] = 0;
    write_segments(message);
    usleep(100000);
}


//character facing
void face_up(){
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 5;
    message[11] = 0;
    write_segments(message);
    facing_state = 'U';
    usleep(100);
}

void face_down(){
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 2;
    message[11] = 0;
    write_segments(message);
    facing_state = 'D';
    usleep(100);
}

void face_left(){
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 8;
    message[11] = 0;
    write_segments(message);
    facing_state = 'L';
    usleep(100);
}

void face_right(){
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 11;
    message[11] = 0;
    write_segments(message);
    facing_state = 'R';
    usleep(100);
}


void move_up(){
  if (facing_state != 'U'){
    face_up();
  }
  else{
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18-6)/256;
    message[9] = (y*18-6)%256;
    message[10] = 4;
    message[11] = 0;
    write_segments(message);
    usleep(50000);
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18-12)/256;
    message[9] = (y*18-12)%256;
    message[10] = 6;
    message[11] = 0;
    write_segments(message);
    usleep(50000);
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18-18)/256;
    message[9] = (y*18-18)%256;
    message[10] = 5;
    message[11] = 0;
    write_segments(message);
    usleep(100);
    y -= 1;
  }
}


void move_down(){
  if (facing_state != 'D'){
    face_down();
  }
  else{
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18+6)/256;
    message[9] = (y*18+6)%256;
    message[10] = 1;
    message[11] = 0;
    write_segments(message);
    usleep(50000);
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18+12)/256;
    message[9] = (y*18+12)%256;
    message[10] = 3;
    message[11] = 0;
    write_segments(message);
    usleep(50000);
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18+18)/256;
    message[9] = (y*18+18)%256;
    message[10] = 2;
    message[11] = 0;
    write_segments(message);
    usleep(100);
    y += 1;
  }
}

void move_left(){
  if (facing_state != 'L'){
    face_left();
  }
  else{
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19-6)/256;
    message[7] = (x*19-6)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 7;
    message[11] = 0;
    write_segments(message);
    usleep(50000);
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19-13)/256;
    message[7] = (x*19-13)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 9;
    message[11] = 0;
    write_segments(message);
    usleep(50000);
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19-19)/256;
    message[7] = (x*19-19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 8;
    message[11] = 0;
    write_segments(message);
    usleep(100);
    x -= 1;
  }
}

void move_right(){
  if (facing_state != 'R'){
    face_right();
  }
  else{
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19+6)/256;
    message[7] = (x*19+6)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 10;
    message[11] = 0;
    write_segments(message);
    usleep(50000);
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19+13)/256;
    message[7] = (x*19+13)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 12;
    message[11] = 0;
    write_segments(message);
    usleep(50000);
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19+19)/256;
    message[7] = (x*19+19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 11;
    message[11] = 0;
    write_segments(message);
    usleep(100);
    x += 1;
  }
}

void general_movement(){

    libusb_interrupt_transfer(keyboard, endpoint_address,
            (unsigned char *) &packet, sizeof(packet),
            &transferred, 0);
    if (transferred == sizeof(packet)) {
    printf("\n");
    printf("%02x %02x %02x\n", packet.modifiers, packet.keycode[0],packet.keycode[1]);  
    }

	//space
    if (packet.keycode[0] == 0x2c){
	print_dialog(possession);
    }

    //right
    else if (packet.keycode[0] == 0x4f && x <= 31 && map[y][x+1] != -1){
        move_right();
    }
    //left
    else if (packet.keycode[0] == 0x50 && x >= 1 && map[y][x-1] != -1){
        move_left();
    }
    //down
    else if (packet.keycode[0] == 0x51 && y <= 25 && map[y+1][x] != -1){
        move_down();
    }
    //up
    else if (packet.keycode[0] == 0x52 && y >= 1 && map[y-1][x] != -1){
        move_up();
    }
    //change facing when encounter obstacle
    //right
    else if (packet.keycode[0] == 0x4f){
          face_right();
    }
    //left
    else if (packet.keycode[0] == 0x50){
          face_left();
    }
    //down
    else if (packet.keycode[0] == 0x51){
          face_down();
    }
    //up
    else if (packet.keycode[0] == 0x52){
          face_up();
    }




    printf("\nx: %d, y: %d", x, y); 
	printf("\nmap_num = %d", map_num);
	printf("\nget_facing_state: %d", get_facing_state());



    if (map[y][x] != 0 && map[y][x] != -1){
      se_door();
      printf("switched map");
      eric_void();
      last_map_num = map_num;
      map_num = map[y][x];
      print_map(map_num);
      get_map_info(map_num);
      set_start_location(map_num);
    }

   // if ( if_event != 0){
     // break;
   // }

}




//send map information and print map
//NOTE: print_map does will set Eric's location to (0,0) (except begining of the game)
//which means Eric will not print out when print map is called
//in order to print Eric's sprite, please use set_start_location()

void print_map(int map_num){
   if (last_map_num != 0){
   	 x = 0;
   	 y = 0;
    }
    FILE * fp;
    char * line = NULL;
    size_t len = 0;
    ssize_t read;
    int count = 0;
    char temp[] = "0000";

    int r = 0;
    int g = 0;
    int b = 0;
    int addr_1 = 0;
    int addr_2 = 0;
    int addr_3 = 0;

    switch(map_num){
      case 1: 
        strcpy(file_name, "1.mif");
        break;
      case 2: 
        strcpy(file_name, "2.mif");
        break;
      case 3: 
        strcpy(file_name, "3.mif");
        break;
      case 4: 
        strcpy(file_name, "4.mif");
        break;
      case 5: 
        strcpy(file_name, "5.mif");
        break;
      case 6: 
        strcpy(file_name, "6.mif");
        break;
      case 7: 
        strcpy(file_name, "7.mif");
        break;
      case 8: 
        strcpy(file_name, "8.mif");
        break;
      case 9: 
        strcpy(file_name, "9.mif");
        break;
      case 10: 
        strcpy(file_name, "10.mif");
        break;
      case 11: 
        strcpy(file_name, "11.mif");
        break;

    }


    fp = fopen(file_name, "r");
    if (fp == NULL)
        exit(EXIT_FAILURE);


    while ((read = getline(&line, &len, fp)) != -1) {
      if (count >= 9 && line[0] != 'E'){
    	int i = offset;
        for (i; i <= offset+3; i++){
        	temp[i-offset] = line[i];
        	if (temp[i-offset] == ' '){
        	  temp[i-offset] = '0';
        	}
        }
        int data = atoi(temp);
        int address = count - 9;
    r = data/256;
    g = (data%256)/16;
    b = data%16;
    addr_1 = address/65536;
    addr_2 = (address%65536)/256;
    addr_3 = address%256;
    message[0] = r;
    message[1] = g;
    message[2] = b;
    message[3] = addr_1;
    message[4] = addr_2;
    message[5] = addr_3;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = get_facing_state();
    message[11] = 1;
    write_segments(message);
    
      }
      count++;
    }

    fclose(fp);

    message[11] = 0;
    write_segments(message);


}



void print_cover(){

    FILE * fp;
    char * line = NULL;
    size_t len = 0;
    ssize_t read;
    int count = 0;
    char temp[] = "0000";

    int r = 0;
    int g = 0;
    int b = 0;
    int addr_1 = 0;
    int addr_2 = 0;
    int addr_3 = 0;


    fp = fopen("welcome_cover.mif", "r");
    if (fp == NULL)
        exit(EXIT_FAILURE);


    while ((read = getline(&line, &len, fp)) != -1) {
      if (count >= 9 && line[0] != 'E'){
    	int i = offset;
        for (i; i <= offset+3; i++){
        	temp[i-offset] = line[i];
        	if (temp[i-offset] == ' '){
        	  temp[i-offset] = '0';
        	}
        }
        int data = atoi(temp);
        int address = count - 9;
    r = data/256;
    g = (data%256)/16;
    b = data%16;
    addr_1 = address/65536;
    addr_2 = (address%65536)/256;
    addr_3 = address%256;
    message[0] = r;
    message[1] = g;
    message[2] = b;
    message[3] = addr_1;
    message[4] = addr_2;
    message[5] = addr_3;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = get_facing_state();
    message[11] = 1;
    write_segments(message);
    
      }
      count++;
    }

    fclose(fp);

    message[11] = 0;
    write_segments(message);


}
void print_game_over(){
    FILE * fp;
    char * line = NULL;
    size_t len = 0;
    ssize_t read;
    int count = 0;
    char temp[] = "0000";

    int r = 0;
    int g = 0;
    int b = 0;
    int addr_1 = 0;
    int addr_2 = 0;
    int addr_3 = 0;

 
    fp = fopen("game_over.mif", "r");
    if (fp == NULL)
        exit(EXIT_FAILURE);


    while ((read = getline(&line, &len, fp)) != -1) {
      if (count >= 9 && line[0] != 'E'){
    	int i = offset;
        for (i; i <= offset+3; i++){
        	temp[i-offset] = line[i];
        	if (temp[i-offset] == ' '){
        	  temp[i-offset] = '0';
        	}
        }
        int data = atoi(temp);
        int address = count - 9;
    r = data/256;
    g = (data%256)/16;
    b = data%16;
    addr_1 = address/65536;
    addr_2 = (address%65536)/256;
    addr_3 = address%256;
    message[0] = r;
    message[1] = g;
    message[2] = b;
    message[3] = addr_1;
    message[4] = addr_2;
    message[5] = addr_3;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = get_facing_state();
    message[11] = 1;
    write_segments(message);
    
      }
      count++;
    }

    fclose(fp);

    message[11] = 0;
    write_segments(message);


}





void print_pic(){
    FILE * fp;
    char * line = NULL;
    size_t len = 0;
    ssize_t read;
    int count = 0;
    char temp[] = "0000";

    int r = 0;
    int g = 0;
    int b = 0;
    int addr_1 = 0;
    int addr_2 = 0;
    int addr_3 = 0;

    fp = fopen("eric_face_7.mif", "r");
    if (fp == NULL)
        exit(EXIT_FAILURE);


    while ((read = getline(&line, &len, fp)) != -1) {
      if (count >= 9 && line[0] != 'E'){
    	int i = offset;
        for (i; i <= offset+3; i++){
        	temp[i-offset] = line[i];
        	if (temp[i-offset] == ' '){
        	  temp[i-offset] = '0';
        	}
        }
        int data = atoi(temp);
        int address = 640*400+560+((count-9)/80)*640+(count-9)%80;
    r = data/256;
    g = (data%256)/16;
    b = data%16;
    addr_1 = address/65536;
    addr_2 = (address%65536)/256;
    addr_3 = address%256;
    message[0] = r;
    message[1] = g;
    message[2] = b;
    message[3] = addr_1;
    message[4] = addr_2;
    message[5] = addr_3;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = get_facing_state();
    message[11] = 1;
    write_segments(message);
    message[11] = 0;
    write_segments(message);

    
      }
      count++;
    }

    fclose(fp);
}

void print_tran(){
    FILE * fp;
    char * line = NULL;
    size_t len = 0;
    ssize_t read;
    int count = 0;
    char temp[] = "0000";

    int r = 0;
    int g = 0;
    int b = 0;
    int addr_1 = 0;
    int addr_2 = 0;
    int addr_3 = 0;

    fp = fopen("transceiver.mif", "r");
    if (fp == NULL)
        exit(EXIT_FAILURE);


    while ((read = getline(&line, &len, fp)) != -1) {
      if (count >= 9 && line[0] != 'E'){
    	int i = offset;
        for (i; i <= offset+3; i++){
        	temp[i-offset] = line[i];
        	if (temp[i-offset] == ' '){
        	  temp[i-offset] = '0';
        	}
        }
        int data = atoi(temp);
        int address = 640*400+560+((count-9)/80)*640+(count-9)%80;
    r = data/256;
    g = (data%256)/16;
    b = data%16;
    addr_1 = address/65536;
    addr_2 = (address%65536)/256;
    addr_3 = address%256;
    message[0] = r;
    message[1] = g;
    message[2] = b;
    message[3] = addr_1;
    message[4] = addr_2;
    message[5] = addr_3;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = get_facing_state();
    message[11] = 1;
    write_segments(message);
    message[11] = 0;
    write_segments(message);

    
      }
      count++;
    }

    fclose(fp);
}


void print_icon(){
    FILE * fp;
    char * line = NULL;
    size_t len = 0;
    ssize_t read;
    int count = 0;
    char temp[] = "0000";

    int r = 0;
    int g = 0;
    int b = 0;
    int addr_1 = 0;
    int addr_2 = 0;
    int addr_3 = 0;

    fp = fopen("icon.mif", "r");
    if (fp == NULL)
        exit(EXIT_FAILURE);


    while ((read = getline(&line, &len, fp)) != -1) {
      if (count >= 9 && line[0] != 'E'){
    	int i = offset;
        for (i; i <= offset+3; i++){
        	temp[i-offset] = line[i];
        	if (temp[i-offset] == ' '){
        	  temp[i-offset] = '0';
        	}
        }
        int data = atoi(temp);
        int address = 640*400+560+((count-9)/80)*640+(count-9)%80;
	//if (data != 0){
    r = data/256;
    g = (data%256)/16;
    b = data%16;
    addr_1 = address/65536;
    addr_2 = (address%65536)/256;
    addr_3 = address%256;
    message[0] = r;
    message[1] = g;
    message[2] = b;
    message[3] = addr_1;
    message[4] = addr_2;
    message[5] = addr_3;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = get_facing_state();
    message[11] = 1;
    write_segments(message);
    message[11] = 0;
    write_segments(message);
      }
      count++;
    }
	//}
    fclose(fp);
}

void print_edwards(){
    FILE * fp;
    char * line = NULL;
    size_t len = 0;
    ssize_t read;
    int count = 0;
    char temp[] = "0000";

    int r = 0;
    int g = 0;
    int b = 0;
    int addr_1 = 0;
    int addr_2 = 0;
    int addr_3 = 0;

    fp = fopen("edwards.mif", "r");
    if (fp == NULL)
        exit(EXIT_FAILURE);


    while ((read = getline(&line, &len, fp)) != -1) {
      if (count >= 9 && line[0] != 'E'){
    	int i = offset;
        for (i; i <= offset+3; i++){
        	temp[i-offset] = line[i];
        	if (temp[i-offset] == ' '){
        	  temp[i-offset] = '0';
        	}
        }
        int data = atoi(temp);
        int address = 640*400+560+((count-9)/80)*640+(count-9)%80;
    r = data/256;
    g = (data%256)/16;
    b = data%16;
    addr_1 = address/65536;
    addr_2 = (address%65536)/256;
    addr_3 = address%256;
    message[0] = r;
    message[1] = g;
    message[2] = b;
    message[3] = addr_1;
    message[4] = addr_2;
    message[5] = addr_3;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = get_facing_state();
    message[11] = 1;
    write_segments(message);
    message[11] = 0;
    write_segments(message);

    
      }
      count++;
    }

    fclose(fp);
}


void clean_screen(int start_height){
    int address = start_height * 640;
    int addr_1 = 0;
    int addr_2 = 0;
    int addr_3 = 0;

    for (address; address < 480*640; address++){
              addr_1 = address/65536;
              addr_2 = (address%65536)/256;
              addr_3 = address%256;
              message[0] = 0;
              message[1] = 0;
              message[2] = 0;
              message[3] = addr_1;
              message[4] = addr_2;
              message[5] = addr_3;
              message[6] = (x*19)/256;
              message[7] = (x*19)%256;
              message[8] = (y*18)/256;
              message[9] = (y*18)%256;
              message[10] = get_facing_state();
              message[11] = 1;
              write_segments(message);
    }
    message[11] = 0;
    write_segments(message);
}

void flash_on(int times){
	int i;
    for (i=0; i < times; i++){
              message[12] = 1;
              write_segments(message);
    		usleep(100000);
              message[12] = 0;
              write_segments(message);
    		usleep(100000);

    }
}

void print_evil_eric(int evil_x, int evil_y){
		printf("printing!!!");
             message[10] = 128;
             message[14] = (evil_x*19)/256;
             message[15] = (evil_x*19)%256;
             message[16] = (evil_y*18)/256;
             message[17] = (evil_y*18)%256;
              write_segments(message);

}



void flash_off(int times){
	int i;
    for (i=0; i < times; i++){
              message[12] = 0;
              write_segments(message);
    		usleep(100000);
              message[12] = 1;
              write_segments(message);
    		usleep(100000);

    }
}

void nuk_on(){
              message[12] = 2;
              write_segments(message);

}


void nuk_off(){
              message[12] = 0;
              write_segments(message);


}

void print_dialog(char *msg){
    
    int r = 0;
    int g = 0;
    int b = 0;
    int addr_1 = 0;
    int addr_2 = 0;
    int addr_3 = 0;
    int address = 0;
    char *msgp = msg;
    int pixel;
    int dialog_x, dialog_y, dialog_col, dialog_row;
    dialog_col = 0;
    dialog_row = 0;
    unsigned char pixels, *pixelp = font + FONT_HEIGHT * (*msg);

    clean_screen(480 - DIALOG_HEIGHT);


    while(*msgp != '\0'){
    pixelp = font + FONT_HEIGHT * (*msgp);
      for (dialog_y = 0 ; dialog_y < FONT_HEIGHT ; dialog_y++) {
          pixels = *pixelp++;
          for (dialog_x = 0 ; dialog_x < FONT_WIDTH ; dialog_x++, pixels <<= 1){
              if (pixels & 0x80) {
                  pixel = 0x0FFF;
              } 
              else {
                  pixel = 0x0000;
              }
              address = (480 - DIALOG_HEIGHT + dialog_row * FONT_HEIGHT) * 640 + dialog_y * 640 + dialog_col * FONT_WIDTH + dialog_x; 
              r = pixel/256;
              g = (pixel%256)/16;
              b = pixel%16;
              addr_1 = (address >> 16);
              addr_2 = ((address%65536)>>8);
              addr_3 = address%256;
              message[0] = r;
              message[1] = g;
              message[2] = b;
              message[3] = addr_1;
              message[4] = addr_2;
              message[5] = addr_3;
              message[6] = (x*19)/256;
              message[7] = (x*19)%256;
              message[8] = (y*18)/256;
              message[9] = (y*18)%256;
              message[10] = get_facing_state();
              message[11] = 1;
              write_segments(message);
              message[11] = 0;
              write_segments(message);
      }
    		} 
      msgp++;
      if (dialog_col < 60){
        dialog_col++;
      }
      else{
        dialog_col = 0;
        dialog_row++;
      }
    }

    message[11] = 0;
    write_segments(message);
        
}



void retrieve_map(int map_num, int height){
    FILE * fp;
    char * line = NULL;
    size_t len = 0;
    ssize_t read;
    int count = 0;
    char temp[] = "0000";

    int r = 0;
    int g = 0;
    int b = 0;
    int addr_1 = 0;
    int addr_2 = 0;
    int addr_3 = 0;

    switch(map_num){
      case 1: 
        strcpy(file_name, "1.mif");
        break;
      case 2: 
        strcpy(file_name, "2.mif");
        break;
      case 3: 
        strcpy(file_name, "3.mif");
        break;
      case 4: 
        strcpy(file_name, "4.mif");
        break;
    }


    fp = fopen(file_name, "r");
    if (fp == NULL)
        exit(EXIT_FAILURE);


    while ((read = getline(&line, &len, fp)) != -1) {
      if (count >= (9 + 640 * height) && line[0] != 'E'){
    	int i = offset;
        for (i; i <= offset+3; i++){
        	temp[i-offset] = line[i];
        	if (temp[i-offset] == ' '){
        	  temp[i-offset] = '0';
        	}
        }
        int data = atoi(temp);
        int address = count - 9;
    r = data/256;
    g = (data%256)/16;
    b = data%16;
    addr_1 = address/65536;
    addr_2 = (address%65536)/256;
    addr_3 = address%256;
    message[0] = r;
    message[1] = g;
    message[2] = b;
    message[3] = addr_1;
    message[4] = addr_2;
    message[5] = addr_3;
    message[6] = (x*19)/256;
    message[7] = (x*19)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = get_facing_state();
    message[11] = 1;
    write_segments(message);
    
      }
      count++;
    }

    fclose(fp);

    message[11] = 0;
    write_segments(message);


}


void check_skip(){
    while(1){
            libusb_interrupt_transfer(keyboard, endpoint_address,(unsigned char *) &packet, sizeof(packet),&transferred, 0);
            if (transferred == sizeof(packet)) {
               printf("\n");
               printf("%02x %02x %02x\n", packet.modifiers, packet.keycode[0],packet.keycode[1]);  
            }
    	    if (packet.keycode[0] == 0x49 || packet.keycode[0] == 0x50 || packet.keycode[0] == 0x51 || packet.keycode[0] == 0x52){
               break;
    	    }
    }

}

void check_space(){
    while(1){
            libusb_interrupt_transfer(keyboard, endpoint_address,(unsigned char *) &packet, sizeof(packet),&transferred, 0);
            if (transferred == sizeof(packet)) {
               printf("\n");
               printf("%02x %02x %02x\n", packet.modifiers, packet.keycode[0],packet.keycode[1]);  
            }
    	    if (packet.keycode[0] == 0x2c){
               break;
    	    }
    }

}

void se_door(){
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19+6)/256;
    message[7] = (x*19+6)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 10;
    message[11] = 0;
    message[13] = 140;
    write_segments(message);
    usleep(50); 
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19+6)/256;
    message[7] = (x*19+6)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 10;
    message[11] = 0;
    message[13] = 12;
    write_segments(message);
    usleep(50);
}

void se_welcome(){
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19+6)/256;
    message[7] = (x*19+6)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 10;
    message[11] = 0;
    message[13] = 133;
    write_segments(message);
    usleep(50); 
    message[0] = 0;
    message[1] = 0;
    message[2] = 0;
    message[3] = 0;
    message[4] = 0;
    message[5] = 0;
    message[6] = (x*19+6)/256;
    message[7] = (x*19+6)%256; 
    message[8] = (y*18)/256;
    message[9] = (y*18)%256;
    message[10] = 10;
    message[11] = 0;
    message[13] = 5;
    write_segments(message);
    usleep(50);
}




































