module audio_effects (
    input  clk,
    input  sample_end,
    input  sample_req,
    output [15:0] audio_output,
    input  [15:0] audio_input,
    input  [3:0]  control,
	 input  [3:0]  song_crl,
	 input  song_begin
);


reg [15:0] romdata;
reg [16:0]  index = 16'd0;

reg [15:0] last_sample;
reg [15:0] dat;

wire [15:0] trans1, trans2,trans3,trans4,trans5,trans6,trans7,trans8,trans9,trans10,trans11,trans12;

assign audio_output = dat;

parameter SINE     = 0;
parameter FEEDBACK = 1;

/*ROM1 Computer (.address(index[14:0]),.q(trans1),.clock(clk));
ROM2 Devil1 (.address(index),.q(trans2),.clock(clk));
ROM3 Door4 (.address(index),.q(trans3),.clock(clk));
ROM4 Drips (.address(index[12:0]),.q(trans4),.clock(clk));
*/
ROM5 Death (.address(index[14:0]),.q(trans5),.clock(clk));
//ROM6 Key (.address(index[11:0]),.q(trans6),.clock(clk));

//ROM7 Leakage (.address(index[14:0]),.q(trans7),.clock(clk));
/*ROM8 Monster1 (.address(index[13:0]),.q(trans8),.clock(clk));
ROM9 Monster2 (.address(index[14:0]),.q(trans9),.clock(clk));
*/
//ROM10 Move2 (.address(index[13:0]),.q(trans10),.clock(clk));
//ROM11 Move3 (.address(index[13:0]),.q(trans11),.clock(clk));
ROM12 Open5 (.address(index[13:0]),.q(trans12),.clock(clk));

always @(posedge clk) begin
    if (sample_end) begin
        last_sample <= audio_input;
    end

    if (sample_req) begin
        if (control[FEEDBACK])
            dat <= last_sample;
        else if (control[SINE]) begin
		  
		  if (song_begin == 1'b1)
		  index <= 16'd00;
		  else begin
				case (song_crl)
				//4'b0000 : 
				//begin 						
					//if (index < 13'd5552) begin
						//index <= index + 1'b1;	
						//dat <= trans1;						
					//end else
						//dat <= 16'd0;
				//end
						
				/*4'b0001 : 	//ROM1		
				begin 						
					if (index < 15'd18175) begin
						index <= index + 1'b1;	
						dat <= trans1;						
					end else
						dat <= 16'd0;
				end
				4'b0010 : //ROM2
				begin 						
					if (index < 16'd46079) begin
						index <= index + 1'b1;	
						dat <= trans2;						
					end else
						dat <= 16'd0;
				end
				4'b0011 : //ROM3
				begin 						
					if (index < 16'd35839) begin
						index <= index + 1'b1;	
						dat <= trans3;						
					end else
						dat <= 16'd0;
				end
				4'b0100 : //ROM4
				begin 						
					if (index < 13'd5000) begin
						index <= index + 1'b1;	
						dat <= trans4;						
					end else
						dat <= 16'd0;
				end*/
				4'b0101 : //ROM5
				begin 						
					if (index < 15'd24569) begin
						index <= index + 1'b1;	
						dat <= trans5;						
					end else
						dat <= 16'd0;
				end
				/*4'b0110 ://ROM6 
				begin 						
					if (index < 12'd2559) begin
						index <= index + 1'b1;	
						dat <= trans6;						
					end else
						dat <= 16'd0;
				end
				
				4'b0111 : //ROM7
				begin 						
					if (index < 15'd22775) begin
						index <= index + 1'b1;	
						dat <= trans7;						
					end else
						dat <= 16'd0;
				end
				4'b1000 : //ROM8
				begin 						
					if (index < 14'd12791) begin
						index <= index + 1'b1;	
						dat <= trans8;						
					end else
						dat <= 16'd0;
				end
				4'b1001 : //ROM9
				begin 						
					if (index < 15'd16887) begin
						index <= index + 1'b1;	
						dat <= trans9;						
					end else
						dat <= 16'd0;
				end */
				/*4'b1010 : //ROM10
				begin 						
					if (index < 14'd8951) begin
						index <= index + 1'b1;	
						dat <= trans10;						
					end else
						dat <= 16'd0;
				end*/
				/*4'b1011 : //ROM11
				begin 						
					if (index < 14'd8951) begin
						index <= index + 1'b1;	
						dat <= trans11;						
					end else
						dat <= 16'd0;
				end*/
				4'b1100 : //ROM12
				begin 						
					if (index < 14'd10231) begin
						index <= index + 1'b1;	
						dat <= trans12;						
					end else
						dat <= 16'd0;
				end
				
				default : dat <= 16'd0;
				endcase		  
		  end
		  //dat <= trans;
            
            //if (index == 13'd5552)
                //index <= 13'd00;
            //else
                //index <= index + 1'b1;
					 					 
        end else
            dat <= 16'd0;
    end
end
//always @(posedge song_begin) begin
		   //index <= 13'd00;
//end

endmodule