/*
 * Avalon memory-mapped peripheral for the VGA LED Emulator
 *
 * Stephen A. Edwards
 * Columbia University
 */

module VGA_LED(input logic        clk,
	       input logic 	  reset,
	       input logic [7:0]  writedata,
	       input logic 	  write,
	       input 		  chipselect,
	       input logic [4:0]  address,

	       output logic [7:0] VGA_R, VGA_G, VGA_B,

	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n, 
		output logic [7:0]      VGA_MUSIC_CRL,
	       output logic 	  VGA_SYNC_n);
	 
		logic [23:0] write_line_num;
		logic [11:0] color;
		logic [15:0] x_in, y_in, xv_in, yv_in;
		logic [7:0] map_crl, char_crl,filt_crl;

	VGA_LED_Emulator led_emulator(.clk50(clk), .reset(reset), .VGA_R(VGA_R), .color(color), .write_line_num(write_line_num), .map_crl(map_crl), .x_in(x_in), .y_in(y_in), .xv_in(xv_in), .yv_in(yv_in), .char_crl(char_crl), .filt_crl(filt_crl), 
											.VGA_G(VGA_G), .VGA_B(VGA_B), .VGA_CLK(VGA_CLK), .VGA_HS(VGA_HS), .VGA_VS(VGA_VS), 
											.VGA_BLANK_n(VGA_BLANK_n), .VGA_SYNC_n(VGA_SYNC_n));
   always_ff @(posedge clk)
     if (reset) begin
	color[11:0] <= 12'hFFF;
	write_line_num[7:0] <= 8'h50;
	write_line_num[15:8] <= 8'hFF;
	write_line_num[23:16] <= 8'h02;
	map_crl[7:0] <= 8'h01;
	char_crl[7:0] <= 8'b10000011;
	x_in <= 16'd1;
	y_in <= 16'd55;
	xv_in <= 16'd100;
	yv_in <= 16'd100;

	VGA_MUSIC_CRL <= 8'd1;


     end else if (chipselect && write)
       case (address)
	5'h0 : color[11:8] <= writedata[3:0];
	5'h1 : color[7:4] <= writedata[3:0];
	5'h2 : color[3:0] <= writedata[3:0];
	5'h3 : write_line_num[23:16] <= writedata;
	5'h4 : write_line_num[15:8] <= writedata;
	5'h5 : write_line_num[7:0] <= writedata;
	5'h6 : x_in[15:8] <= writedata;
	5'h7 : x_in[7:0] <= writedata;
	5'h8 : y_in[15:8] <= writedata;
	5'h9 : y_in[7:0] <= writedata;
	5'd10 : char_crl[7:0] <= writedata;
	5'd11 : map_crl[7:0] <= writedata;
	5'd12 : filt_crl[7:0] <= writedata;
	5'd13 : VGA_MUSIC_CRL[7:0] <= writedata;
	5'd14 : xv_in[15:8] <= writedata;
	5'd15 : xv_in[7:0] <= writedata;
	5'd16 : yv_in[15:8] <= writedata;
	5'd17 : yv_in[7:0] <= writedata;

      endcase
	       
endmodule
