module audio_effects(
	input  clk,
	input [1:0] sample_end,
	input [1:0] sample_req,
	input [3:0] control,
	output [15:0] audio_output);  

	//reg[15:0] index_background = 16'd0;
	reg[15:0] count = 16'd0;
	reg[15:0] data;
	reg [15:0] background;
	reg [15:0] alarm;
	reg [15:0] data_out;
	assign audio_output = data_out;
	reg [16:0] addr_background;
	reg [14:0] addr_alarm;
	background  Background(.clock(clk), .address(addr_background), .q(background));
	alarm Alarm(.clock(clk), .address(addr_alarm), .q(alarm));
	
	logic [3:0] state;
	logic flag_alarm;

	
	always @(posedge clk) begin
	if (sample_req) begin
		state <= control;

		/* Background music */
		if (state == 4'd1) begin
				data_out <= background;
				if(addr_background == 17'd80000)
					addr_background <= 17'd0;
				else
					addr_background <= addr_background + 1'b1;
				end

		/* Alarm effect */
		else if (state == 4'd2) begin
		    	data_out <= alarm;
				
				flag_alarm <= 0;
				if(addr_alarm == 15'd20000)begin
					flag_alarm <= 1;
					addr_alarm <= 15'd0;
					state <= 4'b0;
				end
				else if (flag_alarm == 0)
					addr_alarm <= addr_alarm + 1'b1;
				
				end
				
		end
	end

endmodule		
	
	
