module nameIndexCalculation(
							input logic clk65,
							input logic [4:0] displayColumnSync,
							input logic [7:0] nameColumnOffsetSyncTwo,
							input logic nextColumn,
							input logic [4:0] displayRowSync,
							input logic [9:0] nameRowOffsetSyncTwo,
							input logic nextRow,
							output logic [15:0] rdNameRAMAddrSync);

	logic [9:0] nameColumnOffsetSyncThree, nameRowOffsetSyncThree;
	logic [7:0] displayColumnSyncTwo, displayRowSyncTwo;
  logic [7:0] displayColumnCondInc, displayRowCondInc;
  logic [9:0] nameRow;
	logic [15:0] nameIndex;
	logic [15:0] nameColumn, nameRowMult;

	ShiftMultiply64_U16 multiplyNameRow(.A(nameRow) , .Y(nameRowMult));

	always_comb begin
		if(nextColumn) displayColumnCondInc = displayColumnSyncTwo + 5'd1;
		else displayColumnCondInc = displayColumnSyncTwo;

		if(nextRow) displayRowCondInc = displayRowSyncTwo + 5'd1;
		else displayRowCondInc = displayRowSyncTwo;

		nameColumn = displayColumnCondInc + nameColumnOffsetSyncThree;
		nameRow    = displayRowCondInc + nameRowOffsetSyncThree;
		nameIndex  = nameColumn + nameRowMult;

	end

	always_ff @(posedge clk65) begin
		displayColumnSyncTwo       <= displayColumnSync;
		displayRowSyncTwo          <= displayRowSync;
		nameColumnOffsetSyncThree  <= nameColumnOffsetSyncTwo;
		nameRowOffsetSyncThree     <= nameRowOffsetSyncTwo;
		rdNameRAMAddrSync          <= nameIndex;
	end
endmodule
