/*
 * Avalon memory-mapped peripheral for the VGA LED Emulator
 *
 * Stephen A. Edwards
 * Columbia University
 */

module VGA_LED(input logic        clk,
	       input logic 	  reset,
	       input logic [7:0]  writedata,
	       input logic 	  write,
	       input 		  chipselect,
	       input logic [2:0]  address,

	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n);

	       logic[10:0] centx;
			 logic[9:0] centy;
   logic [7:0] 			  hex0, hex1, hex2, hex3,
				  hex4, hex5, hex6, hex7;

   VGA_LED_Emulator led_emulator(.clk50(clk), .*);

   always_ff @(posedge clk)
     if (reset) begin
		  centx <= 11'd640;
		  centy <= 10'b0011110000;
			hex0 <= 8'b00000010; // 640 MSB
			hex1 <= 8'b10000000; // 640 LSB
			hex2 <= 8'b00000000; // 240 MSB
			hex3 <= 8'b11110000; // 240 LSB
			hex4 <= 8'b00000000; // 0
			hex5 <= 8'b00000000; // 0
			hex6 <= 8'b00000000; // 0
			hex7 <= 8'b00000000; // 0
		
		end else if (chipselect && write) begin
		 case (address)
		 3'h0 : hex0 <= writedata;
		 3'h1 : hex1 <= writedata;
		 3'h2 : hex2 <= writedata;
		 3'h3 : hex3 <= writedata;
		 3'h4 : hex4 <= writedata;
		 3'h5 : hex5 <= writedata;
		 3'h6 : hex6 <= writedata;
		 3'h7 : hex7 <= writedata;
		 endcase
		 centx[10:8]<= hex0[2:0];
		 centx[7:0] <= hex1;
		 centy[9:8]<= hex2[1:0];
		 centy[7:0] <= hex3;
		 end
	       
endmodule
