module SpriteRotationCalculation(
	input logic clk260,
	input logic [6:0] spritePixelX, spritePixelY,
	input shortint translatedXOrigin, translatedYOrigin,
	input shortint vecXNormalized, vecYNormalized,
	output logic [6:0] spriteZeroXPixelSyncTwo, rdSpriteZeroRAMAddrSync);

	shortint translatedXOriginSyncPipe, translatedYOriginSyncPipe;
	shortint xExtended, yExtended;
	shortint xExtendedSyncPipe, yExtendedSyncPipe;
	int yMultVecX, xMultVecY, yMultVecY, xMultVecX;
	int yMultVecXSyncPipe, xMultVecYSyncPipe, yMultVecYSyncPipe, xMultVecXSyncPipe;
	shortint yMultVecXShifted, xMultVecYShifted, yMultVecYShifted, xMultVecXShifted;
	logic [15:0] spriteRAMIndex,spritePixelIndex;
	logic [15:0] spriteRAMIndexSyncPipe,spritePixelIndexSyncPipe;
	shortint yMultVecXShifted_SUB_xMultVecYShifted, yMultVecYShifted_ADD_xMultVecXShifted;
	shortint yMultVecXShifted_SUB_xMultVecYShiftedSyncPipe, yMultVecYShifted_ADD_xMultVecXShiftedSyncPipe;
	shortint vecXNormalizedSyncPipe, vecYNormalizedSyncPipe;
	logic [6:0] spriteZeroXPixelSync;

	FXP_MULT_FAST yMultVecXModule(.dataa(yExtendedSyncPipe), .datab(vecXNormalizedSyncPipe), .result(yMultVecX));
	FXP_MULT_FAST xMultVecYModule(.dataa(xExtendedSyncPipe), .datab(vecYNormalizedSyncPipe), .result(xMultVecY));
	FXP_MULT_FAST yMultVecYModule(.dataa(yExtendedSyncPipe), .datab(vecYNormalizedSyncPipe), .result(yMultVecY));
	FXP_MULT_FAST xMultVecXModule(.dataa(xExtendedSyncPipe), .datab(vecXNormalizedSyncPipe), .result(xMultVecX));

	assign xExtended[14:8] = spritePixelX;
	assign yExtended[14:8] = spritePixelY;

	assign yMultVecXShifted = yMultVecXSyncPipe >> 8;
	assign xMultVecYShifted = xMultVecYSyncPipe >> 8;
	assign yMultVecYShifted = yMultVecYSyncPipe >> 8;
	assign xMultVecXShifted = xMultVecXSyncPipe >> 8;

	assign yMultVecXShifted_SUB_xMultVecYShifted = yMultVecXShifted - xMultVecYShifted;
	assign yMultVecYShifted_ADD_xMultVecXShifted = yMultVecYShifted + xMultVecXShifted;

	assign spriteRAMIndex   = translatedYOriginSyncPipe + yMultVecXShifted_SUB_xMultVecYShiftedSyncPipe;
	assign spritePixelIndex = translatedXOriginSyncPipe + yMultVecYShifted_ADD_xMultVecXShiftedSyncPipe;

	always_ff @ (posedge clk260) begin

		// Boundary pipeline stage 0
		translatedXOriginSyncPipe <= translatedXOrigin;
		translatedYOriginSyncPipe <= translatedYOrigin;
		xExtendedSyncPipe         <= xExtended;
		yExtendedSyncPipe         <= yExtended;
		vecXNormalizedSyncPipe    <= vecXNormalized;
		vecYNormalizedSyncPipe    <= vecYNormalized;
		// Multiply pipeline stage 1
		yMultVecXSyncPipe <= yMultVecX;
		xMultVecYSyncPipe <= xMultVecY;
		yMultVecYSyncPipe <= yMultVecY;
		xMultVecXSyncPipe <= xMultVecX;
		// Add pipeline stage 2
		yMultVecXShifted_SUB_xMultVecYShiftedSyncPipe <= yMultVecXShifted_SUB_xMultVecYShifted;
		yMultVecYShifted_ADD_xMultVecXShiftedSyncPipe <= yMultVecYShifted_ADD_xMultVecXShifted;
		// Add pipeline stage 3
		spriteRAMIndexSyncPipe   <= spriteRAMIndex[14:8];
		spritePixelIndexSyncPipe <= spritePixelIndex[14:8];
		rdSpriteZeroRAMAddrSync <= spriteRAMIndexSyncPipe;
		spriteZeroXPixelSync    <= spritePixelIndexSyncPipe;
	   spriteZeroXPixelSyncTwo <= spriteZeroXPixelSync;    // Delay one cycle for RAM Read delay
	end

endmodule
