#ifndef _VGA_LED_H
#define _VGA_LED_H

#include <linux/ioctl.h>

#define VGA_LED_DIGITS 8

typedef struct {
  unsigned char digit;    /* 0, 1, .. , VGA_LED_DIGITS - 1 */
  unsigned char segments; /* LSB is segment a, MSB is decimal point */
} vga_led_arg_t;

typedef struct{
  unsigned int x;  //32 bits unsigned int x coordinate of the ball
  unsigned int y;                       //y coordinate of the ball
  unsigned int z;
} circle_center;

typedef struct{
  unsigned int opp_state;
  unsigned int spark;
  unsigned int my_state;
  unsigned int isleft;
  unsigned int atk_state;
  unsigned int idle_state;
  unsigned int def_state;
  unsigned int opp_fist;
  unsigned int other_state; //other state contains audio states, my&opp states
} game_state;

#define VGA_LED_MAGIC 'q'

/* ioctls and their arguments */
#define VGA_LED_WRITE_DIGIT _IOW(VGA_LED_MAGIC, 1, vga_led_arg_t *)
#define VGA_LED_READ_DIGIT  _IOWR(VGA_LED_MAGIC, 2, vga_led_arg_t *)
#define VGA_LED_WRITE_CENTER _IOW(VGA_LED_MAGIC, 3, vga_led_arg_t *)
#define VGA_LED_WRITE_GAME_STATE _IOW(VGA_LED_MAGIC, 4, vga_led_arg_t *)

#endif
