/*
 * Userspace program that communicates with the led_vga device driver
 * primarily through ioctls
 *
 * Stephen A. Edwards
 * Columbia University
 */

#include <stdio.h>
#include "vga_led.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>



int vga_led_fd;




void write_coords(unsigned int x, unsigned int y) {
   circle_center cc;
   cc.x = x;
   cc.y = y;
   if(ioctl(vga_led_fd, VGA_LED_WRITE_CENTER, &cc)) {
      perror("ioctl(VGA_LED_WRITE_CENTER) failed");
   return;
   }
}

void init_vga_led()
{
  static const char filename[] = "/dev/vga_led";

  printf("VGA LED Inilization\n");
  

  if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }

}


int main()
{

  init_vga_led();


  int x = 320;
  int y = 240;
  int dx = 1;
  int dy = 1;
  write_coords(x,y);




//  bool isColl;
 while(1) {
 
  x += dx;
  y += dy;
  write_coords(x, y);
  if(x == 30|| x == 610)
   dx = -dx;
  if(y == 30 || y == 450)
   dy = -dy;
  usleep(5000);

 }



  printf("VGA LED Userspace program terminating\n");
  return 0;
}

