#include "usbkeyboard.h"
#include "vga_led.h"
#include <stdlib.h> 
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <stdio.h>
#include <sys/ioctl.h>





#define ATK_INTV 25000 //25000
#define BLINK_INTV 200000
#define IDL_INTV 100000 //100000
#define DFD_INTV 200000
//set AI boxer parameter here
#define DDG_PROB 7  //7
#define ATK_PROB 3  //3
#define REF_INTV 300000




/************************************************************game variables************************************************/

//keyboard variables
int key_value = 0;  //keyboard read in value
int insign=0;       //keyboard pressed or idle
int temp_insign=0;

//vga led variables
int vga_led_fd;
unsigned int other_state;


//game state variables
int myhealth_state=15;
int opphealth_state = 15;
int game_on=0;


/**************************************************************system functions*************************************************/

//KeyBoard Thread
pthread_t keyboard_thread;
void *keyboard_thread_f(void *ignore)
     { 
     while(1)
       {
       //every time a key is pressed, this part is called six times, which means 6 same key_values are given back.
       // to distinguish the same key_value comes from the same key or no key press at all, use insign to count.
       insign += 1; 
       usbkeyboard(&key_value);
     //  printf("insign: %d\n",insign);
       }
     }




//vga led initialize function


void init_vga_led()
{
  static const char filename[] = "/dev/vga_led";

  if ( (vga_led_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
    return -1;
  }
}


unsigned int gen_other_state(unsigned int audio_state,
                             unsigned int myhealth_state,
                             unsigned int opphealth_state,
                             unsigned int title_state,
                             unsigned int start_state,
                             unsigned int num_state)
{
  unsigned int other_state;
  
  other_state = audio_state | myhealth_state << 2 | opphealth_state << 6 | title_state << 10 | start_state << 11 | num_state << 12;
  return (other_state);
}


//vga ioctl write function

void write_game_state(unsigned int opp_state,
                      unsigned int spark,
		      unsigned int my_state,
		      unsigned int isleft,
		      unsigned int atk_state,
		      unsigned int idle_state,
		      unsigned int def_state,
		      unsigned int opp_fist,
                      unsigned int other_state
                     )
{
  game_state gs;
  gs.opp_state = opp_state;
  gs.spark = spark;  
  gs.my_state = my_state;
  gs.isleft = isleft;
  gs.atk_state = atk_state;
  gs.idle_state = idle_state;
  gs.def_state = def_state;
  gs.opp_fist = opp_fist;
  gs.other_state = other_state;

  if(ioctl(vga_led_fd, VGA_LED_WRITE_GAME_STATE, &gs)){
    // perror("ioctl(VGA_LED_WRITE_GAME_STATE) failed"); 
  }
}




/************************************************************display functions*******************************************************/

void left_atk_hit()
{
  int cnt1,cnt2;
  //                 opp  spark  mys  isleft  atk  idle  def  oppfist                      audio  myhealth  opphealth  title  start  cdnum
  for(cnt1=0; cnt1<7; cnt1++)
    {
    write_game_state(  2,    0,    0,     1, cnt1,    0,   0,       0,  gen_other_state(3, myhealth_state, opphealth_state, 0,   0,   0) );
    usleep(ATK_INTV);
    }
  opphealth_state -= 1;
  write_game_state(  2,    2,      0,     1,    7,    0,   0,     0,    gen_other_state(0, myhealth_state, opphealth_state,0,0,0));
  usleep(5*ATK_INTV);

  for(cnt2=6; cnt2>=0; cnt2--)
    {
    write_game_state(  0,    0,      0,     1, cnt2,  0,   0,     0, gen_other_state(3, myhealth_state, opphealth_state,0,0,0));
    usleep(ATK_INTV);
    }
    
}

void right_atk_hit()
{
  int cnt1,cnt2;
  //                 opp spark mystate isleft    atkstate   idlestate  defstate oppfist        audio   myhealth  opphealth  title  start  cdnum
  for(cnt1=0; cnt1<7; cnt1++)
    {
    write_game_state(  1,    0,      0,     0,       cnt1,        0,        0,     0,  gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
    usleep(ATK_INTV);
    }
  opphealth_state -= 1;
  write_game_state(  1,    3,      0,     0,         7,         0,       0,        0,    gen_other_state(0, myhealth_state, opphealth_state,0,0,0));
  usleep(5*ATK_INTV);

  for(cnt2=6; cnt2>=0; cnt2--)
    {
    write_game_state(  0,    0,      0,     0,       cnt2,        0,        0,     0, gen_other_state(3, myhealth_state, opphealth_state,0,0,0));
    usleep(ATK_INTV);
    }
    
}

void left_atk_ddg()
{
  int cnt1,cnt2;
  //                 opp  spark  mys  isleft  atk  idle  def  oppfist                      audio  myhealth  opphealth title  start  cdnum
  for(cnt1=0; cnt1<3; cnt1++)
    {
    write_game_state(  2,    0,    0,     1, cnt1,    0,   0,       0,  gen_other_state(3, myhealth_state, opphealth_state,0,0,0) );
    usleep(ATK_INTV);
    }

  write_game_state(  4,    0,      0,     1,    3,    0,   0,     0,    gen_other_state(3, myhealth_state, opphealth_state,0,0,0));
  usleep(2*ATK_INTV);

  for(cnt1=4; cnt1<7; cnt1++)
    {
    write_game_state(  4,    0,    0,     1, cnt1,    0,   0,       0,  gen_other_state(3, myhealth_state, opphealth_state,0,0,0) );
    usleep(ATK_INTV);
    }

  write_game_state(  6,    0,      0,     1,    7,    0,   0,     0,    gen_other_state(1, myhealth_state, opphealth_state,0,0,0));
  usleep(4*ATK_INTV);

  for(cnt2=6; cnt2>3; cnt2--)
    {
    write_game_state(  4,    0,      0,     1, cnt2,  0,   0,     0, gen_other_state(3, myhealth_state, opphealth_state,0,0,0));
    usleep(ATK_INTV);
    }

  write_game_state(  4,    0,      0,     1,    3,    0,   0,     0,    gen_other_state(3, myhealth_state, opphealth_state,0,0,0));
  usleep(2*ATK_INTV);

  for(cnt2=3; cnt2>=0; cnt2--)
    {
    write_game_state(  2,    0,      0,     1, cnt2,  0,   0,     0, gen_other_state(3, myhealth_state, opphealth_state,0,0,0));
    usleep(ATK_INTV);
    }
    
}

void right_atk_ddg()
{
  int cnt1,cnt2;
  //                 opp  spark  mys  isleft  atk  idle  def  oppfist                      audio  myhealth  opphealth
  for(cnt1=0; cnt1<3; cnt1++)
    {
    write_game_state(  1,    0,    0,     0, cnt1,    0,   0,       0,  gen_other_state(3, myhealth_state, opphealth_state,0,0,0) );
    usleep(ATK_INTV);
    }

  write_game_state(  3,    0,      0,     0,    3,    0,   0,     0,    gen_other_state(3, myhealth_state, opphealth_state,0,0,0));
  usleep(2*ATK_INTV);

  for(cnt1=4; cnt1<7; cnt1++)
    {
    write_game_state(  3,    0,    0,     0, cnt1,    0,   0,       0,  gen_other_state(3, myhealth_state, opphealth_state,0,0,0) );
    usleep(ATK_INTV);
    }

  write_game_state(  5,    0,      0,     0,    7,    0,   0,     0,    gen_other_state(1, myhealth_state, opphealth_state,0,0,0));
  usleep(4*ATK_INTV);

  for(cnt2=6; cnt2>3; cnt2--)
    {
    write_game_state(  3,    0,      0,     0, cnt2,  0,   0,     0, gen_other_state(3, myhealth_state, opphealth_state,0,0,0));
    usleep(ATK_INTV);
    }

  write_game_state(  3,    0,      0,     0,    3,    0,   0,     0,    gen_other_state(3, myhealth_state, opphealth_state,0,0,0));
  usleep(2*ATK_INTV);

  for(cnt2=3; cnt2>=0; cnt2--)
    {
    write_game_state(  1,    0,      0,     0, cnt2,  0,   0,     0, gen_other_state(3, myhealth_state, opphealth_state,0,0,0));
    usleep(ATK_INTV);
    }
    
}


void dfd_opphit()
{
        write_game_state(0,0,1,0,0,0,1,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
        usleep(DFD_INTV);
        write_game_state(0,0,1,0,0,0,1,2,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
        usleep(DFD_INTV);
        write_game_state(0,0,1,0,0,0,0,3,gen_other_state(2,myhealth_state, opphealth_state,0,0,0));
        usleep(DFD_INTV*0.5);
        write_game_state(0,0,1,0,0,0,0,3,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
        usleep(DFD_INTV*0.5);
}


void dfd_oppidle()
{
        write_game_state(1,0,1,0,0,0,1,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
        usleep(DFD_INTV);
        write_game_state(0,0,1,0,0,0,1,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
        usleep(DFD_INTV);
        write_game_state(2,0,1,0,0,0,1,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
        usleep(DFD_INTV);
        write_game_state(0,0,1,0,0,0,1,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
}
 


void my_idle1()
{
    write_game_state(0,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
    usleep(IDL_INTV);
    write_game_state(0,0,2,0,0,1,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
    usleep(IDL_INTV);
    write_game_state(0,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
}

void my_idle2()
{
    write_game_state(0,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
    usleep(IDL_INTV);
    write_game_state(0,0,2,0,0,2,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
    usleep(IDL_INTV);
    write_game_state(0,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
}


void player_down()
{
       write_game_state(0,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
       write_game_state(0,0,3,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
       write_game_state(0,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
       write_game_state(0,0,3,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
       write_game_state(0,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
       write_game_state(0,0,3,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
}


void AI_down()
{
       write_game_state(0,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
       write_game_state(7,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
       write_game_state(0,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
       write_game_state(7,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
       write_game_state(0,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
       write_game_state(7,0,2,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
       usleep(BLINK_INTV);
}

void countdown()
{
      write_game_state(7,0,0,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,3));
      usleep(1000000); 
      write_game_state(7,0,0,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,2));
      usleep(1000000); 
      write_game_state(7,0,0,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,0,0,1));
      usleep(1000000); 
}

/**************************************************main function************************************************************/

int main()
{
  //initialize devices
  init_keyboard();  
  init_vga_led();
  //initialize game state
  write_game_state(7,0,3,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,1,1,0));
 

  //keyboard thread start
  pthread_create(&keyboard_thread, NULL, keyboard_thread_f, NULL);


/************************************************main loop***********************************************************/
  while(1)
    {
      write_game_state(7,0,3,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,1,1,0));
      usleep(350000);
      if(insign>temp_insign && key_value == 28)
        {
         // insign = 0;
         // temp_insign = insign;
          myhealth_state = 15;
          opphealth_state = 15;
          game_on = 1;
          
          countdown();        
          

	  while(game_on == 1)
	  {
	  if(insign>temp_insign)//check whether a key is pressed
	    {
	    printf("\nkey_value: %d\n\n",key_value);
	   // temp_insign+=6; 
	    if(key_value == 105)
	      {
	      int jud = 1+(int)(10.0*rand()/(RAND_MAX+1.0));
	      printf("jud: %d\n",jud);
	        if(jud>DDG_PROB)
	         left_atk_hit();
	        else
	         left_atk_ddg();
	      }
	    else if(key_value == 106)
	      {
	      int jud = 1+(int)(10.0*rand()/(RAND_MAX+1.0));
	      printf("jud: %d\n",jud);
	        if(jud>DDG_PROB)
	         right_atk_hit();
	        else
	         right_atk_ddg();
	      }
	    else if(key_value == 108 || key_value == 57)
	      {
	      int jud = 1+(int)(10.0*rand()/(RAND_MAX+1.0));
	      if(jud > 8)
	        {
	        dfd_opphit();
	        }
	      else 
	        {
	        dfd_oppidle();
	        }
	      }
	    else if(key_value==1)
              {
	      game_on = 0;
              key_value = 2;
              }
	    temp_insign = insign;
	    }
	  
	  else //no key is pressed
	    {
	    int jud = 1+(int)(10.0*rand()/(RAND_MAX+1.0));
	    if(jud>ATK_PROB)
	      {
	      my_idle1();
	      if(insign>temp_insign)
	      continue;
	      my_idle2();
	      if(insign>temp_insign)
	      continue;
	      }   
	    else
	      {
              usleep(0.5*REF_INTV);
	      write_game_state(0,0,2,0,0,0,0,2,gen_other_state(3,myhealth_state, opphealth_state,0,0,0)); 
	      usleep(REF_INTV);
	      if(insign>temp_insign && (key_value == 108 || key_value == 57))
	         {
	         write_game_state(0,0,1,0,0,0,1,3,gen_other_state(2,myhealth_state, opphealth_state,0,0,0));
	         usleep(DFD_INTV*0.5);
	         write_game_state(0,0,1,0,0,0,0,3,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
	         usleep(DFD_INTV*0.5);
	         temp_insign = insign;
	         }
	      else  
	         {
	         myhealth_state -= 1;
	         write_game_state(0,0,3,0,0,0,0,3,gen_other_state(0,myhealth_state, opphealth_state,0,0,0));
	         usleep(DFD_INTV*0.5);
	         write_game_state(0,0,3,0,0,0,0,3,gen_other_state(3,myhealth_state, opphealth_state,0,0,0));
	         usleep(DFD_INTV*0.5);
	         temp_insign = insign;
	         }
	      } 
	    }  

	 //temp_insign must be updated before the end of one loop 
	  if(myhealth_state == 0 || opphealth_state ==0)
	    {
	     if(myhealth_state == 0)
	       player_down();
	     else
	       AI_down();
	     game_on = 0;
	    }
	  if(key_value==1)
	     game_on = 0;

	  }//while(game_on ==1)
 
     }//if press enter to start
   else if(insign>temp_insign && key_value == 1)
      break;
   write_game_state(7,0,3,0,0,0,0,0,gen_other_state(3,myhealth_state, opphealth_state,1,0,0));
   usleep(350000);
  }//while(1)


/**********************************program ends here*********************************************/
  printf("program ended\n");
  
  pthread_cancel(keyboard_thread);
  pthread_join(keyboard_thread, NULL); 

  return 1;
}
