
//Original audio codec code taken from
//Howard Mao's FPGA blog
//http://zhehaomao.com/blog/fpga/2014/01/15/sockit-8.html
//MOdified as needed

/* audio_effects.sv
    Reads the audio data from the ROM blocks and sends them to the 
    audio codec interface
*/

module audio_effects (
    input  clk, //audio clock
    input  sample_end, //sample ends
    input  sample_req, //request new sample
    output [15:0] audio_output, //sends audio sample to audio codec
  //  input [15:0] M_bell,    //bell sound ROM data
    input [15:0] M_dfd,    //city sound ROM data
    input [15:0] M_ddg, //whoosh sound ROM data
    input [15:0] M_hrt,  //sword sound ROM data
  //  output [14:0] addr_bell,    //ROM addresses
    output [13:0] addr_ddg,
    output [12:0] addr_dfd,
    output [13:0] addr_hrt,
    input  [1:0] control,    //Control from avalon bus
	 input  [2:0] ctrl
);


reg  [13:0]  index_hrt = 14'd0;     //index through the sound ROM data for different sounds
reg  [13:0]  index_ddg = 14'd0;
reg  [12:0]  index_dfd = 13'd0;
//reg  [15:0]  index_sw = 15'd0;
//reg [15:0] count1 = 15'd0;
//reg [15:0] count2 = 15'd0;


reg [15:0] dat;

assign audio_output = dat;

//assign index to ROM addresses
always @(posedge clk) begin
    addr_hrt <= index_hrt; 
    addr_ddg <= index_ddg;
    addr_dfd <= index_dfd;
 //   addr_who <= index_who;
 //   addr_sw <= index_sw;

end

//Keep playing background (city) sound if control is off
//Play sword sound if control is ON

always @(posedge clk) 
begin

    if (sample_req) 
	  begin
      if(control == 2'b00)
        begin
        dat <= M_hrt;
		  if(index_hrt == 14'd9514)
		    index_hrt <= 14'd0;
		  else
			 index_hrt <= index_hrt + 1'b1; 
		  end
		else if(control == 2'b01)
		  begin
		  dat <= M_ddg;
		  if(index_ddg == 14'd8999)
		    index_ddg <= 14'd0;
		  else
		    index_ddg <= index_ddg + 1'b1;
		  end
		else if(control == 2'b10)
		  begin
		  dat <= M_dfd;
		  if(index_dfd == 13'd7999)
		    index_dfd <= 13'd0;
		  else
		    index_dfd <= index_dfd + 1'b1;
		  end
		 else 
		    dat <= 16'd0;
		end
	   
	  else
         dat <= 16'd0;
end

endmodule
