/*
 * Avalon memory-mapped peripheral for the VGA LED Emulator
 *
 * Stephen A. Edwards
 * Columbia University
 */

module VGA_LED(input logic        clk,
	       input logic 	  reset,
	       input logic [31:0]  writedata,
	       input logic 	  write,
	       input 		  chipselect,
	       input logic [2:0]  address,

	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n,
			 
			 output logic [1:0] VGA_audio_control,
			 output logic [1:0] Test
			 
			 );

			 

	logic  [2:0] opp_state;
	logic  [1:0] spark_state;
   logic  [1:0] my_state;
   logic  isleft;
   logic  [2:0] atk_state;
   logic  [1:0] idle_state;
   logic  def_state;
	logic  [1:0] opp_fist_state;
	
	logic  [3:0] myhealth_state;
	logic  [3:0] opphealth_state;
	
	logic  title_state;
	logic  start_state;
    
	logic  [1:0] num_state;
	
	assign VGA_audio_control = writedata[17:16];
	assign Test = writedata[1:0];
	
   VGA_LED_Emulator led_emulator(.clk50(clk), .*);

   always_ff @(posedge clk)
    begin
     if (reset)
	    begin 
		 opp_state <= 3'b111;
		 spark_state <= 2'b00;
		 my_state <= 2'b11;
		 isleft <= 1;
		 atk_state <= 3'b111;
		 idle_state <= 2'b00;
		 def_state <= 0;
		 opp_fist_state <= 2'b00;
		 myhealth_state <= 4'b1111;
		 opphealth_state <= 4'b1111;
		 title_state <= 1;
		 start_state <= 1;
       num_state <= 2'b00;
       end
	  else if (chipselect && write)
	   begin 
		 opp_state <= writedata[2:0];
		 spark_state <= writedata[4:3];
		 my_state <= writedata[6:5];
		 isleft <= writedata[7];
		 atk_state <= writedata[10:8];
		 idle_state <= writedata[12:11];
		 def_state <= writedata[13];
		 opp_fist_state <= writedata[15:14];
		 myhealth_state <= writedata[21:18];
		 opphealth_state <= writedata[25:22];
       title_state <= writedata[26];
		 start_state <= writedata[27];
		 num_state <= writedata[29:28];
       end
	 end
	 
endmodule
