
// Original audio codec code taken from
//Howard Mao's FPGA blog
//http://zhehaomao.com/blog/fpga/2014/01/15/sockit-8.html
//MOdified as needed

/* Audio_top.sv
Contains the top-level audio controller. Instantiates sprite ROM blocks and
communicates with the avalon bus */

module Audio_top (
    input  OSC_50_B8A,   //reference clock
    input  [1:0] audio_ctrl,    
	 inout  AUD_ADCLRCK, //Channel clock for ADC
    input  AUD_ADCDAT,
    inout  AUD_DACLRCK, //Channel clock for DAC
    output AUD_DACDAT,  //DAC data
    output AUD_XCK, 
    inout  AUD_BCLK, // Bit clock
    output AUD_I2C_SCLK, //I2C clock
    inout  AUD_I2C_SDAT, //I2C data
    output AUD_MUTE,   //Audio mute
    input  [3:0] KEY,
    input  [3:0] SW
 //   output [3:0] LED
);

wire reset;
wire main_clk;
wire audio_clk;

assign reset = !KEY[0];

//reg ctrl;
//wire chipselect = 1;

wire [1:0] sample_end;
wire [1:0] sample_req;
wire [15:0] audio_output;


//Sound samples from audio ROM blocks
wire [15:0] M_hrt;
//wire [15:0] M_bgm;
wire [15:0] M_dfd;
wire [15:0] M_ddg;



//Audio ROM block addresses
wire [13:0] addr_hrt;
wire [13:0] addr_ddg;
wire [12:0] addr_dfd;
//wire [16:0] addr_bgm;



//Store sounds in memory ROM blocks
hrt hrt(.clock(OSC_50_B8A), .address(addr_hrt), .q(M_hrt));
ddg ddg(.clock(OSC_50_B8A), .address(addr_ddg), .q(M_ddg));
dfd dfd(.clock(OSC_50_B8A), .address(addr_dfd), .q(M_dfd));


//generate audio clock
clock_pll pll (
    .refclk (OSC_50_B8A),
    .rst (reset),
    .outclk_0 (audio_clk),
    .outclk_1 (main_clk)
);

//Configure registers of audio codec ssm2603
i2c_av_config av_config (
    .clk (audio_clk),
    .reset (reset),
    .i2c_sclk (AUD_I2C_SCLK),
    .i2c_sdat (AUD_I2C_SDAT),
    .status (LED_FAKE)
);

logic [3:0] LED_FAKE;

assign AUD_XCK = audio_clk;
assign AUD_MUTE = (SW != 4'b0);



//Call Audio codec interface
audio_codec ac (
    .clk (audio_clk),
    .reset (reset),
    .sample_end (sample_end),
    .sample_req (sample_req),
    .audio_output (audio_output),
    .channel_sel (2'b10),

    .AUD_ADCLRCK (AUD_ADCLRCK),
    .AUD_ADCDAT (AUD_ADCDAT),
    .AUD_DACLRCK (AUD_DACLRCK),
    .AUD_DACDAT (AUD_DACDAT),
    .AUD_BCLK (AUD_BCLK)
);

//Fetch audio samples from these ROM blocks
audio_effects ae (
    .clk (audio_clk),
    .sample_end (sample_end[1]),
    .sample_req (sample_req[1]),
    .audio_output (audio_output),
  //  .addr_bell(addr_bell),
    .addr_dfd(addr_dfd),
    .addr_ddg(addr_ddg),
    .addr_hrt(addr_hrt),
    .M_dfd(M_dfd),
    .M_ddg(M_ddg),
    .M_hrt(M_hrt),
    .control(audio_ctrl),
	 
	 .ctrl(KEY[3:1])
);

endmodule