#ifndef _VGA_LED_H
#define _VGA_LED_H

#include <linux/ioctl.h>

#define VGA_LED_DIGITS 8

typedef struct {
  unsigned char digit;    /* 0, 1, .. , VGA_LED_DIGITS - 1 */
  unsigned char segments; /* LSB is segment a, MSB is decimal point */
} vga_ball_arg_t;
typedef struct {
unsigned int x;
unsigned int y;
} circle_center;



#define VGA_LED_MAGIC 'q'

/* ioctls and their arguments */
#define VGA_LED_WRITE_DIGIT _IOW(VGA_LED_MAGIC, 1, vga_ball_arg_t *)
#define VGA_LED_READ_DIGIT  _IOWR(VGA_LED_MAGIC, 2, vga_ball_arg_t *)
#define VGA_LED_WRITE_CENTER _IOW(VGA_LED_MAGIC, 3, vga_ball_arg_t *)
#define VGA_LED_WRITE_PAD _IOW(VGA_LED_MAGIC, 4, vga_ball_arg_t *)
#define VGA_LED_WRITE_SCORE _IOW(VGA_LED_MAGIC, 5, vga_ball_arg_t *)
#define VGA_LED_WRITE_LIFE _IOW(VGA_LED_MAGIC, 6, vga_ball_arg_t *)
#define VGA_LED_WRITE_ON _IOW(VGA_LED_MAGIC, 7, vga_ball_arg_t *)
#define VGA_LED_WRITE_AUDIO _IOW(VGA_LED_MAGIC, 8, vga_ball_arg_t *)
#define VGA_LED_WRITE_OVER _IOW(VGA_LED_MAGIC, 9, vga_ball_arg_t *)
#endif
