logic[26:0]    changeColor;

   always_ff @(posedge clk50 or posedge reset)
     if (reset)  changeColor <= 0;
     else if (changeColor[25:0] == 26'h3ffffff)  begin
        changeColor[26] <= 1 - changeColor[26];
        changeColor[25:0] <= 0;
     end
     else   changeColor <= changeColor + 27'd 1;


logic[6:0] line;
always_ff @(posedge clk50) begin

     if(vcount[6:0] > 7'd120) begin
         line = vcount[6:0] - 7'd120;
     end
     else
         line = vount[6:0];
end

logic[19:0] left_sprite_data;
logic background;

left_rom left_unit(
      .clock(clk50),
      .address(line),
      .q(left_sprite_data)
);


logic[19:0] right_sprite_data;

right_rom right_unit(
      .clock(clk50),
      .address(line),
      .q(right_sprite_data)
);

logic[59:0] mid_sprite_data;
logic[1:0] mid_sprite;
logic[7:0] mid_address;
assign mid_address = mide_sprite * 60 + line;

mid_rom mid_unit(
      .clock(clk50),
      .address(mid_address),
      .q(mid_sprite_data)
);

always_comb begin

    if (hcount[10:1] > 19 && hcount[10:1] < 80 || hcount[10:1] > 139 && hcount[10:1] < 200 || hcount[10:1] > 259 && hcount[10:1] < 320 )
         mid_sprite = 0;
    else if (hcount[10:1] > 79 && hcount[10:1] < 140 || hcount[10:1] > 199 && hcount[10:1] < 260)
         mid_sprite = 1;
    else if(hcount[10:1] > 319 && hcount[10:1] < 380 || hcount[10:1] > 439 && hcount[10:1] < 500 || hcount[10:1] > 559 && hcount[10:1] < 620 )
         mid_sprite = 2;
    else 
         mid_sprite = 3;
end

always_comb begin
    if (hcount[10:1] < 20)
       background = left_sprite_data[19 - hcount[10:1]];
    else if (hcount[10:1] > 619)
       background = right_sprite_data[639 - hcount[10:1]];
    else
       background = mid_sprite_data[59 - (hcount[10:1] - 20)%60];
end


always_comb begin

      if (background && (changeColor[26]))
	        {VGA_R, VGA_G, VGA_B} = {8'd60, 8'd210, 8'd144}; // Light Green
      else if (background && (~changeColor[26]))
          {VGA_R, VGA_G, VGA_B} = {8'd40, 8'd145, 8'd100}; // Dark Green
	  else if (changeColor[26])
	        {VGA_R, VGA_G, VGA_B} = {8'd40, 8'd145, 8'd100}; // Dark Green
      else
          {VGA_R, VGA_G, VGA_B} = {8'd60, 8'd210, 8'd144}; // Light Green
			 

end