/*
 * Avalon memory-mapped peripheral for the VGA LED Emulator
 *
 * Stephen A. Edwards
 * Columbia University
 */

module BALL(input logic        clk,
	     	       input logic 	  reset,
	       input logic [31:0]  writedata, 
	       input logic 	  write,
	       input 		  chipselect,
	       input logic  [2:0] address,
			 
	       output logic [7:0] VGA_R, VGA_G, VGA_B,
	       output logic 	  VGA_CLK, VGA_HS, VGA_VS, VGA_BLANK_n,
	       output logic 	  VGA_SYNC_n,
			 
			 
			 
			 
			 inout AUD_I2C_SDAT,
			 output AUD_I2C_SCLK,
			 output AUD_XCK,
			 output AUD_MUTE,
			 inout AUD_ADCLRCK,
			 input AUD_ADCDAT,
			 inout  AUD_DACLRCK,
			 output AUD_DACDAT,
			 inout AUD_BCLK,
			 input logic [3:0]SW);

	 
   logic [9:0] y_coords, x_coords,px;
	logic [31:0] on;
	logic [31:0] score, life;
	logic [3:0] LED;
	wire main_clk,audio_clk;

wire [1:0] sample_end;
wire [1:0] sample_req;
wire [15:0] audio_output;
wire [15:0] audio_input;

pll pll (
.refclk (clk),
.rst (reset),
.outclk_0 (audio_clk),
.outclk_1 (main_clk)
);

i2c_av_config av_config (
.clk (main_clk),
.reset (reset),
.i2c_sclk (AUD_I2C_SCLK),
.i2c_sdat (AUD_I2C_SDAT),
.status (LED)
);
assign AUD_XCK = audio_clk;
assign AUD_MUTE = (SW != 4'b1111);
audio_codec ac (
.clk (audio_clk),
.reset (reset),
.sample_end (sample_end),
.sample_req (sample_req),
.audio_output (audio_output),
.audio_input (audio_input),
.channel_sel (2'b10),
.AUD_ADCLRCK (AUD_ADCLRCK),
.AUD_ADCDAT (AUD_ADCDAT),
.AUD_DACLRCK (AUD_DACLRCK),
.AUD_DACDAT (AUD_DACDAT),
.AUD_BCLK (AUD_BCLK)
);

wire [15:0] data_connection;
logic pad=1'b0;

audio_effects ae (
.pad(pad),
.apple(data_connection),
//.apple(audio_data[15:0]),
.clk (audio_clk),
.peng(peng),
.sample_end (sample_end[1]),
.sample_req (sample_req[1]),
.audio_output (audio_output),
.audio_input (audio_input),
.control (SW),
.en(en),
.addr_r(addr_r),
.continue_wr(c)
);
logic [10:0] addr_r;
logic en;
logic [31:0] audio_data, over;
logic peng=1'b0;
logic c;
logic [31:0]last_on=32'b11111111111111111111111111111111;
logic [4:0] counter, counter2;

RAM_Controller ram_controller (.clk50(main_clk), .sample_req_c(sample_req[1]),.audio_clk(audio_clk), .data_in(audio_data[15:0]), .data_out(data_connection),.ren(en),.address_r(addr_r),.c(c));
 
	

   BALL_Emulator led_emulator(.clk50(main_clk),.*);

   always_ff @(posedge clk)
     if (reset) begin
	x_coords <= 10'd320; // 
	y_coords <= 10'd240; //
	on <= 32'b11111111111111111111111111111111;
	px <= 10'd1;
	score <= 32'd0;
	life <= 32'd9;
	audio_data <= 32'd0;
	over <= 32'd0;

				
     end else if (chipselect && write) begin
	  	last_on<=on;
	  	if(on!=last_on) begin
					peng <= 1'b1;
					counter <= 5'd0;
		end else begin
	
					counter <= counter + 5'd1;
				end
		if(counter==5'd20) begin
				peng <= 1'b0;
				counter <= 5'd0;
		end
			
				
		if(x_coords>=px && x_coords<=(px+128) && (y_coords == (480-32-32-16))) begin
			pad<=1'b1;
			counter2 <= 5'd0;
		end else begin
			counter2 <= counter2 + 5'd1;
			end
		if(counter2==5'd20) begin
			pad <= 1'b0;
			counter2 <= 5'd0;
		end
		
				
   case (address)
	
	3'b000: begin 
	  x_coords <= writedata[19:10];
	 y_coords <= writedata[9:0];
		end
    3'b001: px <= writedata[9:0];
	 3'b010: score <= writedata;
	 3'b011: life <= writedata;
	 3'b100: on<=writedata;
				
				
	 3'b101: audio_data <= writedata;
	 3'b110: over <= writedata;
	 default:;
		
       endcase
	end


	
endmodule
