#include "alt_types.h"

#define DISTANCE 500
#define SIDE_LENGTH 60

#define PI 3.14159265

typedef struct {
  int x, y, z;             // 3D Coordinates
  int screen_x, screen_y;  // Screen coordinates
} point_3d_struct;

alt_8 cube_tris[12][3] = 
{{0,1,2},{1,2,3},
 {4,5,6},{5,6,7},
 {0,1,4},{1,4,5},
 {2,3,6},{3,6,7},
 {0,2,4},{2,4,6},
 {1,3,5},{3,5,7}};

alt_8 cube_lines[12][2] = 
{{0,2},{1,3},{5,7},{4,6},
 {0,1},{2,3},{6,7},{4,5},
 {0,4},{1,5},{3,7},{2,6}};
 
#define CUBE_COUNT_X 300
#define CUBE_COUNT_Y 420

#define TITLE_X 240
#define TITLE_Y 100


void project(point_3d_struct* point, int dist, display_frame_buffer_struct* vga_fb);

void rotate_point( point_3d_struct* in_point, int angle, point_3d_struct* r, point_3d_struct* out_point);

void run_rotate( display_frame_buffer_struct* vga_frame_buffer );

int int_cos( int deg );

int int_sin( int deg );

// This is a integer SIN lookup table
// Values are (SIN(x) * 1024)
short int_sin_array[360]=
{0, 17, 35, 53, 71, 89, 107, 124, 142, 160, 
177, 195, 212, 230, 247, 265, 282, 299, 316, 333, 
350, 366, 383, 400, 416, 432, 448, 464, 480, 496, 
512, 527, 542, 557, 572, 587, 601, 616, 630, 644, 
658, 671, 685, 698, 711, 724, 736, 748, 760, 772, 
784, 795, 806, 817, 828, 838, 848, 858, 868, 877, 
886, 895, 904, 912, 920, 928, 935, 942, 949, 955, 
962, 968, 973, 979, 984, 989, 993, 997, 1001, 1005, 
1008, 1011, 1014, 1016, 1018, 1020, 1021, 1022, 1023, 1023, 
1024, 1023, 1023, 1022, 1021, 1020, 1018, 1016, 1014, 1011, 
1008, 1005, 1001, 997, 993, 989, 984, 979, 973, 968, 
962, 955, 949, 942, 935, 928, 920, 912, 904, 895, 
886, 877, 868, 858, 848, 838, 828, 817, 806, 795, 
784, 772, 760, 748, 736, 724, 711, 698, 685, 671, 
658, 644, 630, 616, 601, 587, 572, 557, 542, 527, 
512, 496, 480, 464, 448, 432, 416, 400, 383, 366, 
350, 333, 316, 299, 282, 265, 247, 230, 212, 195, 
177, 160, 142, 124, 107, 89, 71, 53, 35, 17, 
0, -18, -36, -54, -72, -90, -108, -125, -143, -161, 
-178, -196, -213, -231, -248, -266, -283, -300, -317, -334, 
-351, -367, -384, -401, -417, -433, -449, -465, -481, -497, 
-512, -528, -543, -558, -573, -588, -602, -617, -631, -645, 
-659, -672, -686, -699, -712, -725, -737, -749, -761, -773, 
-785, -796, -807, -818, -829, -839, -849, -859, -869, -878, 
-887, -896, -905, -913, -921, -929, -936, -943, -950, -956, 
-963, -969, -974, -980, -985, -990, -994, -998, -1002, -1006, 
-1009, -1012, -1015, -1017, -1019, -1021, -1022, -1023, -1024, -1024, 
-1024, -1024, -1024, -1023, -1022, -1021, -1019, -1017, -1015, -1012, 
-1009, -1006, -1002, -998, -994, -990, -985, -980, -974, -969, 
-963, -956, -950, -943, -936, -929, -921, -913, -905, -896, 
-887, -878, -869, -859, -849, -839, -829, -818, -807, -796, 
-785, -773, -761, -749, -737, -725, -712, -699, -686, -672, 
-659, -645, -631, -617, -602, -588, -573, -558, -543, -528, 
-512, -497, -481, -465, -449, -433, -417, -401, -384, -367, 
-351, -334, -317, -300, -283, -266, -248, -231, -213, -196, 
-178, -161, -143, -125, -108, -90, -72, -54, -36, -18};


// This is a integer COS lookup table
// Values are (COS(x) * 1024)
short int_cos_array[360]=
{1024, 1023, 1023, 1022, 1021, 1020, 1018, 1016, 1014, 1011, 
1008, 1005, 1001, 997, 993, 989, 984, 979, 973, 968, 
962, 955, 949, 942, 935, 928, 920, 912, 904, 895, 
886, 877, 868, 858, 848, 838, 828, 817, 806, 795, 
784, 772, 760, 748, 736, 724, 711, 698, 685, 671, 
658, 644, 630, 616, 601, 587, 572, 557, 542, 527, 
512, 496, 480, 464, 448, 432, 416, 400, 383, 366, 
350, 333, 316, 299, 282, 265, 247, 230, 212, 195, 
177, 160, 142, 124, 107, 89, 71, 53, 35, 17, 
0, -18, -36, -54, -72, -90, -108, -125, -143, -161, 
-178, -196, -213, -231, -248, -266, -283, -300, -317, -334, 
-351, -367, -384, -401, -417, -433, -449, -465, -481, -497, 
-512, -528, -543, -558, -573, -588, -602, -617, -631, -645, 
-659, -672, -686, -699, -712, -725, -737, -749, -761, -773, 
-785, -796, -807, -818, -829, -839, -849, -859, -869, -878, 
-887, -896, -905, -913, -921, -929, -936, -943, -950, -956, 
-963, -969, -974, -980, -985, -990, -994, -998, -1002, -1006, 
-1009, -1012, -1015, -1017, -1019, -1021, -1022, -1023, -1024, -1024, 
-1024, -1024, -1024, -1023, -1022, -1021, -1019, -1017, -1015, -1012, 
-1009, -1006, -1002, -998, -994, -990, -985, -980, -974, -969, 
-963, -956, -950, -943, -936, -929, -921, -913, -905, -896, 
-887, -878, -869, -859, -849, -839, -829, -818, -807, -796, 
-785, -773, -761, -749, -737, -725, -712, -699, -686, -672, 
-659, -645, -631, -617, -602, -588, -573, -558, -543, -528, 
-512, -497, -481, -465, -449, -433, -417, -401, -384, -367, 
-351, -334, -317, -300, -283, -266, -248, -231, -213, -196, 
-178, -161, -143, -125, -108, -90, -72, -54, -36, -18, 
-1, 17, 35, 53, 71, 89, 107, 124, 142, 160, 
177, 195, 212, 230, 247, 265, 282, 299, 316, 333, 
350, 366, 383, 400, 416, 432, 448, 464, 480, 496, 
512, 527, 542, 557, 572, 587, 601, 616, 630, 644, 
658, 671, 685, 698, 711, 724, 736, 748, 760, 772, 
784, 795, 806, 817, 828, 838, 848, 858, 868, 877, 
886, 895, 904, 912, 920, 928, 935, 942, 949, 955, 
962, 968, 973, 979, 984, 989, 993, 997, 1001, 1005, 
1008, 1011, 1014, 1016, 1018, 1020, 1021, 1022, 1023, 1023};
