
#include <stdio.h>
#include <sys/alt_alarm.h>
#include "system.h"
#include "alt_types.h"
#include "vga_controller.h"
#include "sys/alt_cache.h"
#include "simple_graphics.h"
#include "vga_example.h"
#include "io.h"
#include "kb.h"
#include "altera_avalon_pio_regs.h"

 /*A̹˰*/
#define a_UP    0x77   //W
#define a_DOWN  0x73   //S
#define a_LEFT  0x61   //A
#define a_RIGHT 0x64   //D
#define a_shoot 0x20   //SPACE

/*B̹˰*/
#define b_UP    0x69    //I
#define b_DOWN  0x6b    //K
#define b_LEFT  0x6a    //J
#define b_RIGHT 0x6c    //L
#define b_shoot 0x70    //P

#define ESC   0x21/*˳*/

#define UPWAY    1/*巽*/
#define DOWNWAY  2
#define LEFTWAY  3
#define RIGHTWAY 4

int enemynum=2;/**/
int player_life=3;/*ESC˳ж*/
int ESC_time=0;
struct SHOOT   /*ڵṹ*/
{
    int life;
    int x,y;
    int way;
}shoot[3]={{0,0,0,UPWAY},{0,0,0,UPWAY},{0,0,0,UPWAY}};

struct PLAYER  /*ҽṹ*/
{
    int life;
    int x,y;
    int i,j;
    int way;
}player[1]={1,0,0,3,13,UPWAY};

struct ENEMY  /*˽ṹ*/
{
    int life;
    int x,y;
    int i,j;
    int way;
    int control;
}enemy[2]={{1,0,0,1,1,DOWNWAY,0},{1,0,0,1,2,DOWNWAY,0}};

/**/

void play(display_frame_buffer_struct* vga_frame_buffer);/*Ϸ*/
void map_all(int map[15][15],  display_frame_buffer_struct* vga_frame_buffer);/*ʼͼ*/

void judge_tank_my(int map[15][15],int key,display_frame_buffer_struct* vga_frame_buffer);/*жϼ̹˶*/
void enemy_control(int map[15][15],display_frame_buffer_struct* vga_frame_buffer);/*Ƶ˶*/

void judge_moveshootway(int map[15][15],int i,display_frame_buffer_struct* vga_frame_buffer);/*ڵ˶ʱжڵ*/
void judge_shoot(int m,int map[15][15],int i,display_frame_buffer_struct* vga_frame_buffer);/*жڵе庯*/
void judge_shootway(int map[15][15],int i,display_frame_buffer_struct* vga_frame_buffer);/*ڵʱжϷ*/

void uptank(int i,int j,int color,display_frame_buffer_struct* vga_frame_buffer);/*̹˺*/
void downtank(int i,int j,int color,display_frame_buffer_struct* vga_frame_buffer);
void lefttank(int i,int j,int color,display_frame_buffer_struct* vga_frame_buffer);
void righttank(int i,int j,int color,display_frame_buffer_struct* vga_frame_buffer);

void allcircle(int i,int j,  display_frame_buffer_struct* vga_frame_buffer);/*̹ԲȦ*/
void blank(int i,int j,  display_frame_buffer_struct* vga_frame_buffer);/*հ׺*/

void map_water(int i,int j,  display_frame_buffer_struct* vga_frame_buffer);/*ͼ*/
void map_steel(int i,int j,  display_frame_buffer_struct* vga_frame_buffer);
void map_wall(int i,int j,  display_frame_buffer_struct* vga_frame_buffer);
void map_border(int i,int j,  display_frame_buffer_struct* vga_frame_buffer);
void map_base_enemy(int i,int j,  display_frame_buffer_struct* vga_frame_buffer);
void map_base_player(int i,int j,  display_frame_buffer_struct* vga_frame_buffer);

void fengming(int n);

void end();/*Ϸ*/

alt_u8 count= 0;

void main()
{
     // VGA Device
    // ps2_command(0xff);    //λ
    // ps2_restart();
    vga_controller_dev* vga;
 
    // VGA frame buffer
    display_frame_buffer_struct* vga_frame_buffer;
    printf("| Nios II VGA Controller Reference Design |\n");
    // Open the VGA controller peripheral and allocate the frame buffers on the heap.
    vga = (vga_controller_dev*)alt_vga_open_dev("/dev/VGA");
    vga_frame_buffer = vga_init_no_interrupt( vga, HEAP );
    
    IOWR_ALTERA_AVALON_PIO_DATA(BUZZER_BASE,0x1); //ƶ˿ڸߵƽ

   {play( vga_frame_buffer);}
 //   end();
} 

void play( display_frame_buffer_struct* vga_frame_buffer)/*Ϸ*/
{
 alt_u8 key,flag;int i;int num=0;

//    int map[15][15]={{8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 },/*ʼͼ*/
//                     {8 ,44,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,8 },
//                     {8 ,45,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,8 },
//                     {8 ,0,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,8 },
//                     {8 ,5 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,5 ,5 ,5 ,8 },
//                     {8 ,5 ,0 ,0 ,7 ,7 ,7 ,6 ,7 ,7 ,7 ,5 ,5 ,5 ,8 },
//                     {8 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,5 ,5 ,5 ,8 },
//                     {8 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,8 },
//                     {8 ,0 ,0 ,0 ,0 ,0 ,0 ,6 ,0 ,0 ,0 ,6 ,0 ,0 ,8 },
//                     {8 ,5 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,5 ,5 ,5 ,8 },
//                     {8 ,5 ,0 ,0 ,5 ,5 ,5 ,5 ,5 ,5 ,0 ,5 ,5 ,5 ,8 },
//                     {8 ,5 ,0 ,0 ,5 ,5 ,5 ,5 ,5 ,5 ,0 ,5 ,5 ,5 ,8 },
//                     {8 ,0 ,0 ,0 ,0 ,5 ,5 ,5 ,5 ,5 ,0 ,0 ,0 ,0 ,8 },
//                     {8 ,0 ,0 ,1 ,0 ,5 ,5 ,9 ,5 ,5 ,2 ,0 ,0 ,0 ,8 },
//                     {8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 }};

    int map[15][15]={{8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 },/*ʼͼ*/
                     {8 ,44,0 ,0 ,0 ,5 ,5 ,9 ,5 ,5 ,0 ,0 ,0 ,0 ,8 },
                     {8 ,45,0 ,0 ,0 ,5 ,5 ,5 ,5 ,5 ,0 ,0 ,0 ,0 ,8 },
                     {8 ,0,0 ,0 ,0 ,5 ,5 ,5 ,5 ,5 ,0 ,0 ,0 ,0 ,8 },
                     {8 ,5 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,5 ,5 ,5 ,8 },
                     {8 ,5 ,0 ,0 ,5 ,5 ,5 ,6 ,5 ,5 ,5 ,5 ,5 ,5 ,8 },
                     {8 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,5 ,5 ,5 ,8 },
                     {8 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,8 },
                     {8 ,0 ,0 ,0 ,0 ,0 ,0 ,6 ,0 ,0 ,0 ,6 ,0 ,0 ,8 },
                     {8 ,5 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,5 ,5 ,5 ,8 },
                     {8 ,5 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,0 ,5 ,5 ,5 ,8 },
                     {8 ,5 ,0 ,0 ,5 ,5 ,5 ,5 ,5 ,5 ,0 ,5 ,5 ,5 ,8 },
                     {8 ,0 ,0 ,0 ,0 ,5 ,5 ,5 ,5 ,5 ,0 ,0 ,0 ,0 ,8 },
                     {8 ,0 ,0 ,1 ,0 ,5 ,5 ,10 ,5 ,5 ,0 ,0 ,0 ,0 ,8 },
                     {8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 ,8 }};


   map_all(map, vga_frame_buffer);/*ʼͼ*/
     vid_print_string(470, 90, GREEN_16,cour10_font,vga_frame_buffer ,"Player Life : 3"); 
                vga_flip_frame_buffers( vga_frame_buffer );
                while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
     vid_print_string(470, 90, GREEN_16,cour10_font,vga_frame_buffer ,"Player Life : 3"); 
                vga_flip_frame_buffers( vga_frame_buffer );
                while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
 //    ps2_command(0xff);    //λ
 //   flag=ps2_kbhit();
    while(1)
         
         
        {
                IOWR_ALTERA_AVALON_PIO_DATA(BUZZER_BASE,0x1); //ƶ˿ڸߵƽ
                  
               flag=ps2_kbhit();
               
               
                                       
                if(enemynum==0||player_life==0)/*Ϊ0Ϸ*/ 
                 {  if(enemynum==0)
                       {
                        vid_print_string(500, 150, GREEN_16,cour10_font,vga_frame_buffer ,"YOU WIN!"); 
                         vga_flip_frame_buffers( vga_frame_buffer );
                         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
                     vid_print_string(500, 150, GREEN_16,cour10_font,vga_frame_buffer ,"YOU WIN!"); 
                         vga_flip_frame_buffers( vga_frame_buffer );
                         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
    
                       }
                     else if(player_life==0) 
                             {
                              vid_print_string(500, 150, RED_16,cour10_font,vga_frame_buffer ,"YOU LOSE!");   
                                 vga_flip_frame_buffers( vga_frame_buffer );
                                while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
                           vid_print_string(500, 150, RED_16,cour10_font,vga_frame_buffer ,"YOU LOSE!");   
                               vga_flip_frame_buffers( vga_frame_buffer );
                              while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
     
                             }
                     
                   goto aaa;
                         
                           
                 }                   
                for(i=0;i<3;i++)/*ѭжÿڵ*/
                       if(shoot[i].life==1)/*ڵ״̬Ϊ*/
                          judge_moveshootway(map,i,vga_frame_buffer);/*ڵ˶ʱжڵ*/
                 usleep(1);num++;
                 if(num==10)
                       {
                            enemy_control(map, vga_frame_buffer);/*Ƶ˶*/
                            num=0;
                        }
                        
            //ж̹Ƿ 
            if(player_life!=0&&player[0].life==0) 
               {  player[0].life=1;
                  player[0].x=0;
                  player[0].y=0;
                  player[0].i=3;
                  player[0].j=13;
                  player[0].way=UPWAY;
               }
           //ps2ɨ
  
             printf("%x", flag);
             if(flag == 0xff)     //ȡֵ
      
                {   ps2_restart();
                    key=ps2_getch();  
                    if(key != 0xff)
                      { if(ESC_time == 0)
                             if(key !=ESC) 
                               judge_tank_my(map,key, vga_frame_buffer);/*жϼ̹˶*/
                             else  { ESC_time =1 ; }
                        else
                         if(key == ESC) 
                         {
                                  judge_tank_my(map,key, vga_frame_buffer);/*жϼ̹˶*/
                                   ESC_time =0 ;
                          }
                          else   ESC_time =1 ;
                      }    
                    count =0;           
                 }
             else  printf("22");
            
            
          //ʾֵ

            
      }      
     aaa: ;
   
}


void map_all(int map[15][15], display_frame_buffer_struct* vga_frame_buffer)/*ʼͼ*/
{
    int i,j;
    for(i=0;i<15;i++)
        for(j=0;j<15;j++)
            switch(map[j][i])
                {
                    case 0: break;                  
                    case 5:map_wall(i,j, vga_frame_buffer);break;/**/
                    case 6:map_steel(i,j, vga_frame_buffer);break;
                    case 7:map_water(i,j, vga_frame_buffer);break;
                    case 8:map_border(i,j, vga_frame_buffer);break;
                    case 9:map_base_enemy(i,j, vga_frame_buffer);break;
                    case 10:map_base_player(i,j, vga_frame_buffer);break;
                }
 //uptank(10, 23,GREEN_16,vga_frame_buffer); 
     
    //    vga_flip_frame_buffers( vga_frame_buffer );
   //     while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
  //  lefttank(10,16,GREEN_16,vga_frame_buffer);
//       vga_flip_frame_buffers( vga_frame_buffer );
//         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
}

//void allcircle(int i,int j)/*̹ԲȦĺ*/
//{
//    int x,y;x=30*i+15,y=30*j+15;   
//         
//    arc(x+15,y+15, 90,180,8);   //Բ
//    
//    arc(x+16,y+15,  0, 90,8);
//    arc(x+15,y+16,180,270,8);
//    arc(x+16,y+16,270,360,8);
//    arc(x+15,y+15, 90,180,4);
//    arc(x+16,y+15,  0, 90,4);
//    arc(x+15,y+16,180,270,4);
//    arc(x+16,y+16,270,360,4);
//   
//    vid_draw_circle(int Hcenter, int Vcenter, int radius, int color, char fill, display_frame_buffer_struct* frame_buffer)
//}



void blank(int i,int j,display_frame_buffer_struct* vga_frame_buffer)/*հ׺*/
{
    int x,y;
    x=30*i+15,y=30*j+15;
   // setfillstyle(1,7);
   // bar(x+1,y+1,x+30,y+30);
    vid_draw_box(x+1, y+1,x+30 , y+30, BLACK_16, DO_FILL, vga_frame_buffer);
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
    vid_draw_box(x+1, y+1,x+30 , y+30, BLACK_16, DO_FILL, vga_frame_buffer);
      //  vga_flip_frame_buffers( vga_frame_buffer );
    //      while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
}


void map_water(int i,int j,display_frame_buffer_struct* vga_frame_buffer)/*Ρˮĺ*/
{
    int x,y;x=30*i+15,y=30*j+15;
 //   setfillstyle(1,9);
 //   bar(x+1,y+1,x+30,y+30);
   // setfillstyle(1,7);
  //  bar(x+14,y+1,x+17,y+30);
  //  bar(x+1,y+14,x+30,y+17);
   vid_draw_box(x+1, y+1,x+30 , y+30, BLUE_16, DO_FILL, vga_frame_buffer); 
      vga_flip_frame_buffers( vga_frame_buffer );
     while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
      vid_draw_box(x+1, y+1,x+30 , y+30, BLUE_16, DO_FILL, vga_frame_buffer); 
      vga_flip_frame_buffers( vga_frame_buffer );
     while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
   vid_draw_box(x+14, y+1,x+17 , y+30, BLUE_16, DO_FILL, vga_frame_buffer); 
       vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
         vid_draw_box(x+14, y+1,x+17 , y+30, BLUE_16, DO_FILL, vga_frame_buffer); 
       vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
   vid_draw_box(x+1,y+14,x+30,y+17, BLUE_16, DO_FILL, vga_frame_buffer); 
      vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
     vid_draw_box(x+1,y+14,x+30,y+17, BLUE_16, DO_FILL, vga_frame_buffer); 
        vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
}
void map_steel(int i,int j,display_frame_buffer_struct* vga_frame_buffer)/*Ρ֡ĺ*/
{
    int x,y;x=30*i+15,y=30*j+15;
   // setfillstyle(1,8);
   // bar(x+1,y+1,x+30,y+30);
    vid_draw_box(x+1,y+1,x+30,y+30, GOLD_16, DO_FILL, vga_frame_buffer); 
       vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
       vid_draw_box(x+1,y+1,x+30,y+30, GOLD_16, DO_FILL, vga_frame_buffer); 
        vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
 //   setfillstyle(1,15);
  //  bar(x+3,y+3,x+12,y+12);
  //  bar(x+19,y+3,x+28,y+12);
  //  bar(x+3,y+19,x+12,y+28);
   // bar(x+19,y+19,x+28,y+28);
    vid_draw_box(x+3,y+3,x+12,y+12, GRAY_16, DO_FILL, vga_frame_buffer); 
       vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
           vid_draw_box(x+3,y+3,x+12,y+12, GRAY_16, DO_FILL, vga_frame_buffer); 
       vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
           
    vid_draw_box(x+19,y+3,x+28,y+12, GRAY_16, DO_FILL, vga_frame_buffer); 
      vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
       vid_draw_box(x+19,y+3,x+28,y+12, GRAY_16, DO_FILL, vga_frame_buffer); 
      vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
            
         vid_draw_box(x+3,y+19,x+12,y+28, GRAY_16, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
          vid_draw_box(x+3,y+19,x+12,y+28, GRAY_16, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
          
      vid_draw_box(x+19,y+19,x+28,y+28, GRAY_16, DO_FILL, vga_frame_buffer); 
           vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );   
      vid_draw_box(x+19,y+19,x+28,y+28, GRAY_16, DO_FILL, vga_frame_buffer); 
           vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );     
   
    
}
void map_wall(int i,int j,display_frame_buffer_struct* vga_frame_buffer)/*Ρשĺ*/
{
    int x,y;
    x=30*i+15,y=30*j+15;
//    setfillstyle(1,13);
//    bar(x+1,y+1,x+30,y+30);
//    setcolor(15);
//    line(x+1,y+1,x+30,y+30);
//    line(x+1,y+30,x+30,y+1);
  vid_draw_box(x+1, y+1,x+30 , y+30, WHITE_16, DO_FILL, vga_frame_buffer);
      vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
   vid_draw_box(x+1, y+1,x+30 , y+30, WHITE_16, DO_FILL, vga_frame_buffer);
    //  vga_flip_frame_buffers( vga_frame_buffer );
    //    while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
}

void map_border(int i,int j,display_frame_buffer_struct* vga_frame_buffer)/*Ρ߽硯ĺ*/
{
    int x,y;x=30*i+15,y=30*j+15;
//    setfillstyle(1,8);
//    bar(x+1,y+1,x+30,y+30);
    vid_draw_box(x+1, y+1,x+30 , y+30, WHEAT_16, DO_FILL, vga_frame_buffer);
      vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );   
      vid_draw_box(x+1, y+1,x+30 , y+30, WHEAT_16, DO_FILL, vga_frame_buffer);
          vga_flip_frame_buffers( vga_frame_buffer );
       while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );   
}


void map_base_enemy(int i,int j,display_frame_buffer_struct* vga_frame_buffer)/*ͼЦĺ*/
{
    int x,y;x=30*i+15,y=30*j+15;
 //   setcolor(15);
//    circle(x+15,y+15,10);
//    circle(x+11,y+11,2);
//    circle(x+19,y+11,2);

   vid_draw_circle(x+15, y+15, 10, RED_16, DO_FILL, vga_frame_buffer);
     vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );        
     vid_draw_circle(x+15, y+15, 10, RED_16, DO_FILL, vga_frame_buffer);
     vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
              
}

void map_base_player(int i,int j,display_frame_buffer_struct* vga_frame_buffer)/*ͼЦĺ*/
{
    int x,y;x=30*i+15,y=30*j+15;

   vid_draw_circle(x+15, y+15, 10, GREEN_16, DO_FILL, vga_frame_buffer);
     vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );        
   vid_draw_circle(x+15, y+15, 10, GREEN_16, DO_FILL, vga_frame_buffer);
     vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
                     
}

void uptank(int i,int j,int color,display_frame_buffer_struct* vga_frame_buffer)/*ϵ̹*/

{
    int x,y;x=30*i+15,y=30*j+15;
    
//    setcolor(color);
//    line(x+1,y+4,x+1,y+27);  
//    line(x+7,y+4,x+7,y+27);
//    line(x+24,y+4,x+24,y+27);
//    line(x+30,y+4,x+30,y+27);
//    arc(x+4,y+4,0,180,3);
//    arc(x+4,y+27,180,360,3);
//    arc(x+27,y+4,0,180,3);
//    arc(x+27,y+27,180,360,3);
//    allcircle(i,j);
//    setfillstyle(1,color);
//    bar(x+14,y+1,x+17,y+15);
//    
    vid_draw_box(x+1,y+4,x+7,y+27, color, DO_FILL, vga_frame_buffer); 
        vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
   vid_draw_box(x+1,y+4,x+7,y+27, color, DO_FILL, vga_frame_buffer); 
        vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
   vid_draw_box(x+24,y+4,x+30,y+27, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
         
    vid_draw_box(x+24,y+4,x+30,y+27, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
         
              
     vid_draw_circle(x+15,y+14, 2, color, DO_FILL, vga_frame_buffer);
        vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
       vid_draw_circle(x+15,y+14, 2, color, DO_FILL, vga_frame_buffer);
        vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
         
   vid_draw_box(x+14,y+1,x+17,y+15, color, DO_FILL, vga_frame_buffer); 
       vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );    
     vid_draw_box(x+14,y+1,x+17,y+15, color, DO_FILL, vga_frame_buffer); 
     //  vga_flip_frame_buffers( vga_frame_buffer );
      //   while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );     
} 


void downtank(int i,int j,int color,display_frame_buffer_struct* vga_frame_buffer)/*µ̹*/
{
   int x,y;x=30*i+15,y=30*j+15;
//    setcolor(color);
//    line(x+1,y+4,x+1,y+27);
//    line(x+7,y+4,x+7,y+27);
//    line(x+24,y+4,x+24,y+27);
//    line(x+30,y+4,x+30,y+27);
//    arc(x+4,y+4,0,180,3);
//    arc(x+4,y+27,180,360,3);
//    arc(x+27,y+4,0,180,3);
//    arc(x+27,y+27,180,360,3);
//    allcircle(i,j); 
//    line(x+14,y+16,x+14,y+30);
//    line(x+15,y+16,x+15,y+30);
//    line(x+16,y+16,x+16,y+30);
//    line(x+17,y+16,x+17,y+30);  
     vid_draw_box(x+1,y+4,x+7,y+27, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
     vid_draw_box(x+1,y+4,x+7,y+27, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
         
         
   vid_draw_box(x+24,y+4,x+30,y+27, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );       
    vid_draw_box(x+24,y+4,x+30,y+27, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );       
         
         
         
     vid_draw_circle(x+15,y+14, 2, color, DO_FILL, vga_frame_buffer);
     vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
   vid_draw_circle(x+15,y+14, 2, color, DO_FILL, vga_frame_buffer);
        vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
         
         
   vid_draw_box(x+14,y+16,x+17,y+30, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
     vid_draw_box(x+14,y+16,x+17,y+30, color, DO_FILL, vga_frame_buffer); 
       //  vga_flip_frame_buffers( vga_frame_buffer );
       //  while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
    
        
}

void lefttank(int i,int j,int color,display_frame_buffer_struct* vga_frame_buffer)/*̹*/
{
    int x,y;x=30*i+15,y=30*j+15;
//    setcolor(color);
//    line(x+4,y+1,x+27,y+1);
//    line(x+4,y+7,x+27,y+7);
//    line(x+4,y+24,x+27,y+24);
//    line(x+4,y+30,x+27,y+30);
//    arc(x+4,y+4,90,270,3);
//    arc(x+27,y+4,270,90,3);
//    arc(x+4,y+27,90,270,3);
//    arc(x+27,y+27,270,90,3);
//    line(x+15,y+14,x+1,y+14);
//    line(x+15,y+15,x+1,y+15);
//    line(x+15,y+16,x+1,y+16);
//    line(x+15,y+17,x+1,y+17);
//    allcircle(i,j);  
    
    vid_draw_box(x+4,y+1,x+27,y+7, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );           
   vid_draw_box(x+4,y+1,x+27,y+7, color, DO_FILL, vga_frame_buffer); 
        vga_flip_frame_buffers( vga_frame_buffer );
       while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
        
        
   vid_draw_box(x+4,y+24,x+27,y+30, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );       
     vid_draw_box(x+4,y+24,x+27,y+30, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );       
         
     vid_draw_circle(x+15,y+14, 2, color, DO_FILL, vga_frame_buffer);
     vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
    vid_draw_circle(x+15,y+14, 2, color, DO_FILL, vga_frame_buffer);
     vga_flip_frame_buffers( vga_frame_buffer );
       while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
        
        
   vid_draw_box(x+1,y+14,x+15,y+17, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
    vid_draw_box(x+1,y+14,x+15,y+17, color, DO_FILL, vga_frame_buffer); 
     //    vga_flip_frame_buffers( vga_frame_buffer );
      //  while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  

}

void righttank(int i,int j,int color,display_frame_buffer_struct* vga_frame_buffer)/*ҵ̹*/
{
    int x,y;x=30*i+15,y=30*j+15;
//    setcolor(color);
//    line(x+4,y+1,x+27,y+1);
//    line(x+4,y+7,x+27,y+7);
//    line(x+4,y+24,x+27,y+24);
//    line(x+4,y+30,x+27,y+30);
//    arc(x+4,y+4,90,270,3);
//    arc(x+27,y+4,270,90,3);
//    arc(x+4,y+27,90,270,3);
//    arc(x+27,y+27,270,90,3);
//    line(x+16,y+14,x+30,y+14);
//    line(x+16,y+15,x+30,y+15);
//    line(x+16,y+16,x+30,y+16);
//    line(x+16,y+17,x+30,y+17);
//    allcircle(i,j);
    
     vid_draw_box(x+4,y+1,x+27,y+7, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
     vid_draw_box(x+4,y+1,x+27,y+7, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
         while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
         
          
   vid_draw_box(x+4,y+24,x+27,y+30, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );    
      vid_draw_box(x+4,y+24,x+27,y+30, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );    
           
          
     vid_draw_circle(x+15,y+14, 2, color, DO_FILL, vga_frame_buffer);
     vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
   vid_draw_circle(x+15,y+14, 2, color, DO_FILL, vga_frame_buffer);
     vga_flip_frame_buffers( vga_frame_buffer );
        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
            
   vid_draw_box(x+16,y+14,x+30,y+17, color, DO_FILL, vga_frame_buffer); 
         vga_flip_frame_buffers( vga_frame_buffer );
     while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
   vid_draw_box(x+16,y+14,x+30,y+17, color, DO_FILL, vga_frame_buffer); 
   //     vga_flip_frame_buffers( vga_frame_buffer );
    // while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
       
     
    
}


void judge_shoot(int m,int map[15][15],int i,display_frame_buffer_struct* vga_frame_buffer)/*жڵе庯*/
{
  char *string_life="\0";
    switch(m)
        {
            case 1 :shoot[i].life=0;                              //˻
                    if(i>=1&&i<=2)
                    {
                        player[0].life=0;
                        player_life--;
                   if(player_life==1)
                         {string_life="Player Life : 1\n";
                          }
                    else if(player_life==2)
                    {
                        string_life="Player Life : 2\n";           
                    }
                   else if(player_life==3)
                    {
                        string_life="Player Life : 3\n";
             
                     }
                  
                  vid_draw_box(570, 80 , 600 , 100, BLACK_16, DO_FILL, vga_frame_buffer);
                  vga_flip_frame_buffers( vga_frame_buffer );
                 while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
                 vid_draw_box(570, 80 , 600 , 100, BLACK_16, DO_FILL, vga_frame_buffer);
                   vga_flip_frame_buffers( vga_frame_buffer );
                 while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
                
              vid_print_string(470, 90, GREEN_16,cour10_font,vga_frame_buffer ,string_life); 
                vga_flip_frame_buffers( vga_frame_buffer );
                while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
              vid_print_string(470, 90, GREEN_16,cour10_font,vga_frame_buffer ,string_life); 
                vga_flip_frame_buffers( vga_frame_buffer );
                while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );  
                        judge_shootway(map,i, vga_frame_buffer);
                    }
                    break;
                   
            case 5 :shoot[i].life=0;                              //и        
                    judge_shootway(map,i, vga_frame_buffer);/*жڵ*/
                    break;
            case 7 :shoot[i].life=1;                            //ˮ
                    break;
            case 9 :shoot[i].life=0;                           //һе˻    
                    if(i==0) enemynum=0;
                    break;
           case 10: shoot[i].life=0;                           //˻һ
                   if((i>=1&&i<=2)) player_life=0;
                    break;
                    
            case 44:shoot[i].life=0;                            //ез̹ 1
                    if(i==0)
                    {
                        enemy[0].life=0;enemynum--;
                        judge_shootway(map,i, vga_frame_buffer);/*жڵ*/  
                    }               
                    break;
            case 45:shoot[i].life=0;                             //ез̹2 
                    if(i==0)
                    {
                        enemy[1].life=0;enemynum--;
                        judge_shootway(map,i, vga_frame_buffer);/*жڵ*/                   
                    }
                    break;
                           
        }
}

void enemy_control(int map[15][15],display_frame_buffer_struct* vga_frame_buffer)/*Ƶ˶*/
{
    int i;
    for(i=0;i<3;i++)
        {
            enemy[i].control=rand()%50;/**/
            if(enemy[i].life==1)
                {
                    if(enemy[i].control>=0&&enemy[i].control<=9&&map[enemy[i].j-1][enemy[i].i]==0)/*˶*/
                        {   
                            enemy[i].way=UPWAY;
                            map[enemy[i].j][enemy[i].i]=0; 
                            blank(enemy[i].i,enemy[i].j,vga_frame_buffer);
                            enemy[i].j--;
                            uptank(enemy[i].i,enemy[i].j,RED_16,vga_frame_buffer);
                            map[enemy[i].j][enemy[i].i]=44+i;
                        }
                    else if(enemy[i].control>=10&&enemy[i].control<=19&&map[enemy[i].j+1][enemy[i].i]==0)/*˶*/
                        {   
                            enemy[i].way=DOWNWAY;
                            map[enemy[i].j][enemy[i].i]=0;
                            blank(enemy[i].i,enemy[i].j,vga_frame_buffer);
                            enemy[i].j++;
                            downtank(enemy[i].i,enemy[i].j,RED_16,vga_frame_buffer);
                            map[enemy[i].j][enemy[i].i]=44+i;
                        }
                    else if(enemy[i].control>=20&&enemy[i].control<=29&&map[enemy[i].j][enemy[i].i-1]==0)/*˶*/
                        {   
                            enemy[i].way=LEFTWAY;
                            map[enemy[i].j][enemy[i].i]=0;
                            blank(enemy[i].i,enemy[i].j,vga_frame_buffer);
                            enemy[i].i--;
                            lefttank(enemy[i].i,enemy[i].j,RED_16,vga_frame_buffer);
                            map[enemy[i].j][enemy[i].i]=44+i;
                        }
                    else if(enemy[i].control>=30&&enemy[i].control<=39&&map[enemy[i].j][enemy[i].i+1]==0)/*˶*/
                        {   
                            enemy[i].way=RIGHTWAY;
                            map[enemy[i].j][enemy[i].i]=0;
                            blank(enemy[i].i,enemy[i].j,vga_frame_buffer);
                            enemy[i].i++;
                            righttank(enemy[i].i,enemy[i].j,RED_16,vga_frame_buffer);
                            map[enemy[i].j][enemy[i].i]=44+i;
                        }
                    else if(enemy[i].control>=40&&enemy[i].control<=49)/*δɣڵ*/
                        {
                            if(shoot[1+i].life==0&&enemy[i].life==1)
                                {
                                    shoot[1+i].life=1;
                                    shoot[1+i].x=enemy[i].i*30+15;  shoot[1+i].y=enemy[i].j*30+15;
                                    shoot[1+i].way=enemy[i].way;break;
                                }
                        }
                }
        }
}


void judge_shootway(int map[15][15],int i,display_frame_buffer_struct* vga_frame_buffer)/*жڵ*/
{
    switch(shoot[i].way)
        {   
            case UPWAY:map[(shoot[i].y-15)/30-1][(shoot[i].x-15)/30]=0;blank((shoot[i].x-15)/30,(shoot[i].y-15)/30-1,vga_frame_buffer);break;
            case DOWNWAY:map[(shoot[i].y-15)/30+1][(shoot[i].x-15)/30]=0;blank((shoot[i].x-15)/30,(shoot[i].y-15)/30+1,vga_frame_buffer);break;
            case LEFTWAY:map[(shoot[i].y-15)/30][(shoot[i].x-15)/30-1]=0;blank((shoot[i].x-15)/30-1,(shoot[i].y-15)/30,vga_frame_buffer);break;
            case RIGHTWAY:map[(shoot[i].y-15)/30][(shoot[i].x-15)/30+1]=0;blank((shoot[i].x-15)/30+1,(shoot[i].y-15)/30,vga_frame_buffer);break; 
        }
}

void judge_moveshootway(int map[15][15],int i,display_frame_buffer_struct* vga_frame_buffer)/*ڵ˶ʱжڵ*/
{ 
    int shoot_color,per=9;
    if(i<1) shoot_color=GREEN_16;
    else   shoot_color=RED_16;
    switch(shoot[i].way)
        {
            case UPWAY :
                if((shoot[i].y-15)%30==0)/*жڵǷ񵽴СͼԵ*/
                    if(map[(shoot[i].y-15)/30-1][(shoot[i].x-15)/30]!=0)/*жڵǰǷ*/
                        {
                            shoot[i].life=0;/*ڵ״̬Ϊ*/
                            judge_shoot(map[(shoot[i].y-15)/30-1][(shoot[i].x-15)/30],map,i,vga_frame_buffer);/*ڵе庯*/
                            
                            
                             fengming(5000);   //Ч
                             
                        }
                if(shoot[i].y<47+5+per)/*жڵǷ񵽴ͼԵ*/
                    shoot[i].life=0;/*ڵ״̬Ϊ*/
                if(shoot[i].life!=0)/*ڵ״̬Ϊ*/
                    {
//                        setfillstyle(1,1);/*ڵ*/
//                        bar(shoot[i].x+14,shoot[i].y-5,shoot[i].x+17,shoot[i].y-2);
//                        setcolor(7);
//                        line(shoot[i].x+14,shoot[i].y-1,shoot[i].x+17,shoot[i].y-1);
                     vid_draw_box(shoot[i].x+14,shoot[i].y-4,shoot[i].x+17,shoot[i].y-1, BLACK_16, DO_FILL, vga_frame_buffer); 
                             vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
                   vid_draw_box(shoot[i].x+14,shoot[i].y-4,shoot[i].x+17,shoot[i].y-1, BLACK_16, DO_FILL, vga_frame_buffer); 
                             vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
                             
                                 
                    vid_draw_box(shoot[i].x+14,shoot[i].y-5-per,shoot[i].x+17,shoot[i].y-2-per, shoot_color, DO_FILL, vga_frame_buffer); 
                             vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
                   vid_draw_box(shoot[i].x+14,shoot[i].y-5-per,shoot[i].x+17,shoot[i].y-2-per, shoot_color, DO_FILL, vga_frame_buffer); 
                          //   vga_flip_frame_buffers( vga_frame_buffer );
                         //    while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
             
                   // vid_draw_line(shoot[i].x+14,shoot[i].y-1,shoot[i].x+17,shoot[i].y-1, 1,  RED_16, vga_frame_buffer);
                     //      vga_flip_frame_buffers( vga_frame_buffer );
                     //        while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );   
                    // vid_draw_line(shoot[i].x+14,shoot[i].y-1,shoot[i].x+17,shoot[i].y-1, 1,  RED_16, vga_frame_buffer);
                         //   vga_flip_frame_buffers( vga_frame_buffer );
                          //  while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );          
                     shoot[i].y=shoot[i].y-per-1;
                    }
                else /*ڵ״̬Ϊ*/
                    {
                       // setfillstyle(1,getpixel(shoot[i].x+14,shoot[i].y-6));/*ڵۼ*/
                      //  bar(shoot[i].x+14,shoot[i].y-5,shoot[i].x+17,shoot[i].y-1);
                      if(shoot[i].y<50)
                         {  vid_draw_box(shoot[i].x+14,shoot[i].y-5,shoot[i].x+17,shoot[i].y-1, WHEAT_16, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                        vid_draw_box(shoot[i].x+14,shoot[i].y-5,shoot[i].x+17,shoot[i].y-1, WHEAT_16, DO_FILL, vga_frame_buffer); 
                             // vga_flip_frame_buffers( vga_frame_buffer );
                            // while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                         }    
                       else     
                       {  vid_draw_box(shoot[i].x+14,shoot[i].y-5,shoot[i].x+17,shoot[i].y-1, BLACK_16, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                        vid_draw_box(shoot[i].x+14,shoot[i].y-5,shoot[i].x+17,shoot[i].y-1, BLACK_16, DO_FILL, vga_frame_buffer); 
                             vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );    
                       }   
                    }
                break;
            case DOWNWAY:
                if((shoot[i].y-15)%30==0)
                    if(map[(shoot[i].y-15)/30+1][(shoot[i].x-15)/30]!=0)
                        {
                            shoot[i].life=0;
                            judge_shoot(map[(shoot[i].y-15)/30+1][(shoot[i].x-15)/30],map,i,vga_frame_buffer);
                                fengming(5000);   //Ч
                        }
                if(shoot[i].y>403-per)
                    shoot[i].life=0;
                if(shoot[i].life!=0)
                    {
//                        setfillstyle(1,1);
//                        bar(shoot[i].x+14,shoot[i].y+35,shoot[i].x+17,shoot[i].y+32);setcolor(7);
//                        line(shoot[i].x+14,shoot[i].y+31,shoot[i].x+17,shoot[i].y+31);
//                     
                        vid_draw_box(shoot[i].x+14,shoot[i].y+31,shoot[i].x+17,shoot[i].y+34, BLACK_16, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                         vid_draw_box(shoot[i].x+14,shoot[i].y+31,shoot[i].x+17,shoot[i].y+34, BLACK_16, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                            
                         vid_draw_box(shoot[i].x+14,shoot[i].y+32+per,shoot[i].x+17,shoot[i].y+35+per, shoot_color, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                         vid_draw_box(shoot[i].x+14,shoot[i].y+32+per,shoot[i].x+17,shoot[i].y+35+per, shoot_color, DO_FILL, vga_frame_buffer); 
                           //   vga_flip_frame_buffers( vga_frame_buffer );
                           //  while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                             
                     //    vid_draw_line(shoot[i].x+14,shoot[i].y+31,shoot[i].x+17,shoot[i].y+31, 1,  RED_16, vga_frame_buffer);
                        //   vga_flip_frame_buffers( vga_frame_buffer );
                       //      while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );   
                       //  vid_draw_line(shoot[i].x+14,shoot[i].y+31,shoot[i].x+17,shoot[i].y+31, 1,  RED_16, vga_frame_buffer);
                           //vga_flip_frame_buffers( vga_frame_buffer );
                          //  while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );     
                        shoot[i].y= shoot[i].y+per+1;
                    }
                else
                    {
                      //  setfillstyle(1,getpixel(shoot[i].x+14,shoot[i].y+36));
                      //  bar(shoot[i].x+14,shoot[i].y+35,shoot[i].x+17,shoot[i].y+31);
                      
                        vid_draw_box(shoot[i].x+14,shoot[i].y+31,shoot[i].x+17,shoot[i].y+35, BLACK_16, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0);
                       vid_draw_box(shoot[i].x+14,shoot[i].y+31,shoot[i].x+17,shoot[i].y+35, BLACK_16, DO_FILL, vga_frame_buffer); 
                           //   vga_flip_frame_buffers( vga_frame_buffer );
                          //   while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0);
                    }
                break;
            case LEFTWAY:
                if((shoot[i].x-15)%30==0)/*жڵǷ񵽴СͼԵ*/
                    if(map[(shoot[i].y-15)/30][(shoot[i].x-15)/30-1]!=0)/*жڵǰǷ*/
                        {
                            shoot[i].life=0;/*ڵ״̬Ϊ*/
                            judge_shoot(map[(shoot[i].y-15)/30][(shoot[i].x-15)/30-1],map,i,vga_frame_buffer);/*ڵе庯*/
                                fengming(5000);   //Ч
                            
                        }
                if(shoot[i].x<48+5+per)/*жڵǷ񵽴ͼԵ*/
                    shoot[i].life=0;/*ڵ״̬Ϊ*/
                if(shoot[i].life!=0)/*ڵ״̬Ϊ*/
                    {
                     //   setfillstyle(1,1);/*ڵ*/
                     //   bar(shoot[i].x-5,shoot[i].y+14,shoot[i].x-2,shoot[i].y+17);setcolor(7);
                     //   line(shoot[i].x-1,shoot[i].y+14,shoot[i].x-1,shoot[i].y+17);
                     
                      vid_draw_box(shoot[i].x-4,shoot[i].y+14,shoot[i].x-1,shoot[i].y+17, BLACK_16, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                          vid_draw_box(shoot[i].x-4,shoot[i].y+14,shoot[i].x-1,shoot[i].y+17, BLACK_16, DO_FILL, vga_frame_buffer); 
                          //  vga_flip_frame_buffers( vga_frame_buffer );
                            //while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                     
                     
                         vid_draw_box(shoot[i].x-5-per,shoot[i].y+14,shoot[i].x-2-per,shoot[i].y+17, shoot_color, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                          vid_draw_box(shoot[i].x-5-per,shoot[i].y+14,shoot[i].x-2-per,shoot[i].y+17, shoot_color, DO_FILL, vga_frame_buffer); 
                       //     vga_flip_frame_buffers( vga_frame_buffer );
                        //    while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                             
                             
                       // vid_draw_line(shoot[i].x-1,shoot[i].y+14,shoot[i].x-1,shoot[i].y+17, 2,  RED_16, vga_frame_buffer);
                        //   vga_flip_frame_buffers( vga_frame_buffer );
                        //     while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
                      // vid_draw_line(shoot[i].x-1,shoot[i].y+14,shoot[i].x-1,shoot[i].y+17, 2,  RED_16, vga_frame_buffer);
                        //   vga_flip_frame_buffers( vga_frame_buffer );
                         //   while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
                        
                        
                        shoot[i].x= shoot[i].x-per-1;
                    }
                else/*ڵ״̬Ϊ*/
                    {
                      //  setfillstyle(1,getpixel(shoot[i].x-6,shoot[i].y+14));/*ڵۼ*/
                      //  bar(shoot[i].x-5,shoot[i].y+14,shoot[i].x-1,shoot[i].y+17);
                        if(shoot[i].x<50)
                     {  vid_draw_box(shoot[i].x-5,shoot[i].y+14,shoot[i].x-1,shoot[i].y+17, WHEAT_16, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0);
                         vid_draw_box(shoot[i].x-5,shoot[i].y+14,shoot[i].x-1,shoot[i].y+17, WHEAT_16, DO_FILL, vga_frame_buffer); 
                          //   vga_flip_frame_buffers( vga_frame_buffer );
                           // while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0);
                      } 
                      else
                        {vid_draw_box(shoot[i].x-5,shoot[i].y+14,shoot[i].x-1,shoot[i].y+17, BLACK_16, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0);
                         vid_draw_box(shoot[i].x-5,shoot[i].y+14,shoot[i].x-1,shoot[i].y+17, BLACK_16, DO_FILL, vga_frame_buffer); 
                          //   vga_flip_frame_buffers( vga_frame_buffer );
                           // while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0);
                        }
                    }
                break;
                
            case RIGHTWAY:
                if((shoot[i].x-15)%30==0)
                    if(map[(shoot[i].y-15)/30][(shoot[i].x-15)/30+1]!=0)
                        {
                            shoot[i].life=0;
                            judge_shoot(map[(shoot[i].y-15)/30][(shoot[i].x-15)/30+1],map,i,vga_frame_buffer);
                                fengming(5000);   //Ч
                        }
                if(shoot[i].x>402-per)
                    shoot[i].life=0;
                if(shoot[i].life!=0)
                    {
                      //  setfillstyle(1,1);
                        //bar(shoot[i].x+35,shoot[i].y+14,shoot[i].x+32,shoot[i].y+17);setcolor(7);
                        //line(shoot[i].x+31,shoot[i].y+14,shoot[i].x+31,shoot[i].y+17);
                        
                        vid_draw_box(shoot[i].x+31,shoot[i].y+14,shoot[i].x+34,shoot[i].y+17, BLACK_16, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                        vid_draw_box(shoot[i].x+31,shoot[i].y+14,shoot[i].x+34,shoot[i].y+17, BLACK_16, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                             
                                       
                         vid_draw_box(shoot[i].x+32+per,shoot[i].y+14,shoot[i].x+35+per,shoot[i].y+17, shoot_color, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                        vid_draw_box(shoot[i].x+32+per,shoot[i].y+14,shoot[i].x+35+per,shoot[i].y+17, shoot_color, DO_FILL, vga_frame_buffer); 
                          //    vga_flip_frame_buffers( vga_frame_buffer );
                          //   while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 );
                          
                          
                    //  vid_draw_line(shoot[i].x+31,shoot[i].y+14,shoot[i].x+31,shoot[i].y+17, 2,  RED_16, vga_frame_buffer);
                     //      vga_flip_frame_buffers( vga_frame_buffer );
                      //       while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
                  //  vid_draw_line(shoot[i].x+31,shoot[i].y+14,shoot[i].x+31,shoot[i].y+17, 2,  RED_16, vga_frame_buffer);
                      //     vga_flip_frame_buffers( vga_frame_buffer );
                       //     while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0 ); 
                        shoot[i].x=shoot[i].x+per+1;
                    }
                else
                    {
            //            setfillstyle(1,getpixel(shoot[i].x+36,shoot[i].y+14));
                 //       bar(shoot[i].x+35,shoot[i].y+14,shoot[i].x+31,shoot[i].y+17);
                        
                        vid_draw_box(shoot[i].x+31,shoot[i].y+14,shoot[i].x+35,shoot[i].y+17, BLACK_16, DO_FILL, vga_frame_buffer); 
                              vga_flip_frame_buffers( vga_frame_buffer );
                             while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0);
                      vid_draw_box(shoot[i].x+31,shoot[i].y+14,shoot[i].x+35,shoot[i].y+17, BLACK_16, DO_FILL, vga_frame_buffer); 
                          //    vga_flip_frame_buffers( vga_frame_buffer );
                          //  while( IORD_32DIRECT( vga_frame_buffer->vga_controller_base, 0xC ) != (int)vga_frame_buffer->frame0);
                    }
                break;
        }
}



void judge_tank_my(int map[15][15],int key,display_frame_buffer_struct* vga_frame_buffer)/*жϼ̹˶*/
{
    switch(key)/*жϼ̰*/
        {
        case a_UP:/*A̹˵ϼ*/
            if(player[0].life==1){
            if(map[player[0].j-1][player[0].i]==0)/*̹ǰû*/
                {
                    if(player[0].way==UPWAY)/*̹˷*/
                        {
                            map[player[0].j][player[0].i]=0;/*λû̹ˣԭ̹*/
                            blank(player[0].i,player[0].j,vga_frame_buffer);
                            player[0].j--;
                            uptank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);
                            map[player[0].j][player[0].i]=1;
                            player[0].way=UPWAY;
                        }
                    else /*̹˷Ϊ*/
                        {
                            blank(player[0].i,player[0].j,vga_frame_buffer);/*ԭ̹*/
                            uptank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);/*ԭλûϵ̹*/
                            player[0].way=UPWAY;/*̹˷Ϊ*/
                        }
                }
            else /*̹ǰ*/      
                {
                    blank(player[0].i,player[0].j,vga_frame_buffer);
                    uptank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);player[0].way=UPWAY;
                }     
                          fengming(100);   //ƶ̹Ч
            }
            break;
        case a_DOWN:
            if(player[0].life==1){
            if(map[player[0].j+1][player[0].i]==0)
                {
                    if(player[0].way==DOWNWAY)
                        {
                            map[player[0].j][player[0].i]=0;
                            blank(player[0].i,player[0].j,vga_frame_buffer);
                            player[0].j++;
                            downtank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);
                            map[player[0].j][player[0].i]=1;
                            player[0].way=DOWNWAY;
                        }
                    else 
                        {
                            blank(player[0].i,player[0].j,vga_frame_buffer);
                            downtank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);player[0].way=DOWNWAY;
                        } 
                }
            else 
                {
                    blank(player[0].i,player[0].j,vga_frame_buffer);downtank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);player[0].way=DOWNWAY;
                }           
                   fengming(100);   //ƶ̹Ч
            }
            break;
        case a_LEFT:
            if(player[0].life==1){
            if(map[player[0].j][player[0].i-1]==0)
                {
                    if(player[0].way==LEFTWAY)
                        {
                            map[player[0].j][player[0].i]=0;
                            blank(player[0].i,player[0].j,vga_frame_buffer);
                            player[0].i--;
                            lefttank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);
                            map[player[0].j][player[0].i]=1;
                            player[0].way=LEFTWAY;
                        }
                    else 
                        {
                            blank(player[0].i,player[0].j,vga_frame_buffer);lefttank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);player[0].way=LEFTWAY;
                        }
                }
            else 
                {
                    blank(player[0].i,player[0].j,vga_frame_buffer);lefttank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);player[0].way=LEFTWAY;
                } fengming(100);   //ƶ̹Ч
                }
    
            break;
        case a_RIGHT:
            if(player[0].life==1){
            if(map[player[0].j][player[0].i+1]==0)
                {
                    if(player[0].way==RIGHTWAY)
                        {
                            map[player[0].j][player[0].i]=0;
                            blank(player[0].i,player[0].j,vga_frame_buffer);
                            player[0].i++;
                            righttank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);
                            map[player[0].j][player[0].i]=1;
                            player[0].way=RIGHTWAY;
                        }
                    else 
                        {
                            blank(player[0].i,player[0].j,vga_frame_buffer);righttank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);player[0].way=RIGHTWAY;
                        }
                }
            else 
                {
                    blank(player[0].i,player[0].j,vga_frame_buffer);righttank(player[0].i,player[0].j,GREEN_16,vga_frame_buffer);player[0].way=RIGHTWAY;
                }

              fengming(100);   //ƶ̹Ч
            }
            break;
        case a_shoot:
            if(player[0].life==1){
            if(shoot[0].life==0)
                {
                    shoot[0].life=1;
                    shoot[0].x=player[0].i*30+15;  shoot[0].y=player[0].j*30+15;
                    shoot[0].way=player[0].way;
                
                    break;
                } fengming(500);   //Ч
                }
                break;
          
           player_life=0;
    }                   
}

//÷Ч


void fengming(int n)
{
    int j;
    for(j=0;j<100;j++)// ṩһԴ
       {
       IOWR_ALTERA_AVALON_PIO_DATA(BUZZER_BASE,0x1); //ƶ˿ڸߵƽ
       usleep(n);  //ʱԼ n  um
       IOWR_ALTERA_AVALON_PIO_DATA(BUZZER_BASE,0x0); //ƶ˿ڵ͵ƽ
       usleep(n);  //ʱԼ n um
       }
}
