/*
 * =====================================================================================
 *
 *       Filename:  kb.c
 *
 *    Description:  
 *
 *        Version:  1.0.0
 *        Created:  2010.4.16
 *       Revision:  none
 *       Compiler:  Nios II 9.0 IDE
 *
 *         Author:   (AVIC)
 *			Email:  avic633@gmail.com  
 *			   QQ:  984597569
 *			  URL:  http://kingst.cnblogs.com
 *
 * =====================================================================================
 */


/*--------------------------------------------------------------------------------------
 *  Include
 *-------------------------------------------------------------------------------------*/ 
#include "../inc/kb.h"
#include "altera_avalon_pio_regs.h"

/*--------------------------------------------------------------------------------------
 *  Define
 *-------------------------------------------------------------------------------------*/ 
#define   OUT     1
#define   IN      0

/*--------------------------------------------------------------------------------------
 *  Struct
 *-------------------------------------------------------------------------------------*/ 
KEYBOARD_STRUCT key1_lut[]=
{
	0x16, 0x31, 0x21, 0,  0,  // { 1 }    { ! }
	0x1e, 0x32, 0x40, 0,  0,  // { 2 }    { @ }
	0x26, 0x33, 0x23, 0,  0,  // { 3 }    { # }
	0x25, 0x34, 0x24, 0,  0,  // { 4 }    { $ }
	0x2e, 0x35, 0x25, 0,  0,  // { 5 }    { % }
	0x36, 0x36, 0x5e, 0,  0,  // { 6 }    { ^ }
	0x3d, 0x37, 0x26, 0,  0,  // { 7 }    { & }
	0x3e, 0x38, 0x2a, 0,  0,  // { 8 }    { * }
	0x46, 0x39, 0x28, 0,  0,  // { 9 }    { ( }
	0x45, 0x30, 0x29, 0,  0,  // { 0 }    { ) }
	0x1c, 0x61, 0x41, 0,  0,  // { a }    { A }
	0x32, 0x62, 0x42, 0,  0,  // { b }    { B }
	0x21, 0x63, 0x43, 0,  0,  // { c }    { C }
	0x23, 0x64, 0x44, 0,  0,  // { d }    { D }
	0x24, 0x65, 0x45, 0,  0,  // { e }    { E }
	0x2b, 0x66, 0x46, 0,  0,  // { f }    { F }
	0x34, 0x67, 0x47, 0,  0,  // { g }    { G }
	0x33, 0x68, 0x48, 0,  0,  // { h }    { H }
	0x43, 0x69, 0x49, 0,  0,  // { i }    { I }
	0x3b, 0x6a, 0x4a, 0,  0,  // { j }    { J }
	0x42, 0x6b, 0x4b, 0,  0,  // { k }    { K }
	0x4b, 0x6c, 0x4c, 0,  0,  // { l }    { L }
	0x3a, 0x6d, 0x4d, 0,  0,  // { m }    { M }
	0x31, 0x6e, 0x4e, 0,  0,  // { n }    { N }
	0x44, 0x6f, 0x4f, 0,  0,  // { o }    { O }
	0x4d, 0x70, 0x50, 0,  0,  // { p }    { P }
	0x15, 0x71, 0x51, 0,  0,  // { q }    { Q }
	0x2d, 0x72, 0x52, 0,  0,  // { r }    { R }
	0x1b, 0x73, 0x53, 0,  0,  // { s }    { S }
	0x2c, 0x74, 0x54, 0,  0,  // { t }    { T }
	0x3c, 0x75, 0x55, 0,  0,  // { u }    { U }
	0x2a, 0x76, 0x56, 0,  0,  // { v }    { V }
	0x1d, 0x77, 0x57, 0,  0,  // { w }    { W }
	0x22, 0x78, 0x58, 0,  0,  // { x }    { X }
	0x35, 0x79, 0x59, 0,  0,  // { y }    { Y }
	0x1a, 0x7a, 0x5a, 0,  0,  // { z }    { Z }
	0x0e, 0x60, 0x7e, 0,  0,  // { ` }    { ~ }
	0x4e, 0x2d, 0x5f, 0,  0,  // { - }    { _ }
	0x55, 0x3d, 0x2b, 0,  0,  // { = }    { + }
	0x5d, 0x5c, 0x7c, 0,  0,  // { \ }    { | }
	0x54, 0x5b, 0x7b, 0,  0,  // { [ }    { { }
	0x5b, 0x5d, 0x7d, 0,  0,  // { ] }    { } }
	0x4c, 0x3b, 0x3a, 0,  0,  // { ; }    { : }
	0x52, 0x27, 0x22, 0,  0,  // { ' }    { " }
	0x41, 0x2c, 0x3c, 0,  0,  // { , }    { < }
	0x49, 0x2e, 0x3e, 0,  0,  // { . }    { > }
	0x4a, 0x2f, 0x3f, 0,  0,  // { / }    { ? }
	0x5a, 0x0a, 0,    0,  0,  // u{ enter }
	0x29, 0x20, 0,    0,  0,  // { space }
	0x05,   0,    0,    0,  "F1", 
	0x06,   0,    0,    0,  "F2", 
	0x04,   0,    0,    0,  "F3", 
	0x0c,   0,    0,    0,  "F4", 
	0x03,   0,    0,    0,  "F5", 
	0x0b,   0,    0,    0,  "F6", 
	0x83,   0,    0,    0,  "F7", 
	0x0a,   0,    0,    0,  "F8", 
	0x01,   0,    0,    0,  "F9", 
	0x09,   0,    0,    0,  "F10",  
	0x78,   0,    0,    0,  "F11",  
	0x07,   0,    0,    0,  "F12",
	0x66,   0,    0,    0,  "BKSP",
	0x0d,   0,    0,    0,  "TAB",
	0x14,   0,    0,    0,  "L_CTRL",
	0xe01f, 0,    0,    0,  "L_GUI",
	0x11,   0,    0,    0,  "L_ALT",
	0xe014, 0,    0,    0,  "R_CTRL",
	0xe027, 0,    0,    0,  "R_GUI",
	0xe011, 0,    0,    0,  "R_ALT",
	0xe02f, 0,    0,    0,  "APPS",
	0x76,   0,    0,    0,  "ESC",
	0xe070, 0,    0,    0,  "Ins",  
	0xe06c, 0,    0,    0,  "Home",
	0xe07d, 0,    0,    0,  "PgUP",
	0xe071, 0,    0,    0,  "Del",
	0xe069, 0,    0,    0,  "End",
	0xe07a, 0,    0,    0,  "PgDn",
	0xe075, 0,    0,    0,  "U_ARROW",
	0xe06b, 0,    0,    0,  "L_ARROW",
	0xe072, 0,    0,    0,  "D_ARROW",
	0xe074, 0,    0,    0,  "R_ARROW",
	0xe04a, 0,    0,    0,  "KP_/",
	0x7c,   0,    0,    0,  "KP_*",
	0x7b,   0,    0,    0,  "KP_-",
	0x79,   0,    0,    0,  "KP_+",
	0xe05a, 0,    0,    0,  "KP_EN",
	0x71,   0,    0,    0,  "KP_.",
	0x70,   0,    0,    0,  "KP_0",
	0x69,   0,    0,    0,  "KP_1",
	0x72,   0,    0,    0,  "KP_2",    
	0x7a,   0,    0,    0,  "KP_3",    
	0x6b,   0,    0,    0,  "KP_4",    
	0x73,   0,    0,    0,  "KP_5",    
	0x74,   0,    0,    0,  "KP_6",    
	0x6c,   0,    0,    0,  "KP_7",    
	0x75,   0,    0,    0,  "KP_8",    
	0x7d,   0,    0,    0,  "KP_9", 
	0xe037, 0,    0,    0,  "Power",
	0xe03f, 0,    0,    0,  "Sleep",
	0xe05e, 0,    0,    0,  "Wake",
	0,      0,    0,    0,  0,
};

#define KEY_LSHIFT_MASK   (0x12)
#define KEY_RSHIFT_MASK   (0x59)
#define KEY_CAPS_MASK     (0x58)    
#define KEY_NUM_MASK      (0x77)

#define KEY_LSHIFT_INDEX  (0)
#define KEY_RSHIFT_INDEX  (1)
#define KEY_CAPS_INDEX    (2)
#define KEY_NUM_INDEX     (3)

KEYBOARD_STRUCT keys_lut[]=
{
	KEY_LSHIFT_MASK,  0,  0,  0,  0,    //L_shift
	KEY_RSHIFT_MASK,  0,  0,  0,  0,    //R_shift
	KEY_CAPS_MASK,    0,  0,  0,  0,    //caps
	KEY_NUM_MASK,     0,  0,  0,  0,    //num
	0,                0,  0,  0,  0,
};
/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  ps2_restart
 *  Description:  
 * =====================================================================================
 */
void ps2_restart(void)
{
	IOWR_ALTERA_AVALON_PIO_DIRECTION(PS2_CLK_BASE, OUT);  //clk and data direction is output
	IOWR_ALTERA_AVALON_PIO_DIRECTION(PS2_DAT_BASE, OUT);
	IOWR_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE, 0);   //drive clk and data low
	IOWR_ALTERA_AVALON_PIO_DATA(PS2_DAT_BASE, 1);
	usleep(200);
}
/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  ps2_input
 *  Description:  
 * =====================================================================================
 */
alt_u8 ps2_input(void)
{
	alt_u16 i, dat;

	IOWR_ALTERA_AVALON_PIO_DIRECTION(PS2_CLK_BASE, IN);
	IOWR_ALTERA_AVALON_PIO_DIRECTION(PS2_DAT_BASE, IN);
	usleep(1);

	for(i=0; i<11; i++)
	{
		while(IORD_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE) & 0x01); //Wait for the device to bring Clock low.
		while(!(IORD_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE) & 0x01)); //Wait for the device to bring Clock High.
		dat >>= 1;
		if(IORD_ALTERA_AVALON_PIO_DATA(PS2_DAT_BASE)) 
			dat |= 0x200;
	}

	return dat & 0xff;

}
/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  ps2_getch
 *  Description:  
 * =====================================================================================
 */
alt_8 ps2_getch(void)
{
	alt_u16 i;
	alt_u8 status, ps2_dat;
	alt_8 mchar;

	ps2_dat = ps2_input();
	if(ps2_dat == 0xf0)   //
	{
		ps2_input();
		return 0xff;
	}
	else                  //ͨ
	{ 
		for(i=0; i<50; i++)
			if(ps2_dat == key1_lut[i].mask)
				mchar = key1_lut[i].value;
		return mchar;
	}
}
/* 
 * ===  FUNCTION  ======================================================================
 *         Name:  ps2_command
 *  Description:  
 * =====================================================================================
 */
void ps2_command(alt_u8 cmd)
{
	alt_u16 i, j;

	IOWR_ALTERA_AVALON_PIO_DIRECTION(PS2_CLK_BASE, OUT);  //clk and data direction is output
	IOWR_ALTERA_AVALON_PIO_DIRECTION(PS2_DAT_BASE, OUT);
	IOWR_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE, 0);   //drive clk and data low
	IOWR_ALTERA_AVALON_PIO_DATA(PS2_DAT_BASE, 0);

	usleep(200);

	IOWR_ALTERA_AVALON_PIO_DIRECTION(PS2_CLK_BASE, IN); //Release the Clock line.
	usleep(10);
	while(IORD_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE) & 0x01); //Wait for the device to bring the Clock line low.

	for(i=0,j=0; i<8; i++)
	{
		if(cmd & 0x01)          //Set/reset the Data line to send the first data bit.
		{
			IOWR_ALTERA_AVALON_PIO_DATA(PS2_DAT_BASE, 1);
			j++;
		}
		else
			IOWR_ALTERA_AVALON_PIO_DATA(PS2_DAT_BASE, 0);;

		cmd >>= 1;
		while(!(IORD_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE) & 0x01));   //Wait for the device to bring Clock high.
		usleep(20);
		while(IORD_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE) & 0x01);      //Wait for the device to bring Clock low.
		usleep(20);
	}

	if(!(j&0x01))
		IOWR_ALTERA_AVALON_PIO_DATA(PS2_DAT_BASE, 1);   //Send parity bit
	else
		IOWR_ALTERA_AVALON_PIO_DATA(PS2_DAT_BASE, 0);

	usleep(20);
	while(!(IORD_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE) & 0x01));  //Wait for the device to bring Clock high.

	usleep(20);
	while(IORD_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE) & 0x01);     //Wait for the device to bring Clock low.

	IOWR_ALTERA_AVALON_PIO_DATA(PS2_DAT_BASE, 1);                //Send stop bit

	usleep(20);
	while(!(IORD_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE) & 0x01));  //Wait for the device to bring Clock high.

	usleep(20);
	while(IORD_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE) & 0x01);     //Wait for the device to bring Clock low.

	IOWR_ALTERA_AVALON_PIO_DIRECTION(PS2_DAT_BASE, IN);;         //Release the Data line.

	usleep(20);
	while(IORD_ALTERA_AVALON_PIO_DATA(PS2_DAT_BASE) & 0x01);     //Wait for the device to bring Data low.

	while(IORD_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE) & 0x01);     //Wait for the device to bring Clock low.

	usleep(20);

	while(!(IORD_ALTERA_AVALON_PIO_DATA(PS2_CLK_BASE) & 0x01));     //Wait for the device to bring Clock high.
	while(!(IORD_ALTERA_AVALON_PIO_DATA(PS2_DAT_BASE) & 0x01));     //Wait for the device to bring Data high.
}


