// --------------------------------------------------------------------
// Copyright (c) 2005 by Terasic Technologies Inc. 
// --------------------------------------------------------------------
//
// Permission:
//
//   Terasic grants permission to use and modify this code for use
//   in synthesis for all Terasic Development Boards and Altera Development 
//   Kits made by Terasic.  Other use of this code, including the selling 
//   ,duplication, or modification of any portion is strictly prohibited.
//
// Disclaimer:
//
//   This VHDL/Verilog or C/C++ source code is intended as a design reference
//   which illustrates how these types of functions can be implemented.
//   It is the user's responsibility to verify their design for
//   consistency and functionality through the use of formal
//   verification methods.  Terasic provides no warranty regarding the use 
//   or functionality of this code.
//
// --------------------------------------------------------------------
//           
//                     Terasic Technologies Inc
//                     356 Fu-Shin E. Rd Sec. 1. JhuBei City,
//                     HsinChu County, Taiwan
//                     302
//
//                     web: http://www.terasic.com/
//                     email: support@terasic.com
//
// --------------------------------------------------------------------
//
// Major Functions:	DE1 NIOS
//
// --------------------------------------------------------------------
//
// Revision History :
// --------------------------------------------------------------------
//   Ver  :| Author            :| Mod. Date :| Changes Made:
//   V1.0 :| Johnny Chen       :| 06/04/24  :|      Initial Revision
// --------------------------------------------------------------------

module DE1_NIOS
	(
		////////////////////	Clock Input	 	////////////////////	 
//		CLOCK_24,						//	24 MHz
//		CLOCK_27,						//	27 MHz
		CLOCK_50,						//	50 MHz
//		EXT_CLOCK,						//	External Clock
		////////////////////	Push Button		////////////////////
//		KEY,							//	Pushbutton[3:0]
		////////////////////	DPDT Switch		////////////////////
//		SW,								//	Toggle Switch[9:0]
		////////////////////	7-SEG Dispaly	////////////////////
//		HEX0,							//	Seven Segment Digit 0
//		HEX1,							//	Seven Segment Digit 1
//		HEX2,							//	Seven Segment Digit 2
//		HEX3,							//	Seven Segment Digit 3
		////////////////////////	LED		////////////////////////
//		LEDG,							//	LED Green[7:0]
//		LEDR,							//	LED Red[9:0]
		////////////////////////	UART	////////////////////////
//		UART_TXD,						//	UART Transmitter
//		UART_RXD,						//	UART Receiver
		/////////////////////	SDRAM Interface		////////////////
		DRAM_DQ,						//	SDRAM Data bus 16 Bits
		DRAM_ADDR,						//	SDRAM Address bus 12 Bits
		DRAM_LDQM,						//	SDRAM Low-byte Data Mask 
		DRAM_UDQM,						//	SDRAM High-byte Data Mask
		DRAM_WE_N,						//	SDRAM Write Enable
		DRAM_CAS_N,						//	SDRAM Column Address Strobe
		DRAM_RAS_N,						//	SDRAM Row Address Strobe
		DRAM_CS_N,						//	SDRAM Chip Select
		DRAM_BA_0,						//	SDRAM Bank Address 0
		DRAM_BA_1,						//	SDRAM Bank Address 0
		DRAM_CLK,						//	SDRAM Clock
		DRAM_CKE,						//	SDRAM Clock Enable
		////////////////////	Flash Interface		////////////////
//		FL_DQ,							//	FLASH Data bus 8 Bits
//		FL_ADDR,						//	FLASH Address bus 22 Bits
//		FL_WE_N,						//	FLASH Write Enable
//		FL_RST_N,						//	FLASH Reset
//		FL_OE_N,						//	FLASH Output Enable
//		FL_CE_N,						//	FLASH Chip Enable
		////////////////////	SRAM Interface		////////////////
		SRAM_DQ,						//	SRAM Data bus 16 Bits
		SRAM_ADDR,						//	SRAM Address bus 18 Bits
		SRAM_UB_N,						//	SRAM High-byte Data Mask 
		SRAM_LB_N,						//	SRAM Low-byte Data Mask 
		SRAM_WE_N,						//	SRAM Write Enable
		SRAM_CE_N,						//	SRAM Chip Enable
		SRAM_OE_N,						//	SRAM Output Enable
		////////////////////	SD_Card Interface	////////////////
//		SD_DAT,							//	SD Card Data
//		SD_DAT3,						//	SD Card Data 3
//		SD_CMD,							//	SD Card Command Signal
//		SD_CLK,							//	SD Card Clock
		////////////////////	USB JTAG link	////////////////////
//		TDI,  							// CPLD -> FPGA (data in)
//		TCK,  							// CPLD -> FPGA (clk)
//		TCS,  							// CPLD -> FPGA (CS)
//	    TDO,  							// FPGA -> CPLD (data out)
		////////////////////	I2C		////////////////////////////
//		I2C_SDAT,						//	I2C Data
//		I2C_SCLK,						//	I2C Clock
//		////////////////////	PS2		////////////////////////////
		PS2_DAT,						//	PS2 Data
		PS2_CLK,						//	PS2 Clock
		////////////////////	BUZZER		////////////////////////////
		
		BUZZER,
		////////////////////	VGA		////////////////////////////
		VGA_HS,							//	VGA H_SYNC
		VGA_VS,							//	VGA V_SYNC
		VGA_R,   						//	VGA Red[3:0]
		VGA_G,	 						//	VGA Green[3:0]
		VGA_B,  						//	VGA Blue[3:0]
//		////////////////	Audio CODEC		////////////////////////
//		AUD_ADCLRCK,					//	Audio CODEC ADC LR Clock
//		AUD_ADCDAT,						//	Audio CODEC ADC Data
//		AUD_DACLRCK,					//	Audio CODEC DAC LR Clock
//		AUD_DACDAT,						//	Audio CODEC DAC Data
//		AUD_BCLK,						//	Audio CODEC Bit-Stream Clock
//		AUD_XCK,						//	Audio CODEC Chip Clock
		////////////////////	GPIO	////////////////////////////
//		GPIO_0,							//	GPIO Connection 0
//		GPIO_1							//	GPIO Connection 1
	);

////////////////////////	Clock Input	 	////////////////////////
//input	[1:0]	CLOCK_24;				//	24 MHz
//input	[1:0]	CLOCK_27;				//	27 MHz
input			CLOCK_50;				//	50 MHz
//input			EXT_CLOCK;				//	External Clock
////////////////////////	Push Button		////////////////////////
//input	[3:0]	KEY;					//	Pushbutton[3:0]
//////////////////////////	DPDT Switch		////////////////////////
//input	[9:0]	SW;						//	Toggle Switch[9:0]
//////////////////////////	7-SEG Dispaly	////////////////////////
//output	[6:0]	HEX0;					//	Seven Segment Digit 0
//output	[6:0]	HEX1;					//	Seven Segment Digit 1
//output	[6:0]	HEX2;					//	Seven Segment Digit 2
//output	[6:0]	HEX3;					//	Seven Segment Digit 3
////////////////////////////	LED		////////////////////////////
//output	[7:0]	LEDG;					//	LED Green[7:0]
//output	[9:0]	LEDR;					//	LED Red[9:0]
////////////////////////////	UART	////////////////////////////
//output			UART_TXD;				//	UART Transmitter
//input			UART_RXD;				//	UART Receiver
///////////////////////		SDRAM Interface	////////////////////////
inout	[15:0]	DRAM_DQ;				//	SDRAM Data bus 16 Bits
output	[12:0]	DRAM_ADDR;				//	SDRAM Address bus 12 Bits
output			DRAM_LDQM;				//	SDRAM Low-byte Data Mask 
output			DRAM_UDQM;				//	SDRAM High-byte Data Mask
output			DRAM_WE_N;				//	SDRAM Write Enable
output			DRAM_CAS_N;				//	SDRAM Column Address Strobe
output			DRAM_RAS_N;				//	SDRAM Row Address Strobe
output			DRAM_CS_N;				//	SDRAM Chip Select
output			DRAM_BA_0;				//	SDRAM Bank Address 0
output			DRAM_BA_1;				//	SDRAM Bank Address 0
output			DRAM_CLK;				//	SDRAM Clock
output			DRAM_CKE;				//	SDRAM Clock Enable
////////////////////////	Flash Interface	////////////////////////
//inout	[7:0]	FL_DQ;					//	FLASH Data bus 8 Bits
//output	[21:0]	FL_ADDR;				//	FLASH Address bus 22 Bits
//output			FL_WE_N;				//	FLASH Write Enable
//output			FL_RST_N;				//	FLASH Reset
//output			FL_OE_N;				//	FLASH Output Enable
//output			FL_CE_N;				//	FLASH Chip Enable
////////////////////////	SRAM Interface	////////////////////////
inout	[15:0]	SRAM_DQ;				//	SRAM Data bus 16 Bits
output	[18:0]	SRAM_ADDR;				//	SRAM Address bus 18 Bits
output			SRAM_UB_N;				//	SRAM High-byte Data Mask 
output			SRAM_LB_N;				//	SRAM Low-byte Data Mask 
output			SRAM_WE_N;				//	SRAM Write Enable
output			SRAM_CE_N;				//	SRAM Chip Enable
output			SRAM_OE_N;				//	SRAM Output Enable
////////////////////	SD Card Interface	////////////////////////
//inout			SD_DAT;					//	SD Card Data
//inout			SD_DAT3;				//	SD Card Data 3
//inout			SD_CMD;					//	SD Card Command Signal
//output			SD_CLK;					//	SD Card Clock
////////////////////////	I2C		////////////////////////////////
//inout			I2C_SDAT;				//	I2C Data
//output			I2C_SCLK;				//	I2C Clock
//////////////////////	PS2		////////////////////////////////
input		 	PS2_DAT;				//	PS2 Data
input			PS2_CLK;				//	PS2 Clock
////////////////////	USB JTAG link	////////////////////////////
//input  			TDI;					// CPLD -> FPGA (data in)
//input  			TCK;					// CPLD -> FPGA (clk)
//input  			TCS;					// CPLD -> FPGA (CS)
//output 			TDO;					// FPGA -> CPLD (data out)
////////////////////////	VGA			////////////////////////////
output			VGA_HS;					//	VGA H_SYNC
output			VGA_VS;					//	VGA V_SYNC
output		VGA_R;   				//	VGA Red[3:0]
output		VGA_G;	 				//	VGA Green[3:0]
output		VGA_B;   				//	VGA Blue[3:0]
////////////////////////	BUZZER			////////////////////////////
output      BUZZER;

////////////////////	Audio CODEC		////////////////////////////
//inout			AUD_ADCLRCK;			//	Audio CODEC ADC LR Clock
//input			AUD_ADCDAT;				//	Audio CODEC ADC Data
//inout			AUD_DACLRCK;			//	Audio CODEC DAC LR Clock
//output			AUD_DACDAT;				//	Audio CODEC DAC Data
//inout			AUD_BCLK;				//	Audio CODEC Bit-Stream Clock
//output			AUD_XCK;				//	Audio CODEC Chip Clock
////////////////////////	GPIO	////////////////////////////////
//inout	[35:0]	GPIO_0;					//	GPIO Connection 0
//inout	[35:0]	GPIO_1;					//	GPIO Connection 1

//	All inout port turn to tri-state
//assign	SD_DAT		=	1'bz;
//assign	I2C_SDAT	=	1'bz;
//assign	AUD_ADCLRCK	=	1'bz;
//assign	AUD_DACLRCK	=	1'bz;
//assign	AUD_BCLK	=	1'bz;
//assign	GPIO_0		=	36'hzzzzzzzzz;
//assign	GPIO_1		=	36'hzzzzzzzzz;

wire	CPU_CLK;
wire	CPU_RESET;

wire	VGA_CLK;
wire	[7:1] tVGA_R;
wire	[7:1] tVGA_G;
wire	[7:1] tVGA_B;


//assign	FL_RST_N	=	1'b1;


Reset_Delay	delay1	(.iRST(1'b1),.iCLK(CLOCK_50),.oRESET(CPU_RESET));

SDRAM_PLL 	PLL1	(.inclk0(CLOCK_50),.c0(DRAM_CLK),.c1(CPU_CLK), .c2(VGA_CLK));

system_0 	u0	(
                  // 1) global signals:
                   .clk(CPU_CLK),
                   .reset_n(CPU_RESET),

//                  // the_KEY
//                   .in_port_to_the_KEY(KEY),
//
//                  // the_LEDG
//                   .out_port_from_the_LEDG(LEDG),
//
//                  // the_LEDR
//                   .out_port_from_the_LEDR(LEDR),
//
//                  // the_SEG7
//                   .oSEG0_from_the_SEG7(HEX0),
//                   .oSEG1_from_the_SEG7(HEX1),
//                   .oSEG2_from_the_SEG7(HEX2),
//                   .oSEG3_from_the_SEG7(HEX3),
//
//                  // the_Switch
//                   .in_port_to_the_Switch(SW),

                  // the_sdram_0
                   .zs_addr_from_the_sdram_0(DRAM_ADDR),
                   .zs_ba_from_the_sdram_0({DRAM_BA_1,DRAM_BA_0}),
                   .zs_cas_n_from_the_sdram_0(DRAM_CAS_N),
                   .zs_cke_from_the_sdram_0(DRAM_CKE),
                   .zs_cs_n_from_the_sdram_0(DRAM_CS_N),
                   .zs_dq_to_and_from_the_sdram_0(DRAM_DQ),
                   .zs_dqm_from_the_sdram_0({DRAM_UDQM,DRAM_LDQM}),
                   .zs_ras_n_from_the_sdram_0(DRAM_RAS_N),
                   .zs_we_n_from_the_sdram_0(DRAM_WE_N),

                  // the_tri_state_bridge_0_avalon_slave
//                   .select_n_to_the_cfi_flash_0(FL_CE_N),
//                   .tri_state_bridge_0_address(FL_ADDR),
//                   .tri_state_bridge_0_data(FL_DQ),
//                   .tri_state_bridge_0_readn(FL_OE_N),
//                   .write_n_to_the_cfi_flash_0(FL_WE_N),
//
//                  // the_uart_0
//                   .rxd_to_the_uart_0(UART_RXD),
//                   .txd_from_the_uart_0(UART_TXD),

                    // the_sram_0
                   .SRAM_ADDR_from_the_sram_0(SRAM_ADDR),
                   .SRAM_CE_N_from_the_sram_0(SRAM_CE_N),
                   .SRAM_DQ_to_and_from_the_sram_0(SRAM_DQ),
                   .SRAM_LB_N_from_the_sram_0(SRAM_LB_N),
                   .SRAM_OE_N_from_the_sram_0(SRAM_OE_N),
                   .SRAM_UB_N_from_the_sram_0(SRAM_UB_N),
                   .SRAM_WE_N_from_the_sram_0(SRAM_WE_N),
                //vga
				  .vga_clk_to_the_VGA             (VGA_CLK),
				  .B_from_the_VGA                 (tVGA_B),
				  .G_from_the_VGA                 (tVGA_G),
				  .R_from_the_VGA                 (tVGA_R),
				  .hsync_from_the_VGA             (VGA_HS),
				  .vsync_from_the_VGA             (VGA_VS),
				  
				 //PS2
				  .in_port_to_the_PS2_CLK         (PS2_CLK),
                  .in_port_to_the_PS2_DAT          (PS2_DAT),
                 //BUZZER
                 .out_port_from_the_BUZZER       (BUZZER)
				  
				);
				
				assign VGA_R = tVGA_R[7];
				assign VGA_G = tVGA_G[7];
				assign VGA_B = tVGA_B[7];
				

endmodule