#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <math.h>




#define POPULATION 100
#define DIM 200*300
#define DIMX 300
#define DIMY 200
#define MIN(x,y) (x>y?y:x)

int ball_fd;

void write_reg(int addr,int color)
{
  ball_arg_t balla;
    balla.addr = addr;
    balla.reg_data = color;
    if (ioctl(ball_fd, BALL_WRITE_REG, &balla)) {
      printf("ioctl(ball_WRITE_REG) failed");
      return;
  }
}

/**** my code ***/


/*****/

unsigned int read_reg(int addr)
{
  	ball_arg_t balla;
	balla.addr=addr;
	ioctl(ball_fd,BALL_READ_REG,&balla);
	return balla.reg_data;
}

void draw (int x, int y, int r, int opacity, int color){
	write_reg(0x10004,0);
	write_reg(0x10001,((x<<16)+(y<<7)+r));
	write_reg(0x10002,opacity);
	write_reg(0x10003,color);
	read_reg(3);
	while(!(read_reg(2)&0x00000008)){};
}




void init()
{
	static const char filename[] = "/dev/ball";
 if ( (ball_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
  }
}

void clean(){
	write_reg(0x10005,0);
	read_reg(4);
	printf("%X\n",read_reg(2));	
	while(!(read_reg(2)&0x00000004)){};
}
void writeram(int addr,int color){
	write_reg(0x1000A,0);
	write_reg(addr,color);
}
void writeleft(int color){
	int i;
	write_reg(0x10008,0);
  	for(i=0;i<60000;i++)
		write_reg(i,color);
}
void writeright(int* data){
	int i;
	write_reg(0x10009,0);
  	for(i=0;i<60000;i++)
		write_reg(i,data[i]);
}
void copy(){
	write_reg(0x10006,0);
	read_reg(5);
	while(!(read_reg(2)&0x00000002)){};
}

void fit(){
	write_reg(0x10007,0);
	write_reg(0x10000,100);
	read_reg(6);
	while(!(read_reg(2)&0x00000001)){};
}
int* loadTarget(){
	void* fp = fopen("mldata", "r");
	int i =0;
	int j=0;
	char x;
	int* data = malloc(DIM * sizeof(int));
	for(i=0;i<DIM;i++) {
		for(j=0;j<4;j++){
			fscanf(fp,"%c",&x);
			*(data+i)|=(0x000000ff&x);
			if(j!=3)
				*(data+i)<<=8;
		}
	}
	fclose(fp);
	return data;
}
void main(){
	unsigned int best, diff;
	int status;
	int i;
	init();
	clean();
	//printf("%X\n",read_reg(2));
	//draw(10,10,50,0xffffff,0xffffff);
	//draw(190,10,50,0x3fffff,0xff00ff);
	//draw(190,290,50,0x5fffff,0x0f00ff);
	//draw(10,290,50,0xCfffff,0xff00f0);
	//draw(100,100,100,0xAfffff,0xf000ff);
	//sleep(1);
	copy();	
}
//	write_reg(0x10005,0);

//	write_reg(0x10004,0);
//	write_reg(0x10001,((100<<16)+(50<<7)+60));
//	write_reg(0x10002,0x2fffff);
//	write_reg(0x10003,0x0000ff);
//	read_reg(0);
//	sleep(1);
//	write_reg(0x10005,0);
	
//}*/

