#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <stdio.h>
#include "lisamem.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>





#define POPULATION 100
#define DIM 200*311
#define DIMX 311
#define DIMY 200
#define MIN(x,y) (x>y?y:x)

int lisamem_fd;


typedef struct circ{
	int x, y, rad, color;
	float opacity;
	struct circ* next;
} circle;

void write_reg(int addr, int color)
{
  lisamem_arg_t lisamema;
    lisamema.addr = addr;
    lisamema.pixel_color = color;
    if (ioctl(lisamem_fd, LISAMEM_WRITE_REG, &lisamema)) {
      printf("ioctl(LISAMEM_WRITE_REG) failed");
      return;
  }
}

/**
 * Convert an array of ints to a comma seperated string
 */
void writebest (int* arr, int dim){
	int i;
	for(i=0;i<dim;i++)
		write_reg(i,arr[i]);
	
}
void writetest (int* arr, int dim){
	int i;
	for(i=65536;i<dim+65536;i++)
		write_reg(i,arr[i]);
}
int* loadTarget(){
	void* fp = fopen("mldata", "r");
	int i =0;
	int j=0;
	char x;
	int* data = malloc(DIM * sizeof(int));
	for(i=0;i<DIM;i++) {
		for(j=0;j<4;j++){
			fscanf(fp,"%c",&x);
			*(data+i)|=(0x000000ff&x);
			if(j!=3)
				*(data+i)<<=8;
		}
	}
	writetest(data,DIM);
	fclose(fp);
	return data;
}

/*
 * A fitness function to compare between 2 images.
 */
int fitness(int* im, int objcount, int* targ, int size){
	unsigned int diff = 0;
	int i;
	int r,g,b;
	for (i=0; i<size; ++i){
		r = ((targ[i]>>16) % 256) - ((im[i]>>16) % 256);
		g = ((targ[i]>>8) % 256) - ((im[i]>>8) % 256);
		b = (targ[i] % 256) - (im[i] % 256);
		diff += r*r + g*g + b*b;
	}
	return diff; // * (1+objcount/100);
}

/*
 * Create Image
 */
int* allocateImage(){
	int* im = malloc(DIM * sizeof(int));
	int i;
	for (i=0; i<DIM; i++){
		im[i]=0;
	}
	return im;
}


/**
 * Overlay color
 */
int resolveColor(int existing, int color, float opacity){
	int r = MIN(((existing >> 16) % 256 * (1.0-opacity)) + (((color >> 16) % 256) * opacity),255);
	int g = MIN(((existing >> 8) % 256 * (1.0-opacity)) +(((color >> 8) % 256) * opacity), 255);
	int b = MIN((existing % 256 * (1.0-opacity)) + ((color % 256) * opacity), 255);

	return (r << 16) + (g << 8) + b;
}

/*
 * Draw a circle upon the image
 */
void drawCircle(int* im, circle* c){
	int x, height, y;
	for (x = -c->rad; x <= c->rad; x++){
    	height = (int) sqrt(c->rad * c->rad - x*x);
	    for (y = -height; y <= height; y++){
	        if ((x+c->x) >=0 && (y + c->y)>=0 && (y+c->y)<DIMY && (x+c->x)<DIMX){
	        	im[(y+c->y)*DIMX+(x+c->x)]=resolveColor(im[(y+c->y)*DIMX+(x+c->x)], c->color, c->opacity);
	    	}
	    }
	}
}

void redraw(int* im, circle* c){
	int i;
	for (i=0;i<DIM; i++){
		im[i] = 0;	
	}

	if (c!=NULL){
		circle* f;
		for(f=c; f!=NULL; f = f->next){
			drawCircle(im, f);
		}
	}	
}

int countCircles(circle* e){
	if (e == NULL)
		return 0;
	return countCircles(e->next) + 1;
}

int rnd(int max){
	return rand() % max + 1;
}

circle* mutate(int* im, circle* c){
	if (rnd(2) > 1){
		/* Add Random Circle */
		circle* d = (circle *) malloc(sizeof(circle));
		d->x = rnd(DIMX);
		d->y = rnd(DIMY);
		d->color = rnd(0xffffff);
		d->rad = rnd(100);
		d->opacity = ((float) (rnd(10000))/30000) + 0.1;
		d->next = NULL;

		// Put on end so doesn't screw prev image
		if (c!=NULL){
			circle* f;
			circle* p;
			for(f=c;f!=NULL;f = f->next){
				p=f;
			}
			p->next = d;
		}else{
			c = d;
			c->next = NULL;
		}
		drawCircle(im, d);

	}else{
		/* Delete Random Circle */
		circle* f = c;
		int num = countCircles(c)-1;
		
		if (num >1){
			int ind = rand() % num;
			circle* old;
			
			if (ind==0){
				old = c;
				c = c->next;
				
			}else{
				
				int i;
				for (i=0; i<ind; i++){
					f = f->next;
				}
				
				old = (circle*) f->next;
				f->next = f->next->next;
			}
			old->next =NULL;
			free(old);	
			redraw(im, c);
				
		}else{
			if(c!=NULL){
				free(c);
			}	
			c = NULL;
		}		
	}
	if (rnd(2)>1)
		c = mutate(im, c);
	return c;
}

void freeCircles(circle* e){
	if (e != NULL){
		if (e->next){
			freeCircles(e->next);
		}
		e->next = NULL;
		free(e);
	}
}

void cloneImage(int* old, int* nw){
	memcpy(old, nw, DIM*sizeof(int));
}

		


circle* cloneCircles(circle* e){
	if (e == NULL){
		return NULL;
	}	
	
	circle* d = (circle *) malloc(sizeof(circle));
	d->x = e->x;
	d->y = e->y;
	d->color = e->color;
	d->rad = e->rad;
	d->opacity =e->opacity;
	
	
	if (e->next != NULL){
		d->next = cloneCircles(e->next);
	}else{
		d->next = NULL;
	}
	return d;
}
void init()
{
	static const char filename[] = "/dev/lisamem";
 if ( (lisamem_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
  }
}
int main(char* args){
	srand(1);
	init();
	int* dat = loadTarget();
	int i;
	
	int** images = malloc(POPULATION*sizeof(int*));
	circle** data = malloc(POPULATION*sizeof(circle*));
	for(i=0;i<POPULATION; i++){
		images[i] = allocateImage();
		data[i] = NULL;
	}	
	 
	 
	unsigned int min = 0xffffffff;
	unsigned int prev = min;
	circle* best = NULL;
	int min_ind = 0;
	int itrs =0;
	while (1){
		for(i =0; i<POPULATION; i++){
			data[i] = mutate(images[i], data[i]);
			int f = fitness(images[i], countCircles(data[i]), dat, DIM);
			//printCircles(data[i]);
			//printf("\t\tf: %d\n", fitness(images[i], countCircles(data[i]), dat, DIM));
			
			if (f<min){
				min = f;
				min_ind = i;
				best = cloneCircles(data[i]);
			}		
		}
		
		if (min<prev){
			printf("new best: %d - %d circles\n", min, countCircles(data[min_ind]));
			prev = min;
			writebest(images[min_ind], DIM);
			
		}
		
		if(itrs%10==0){
			printf("\t->%d, %d \n" , itrs, min);	
		}
		
		for(i =0; i<POPULATION; i++){
			if (i != min_ind){
				//Clone circles
				freeCircles(data[i]);
				data[i] = cloneCircles(best);
				//Clone images
				cloneImage(images[i], images[min_ind]); 
			}
		}	

		itrs ++;
	}
	return 0;
}
