#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "ball.h"
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <math.h>
#include "test.h"


/*****************FOR THE DRIVER**************************/
int ball_fd;


void write_reg(int addr,int color)
{
  ball_arg_t balla;
    balla.addr = addr;
    balla.reg_data = color;
    if (ioctl(ball_fd, BALL_WRITE_REG, &balla)) {
      printf("ioctl(ball_WRITE_REG) failed");
      return;
  }
}
unsigned int read_reg(int addr)
{
  	ball_arg_t balla;
	balla.addr=addr;
	ioctl(ball_fd,BALL_READ_REG,&balla);
	return balla.reg_data;
}

void init()
{
	static const char filename[] = "/dev/ball";
 if ( (ball_fd = open(filename, O_RDWR)) == -1) {
    fprintf(stderr, "could not open %s\n", filename);
  }
}


/***********************FOR FUNC WE DEFINED**************************/
void clean(){
	write_reg(0x10005,0);
	read_reg(4);
	while(!(read_reg(2)&0x00000004)){};
}
void copy(){
	while(!(read_reg(2)&0x00000008)){};
	write_reg(0x10006,0);
	read_reg(5);
	while(!(read_reg(2)&0x00000002)){};
}

void fit(){
	write_reg(0x10007,0);
	write_reg(0x10000,100);
	read_reg(6);
	while(!(read_reg(2)&0x00000001)){};
}
//load data from local file mldata
void writeright(int* data){
	int i;
	write_reg(0x10009,0);
  	for(i=0;i<60000;i++)
		write_reg(i,data[i]);
}
int* loadTarget(){
	void* fp = fopen("mldata", "r");
	int i =0;
	int j=0;
	char x;
	int* data = malloc(DIM * sizeof(int));
	for(i=0;i<DIM;i++) {
		for(j=0;j<4;j++){
			fscanf(fp,"%c",&x);
			*(data+i)|=(0x000000ff&x);
			if(j!=3)
				*(data+i)<<=8;
		}
	}
	fclose(fp);
	return data;
}
int countCircles(circle* e){
	if (e == NULL)
		return 0;
	return countCircles(e->next) + 1;
}

int rnd(int max){
	return rand() % max + 1;
}
void draw (int x, int y, int r, int opacity, int color){
	while(!(read_reg(2)&0x00000008)){};
	write_reg(0x10004,0);
	write_reg(0x10001,((x<<16)+(y<<7)+r));
	write_reg(0x10002,opacity);
	write_reg(0x10003,color);
	read_reg(3);
}
void redraw(circle *c){
	circle* f;
	clean();
	for(f=c;f!=NULL;f=f->next){
		draw(f->x,f->y,f->rad,f->opacity,f->color);	
	}
}
circle* mutate( circle* c){
	if (rnd(2) > 1){
		/* Add Random Circle */
		circle* d = (circle *) malloc(sizeof(circle));
		d->x = rnd(DIMX);
		d->y = rnd(DIMY);
		d->color = rnd(0xffffff);
		d->rad = rnd(50);
		d->opacity = rnd(0x555555);
		d->next = NULL;

		// Put on end so doesn't screw prev image
		if (c!=NULL){
			circle* f;
			circle* p;
			for(f=c;f!=NULL;f = f->next){
				p=f;
			}
			p->next = d;
		}else{
			c = d;
			c->next = NULL;
		}
		draw(d->x,d->y,d->rad,d->opacity,d->color);

	}else{
		/* Delete Random Circle */
		circle* f = c;
		int num = countCircles(c)-1;
		
		if (num >1){
			int ind = rand() % num;
			circle* old;
			
			if (ind==0){
				old = c;
				c = c->next;
				
			}else{
				
				int i;
				for (i=0; i<ind; i++){
					f = f->next;
				}
				
				old = (circle*) f->next;
				f->next = f->next->next;
			}
			old->next =NULL;
			free(old);	
			redraw(c);
				
		}else{
			if(c!=NULL){
				free(c);
			}	
			c = NULL;
		}		
	}
	if (rnd(2)>1)
		c = mutate( c);
	return c;
}

void freeCircles(circle* e){
	if (e != NULL){
		if (e->next){
			freeCircles(e->next);
		}
		e->next = NULL;
		free(e);
	}
}
circle* cloneCircles(circle* e){
	if (e == NULL){
		return NULL;
	}	
	
	circle* d = (circle *) malloc(sizeof(circle));
	d->x = e->x;
	d->y = e->y;
	d->color = e->color;
	d->rad = e->rad;
	d->opacity =e->opacity;
	
	
	if (e->next != NULL){
		d->next = cloneCircles(e->next);
	}else{
		d->next = NULL;
	}
	return d;
}
int main(){

	srand(1);
	init();
	int i;
	unsigned int min_ind = 0;
	unsigned int min=0xffffffff;
	int* dat = loadTarget();
	//write right plane
	writeright(dat);
	circle** data = malloc(POPULATION*sizeof(circle*));
	for(i=0;i<POPULATION; i++){
		data[i] = NULL;
	}	
	unsigned int prev = min;
	circle* best = NULL;
	int itrs =0;
		min=read_reg(0);
		min_ind=read_reg(1);
		printf("inner:%d,%d\n",min,min_ind);
	while (1){
		for(i =0; i<POPULATION; i++){
			redraw(data[i]);
			data[i] = mutate(data[i]);
			fit();
		}
		min=read_reg(0);
		min_ind=read_reg(1);
		printf("min=%d,min_ind=%d\n",min,min_ind);
		//sleep(1);
		best=cloneCircles(data[min_ind]);

		if (min<prev){
			printf("new best: min=%d - %d circles\n", min, countCircles(data[min_ind]));
			prev = min;
			redraw(data[min_ind]);
			copy();
			
		}
		//print every tem generations completed
		if(itrs%10==0){
			printf("\t->%d, %d \n" , itrs, prev);	
		}
		//free all bad children and copy the best to each child and redo mutation on this basis
		for(i =0; i<POPULATION; i++){
			if (i != min_ind){
				freeCircles(data[i]);
				data[i] = cloneCircles(best);
			}
		}
		itrs ++;
	}
	return 0;
}
